/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs;

import com.nidefawl.Stats.Stats;
import com.zford.jobs.Jobs;
import com.zford.jobs.config.JobConfig;
import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.MessageConfig;
import com.zford.jobs.config.container.Job;
import com.zford.jobs.config.container.JobProgression;
import com.zford.jobs.config.container.JobsLivingEntityInfo;
import com.zford.jobs.config.container.JobsMaterialInfo;
import com.zford.jobs.config.container.JobsPlayer;
import com.zford.jobs.event.JobsJoinEvent;
import com.zford.jobs.event.JobsLeaveEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.mbertoli.jfep.Parser;

public class JobsCommands
implements CommandExecutor {
    private Jobs plugin;

    public JobsCommands(Jobs plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> jobs;
        Iterator<Object> i$;
        JobsPlayer jPlayer;
        if (sender instanceof Player) {
            Player pSender = (Player)sender;
            JobsPlayer jPlayer2 = this.plugin.getJobsPlayer(pSender.getName());
            if (args.length == 2 && args[0].equalsIgnoreCase("join")) {
                String jobName = args[1].trim();
                if (JobConfig.getInstance().getJob(jobName) != null && !jobName.equalsIgnoreCase("None")) {
                    if (!(JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has(pSender, "jobs.join." + jobName) || JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled())) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("error-no-permission"));
                        return true;
                    }
                    if (JobsConfiguration.getInstance().getMaxJobs() != null && jPlayer2.getJobs().size() >= JobsConfiguration.getInstance().getMaxJobs()) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("join-too-many-job"));
                        return true;
                    }
                    this.plugin.getServer().getPluginManager().callEvent((Event)new JobsJoinEvent(jPlayer2, JobConfig.getInstance().getJob(jobName)));
                    return true;
                }
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("error-no-job"));
                return true;
            }
            if (args.length >= 2 && args[0].equalsIgnoreCase("leave")) {
                String jobName = args[1].trim();
                if (JobConfig.getInstance().getJob(jobName) != null) {
                    this.plugin.getServer().getPluginManager().callEvent((Event)new JobsLeaveEvent(jPlayer2, JobConfig.getInstance().getJob(jobName)));
                    return true;
                }
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("error-no-job"));
                return true;
            }
            if (args.length >= 2 && args[0].equalsIgnoreCase("info")) {
                Job job = JobConfig.getInstance().getJob(args[1]);
                String type = "";
                if (args.length >= 3) {
                    type = args[2];
                }
                this.sendMessageByLine(sender, this.jobInfoMessage(jPlayer2, job, type));
                return true;
            }
        }
        if (!(sender instanceof ConsoleCommandSender)) {
            if (!(sender instanceof Player)) return true;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("stats")) {
            block101: {
                jPlayer = null;
                if (args.length >= 2) {
                    if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.stats")) {
                        jPlayer = this.plugin.getJobsPlayer(args[1]);
                        break block101;
                    } else {
                        sender.sendMessage(ChatColor.RED + "There was an error in your command");
                        return true;
                    }
                }
                if (sender instanceof Player) {
                    jPlayer = this.plugin.getJobsPlayer(((Player)sender).getName());
                }
            }
            if (jPlayer == null) {
                sender.sendMessage(ChatColor.RED + "There was an error in your command");
                return true;
            }
            if (jPlayer.getJobsProgression().size() == 0) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("stats-no-job"));
                return true;
            }
            i$ = jPlayer.getJobsProgression().iterator();
            while (i$.hasNext()) {
                JobProgression jobProg = (JobProgression)i$.next();
                this.sendMessageByLine(sender, this.jobStatsMessage(jobProg));
            }
            return true;
        }
        if (args.length >= 1 && args[0].equalsIgnoreCase("browse")) {
            jobs = new ArrayList<String>();
            i$ = JobConfig.getInstance().getJobs().iterator();
        } else {
            JobsPlayer player;
            if (args.length >= 2 && args[0].equalsIgnoreCase("admininfo")) {
                if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.info"))) {
                    if (JobsConfiguration.getInstance().getPermissions() != null) {
                        if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                    }
                    if (!sender.isOp()) return true;
                }
                String message = "";
                message = message + "----------------\n";
                player = this.plugin.getJobsPlayer(args[1]);
                Iterator<JobProgression> i$2 = player.getJobsProgression().iterator();
                while (true) {
                    if (!i$2.hasNext()) {
                        this.sendMessageByLine(sender, message);
                        return true;
                    }
                    JobProgression jobProg = i$2.next();
                    Job job = jobProg.getJob();
                    message = message + this.jobStatsMessage(jobProg);
                    message = message + this.jobInfoMessage(player, job, "");
                    message = message + "----------------\n";
                }
            }
            if (args.length == 1 && args[0].equalsIgnoreCase("reload") && (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.reload") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp())) {
                try {
                    if (!this.plugin.isEnabled()) return true;
                    for (Player player2 : this.plugin.getServer().getOnlinePlayers()) {
                        JobsPlayer jPlayer3 = this.plugin.getJobsPlayer(player2.getName());
                        jPlayer3.removeHonorific();
                        this.plugin.removePlayer(player2.getName());
                    }
                    Jobs.reloadConfigurations();
                    Player[] arr$ = this.plugin.getServer().getOnlinePlayers();
                    int len$ = arr$.length;
                    int i$3 = 0;
                    while (true) {
                        Player player2;
                        if (i$3 >= len$) {
                            if (!(sender instanceof Player)) return true;
                            this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                            return true;
                        }
                        player2 = arr$[i$3];
                        this.plugin.addPlayer(player2.getName());
                        ++i$3;
                    }
                }
                catch (Exception e) {
                    this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                }
                return true;
            }
            if (args.length == 3) {
                if (args[0].equalsIgnoreCase("fire")) {
                    if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.fire"))) {
                        if (JobsConfiguration.getInstance().getPermissions() != null) {
                            if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                        }
                        if (!sender.isOp()) return true;
                    }
                    jPlayer = this.plugin.getJobsPlayer(args[1]);
                    player = this.plugin.getServer().getPlayer(args[1]);
                    Job job = JobConfig.getInstance().getJob(args[2]);
                    if (jPlayer == null) return true;
                    if (job == null) return true;
                    try {
                        if (!jPlayer.isInJob(job)) {
                            String message = MessageConfig.getInstance().getMessage("fire-target-no-job");
                            message = message.replace("%jobcolour%", job.getChatColour().toString());
                            message = message.replace("%jobname%", job.getName());
                            this.sendMessageByLine(sender, message);
                            return true;
                        }
                        this.plugin.getServer().getPluginManager().callEvent((Event)new JobsLeaveEvent(jPlayer, job));
                        if (player != null) {
                            String message = MessageConfig.getInstance().getMessage("fire-target");
                            message = message.replace("%jobcolour%", job.getChatColour().toString());
                            message = message.replace("%jobname%", job.getName());
                            this.sendMessageByLine((CommandSender)player, message);
                        }
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                        return true;
                    }
                    catch (Exception e) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                    }
                    return true;
                }
                if (!args[0].equalsIgnoreCase("employ")) return true;
                if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.employ." + args[2]))) {
                    if (JobsConfiguration.getInstance().getPermissions() != null) {
                        if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                    }
                    if (!sender.isOp()) return true;
                }
                jPlayer = this.plugin.getJobsPlayer(args[1]);
                player = this.plugin.getServer().getPlayer(args[1]);
                Job job = JobConfig.getInstance().getJob(args[2]);
                if (jPlayer == null) return true;
                if (job == null) return true;
                try {
                    if (jPlayer.isInJob(job)) return true;
                    this.plugin.getServer().getPluginManager().callEvent((Event)new JobsJoinEvent(jPlayer, job));
                    if (player != null) {
                        String message = MessageConfig.getInstance().getMessage("employ-target");
                        message = message.replace("%jobcolour%", job.getChatColour().toString());
                        message = message.replace("%jobname%", job.getName());
                        this.sendMessageByLine((CommandSender)player, message);
                    }
                    this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                    return true;
                }
                catch (Exception e) {
                    this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                }
                return true;
            }
            if (args.length == 4) {
                if (args[0].equalsIgnoreCase("promote")) {
                    if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.promote"))) {
                        if (JobsConfiguration.getInstance().getPermissions() != null) {
                            if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                        }
                        if (!sender.isOp()) return true;
                    }
                    jPlayer = this.plugin.getJobsPlayer(args[1]);
                    player = this.plugin.getServer().getPlayer(args[1]);
                    Job job = JobConfig.getInstance().getJob(args[2]);
                    if (jPlayer == null) return true;
                    if (job == null) return true;
                    try {
                        if (jPlayer.isInJob(job)) {
                            Integer levelsGained = Integer.parseInt(args[3]);
                            if (jPlayer.getJobsProgression(job).getJob().getMaxLevel() != null && levelsGained + jPlayer.getJobsProgression(job).getLevel() > jPlayer.getJobsProgression(job).getJob().getMaxLevel()) {
                                levelsGained = jPlayer.getJobsProgression(job).getJob().getMaxLevel() - jPlayer.getJobsProgression(job).getLevel();
                            }
                            jPlayer.getJobsProgression(job).setLevel(jPlayer.getJobsProgression(job).getLevel() + levelsGained);
                            jPlayer.reloadMaxExperience();
                            jPlayer.checkLevels();
                            if (player != null) {
                                String message = MessageConfig.getInstance().getMessage("promote-target");
                                message = message.replace("%jobcolour%", job.getChatColour().toString());
                                message = message.replace("%jobname%", job.getName());
                                message = message.replace("%levelsgained%", levelsGained.toString());
                                this.sendMessageByLine((CommandSender)player, message);
                            }
                            this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                        }
                        JobsConfiguration.getInstance().getJobsDAO().save(jPlayer);
                        return true;
                    }
                    catch (Exception e) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("demote")) {
                    if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.demote"))) {
                        if (JobsConfiguration.getInstance().getPermissions() != null) {
                            if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                        }
                        if (!sender.isOp()) return true;
                    }
                    jPlayer = this.plugin.getJobsPlayer(args[1]);
                    player = this.plugin.getServer().getPlayer(args[1]);
                    Job job = JobConfig.getInstance().getJob(args[2]);
                    if (jPlayer == null) return true;
                    if (job == null) return true;
                    try {
                        if (jPlayer.isInJob(job)) {
                            Integer levelsLost = Integer.parseInt(args[3]);
                            if (jPlayer.getJobsProgression(job).getLevel() - levelsLost < 1) {
                                levelsLost = jPlayer.getJobsProgression(job).getLevel() - 1;
                            }
                            jPlayer.getJobsProgression(job).setLevel(jPlayer.getJobsProgression(job).getLevel() - levelsLost);
                            jPlayer.reloadMaxExperience();
                            jPlayer.checkLevels();
                            if (player != null) {
                                String message = MessageConfig.getInstance().getMessage("demote-target");
                                message = message.replace("%jobcolour%", job.getChatColour().toString());
                                message = message.replace("%jobname%", job.getName());
                                message = message.replace("%levelslost%", levelsLost.toString());
                                this.sendMessageByLine((CommandSender)player, message);
                            }
                            this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                        }
                        JobsConfiguration.getInstance().getJobsDAO().save(jPlayer);
                        return true;
                    }
                    catch (Exception e) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase("grantxp")) {
                    Double expGained;
                    if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.grantxp"))) {
                        if (JobsConfiguration.getInstance().getPermissions() != null) {
                            if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                        }
                        if (!sender.isOp()) return true;
                    }
                    jPlayer = this.plugin.getJobsPlayer(args[1]);
                    player = this.plugin.getServer().getPlayer(args[1]);
                    Job job = JobConfig.getInstance().getJob(args[2]);
                    if (jPlayer == null) return true;
                    if (job == null) return true;
                    try {
                        expGained = Double.parseDouble(args[3]);
                    }
                    catch (ClassCastException ex) {
                        expGained = Integer.parseInt(args[3]);
                    }
                    catch (Exception e) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                        return true;
                    }
                    if (jPlayer.isInJob(job)) {
                        jPlayer.getJobsProgression(job).setExperience(jPlayer.getJobsProgression(job).getExperience() + expGained);
                        jPlayer.reloadMaxExperience();
                        jPlayer.checkLevels();
                        if (player != null) {
                            String message = MessageConfig.getInstance().getMessage("grantxp-target");
                            message = message.replace("%jobcolour%", job.getChatColour().toString());
                            message = message.replace("%jobname%", job.getName());
                            message = message.replace("%expgained%", args[3]);
                            this.sendMessageByLine((CommandSender)player, message);
                        }
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                    }
                    JobsConfiguration.getInstance().getJobsDAO().save(jPlayer);
                    return true;
                }
                if (args[0].equalsIgnoreCase("removexp")) {
                    Double expLost;
                    if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.removexp"))) {
                        if (JobsConfiguration.getInstance().getPermissions() != null) {
                            if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                        }
                        if (!sender.isOp()) return true;
                    }
                    jPlayer = this.plugin.getJobsPlayer(args[1]);
                    player = this.plugin.getServer().getPlayer(args[1]);
                    Job job = JobConfig.getInstance().getJob(args[2]);
                    if (jPlayer == null) return true;
                    if (job == null) return true;
                    try {
                        expLost = Double.parseDouble(args[3]);
                    }
                    catch (ClassCastException ex) {
                        expLost = Integer.parseInt(args[3]);
                    }
                    catch (Exception e) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                        return true;
                    }
                    if (jPlayer.isInJob(job)) {
                        jPlayer.getJobsProgression(job).setExperience(jPlayer.getJobsProgression(job).getExperience() - expLost);
                        if (player != null) {
                            String message = MessageConfig.getInstance().getMessage("removexp-target");
                            message = message.replace("%jobcolour%", job.getChatColour().toString());
                            message = message.replace("%jobname%", job.getName());
                            message = message.replace("%explost%", args[3]);
                            this.sendMessageByLine((CommandSender)player, message);
                        }
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                    }
                    JobsConfiguration.getInstance().getJobsDAO().save(jPlayer);
                    return true;
                }
                if (args[0].equalsIgnoreCase("transfer")) {
                    if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.transfer"))) {
                        if (JobsConfiguration.getInstance().getPermissions() != null) {
                            if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                        }
                        if (!sender.isOp()) return true;
                    }
                    jPlayer = this.plugin.getJobsPlayer(args[1]);
                    player = this.plugin.getServer().getPlayer(args[1]);
                    Job oldjob = JobConfig.getInstance().getJob(args[2]);
                    Job newjob = JobConfig.getInstance().getJob(args[3]);
                    if (jPlayer == null) return true;
                    if (!(oldjob != null & newjob != null)) return true;
                    try {
                        if (!jPlayer.isInJob(oldjob)) return true;
                        if (jPlayer.isInJob(newjob)) return true;
                        jPlayer.transferJob(oldjob, newjob);
                        if (newjob.getMaxLevel() != null && jPlayer.getJobsProgression(newjob).getLevel() > newjob.getMaxLevel()) {
                            jPlayer.getJobsProgression(newjob).setLevel(newjob.getMaxLevel());
                        }
                        jPlayer.reloadMaxExperience();
                        jPlayer.reloadHonorific();
                        jPlayer.checkLevels();
                        JobsConfiguration.getInstance().getJobsDAO().quitJob(jPlayer, oldjob);
                        JobsConfiguration.getInstance().getJobsDAO().joinJob(jPlayer, newjob);
                        JobsConfiguration.getInstance().getJobsDAO().save(jPlayer);
                        if (player != null) {
                            String message = MessageConfig.getInstance().getMessage("transfer-target");
                            message = message.replace("%oldjobcolour%", oldjob.getChatColour().toString());
                            message = message.replace("%oldjobname%", oldjob.getName());
                            message = message.replace("%newjobcolour%", newjob.getChatColour().toString());
                            message = message.replace("%newjobname%", newjob.getName());
                            this.sendMessageByLine((CommandSender)player, message);
                        }
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-success"));
                        if (JobsConfiguration.getInstance().getStats() == null) return true;
                        if (!JobsConfiguration.getInstance().getStats().isEnabled()) return true;
                        Stats stats = JobsConfiguration.getInstance().getStats();
                        if (jPlayer.getJobsProgression(newjob).getLevel() <= stats.get(jPlayer.getName(), "job", newjob.getName())) return true;
                        stats.setStat(jPlayer.getName(), "job", newjob.getName(), jPlayer.getJobsProgression(newjob).getLevel());
                        stats.saveAll();
                        return true;
                    }
                    catch (Exception e) {
                        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("admin-command-failed"));
                    }
                    return true;
                }
            }
            if (args.length > 0) {
                sender.sendMessage(ChatColor.RED + "There was an error in your command");
            }
            this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-browse"));
            if (sender instanceof Player) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-join"));
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-leave"));
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-stats"));
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-info"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.info") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-info"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.fire") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-fire"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.employ") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-employ"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.promote") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-promote"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.demote") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-demote"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.grantxp") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-grantxp"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.removexp") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-removexp"));
            }
            if (sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.transfer") || (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled()) && sender.isOp()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-transfer"));
            }
            if (!(sender instanceof ConsoleCommandSender || JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() && JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.admin.reload"))) {
                if (JobsConfiguration.getInstance().getPermissions() != null) {
                    if (JobsConfiguration.getInstance().getPermissions().isEnabled()) return true;
                }
                if (!sender.isOp()) return true;
            }
            this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("jobs-admin-reload"));
            return true;
        }
        while (i$.hasNext()) {
            Job temp = i$.next();
            if (!(sender instanceof ConsoleCommandSender) && (JobsConfiguration.getInstance().getPermissions() == null || !JobsConfiguration.getInstance().getPermissions().isEnabled() || !JobsConfiguration.getInstance().getPermissions().getHandler().has((Player)sender, "jobs.join." + temp.getName())) && JobsConfiguration.getInstance().getPermissions() != null && JobsConfiguration.getInstance().getPermissions().isEnabled() || temp.getName().equalsIgnoreCase("None")) continue;
            if (temp.getMaxLevel() == null) {
                jobs.add(temp.getChatColour() + temp.getName());
                continue;
            }
            jobs.add(temp.getChatColour() + temp.getName() + ChatColor.WHITE + " - max lvl: " + temp.getMaxLevel());
        }
        if (jobs.size() == 0) {
            this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("browse-no-jobs"));
            return true;
        }
        this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("browse-jobs-header"));
        i$ = jobs.iterator();
        while (true) {
            if (!i$.hasNext()) {
                this.sendMessageByLine(sender, MessageConfig.getInstance().getMessage("browse-jobs-footer"));
                return true;
            }
            String job = (String)i$.next();
            sender.sendMessage("    " + job);
        }
    }

    private String jobInfoMessage(JobsPlayer player, Job job, String type) {
        String myMessage;
        if (job == null) {
            return MessageConfig.getInstance().getMessage("error-no-job");
        }
        String message = "";
        boolean showAllTypes = true;
        if (type.equalsIgnoreCase("break") || type.equalsIgnoreCase("place") || type.equalsIgnoreCase("kill") || type.equalsIgnoreCase("fish") || type.equalsIgnoreCase("craft")) {
            showAllTypes = false;
        }
        if (type.equalsIgnoreCase("break") || showAllTypes) {
            HashMap<String, JobsMaterialInfo> jobBreakInfo = job.getBreakInfo();
            if (jobBreakInfo != null) {
                message = message + this.jobInfoBreakMessage(player, job, jobBreakInfo);
            } else if (!showAllTypes) {
                myMessage = MessageConfig.getInstance().getMessage("break-none");
                myMessage = myMessage.replace("%jobcolour%", job.getChatColour().toString());
                myMessage = myMessage.replace("%jobname%", job.getName());
                message = message + myMessage;
            }
        }
        if (type.equalsIgnoreCase("place") || showAllTypes) {
            HashMap<String, JobsMaterialInfo> jobPlaceInfo = job.getPlaceInfo();
            if (jobPlaceInfo != null) {
                message = message + this.jobInfoPlaceMessage(player, job, jobPlaceInfo);
            } else if (!showAllTypes) {
                myMessage = MessageConfig.getInstance().getMessage("place-none");
                myMessage = myMessage.replace("%jobcolour%", job.getChatColour().toString());
                myMessage = myMessage.replace("%jobname%", job.getName());
                message = message + myMessage;
            }
        }
        if (type.equalsIgnoreCase("kill") || showAllTypes) {
            HashMap<String, JobsLivingEntityInfo> jobKillInfo = job.getKillInfo();
            if (jobKillInfo != null) {
                message = message + this.jobInfoKillMessage(player, job, jobKillInfo);
            } else if (!showAllTypes) {
                myMessage = MessageConfig.getInstance().getMessage("kill-none");
                myMessage = myMessage.replace("%jobcolour%", job.getChatColour().toString());
                myMessage = myMessage.replace("%jobname%", job.getName());
                message = message + myMessage;
            }
        }
        if (type.equalsIgnoreCase("fish") || showAllTypes) {
            HashMap<String, JobsMaterialInfo> jobFishInfo = job.getFishInfo();
            if (jobFishInfo != null) {
                message = message + this.jobInfoFishMessage(player, job, jobFishInfo);
            } else if (!showAllTypes) {
                myMessage = MessageConfig.getInstance().getMessage("fish-none");
                myMessage = myMessage.replace("%jobcolour%", job.getChatColour().toString());
                myMessage = myMessage.replace("%jobname%", job.getName());
                message = message + myMessage;
            }
        }
        if (this.plugin.getServer().getPluginManager().getPlugin("Spout") != null && (type.equalsIgnoreCase("craft") || showAllTypes)) {
            HashMap<String, JobsMaterialInfo> jobCraftInfo = job.getCraftInfo();
            if (jobCraftInfo != null) {
                message = message + this.jobInfoCraftMessage(player, job, jobCraftInfo);
            } else if (!showAllTypes) {
                myMessage = MessageConfig.getInstance().getMessage("craft-none");
                myMessage = myMessage.replace("%jobcolour%", job.getChatColour().toString());
                myMessage = myMessage.replace("%jobname%", job.getName());
                message = message + myMessage;
            }
        }
        return message;
    }

    private String jobInfoBreakMessage(JobsPlayer player, Job job, HashMap<String, JobsMaterialInfo> jobBreakInfo) {
        String message = "";
        message = message + MessageConfig.getInstance().getMessage("break-header");
        DecimalFormat format = new DecimalFormat("#.##");
        JobProgression prog = player.getJobsProgression(job);
        Parser expEquation = job.getExpEquation();
        Parser incomeEquation = job.getIncomeEquation();
        if (prog != null) {
            expEquation.setVariable("joblevel", prog.getLevel());
            incomeEquation.setVariable("joblevel", prog.getLevel());
        } else {
            expEquation.setVariable("joblevel", 1.0);
            incomeEquation.setVariable("joblevel", 1.0);
        }
        expEquation.setVariable("numjobs", player.getJobs().size());
        incomeEquation.setVariable("numjobs", player.getJobs().size());
        for (Map.Entry<String, JobsMaterialInfo> temp : jobBreakInfo.entrySet()) {
            expEquation.setVariable("baseexperience", temp.getValue().getXpGiven());
            incomeEquation.setVariable("baseincome", temp.getValue().getMoneyGiven());
            String myMessage = temp.getKey().contains(":") ? MessageConfig.getInstance().getMessage("break-info-sub") : MessageConfig.getInstance().getMessage("break-info-no-sub");
            if (temp.getKey().contains(":")) {
                myMessage = myMessage.replace("%item%", temp.getKey().split(":")[0].replace("_", " ").toLowerCase());
                myMessage = myMessage.replace("%subitem%", temp.getKey().split(":")[1]);
            } else {
                myMessage = myMessage.replace("%item%", temp.getKey().replace("_", " ").toLowerCase());
            }
            myMessage = myMessage.replace("%income%", format.format(incomeEquation.getValue()));
            myMessage = myMessage.replace("%experience%", format.format(expEquation.getValue()));
            message = message + myMessage;
        }
        return message;
    }

    private String jobInfoPlaceMessage(JobsPlayer player, Job job, HashMap<String, JobsMaterialInfo> jobPlaceInfo) {
        String message = "";
        message = message + MessageConfig.getInstance().getMessage("place-header");
        DecimalFormat format = new DecimalFormat("#.##");
        JobProgression prog = player.getJobsProgression(job);
        Parser expEquation = job.getExpEquation();
        Parser incomeEquation = job.getIncomeEquation();
        if (prog != null) {
            expEquation.setVariable("joblevel", prog.getLevel());
            incomeEquation.setVariable("joblevel", prog.getLevel());
        } else {
            expEquation.setVariable("joblevel", 1.0);
            incomeEquation.setVariable("joblevel", 1.0);
        }
        expEquation.setVariable("numjobs", player.getJobs().size());
        incomeEquation.setVariable("numjobs", player.getJobs().size());
        for (Map.Entry<String, JobsMaterialInfo> temp : jobPlaceInfo.entrySet()) {
            expEquation.setVariable("baseexperience", temp.getValue().getXpGiven());
            incomeEquation.setVariable("baseincome", temp.getValue().getMoneyGiven());
            String myMessage = temp.getKey().contains(":") ? MessageConfig.getInstance().getMessage("place-info-sub") : MessageConfig.getInstance().getMessage("place-info-no-sub");
            if (temp.getKey().contains(":")) {
                myMessage = myMessage.replace("%item%", temp.getKey().split(":")[0].replace("_", " ").toLowerCase());
                myMessage = myMessage.replace("%subitem%", temp.getKey().split(":")[1]);
            } else {
                myMessage = myMessage.replace("%item%", temp.getKey().replace("_", " ").toLowerCase());
            }
            myMessage = myMessage.replace("%income%", format.format(incomeEquation.getValue()));
            myMessage = myMessage.replace("%experience%", format.format(expEquation.getValue()));
            message = message + myMessage;
        }
        return message;
    }

    private String jobInfoKillMessage(JobsPlayer player, Job job, HashMap<String, JobsLivingEntityInfo> jobKillInfo) {
        String message = "";
        message = message + MessageConfig.getInstance().getMessage("kill-header");
        DecimalFormat format = new DecimalFormat("#.##");
        JobProgression prog = player.getJobsProgression(job);
        Parser expEquation = job.getExpEquation();
        Parser incomeEquation = job.getIncomeEquation();
        if (prog != null) {
            expEquation.setVariable("joblevel", prog.getLevel());
            incomeEquation.setVariable("joblevel", prog.getLevel());
        } else {
            expEquation.setVariable("joblevel", 1.0);
            incomeEquation.setVariable("joblevel", 1.0);
        }
        expEquation.setVariable("numjobs", player.getJobs().size());
        incomeEquation.setVariable("numjobs", player.getJobs().size());
        for (Map.Entry<String, JobsLivingEntityInfo> temp : jobKillInfo.entrySet()) {
            expEquation.setVariable("baseexperience", temp.getValue().getXpGiven());
            incomeEquation.setVariable("baseincome", temp.getValue().getMoneyGiven());
            String myMessage = temp.getKey().contains(":") ? MessageConfig.getInstance().getMessage("kill-info-sub") : MessageConfig.getInstance().getMessage("kill-info-no-sub");
            if (temp.getKey().contains(":")) {
                myMessage = myMessage.replace("%item%", temp.getKey().split(":")[0].replace("org.bukkit.craftbukkit.entity.Craft", ""));
                myMessage = myMessage.replace("%subitem%", temp.getKey().split(":")[1]);
            } else {
                myMessage = myMessage.replace("%item%", temp.getKey().replace("org.bukkit.craftbukkit.entity.Craft", ""));
            }
            myMessage = myMessage.replace("%income%", format.format(incomeEquation.getValue()));
            myMessage = myMessage.replace("%experience%", format.format(expEquation.getValue()));
            message = message + myMessage;
        }
        return message;
    }

    private String jobInfoFishMessage(JobsPlayer player, Job job, HashMap<String, JobsMaterialInfo> jobFishInfo) {
        String message = "";
        message = message + MessageConfig.getInstance().getMessage("fish-header");
        DecimalFormat format = new DecimalFormat("#.##");
        JobProgression prog = player.getJobsProgression(job);
        Parser expEquation = job.getExpEquation();
        Parser incomeEquation = job.getIncomeEquation();
        if (prog != null) {
            expEquation.setVariable("joblevel", prog.getLevel());
            incomeEquation.setVariable("joblevel", prog.getLevel());
        } else {
            expEquation.setVariable("joblevel", 1.0);
            incomeEquation.setVariable("joblevel", 1.0);
        }
        expEquation.setVariable("numjobs", player.getJobs().size());
        incomeEquation.setVariable("numjobs", player.getJobs().size());
        for (Map.Entry<String, JobsMaterialInfo> temp : jobFishInfo.entrySet()) {
            expEquation.setVariable("baseexperience", temp.getValue().getXpGiven());
            incomeEquation.setVariable("baseincome", temp.getValue().getMoneyGiven());
            String myMessage = temp.getKey().contains(":") ? MessageConfig.getInstance().getMessage("fish-info-sub") : MessageConfig.getInstance().getMessage("fish-info-no-sub");
            if (temp.getKey().contains(":")) {
                myMessage = myMessage.replace("%item%", temp.getKey().split(":")[0].replace("_", " ").toLowerCase());
                myMessage = myMessage.replace("%subitem%", temp.getKey().split(":")[1]);
            } else {
                myMessage = myMessage.replace("%item%", temp.getKey().replace("_", " ").toLowerCase());
            }
            myMessage = myMessage.replace("%income%", format.format(incomeEquation.getValue()));
            myMessage = myMessage.replace("%experience%", format.format(expEquation.getValue()));
            message = message + myMessage;
        }
        return message;
    }

    private String jobInfoCraftMessage(JobsPlayer player, Job job, HashMap<String, JobsMaterialInfo> jobFishInfo) {
        String message = "";
        message = message + MessageConfig.getInstance().getMessage("craft-header");
        DecimalFormat format = new DecimalFormat("#.##");
        JobProgression prog = player.getJobsProgression(job);
        Parser expEquation = job.getExpEquation();
        Parser incomeEquation = job.getIncomeEquation();
        if (prog != null) {
            expEquation.setVariable("joblevel", prog.getLevel());
            incomeEquation.setVariable("joblevel", prog.getLevel());
        } else {
            expEquation.setVariable("joblevel", 1.0);
            incomeEquation.setVariable("joblevel", 1.0);
        }
        expEquation.setVariable("numjobs", player.getJobs().size());
        incomeEquation.setVariable("numjobs", player.getJobs().size());
        for (Map.Entry<String, JobsMaterialInfo> temp : jobFishInfo.entrySet()) {
            expEquation.setVariable("baseexperience", temp.getValue().getXpGiven());
            incomeEquation.setVariable("baseincome", temp.getValue().getMoneyGiven());
            String myMessage = temp.getKey().contains(":") ? MessageConfig.getInstance().getMessage("craft-info-sub") : MessageConfig.getInstance().getMessage("craft-info-no-sub");
            if (temp.getKey().contains(":")) {
                myMessage = myMessage.replace("%item%", temp.getKey().split(":")[0].replace("_", " ").toLowerCase());
                myMessage = myMessage.replace("%subitem%", temp.getKey().split(":")[1]);
            } else {
                myMessage = myMessage.replace("%item%", temp.getKey().replace("_", " ").toLowerCase());
            }
            myMessage = myMessage.replace("%income%", format.format(incomeEquation.getValue()));
            myMessage = myMessage.replace("%experience%", format.format(expEquation.getValue()));
            message = message + myMessage;
        }
        return message;
    }

    private String jobStatsMessage(JobProgression jobProg) {
        String message = MessageConfig.getInstance().getMessage("stats-job");
        message = message.replace("%joblevel%", Integer.valueOf(jobProg.getLevel()).toString());
        message = message.replace("%jobcolour%", jobProg.getJob().getChatColour().toString());
        message = message.replace("%jobname%", jobProg.getJob().getName());
        message = message.replace("%jobexp%", Integer.toString((int)jobProg.getExperience()));
        message = message.replace("%jobmaxexp%", Integer.toString(jobProg.getMaxExperience()));
        return message;
    }

    private void sendMessageByLine(CommandSender sender, String message) {
        for (String line : message.split("\n")) {
            sender.sendMessage(line);
        }
    }
}

