/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.config;

import com.zford.jobs.Jobs;
import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.container.Job;
import com.zford.jobs.config.container.JobsLivingEntityInfo;
import com.zford.jobs.config.container.JobsMaterialInfo;
import com.zford.jobs.util.DisplayMethod;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;
import org.bukkit.util.config.Configuration;
import org.mbertoli.jfep.Parser;

public class JobConfig {
    private HashMap<String, Job> jobs;
    private static JobConfig jobsConfig = null;
    private HashMap<Job, Integer> usedSlots;

    private JobConfig() {
    }

    public void reload() {
        this.loadJobSettings();
        this.loadSlots();
    }

    private void loadJobSettings() {
        File f = new File("plugins/Jobs/jobConfig.yml");
        this.jobs = new HashMap();
        if (!f.exists()) {
            System.err.println("[Jobs] - configuration file jobConfig.yml does not exist.  Disabling jobs !");
            Jobs.disablePlugin();
            return;
        }
        Configuration conf = new Configuration(f);
        conf.load();
        List jobKeys = conf.getKeys("Jobs");
        if (jobKeys == null) {
            System.err.println("[Jobs] - No jobs detected. Disabling Jobs!");
            Jobs.disablePlugin();
            return;
        }
        for (String jobKey : jobKeys) {
            List customKillKeys;
            Parser expEquation;
            Parser incomeEquation;
            Parser maxExpEquation;
            DisplayMethod displayMethod;
            String jobShortName;
            Integer maxSlots;
            String jobName = conf.getString("Jobs." + jobKey + ".fullname");
            if (jobName == null) {
                System.err.println("[Jobs] - Job " + jobKey + " has an invalid fullname property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            Integer maxLevel = conf.getInt("Jobs." + jobKey + ".max-level", -1);
            if (maxLevel == -1) {
                maxLevel = null;
                System.out.println("[Jobs] - Job " + jobKey + " is missing the max-level property. defaulting to no limits !");
            }
            if ((maxSlots = Integer.valueOf(conf.getInt("Jobs." + jobKey + ".slots", -1))) == -1) {
                maxSlots = null;
                System.out.println("[Jobs] - Job " + jobKey + " is missing the slots property. defaulting to no limits !");
            }
            if ((jobShortName = conf.getString("Jobs." + jobKey + ".shortname")) == null) {
                System.err.println("[Jobs] - Job " + jobKey + " is missing the shortname property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            ChatColor jobColour = ChatColor.valueOf((String)conf.getString("Jobs." + jobKey + ".ChatColour", "").toUpperCase());
            if (jobColour == null) {
                System.err.println("[Jobs] - Job " + jobKey + " is missing the ChatColour property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            String disp = conf.getString("Jobs." + jobKey + ".chat-display", "").toLowerCase();
            if (disp.equals("full")) {
                displayMethod = DisplayMethod.FULL;
            } else if (disp.equals("job")) {
                displayMethod = DisplayMethod.JOB;
            } else if (disp.equals("title")) {
                displayMethod = DisplayMethod.TITLE;
            } else if (disp.equals("none")) {
                displayMethod = DisplayMethod.NONE;
            } else if (disp.equals("shortfull")) {
                displayMethod = DisplayMethod.SHORT_FULL;
            } else if (disp.equals("shortjob")) {
                displayMethod = DisplayMethod.SHORT_JOB;
            } else if (disp.equals("shorttitle")) {
                displayMethod = DisplayMethod.SHORT_TITLE;
            } else {
                System.err.println("[Jobs] - Job " + jobKey + " has an invalid chat-display property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            String maxExpEquationInput = conf.getString("Jobs." + jobKey + ".leveling-progression-equation");
            try {
                maxExpEquation = new Parser(maxExpEquationInput);
            }
            catch (Exception e) {
                System.err.println("[Jobs] - Job " + jobKey + " has an invalid leveling-progression-equation property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            String incomeEquationInput = conf.getString("Jobs." + jobKey + ".income-progression-equation");
            try {
                incomeEquation = new Parser(incomeEquationInput);
            }
            catch (Exception e) {
                System.err.println("[Jobs] - Job " + jobKey + " has an invalid income-progression-equation property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            String expEquationInput = conf.getString("Jobs." + jobKey + ".experience-progression-equation");
            try {
                expEquation = new Parser(expEquationInput);
            }
            catch (Exception e) {
                System.err.println("[Jobs] - Job " + jobKey + " has an invalid experience-progression-equation property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            List breakKeys = conf.getKeys("Jobs." + jobKey + ".Break");
            HashMap<String, JobsMaterialInfo> jobBreakInfo = new HashMap<String, JobsMaterialInfo>();
            if (breakKeys != null) {
                for (String breakKey : breakKeys) {
                    Material material;
                    String materialType = breakKey.toUpperCase();
                    String subType = "";
                    if (materialType.contains("-")) {
                        subType = ":" + materialType.split("-")[1];
                        materialType = materialType.split("-")[0];
                    }
                    try {
                        material = Material.matchMaterial((String)materialType);
                    }
                    catch (IllegalArgumentException e) {
                        material = null;
                    }
                    if (material == null) {
                        System.err.println("[Jobs] - Job " + jobKey + " has an invalid " + breakKey + " Break material type property. Skipping!");
                        continue;
                    }
                    MaterialData materialData = new MaterialData(material);
                    Double income = conf.getDouble("Jobs." + jobKey + ".Break." + breakKey + ".income", 0.0);
                    Double experience = conf.getDouble("Jobs." + jobKey + ".Break." + breakKey + ".experience", 0.0);
                    jobBreakInfo.put(material.toString() + subType, new JobsMaterialInfo(materialData, experience, income));
                }
            }
            List placeKeys = conf.getKeys("Jobs." + jobKey + ".Place");
            HashMap<String, JobsMaterialInfo> jobPlaceInfo = new HashMap<String, JobsMaterialInfo>();
            if (placeKeys != null) {
                for (String placeKey : placeKeys) {
                    Material material;
                    String materialType = placeKey.toUpperCase();
                    String subType = "";
                    if (materialType.contains("-")) {
                        subType = ":" + materialType.split("-")[1];
                        materialType = materialType.split("-")[0];
                    }
                    try {
                        material = Material.matchMaterial((String)materialType);
                    }
                    catch (IllegalArgumentException e) {
                        material = null;
                    }
                    if (material == null) {
                        System.err.println("[Jobs] - Job " + jobKey + " has an invalid " + placeKey + " Place material type property. Skipping!");
                        continue;
                    }
                    MaterialData materialData = new MaterialData(material);
                    Double income = conf.getDouble("Jobs." + jobKey + ".Place." + placeKey + ".income", 0.0);
                    Double experience = conf.getDouble("Jobs." + jobKey + ".Place." + placeKey + ".experience", 0.0);
                    jobPlaceInfo.put(material.toString() + subType, new JobsMaterialInfo(materialData, experience, income));
                }
            }
            List craftKeys = conf.getKeys("Jobs." + jobKey + ".Craft");
            HashMap<String, JobsMaterialInfo> jobCraftInfo = new HashMap<String, JobsMaterialInfo>();
            if (craftKeys != null) {
                for (String craftKey : craftKeys) {
                    Material material;
                    String materialType = craftKey.toUpperCase();
                    String subType = "";
                    if (materialType.contains("-")) {
                        subType = ":" + materialType.split("-")[1];
                        materialType = materialType.split("-")[0];
                    }
                    try {
                        material = Material.matchMaterial((String)materialType);
                    }
                    catch (IllegalArgumentException e) {
                        material = null;
                    }
                    if (material == null) {
                        System.err.println("[Jobs] - Job " + jobKey + " has an invalid " + craftKey + " Craft material type property. Skipping!");
                        continue;
                    }
                    MaterialData materialData = new MaterialData(material);
                    Double income = conf.getDouble("Jobs." + jobKey + ".Craft." + craftKey + ".income", 0.0);
                    Double experience = conf.getDouble("Jobs." + jobKey + ".Craft." + craftKey + ".experience", 0.0);
                    jobCraftInfo.put(material.toString() + subType, new JobsMaterialInfo(materialData, experience, income));
                }
            }
            List killKeys = conf.getKeys("Jobs." + jobKey + ".Kill");
            HashMap<String, JobsLivingEntityInfo> jobKillInfo = new HashMap<String, JobsLivingEntityInfo>();
            if (killKeys != null) {
                for (String killKey : killKeys) {
                    Class<?> victim;
                    try {
                        victim = Class.forName("org.bukkit.craftbukkit.entity.Craft" + killKey);
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("[Jobs] - Job " + jobKey + " has an invalid " + killKey + " Kill entity type property. Skipping!");
                        continue;
                    }
                    Double income = conf.getDouble("Jobs." + jobKey + ".Kill." + killKey + ".income", 0.0);
                    Double experience = conf.getDouble("Jobs." + jobKey + ".Kill." + killKey + ".experience", 0.0);
                    jobKillInfo.put(("org.bukkit.craftbukkit.entity.Craft" + killKey).trim(), new JobsLivingEntityInfo(victim, experience, income));
                }
            }
            List fishKeys = conf.getKeys("Jobs." + jobKey + ".Fish");
            HashMap<String, JobsMaterialInfo> jobFishInfo = new HashMap<String, JobsMaterialInfo>();
            if (fishKeys != null) {
                for (String fishKey : fishKeys) {
                    Material material;
                    String materialType = fishKey.toUpperCase();
                    String subType = "";
                    if (materialType.contains("-")) {
                        subType = ":" + materialType.split("-")[1];
                        materialType = materialType.split("-")[0];
                    }
                    try {
                        material = Material.matchMaterial((String)materialType);
                    }
                    catch (IllegalArgumentException e) {
                        material = null;
                    }
                    if (material == null) {
                        System.err.println("[Jobs] - Job " + jobKey + " has an invalid " + fishKey + " Fish material type property. Disabling jobs!");
                        Jobs.disablePlugin();
                        return;
                    }
                    MaterialData materialData = new MaterialData(material);
                    Double income = conf.getDouble("Jobs." + jobKey + ".Fish." + fishKey + ".income", 0.0);
                    Double experience = conf.getDouble("Jobs." + jobKey + ".Fish." + fishKey + ".experience", 0.0);
                    jobFishInfo.put(material.toString() + subType, new JobsMaterialInfo(materialData, experience, income));
                }
            }
            if ((customKillKeys = conf.getKeys("Jobs." + jobKey + ".custom-kill")) != null) {
                for (String customKillKey : customKillKeys) {
                    String entityType = customKillKey.toString();
                    Double income = conf.getDouble("Jobs." + jobKey + ".custom-kill." + customKillKey + ".income", 0.0);
                    Double experience = conf.getDouble("Jobs." + jobKey + ".custom-kill." + customKillKey + ".experience", 0.0);
                    try {
                        jobKillInfo.put(("org.bukkit.craftbukkit.entity.CraftPlayer:" + entityType).trim(), new JobsLivingEntityInfo(Class.forName("org.bukkit.craftbukkit.entity.CraftPlayer"), experience, income));
                    }
                    catch (ClassNotFoundException e) {
                        System.err.println("[Jobs] - Job " + jobKey + " has an invalid " + customKillKey + " custom-kill entity type property. Disabling jobs!");
                        Jobs.disablePlugin();
                        return;
                    }
                }
            }
            this.jobs.put(jobName.toLowerCase(), new Job(jobBreakInfo, jobPlaceInfo, jobKillInfo, jobFishInfo, jobCraftInfo, jobName, jobShortName, jobColour, maxExpEquation, incomeEquation, expEquation, displayMethod, maxLevel, maxSlots));
        }
    }

    private void loadSlots() {
        this.usedSlots = new HashMap();
        for (Job temp : this.jobs.values()) {
            this.usedSlots.put(temp, JobsConfiguration.getInstance().getJobsDAO().getSlotsTaken(temp));
        }
    }

    public static JobConfig getInstance() {
        if (jobsConfig == null) {
            jobsConfig = new JobConfig();
        }
        return jobsConfig;
    }

    public Job getJob(String jobName) {
        return this.jobs.get(jobName.toLowerCase());
    }

    public Collection<Job> getJobs() {
        return this.jobs.values();
    }

    public Integer getUsedSlots(Job job) {
        return this.usedSlots.get(job);
    }

    public void takeSlot(Job job) {
        this.usedSlots.put(job, this.usedSlots.get(job) + 1);
    }

    public void leaveSlot(Job job) {
        this.usedSlots.put(job, this.usedSlots.get(job) - 1);
    }
}

