/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.config;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.util.config.Configuration;

public class MessageConfig {
    private static MessageConfig instance = null;
    private HashMap<String, String> messages;

    private MessageConfig() {
    }

    public static MessageConfig getInstance() {
        if (instance == null) {
            instance = new MessageConfig();
        }
        return instance;
    }

    public void reload() {
        this.messages = new HashMap();
        File f = new File("plugins/Jobs/messageConfig.yml");
        if (!f.exists()) {
            System.err.println("[Jobs] - configuration file messageConfig.yml does not exist, using default messages.");
            return;
        }
        Configuration conf = new Configuration(f);
        conf.load();
        List configKeys = conf.getKeys(null);
        if (configKeys == null) {
            return;
        }
        for (String key : configKeys) {
            this.messages.put(key, this.parseColors(conf.getString(key)));
        }
    }

    private String parseColors(String value) {
        return value.replace("ChatColor.AQUA", ChatColor.AQUA.toString()).replace("ChatColor.BLACK", ChatColor.BLACK.toString()).replace("ChatColor.BLUE", ChatColor.BLUE.toString()).replace("ChatColor.DARK_AQUA", ChatColor.DARK_AQUA.toString()).replace("ChatColor.DARK_BLUE", ChatColor.DARK_BLUE.toString()).replace("ChatColor.DARK_GRAY", ChatColor.DARK_GRAY.toString()).replace("ChatColor.DARK_GREEN", ChatColor.DARK_GREEN.toString()).replace("ChatColor.DARK_PURPLE", ChatColor.DARK_PURPLE.toString()).replace("ChatColor.DARK_RED", ChatColor.DARK_RED.toString()).replace("ChatColor.GOLD", ChatColor.GOLD.toString()).replace("ChatColor.GRAY", ChatColor.GRAY.toString()).replace("ChatColor.GREEN", ChatColor.GREEN.toString()).replace("ChatColor.LIGHT_PURPLE", ChatColor.LIGHT_PURPLE.toString()).replace("ChatColor.RED", ChatColor.RED.toString()).replace("ChatColor.WHITE", ChatColor.WHITE.toString()).replace("ChatColor.YELLOW", ChatColor.YELLOW.toString());
    }

    public String getMessage(String key) {
        String message = this.messages.get(key);
        if (message != null) {
            return message;
        }
        JobsMessageEnum enumKey = JobsMessageEnum.fromString(key);
        switch (enumKey) {
            case ADMIN_COMMAND_FAILED: {
                return ChatColor.RED + "There was an error in the command";
            }
            case ADMIN_COMMAND_SUCCESS: {
                return "Your command has been performed.";
            }
            case AT_MAX_LEVEL: {
                return ChatColor.YELLOW + "-- You have reached the maximum level --";
            }
            case BREAK_HEADER: {
                return "Break:";
            }
            case BREAK_INFO_NO_SUB: {
                return "    %item% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case BREAK_INFO_SUB: {
                return "    %item%:%subitem% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case BREAK_NONE: {
                return "%jobcolour%%jobname%" + ChatColor.WHITE + " does not get money from breaking anything.";
            }
            case BROWSE_JOBS_FOOTER: {
                return "For more information type in /jobs info [JobName]";
            }
            case BROWSE_JOBS_HEADER: {
                return "You are allowed to join the following jobs:";
            }
            case BROWSE_NO_JOBS: {
                return "There are no jobs you can join";
            }
            case CRAFT_HEADER: {
                return "Craft:";
            }
            case CRAFT_INFO_NO_SUB: {
                return "    %item% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case CRAFT_INFO_SUB: {
                return "    %item%:%subitem% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case CRAFT_NONE: {
                return "%jobcolour%%jobname%" + ChatColor.WHITE + " does not get money from crafting.";
            }
            case DEMOTE_TARGET: {
                return "You have been demoted %levelslost% levels in %jobcolour%%jobname%";
            }
            case EMPLOY_TARGET: {
                return "You have been employed in %jobcolour%%jobname%";
            }
            case ERROR_NO_JOB: {
                return ChatColor.RED + "The job you have selected does not exist";
            }
            case ERROR_NO_PERMISSION: {
                return ChatColor.RED + "You do not have permission to do that";
            }
            case FIRE_TARGET: {
                return "You have been fired from %jobcolour%%jobname%";
            }
            case FIRE_TARGET_NO_JOB: {
                return "Player does not have the job %jobcolour%%jobname%";
            }
            case FISH_HEADER: {
                return "Fish:";
            }
            case FISH_INFO_NO_SUB: {
                return "    %item% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case FISH_INFO_SUB: {
                return "    %item%:%subitem% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case FISH_NONE: {
                return "%jobcolour%%jobname%" + ChatColor.WHITE + " does not get money for fish.";
            }
            case GRANTXP_TARGET: {
                return "You have been granted %expgained% experience in %jobcolour%%jobname%";
            }
            case JOBS_ADMIN_DEMOTE: {
                return "/jobs demote <playername> <job> <levels> - demote the player X levels in a job";
            }
            case JOBS_ADMIN_EMPLOY: {
                return "/jobs employ <playername> <job> - employ the player to the job";
            }
            case JOBS_ADMIN_FIRE: {
                return "/jobs fire <playername> <job> - fire the player from the job";
            }
            case JOBS_ADMIN_GRANTXP: {
                return "/jobs grantxp <playername> <job> <experience> - grant the player X experience in a job";
            }
            case JOBS_ADMIN_INFO: {
                return ChatColor.YELLOW + "/jobs admininfo <playername>" + ChatColor.WHITE + " - shows the level of each job and experience gains for the player.";
            }
            case JOBS_ADMIN_PROMOTE: {
                return "/jobs promote <playername> <job> <levels> - promote the player X levels in a job";
            }
            case JOBS_ADMIN_REMOVEXP: {
                return "/jobs removexp <playername> <job> <experience> - remove X experience from the player in a job";
            }
            case JOBS_ADMIN_TRANSFER: {
                return "/jobs transfer <playername> <oldjob> <newjob> - transfer a player's job from an old job to a new job";
            }
            case JOBS_ADMIN_RELOAD: {
                return ChatColor.YELLOW + "/jobs reload" + ChatColor.WHITE + " - reload the Jobs plugin.";
            }
            case JOBS_BROWSE: {
                return "/jobs browse - list the jobs available to you";
            }
            case JOBS_INFO: {
                return "/jobs info <jobname> <break, place, kill, fish, craft> - show how much each job is getting paid and for what";
            }
            case JOBS_JOIN: {
                return "/jobs join <jobname> - join the selected job";
            }
            case JOBS_LEAVE: {
                return "/jobs leave <jobname> - leave the selected job";
            }
            case JOBS_STATS: {
                return "/jobs stats - show the level you are in each job you are part of";
            }
            case JOIN_JOB_FAILED_ALREADY_IN: {
                return "You are already in the job %jobcolour%%jobname%" + ChatColor.WHITE + ".";
            }
            case JOIN_JOB_FAILED_NO_SLOTS: {
                return "You cannot join the job %jobcolour%%jobname%" + ChatColor.WHITE + ", there are no slots available.";
            }
            case JOIN_JOB_SUCCESS: {
                return "You have joined the job %jobcolour%%jobname%" + ChatColor.WHITE + ".";
            }
            case JOIN_TOO_MANY_JOB: {
                return ChatColor.RED + "You have already joined too many jobs.";
            }
            case KILL_HEADER: {
                return "Kill:";
            }
            case KILL_INFO_NO_SUB: {
                return "    %item% - %income%" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case KILL_INFO_SUB: {
                return "    %item%:%subitem% - %income%" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case KILL_NONE: {
                return "%jobcolour%%jobname%" + ChatColor.WHITE + " does not get money from killing anything.";
            }
            case LEAVE_JOB_FAILED_TOO_MANY: {
                return "You have already joined too many jobs.";
            }
            case LEAVE_JOB_SUCCESS: {
                return "You have left the job %jobcolour%%jobname%" + ChatColor.WHITE + ".";
            }
            case LEVEL_UP_BROADCAST: {
                return "%playername% is now a level %joblevel% %jobcolour%%jobname%" + ChatColor.WHITE + ".";
            }
            case LEVEL_UP_NO_BROADCAST: {
                return "You are now a level %joblevel% %jobcolour%%jobname%" + ChatColor.WHITE + ".";
            }
            case PLACE_HEADER: {
                return "Place:";
            }
            case PLACE_INFO_NO_SUB: {
                return "    %item% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case PLACE_INFO_SUB: {
                return "    %item%:%subitem% - %income%" + ChatColor.GREEN + " income" + ChatColor.WHITE + ", %experience%" + ChatColor.YELLOW + " exp";
            }
            case PLACE_NONE: {
                return "%jobcolour%%jobname%" + ChatColor.WHITE + " does not get money from placing anything.";
            }
            case PROMOTE_TARGET: {
                return "You have been promoted %levelsgained% levels in %jobcolour%%jobname%";
            }
            case REMOVEXP_TARGET: {
                return "You have lost %explost% experience in jobcolour%%jobname%";
            }
            case SKILL_UP_BROADCAST: {
                return "%playername% has been promoted to a %titlecolour%%titlename% %jobcolour%%jobname%" + ChatColor.WHITE + ".";
            }
            case SKILL_UP_NO_BROADCAST: {
                return "Congratulations, you have been promoted to a %titlecolour%%titlename% %jobcolour%%jobname%" + ChatColor.WHITE + ".";
            }
            case STATS_JOB: {
                return "lvl%joblevel% %jobcolour%%jobname%:\n    Experience: %jobexp% / %jobmaxexp%";
            }
            case STATS_NO_JOB: {
                return ChatColor.RED + "Please join a job first";
            }
            case TRANSFER_TARGET: {
                return "You have been transferred from %oldjobcolour%%oldjobname% to %newjobcolour%%newjobname%";
            }
        }
        System.err.println("[Jobs] Message " + key + " does not exist!");
        return null;
    }

    private static enum JobsMessageEnum {
        ADMIN_COMMAND_FAILED,
        ADMIN_COMMAND_SUCCESS,
        AT_MAX_LEVEL,
        BREAK_HEADER,
        BREAK_INFO_NO_SUB,
        BREAK_INFO_SUB,
        BREAK_NONE,
        BROWSE_JOBS_FOOTER,
        BROWSE_JOBS_HEADER,
        BROWSE_NO_JOBS,
        CRAFT_HEADER,
        CRAFT_NONE,
        CRAFT_INFO_NO_SUB,
        CRAFT_INFO_SUB,
        DEMOTE_TARGET,
        EMPLOY_TARGET,
        ERROR_NO_JOB,
        ERROR_NO_PERMISSION,
        FIRE_TARGET,
        FIRE_TARGET_NO_JOB,
        FISH_HEADER,
        FISH_INFO_NO_SUB,
        FISH_INFO_SUB,
        FISH_NONE,
        GRANTXP_TARGET,
        JOBS_ADMIN_DEMOTE,
        JOBS_ADMIN_EMPLOY,
        JOBS_ADMIN_FIRE,
        JOBS_ADMIN_GRANTXP,
        JOBS_ADMIN_INFO,
        JOBS_ADMIN_PROMOTE,
        JOBS_ADMIN_REMOVEXP,
        JOBS_ADMIN_TRANSFER,
        JOBS_ADMIN_RELOAD,
        JOBS_BROWSE,
        JOBS_INFO,
        JOBS_JOIN,
        JOBS_LEAVE,
        JOBS_STATS,
        JOIN_JOB_FAILED_ALREADY_IN,
        JOIN_JOB_FAILED_NO_SLOTS,
        JOIN_JOB_SUCCESS,
        JOIN_TOO_MANY_JOB,
        KILL_HEADER,
        KILL_INFO_NO_SUB,
        KILL_INFO_SUB,
        KILL_NONE,
        LEAVE_JOB_FAILED_TOO_MANY,
        LEAVE_JOB_SUCCESS,
        LEVEL_UP_BROADCAST,
        LEVEL_UP_NO_BROADCAST,
        PLACE_HEADER,
        PLACE_INFO_NO_SUB,
        PLACE_INFO_SUB,
        PLACE_NONE,
        PROMOTE_TARGET,
        REMOVEXP_TARGET,
        SKILL_UP_BROADCAST,
        SKILL_UP_NO_BROADCAST,
        STATS_JOB,
        STATS_NO_JOB,
        TRANSFER_TARGET;


        public static JobsMessageEnum fromString(String text) {
            if (text != null) {
                text = text.replace('-', '_').toUpperCase();
                for (JobsMessageEnum m : JobsMessageEnum.values()) {
                    if (!text.equals(m.toString())) continue;
                    return m;
                }
            }
            return null;
        }
    }
}

