/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.config.container;

import com.zford.jobs.Jobs;
import com.zford.jobs.config.JobConfig;
import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.container.Job;
import com.zford.jobs.config.container.JobProgression;
import com.zford.jobs.dao.JobsDAO;
import com.zford.jobs.dao.container.JobsDAOData;
import com.zford.jobs.event.JobsEvent;
import com.zford.jobs.event.JobsLevelUpEvent;
import com.zford.jobs.event.JobsSkillUpEvent;
import com.zford.jobs.util.DisplayMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class JobsPlayer {
    private Jobs plugin;
    private String playername;
    private List<Job> jobs;
    private HashMap<Job, JobProgression> progression;
    private String honorific = null;

    public JobsPlayer(Jobs plugin, String playername, JobsDAO dao) {
        this.plugin = plugin;
        this.playername = playername;
        this.jobs = new ArrayList<Job>();
        this.progression = new HashMap();
        List<JobsDAOData> list = dao.getAllJobs(this);
        if (list != null) {
            for (JobsDAOData job : list) {
                if (JobConfig.getInstance().getJob(job.getJobName()) == null) continue;
                this.jobs.add(JobConfig.getInstance().getJob(job.getJobName()));
                JobProgression jobProgression = new JobProgression(JobConfig.getInstance().getJob(job.getJobName()), job.getExperience(), job.getLevel(), this);
                this.progression.put(jobProgression.getJob(), jobProgression);
            }
        }
        this.reloadMaxExperience();
        this.reloadHonorific();
    }

    public void broke(Block block, double multiplier) {
        Job jobNone;
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("numjobs", Double.valueOf(this.progression.size()));
        for (Map.Entry<Job, JobProgression> entry : this.progression.entrySet()) {
            param.put("joblevel", Double.valueOf(entry.getValue().getLevel()));
            Double income = entry.getKey().getBreakIncome(block, param);
            if (income != null) {
                Double exp = entry.getKey().getBreakExp(block, param);
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
                entry.getValue().addExp(exp * multiplier);
                this.checkLevels();
            }
            param.remove("joblevel");
        }
        if (this.progression.size() == 0 && (jobNone = JobConfig.getInstance().getJob("None")) != null) {
            param.put("joblevel", 1.0);
            Double income = jobNone.getBreakIncome(block, param);
            if (income != null) {
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
            }
            param.remove("joblevel");
        }
        JobsConfiguration.getInstance().getEconomyLink().updateStats(this);
    }

    public void placed(Block block, double multiplier) {
        Job jobNone;
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("numjobs", Double.valueOf(this.progression.size()));
        for (Map.Entry<Job, JobProgression> entry : this.progression.entrySet()) {
            param.put("joblevel", Double.valueOf(entry.getValue().getLevel()));
            Double income = entry.getKey().getPlaceIncome(block, param);
            if (income != null) {
                Double exp = entry.getKey().getPlaceExp(block, param);
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
                entry.getValue().addExp(exp * multiplier);
                this.checkLevels();
            }
            param.remove("joblevel");
        }
        if (this.progression.size() == 0 && (jobNone = JobConfig.getInstance().getJob("None")) != null) {
            param.put("joblevel", 1.0);
            Double income = jobNone.getPlaceIncome(block, param);
            if (income != null) {
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
            }
            param.remove("joblevel");
        }
        JobsConfiguration.getInstance().getEconomyLink().updateStats(this);
    }

    public void killed(String victim, double multiplier) {
        Job jobNone;
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("numjobs", Double.valueOf(this.progression.size()));
        for (Map.Entry<Job, JobProgression> entry : this.progression.entrySet()) {
            param.put("joblevel", Double.valueOf(entry.getValue().getLevel()));
            Double income = entry.getKey().getKillIncome(victim, param);
            if (income != null) {
                Double exp = entry.getKey().getKillExp(victim, param);
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
                entry.getValue().addExp(exp * multiplier);
                this.checkLevels();
            }
            param.remove("joblevel");
        }
        if (this.progression.size() == 0 && (jobNone = JobConfig.getInstance().getJob("None")) != null) {
            param.put("joblevel", 1.0);
            Double income = jobNone.getKillIncome(victim, param);
            if (income != null) {
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
            }
            param.remove("joblevel");
        }
        JobsConfiguration.getInstance().getEconomyLink().updateStats(this);
    }

    public void fished(Item item, double multiplier) {
        Job jobNone;
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("numjobs", Double.valueOf(this.progression.size()));
        for (Map.Entry<Job, JobProgression> entry : this.progression.entrySet()) {
            param.put("joblevel", Double.valueOf(entry.getValue().getLevel()));
            Double income = entry.getKey().getFishIncome(item, param);
            if (income != null) {
                Double exp = entry.getKey().getFishExp(item, param);
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
                entry.getValue().addExp(exp * multiplier);
                this.checkLevels();
            }
            param.remove("joblevel");
        }
        if (this.progression.size() == 0 && (jobNone = JobConfig.getInstance().getJob("None")) != null) {
            param.put("joblevel", 1.0);
            Double income = jobNone.getFishIncome(item, param);
            if (income != null) {
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
            }
            param.remove("joblevel");
        }
        JobsConfiguration.getInstance().getEconomyLink().updateStats(this);
    }

    public void crafted(ItemStack items, double multiplier) {
        Job jobNone;
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("numjobs", Double.valueOf(this.progression.size()));
        for (Map.Entry<Job, JobProgression> entry : this.progression.entrySet()) {
            param.put("joblevel", Double.valueOf(entry.getValue().getLevel()));
            Double income = entry.getKey().getCraftIncome(items, param);
            if (income != null) {
                Double exp = entry.getKey().getCraftExp(items, param);
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
                entry.getValue().addExp(exp * multiplier);
                this.checkLevels();
            }
            param.remove("joblevel");
        }
        if (this.progression.size() == 0 && (jobNone = JobConfig.getInstance().getJob("None")) != null) {
            param.put("joblevel", 1.0);
            Double income = jobNone.getCraftIncome(items, param);
            if (income != null) {
                JobsConfiguration.getInstance().getEconomyLink().pay(this, income * multiplier);
            }
            param.remove("joblevel");
        }
        JobsConfiguration.getInstance().getEconomyLink().updateStats(this);
    }

    public List<Job> getJobs() {
        return this.jobs;
    }

    public Collection<JobProgression> getJobsProgression() {
        return this.progression.values();
    }

    public JobProgression getJobsProgression(Job job) {
        return this.progression.get(job);
    }

    public String getName() {
        return this.playername;
    }

    public void checkLevels() {
        for (JobProgression temp : this.progression.values()) {
            JobsEvent event;
            if (temp.canLevelUp()) {
                event = new JobsLevelUpEvent(this, temp);
                this.plugin.getServer().getPluginManager().callEvent((Event)event);
            }
            if (JobsConfiguration.getInstance().getTitleForLevel(temp.getLevel()) == null || JobsConfiguration.getInstance().getTitleForLevel(temp.getLevel()).equals(temp.getTitle())) continue;
            event = new JobsSkillUpEvent(this, temp, JobsConfiguration.getInstance().getTitleForLevel(temp.getLevel()));
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
        }
    }

    public String getDisplayHonorific() {
        String honorific = "";
        if (this.jobs.size() > 1) {
            for (JobProgression temp : this.progression.values()) {
                if ((temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.FULL) || temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.TITLE) || temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.SHORT_FULL) || temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.SHORT_TITLE)) && temp.getTitle() != null) {
                    honorific = honorific + temp.getTitle().getChatColor() + temp.getTitle().getShortName() + ChatColor.WHITE;
                }
                if (temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.FULL) || temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.JOB) || temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.SHORT_FULL) || temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.SHORT_JOB)) {
                    honorific = honorific + temp.getJob().getChatColour() + temp.getJob().getShortName() + ChatColor.WHITE;
                }
                if (temp.getJob().getDisplayMethod().equals((Object)DisplayMethod.NONE)) continue;
                honorific = honorific + " ";
            }
        } else {
            Job job = this.jobs.size() == 0 ? JobConfig.getInstance().getJob("None") : this.jobs.get(0);
            if (job == null) {
                return null;
            }
            JobProgression jobProgression = this.progression.get(job);
            if (job.getDisplayMethod().equals((Object)DisplayMethod.FULL) || job.getDisplayMethod().equals((Object)DisplayMethod.TITLE)) {
                if (jobProgression != null && jobProgression.getTitle() != null) {
                    honorific = honorific + jobProgression.getTitle().getChatColor() + jobProgression.getTitle().getName() + ChatColor.WHITE;
                }
                if (job.getDisplayMethod().equals((Object)DisplayMethod.FULL)) {
                    honorific = honorific + " ";
                }
            }
            if ((job.getDisplayMethod().equals((Object)DisplayMethod.SHORT_FULL) || job.getDisplayMethod().equals((Object)DisplayMethod.SHORT_TITLE)) && jobProgression != null && jobProgression.getTitle() != null) {
                honorific = honorific + jobProgression.getTitle().getChatColor() + jobProgression.getTitle().getShortName() + ChatColor.WHITE;
            }
            if (job.getDisplayMethod().equals((Object)DisplayMethod.FULL) || job.getDisplayMethod().equals((Object)DisplayMethod.JOB)) {
                honorific = honorific + job.getChatColour() + job.getName() + ChatColor.WHITE;
            }
            if (job.getDisplayMethod().equals((Object)DisplayMethod.SHORT_FULL) || job.getDisplayMethod().equals((Object)DisplayMethod.SHORT_JOB)) {
                honorific = honorific + job.getChatColour() + job.getShortName() + ChatColor.WHITE;
            }
        }
        if (honorific.equals("")) {
            return null;
        }
        return honorific.trim();
    }

    public void joinJob(Job job) {
        this.jobs.add(job);
        this.progression.put(job, new JobProgression(job, 0.0, 1, this));
    }

    public void leaveJob(Job job) {
        this.jobs.remove(job);
        this.progression.remove(job);
    }

    public void transferJob(Job oldjob, Job newjob) {
        JobProgression prog = this.progression.get(oldjob);
        this.jobs.remove(oldjob);
        this.jobs.add(newjob);
        this.progression.remove(oldjob);
        prog.setJob(newjob);
        this.progression.put(newjob, prog);
    }

    public boolean isInJob(Job job) {
        return this.jobs.contains(job);
    }

    public void reloadHonorific() {
        String newHonorific = this.getDisplayHonorific();
        Player player = this.plugin.getServer().getPlayer(this.playername);
        if (player == null) {
            return;
        }
        if (newHonorific == null && this.honorific != null) {
            player.setDisplayName(player.getDisplayName().trim().replaceFirst(this.honorific + " ", "").trim());
        } else if (newHonorific != null && this.honorific != null) {
            player.setDisplayName(player.getDisplayName().trim().replaceFirst(this.honorific, newHonorific).trim());
        } else if (newHonorific != null && this.honorific == null) {
            player.setDisplayName((newHonorific + " " + player.getDisplayName().trim()).trim());
        }
        this.honorific = newHonorific;
    }

    public void removeHonorific() {
        Player player = this.plugin.getServer().getPlayer(this.playername);
        if (player == null) {
            return;
        }
        if (this.honorific != null) {
            player.setDisplayName(player.getDisplayName().trim().replaceFirst(this.honorific + " ", "").trim());
        }
        this.honorific = null;
    }

    public void reloadMaxExperience() {
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("numjobs", Double.valueOf(this.progression.size()));
        for (JobProgression temp : this.progression.values()) {
            param.put("joblevel", Double.valueOf(temp.getLevel()));
            temp.setMaxExperience((int)temp.getJob().getMaxExp(param));
            param.remove("joblevel");
        }
    }
}

