/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.dao;

import com.zford.jobs.Jobs;
import com.zford.jobs.config.container.Job;
import com.zford.jobs.config.container.JobsPlayer;
import com.zford.jobs.dao.JobsConnection;
import com.zford.jobs.dao.JobsConnectionPool;
import com.zford.jobs.dao.container.JobsDAOData;
import java.sql.SQLException;
import java.util.List;

public abstract class JobsDAO {
    private JobsConnectionPool pool;

    public JobsDAO(String driver, String url, String username, String password) {
        try {
            this.pool = new JobsConnectionPool(driver, url, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("[Jobs] - database connection error. Disabling jobs!");
            Jobs.disablePlugin();
        }
    }

    public abstract List<JobsDAOData> getAllJobs(JobsPlayer var1);

    public abstract void joinJob(JobsPlayer var1, Job var2);

    public abstract void quitJob(JobsPlayer var1, Job var2);

    public abstract void save(JobsPlayer var1);

    public abstract Integer getSlotsTaken(Job var1);

    protected JobsConnection getConnection() throws SQLException {
        return this.pool.getConnection();
    }

    public void closeConnections() {
        this.pool.closeConnections();
    }
}

