/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.listener;

import com.nidefawl.Stats.Stats;
import com.zford.jobs.Jobs;
import com.zford.jobs.config.JobConfig;
import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.MessageConfig;
import com.zford.jobs.config.container.JobProgression;
import com.zford.jobs.config.container.JobsPlayer;
import com.zford.jobs.event.JobsEventListener;
import com.zford.jobs.event.JobsJoinEvent;
import com.zford.jobs.event.JobsLeaveEvent;
import com.zford.jobs.event.JobsLevelUpEvent;
import com.zford.jobs.event.JobsSkillUpEvent;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class JobsJobListener
extends JobsEventListener {
    Jobs plugin;

    public JobsJobListener(Jobs plugin) {
        this.plugin = plugin;
    }

    @Override
    public void onJobLevelUp(JobsLevelUpEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = this.plugin.getServer().getPlayer(event.getPlayer().getName());
        if (event.getJobProgression().getJob().getMaxLevel() == null || event.getJobProgression().getLevel() < event.getJobProgression().getJob().getMaxLevel()) {
            JobProgression progression = event.getJobProgression();
            progression.setLevel(progression.getLevel() + 1);
            progression.setExperience(progression.getExperience() - (double)progression.getMaxExperience());
            HashMap<String, Double> param = new HashMap<String, Double>();
            param.put("numjobs", Double.valueOf(event.getNumJobs()));
            param.put("joblevel", Double.valueOf(progression.getLevel()));
            progression.setMaxExperience((int)progression.getJob().getMaxExp(param));
            String message = JobsConfiguration.getInstance().isBroadcastingLevelups() ? MessageConfig.getInstance().getMessage("level-up-broadcast") : MessageConfig.getInstance().getMessage("level-up-no-broadcast");
            message = message.replace("%jobname%", "" + progression.getJob().getName());
            message = message.replace("%jobcolour%", "" + progression.getJob().getChatColour());
            if (progression.getTitle() != null) {
                message = message.replace("%titlename%", "" + progression.getTitle().getName());
                message = message.replace("%titlecolour%", "" + progression.getTitle().getChatColor());
            }
            message = message.replace("%playername%", "" + event.getPlayer().getName());
            message = player == null ? message.replace("%playerdisplayname%", "" + event.getPlayer().getName()) : message.replace("%playerdisplayname%", "" + player.getDisplayName());
            message = message.replace("%joblevel%", "" + progression.getLevel());
            if (JobsConfiguration.getInstance().isBroadcastingLevelups()) {
                for (String line : message.split("\n")) {
                    this.plugin.getServer().broadcastMessage(line);
                }
            } else if (player != null) {
                for (String line : message.split("\n")) {
                    player.sendMessage(line);
                }
            }
            if (JobsConfiguration.getInstance().getStats() != null && JobsConfiguration.getInstance().getStats().isEnabled()) {
                Stats stats = JobsConfiguration.getInstance().getStats();
                if (progression.getLevel() > stats.get(event.getPlayer().getName(), "job", progression.getJob().getName())) {
                    stats.setStat(event.getPlayer().getName(), "job", progression.getJob().getName(), progression.getLevel());
                    stats.saveAll();
                }
            }
            event.getPlayer().checkLevels();
        } else if (player != null) {
            event.getJobProgression().setExperience(0.0);
            String message = MessageConfig.getInstance().getMessage("at-max-level");
            for (String line : message.split("\n")) {
                player.sendMessage(line);
            }
        }
    }

    @Override
    public void onJobSkillUp(JobsSkillUpEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = this.plugin.getServer().getPlayer(event.getPlayer().getName());
        event.getJobProgression().setTitle(event.getNewTitle());
        if (JobsConfiguration.getInstance().isBroadcastingSkillups()) {
            String message = MessageConfig.getInstance().getMessage("skill-up-broadcast");
            message = message.replace("%playername%", event.getPlayer().getName());
            if (event.getNewTitle() != null) {
                message = message.replace("%titlecolour%", event.getNewTitle().getChatColor().toString());
                message = message.replace("%titlename%", event.getNewTitle().getName());
            }
            message = message.replace("%jobcolour%", event.getJobProgression().getJob().getChatColour().toString());
            message = message.replace("%jobname%", event.getJobProgression().getJob().getName());
            for (String line : message.split("\n")) {
                this.plugin.getServer().broadcastMessage(line);
            }
        } else if (player != null) {
            String message = MessageConfig.getInstance().getMessage("skill-up-no-broadcast");
            if (event.getNewTitle() != null) {
                message = message.replace("%titlecolour%", event.getNewTitle().getChatColor().toString());
                message = message.replace("%titlename%", event.getNewTitle().getName());
            }
            message = message.replace("%jobcolour%", event.getJobProgression().getJob().getChatColour().toString());
            message = message.replace("%jobname%", event.getJobProgression().getJob().getName());
            for (String line : message.split("\n")) {
                player.sendMessage(line);
            }
        }
        event.getJobProgression().setTitle(event.getNewTitle());
        event.getPlayer().reloadHonorific();
    }

    @Override
    public void onJobJoin(JobsJoinEvent event) {
        block12: {
            Player player;
            block10: {
                block11: {
                    Stats stats;
                    if (event.isCancelled()) {
                        return;
                    }
                    player = this.plugin.getServer().getPlayer(event.getPlayer().getName());
                    if (event.getNewJob().getMaxSlots() != null && JobConfig.getInstance().getUsedSlots(event.getNewJob()) >= event.getNewJob().getMaxSlots()) break block10;
                    if (event.getPlayer().isInJob(event.getNewJob())) break block11;
                    event.getPlayer().joinJob(event.getNewJob());
                    JobsConfiguration.getInstance().getJobsDAO().joinJob(event.getPlayer(), event.getNewJob());
                    JobConfig.getInstance().takeSlot(event.getNewJob());
                    String message = MessageConfig.getInstance().getMessage("join-job-success");
                    message = message.replace("%jobcolour%", event.getNewJob().getChatColour().toString());
                    message = message.replace("%jobname%", event.getNewJob().getName());
                    if (player != null) {
                        for (String line : message.split("\n")) {
                            player.sendMessage(line);
                        }
                    }
                    if (!(event.getPlayer() instanceof JobsPlayer)) {
                        event.getPlayer().reloadHonorific();
                        event.getPlayer().reloadMaxExperience();
                    }
                    if (JobsConfiguration.getInstance().getStats() == null || !JobsConfiguration.getInstance().getStats().isEnabled() || 1 <= (stats = JobsConfiguration.getInstance().getStats()).get(event.getPlayer().getName(), "job", event.getNewJob().getName())) break block12;
                    stats.setStat(event.getPlayer().getName(), "job", event.getNewJob().getName(), 1);
                    stats.saveAll();
                    break block12;
                }
                if (player == null) break block12;
                if (event.getPlayer().isInJob(event.getNewJob())) {
                    String message = MessageConfig.getInstance().getMessage("join-job-failed-already-in");
                    message = message.replace("%jobcolour%", event.getNewJob().getChatColour().toString());
                    message = message.replace("%jobname%", event.getNewJob().getName());
                    for (String line : message.split("\n")) {
                        player.sendMessage(line);
                    }
                } else {
                    String message = MessageConfig.getInstance().getMessage("leave-job-failed-too-many");
                    for (String line : message.split("\n")) {
                        player.sendMessage(line);
                    }
                }
                break block12;
            }
            if (player != null && JobConfig.getInstance().getUsedSlots(event.getNewJob()) >= event.getNewJob().getMaxSlots()) {
                String message = MessageConfig.getInstance().getMessage("join-job-failed-no-slots");
                message = message.replace("%jobcolour%", event.getNewJob().getChatColour().toString());
                message = message.replace("%jobname%", event.getNewJob().getName());
                for (String line : message.split("\n")) {
                    player.sendMessage(line);
                }
            }
        }
    }

    @Override
    public void onJobLeave(JobsLeaveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = this.plugin.getServer().getPlayer(event.getPlayer().getName());
        if (event.getPlayer().isInJob(event.getOldJob())) {
            event.getPlayer().leaveJob(event.getOldJob());
            JobsConfiguration.getInstance().getJobsDAO().quitJob(event.getPlayer(), event.getOldJob());
            JobConfig.getInstance().leaveSlot(event.getOldJob());
            if (player != null) {
                String message = MessageConfig.getInstance().getMessage("leave-job-success");
                message = message.replace("%jobcolour%", event.getOldJob().getChatColour().toString());
                message = message.replace("%jobname%", event.getOldJob().getName());
                for (String line : message.split("\n")) {
                    player.sendMessage(line);
                }
            }
            event.getPlayer().reloadHonorific();
            event.getPlayer().reloadMaxExperience();
            event.getPlayer().checkLevels();
        }
    }
}

