/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs;

import com.earth2me.essentials.Essentials;
import com.iCo6.iConomy;
import com.nidefawl.Stats.Stats;
import com.nijikokun.bukkit.Permissions.Permissions;
import com.zford.jobs.JobsCommands;
import com.zford.jobs.config.JobConfig;
import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.MessageConfig;
import com.zford.jobs.config.container.JobsPlayer;
import com.zford.jobs.economy.JobsBOSEconomyLink;
import com.zford.jobs.economy.JobsEssentialsLink;
import com.zford.jobs.economy.JobsiConomy5Link;
import com.zford.jobs.economy.JobsiConomy6Link;
import com.zford.jobs.listener.JobsBlockPaymentListener;
import com.zford.jobs.listener.JobsCraftPaymentListener;
import com.zford.jobs.listener.JobsFishPaymentListener;
import com.zford.jobs.listener.JobsJobListener;
import com.zford.jobs.listener.JobsKillPaymentListener;
import com.zford.jobs.listener.JobsPlayerListener;
import cosine.boseconomy.BOSEconomy;
import java.util.HashMap;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.server.ServerListener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Jobs
extends JavaPlugin {
    private HashMap<String, JobsPlayer> players = null;
    private static Jobs plugin = null;
    private JobsBlockPaymentListener blockListener = new JobsBlockPaymentListener(this);
    private JobsJobListener jobListener = new JobsJobListener(this);
    private JobsKillPaymentListener killListener = new JobsKillPaymentListener(this);
    private JobsPlayerListener playerListener = new JobsPlayerListener(this);
    private JobsFishPaymentListener fishListener = new JobsFishPaymentListener(this);
    private JobsCraftPaymentListener craftListener;

    public Jobs() {
        plugin = this;
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        for (JobsPlayer player : this.players.values()) {
            player.removeHonorific();
        }
        if (JobsConfiguration.getInstance().getJobsDAO() != null) {
            this.saveAll();
            JobsConfiguration.getInstance().getJobsDAO().closeConnections();
        }
        this.getServer().getLogger().info("[Jobs v" + this.getDescription().getVersion() + "] has been disabled succesfully.");
        this.players.clear();
    }

    public void onEnable() {
        this.players = new HashMap();
        JobsCommands commands = new JobsCommands(this);
        this.getCommand("jobs").setExecutor((CommandExecutor)commands);
        Jobs.reloadConfigurations();
        if (!this.isEnabled()) {
            return;
        }
        if (JobsConfiguration.getInstance().getSavePeriod() > 0) {
            this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    Jobs.this.saveAll();
                }
            }, (long)(1200 * JobsConfiguration.getInstance().getSavePeriod()), (long)(1200 * JobsConfiguration.getInstance().getSavePeriod()));
        }
        this.getServer().getPluginManager().registerEvent(Event.Type.PLUGIN_ENABLE, (Listener)new ServerListener(){

            public void onPluginEnable(PluginEnableEvent event) {
                JobsConfiguration jc = JobsConfiguration.getInstance();
                PluginManager pm = Jobs.this.getServer().getPluginManager();
                if (jc.getEconomyLink() == null && (pm.getPlugin("iConomy") != null || pm.getPlugin("BOSEconomy") != null || pm.getPlugin("Essentials") != null)) {
                    if (pm.getPlugin("iConomy") != null && (jc.getDefaultEconomy() == null || jc.getDefaultEconomy().equalsIgnoreCase("iconomy")) && pm.getPlugin("iConomy").getDescription().getVersion().startsWith("5")) {
                        jc.setEconomyLink(new JobsiConomy5Link((com.iConomy.iConomy)pm.getPlugin("iConomy")));
                        System.out.println("[Jobs] Successfully linked with iConomy 5.");
                    } else if (pm.getPlugin("iConomy") != null && (jc.getDefaultEconomy() == null || jc.getDefaultEconomy().equalsIgnoreCase("iconomy")) && pm.getPlugin("iConomy").getDescription().getVersion().startsWith("6")) {
                        jc.setEconomyLink(new JobsiConomy6Link((iConomy)pm.getPlugin("iConomy")));
                        System.out.println("[Jobs] Successfully linked with iConomy 6.");
                    } else if (pm.getPlugin("BOSEconomy") != null && (jc.getDefaultEconomy() == null || jc.getDefaultEconomy().equalsIgnoreCase("boseconomy"))) {
                        jc.setEconomyLink(new JobsBOSEconomyLink((BOSEconomy)pm.getPlugin("BOSEconomy")));
                        System.out.println("[Jobs] Successfully linked with BOSEconomy.");
                    } else if (pm.getPlugin("Essentials") != null && (jc.getDefaultEconomy() == null || jc.getDefaultEconomy().equalsIgnoreCase("essentials"))) {
                        jc.setEconomyLink(new JobsEssentialsLink((Essentials)pm.getPlugin("Essentials")));
                        System.out.println("[Jobs] Successfully linked with Essentials.");
                    }
                }
                if (jc.getStats() == null && jc.isStatsEnabled() && pm.getPlugin("Stats") != null) {
                    jc.setStats((Stats)pm.getPlugin("Stats"));
                    System.out.println("[Jobs] Successfully linked with Stats.");
                }
                if (jc.getPermissions() == null && pm.getPlugin("Permissions") != null) {
                    jc.setPermissions((Permissions)pm.getPlugin("Permissions"));
                    System.out.println("[Jobs] Successfully linked with Permissions.");
                }
                if (Jobs.this.craftListener == null && Jobs.this.getServer().getPluginManager().getPlugin("Spout") != null) {
                    Jobs.this.craftListener = new JobsCraftPaymentListener(plugin);
                    Jobs.this.getServer().getPluginManager().registerEvent(Event.Type.CUSTOM_EVENT, (Listener)Jobs.this.craftListener, Event.Priority.Monitor, (Plugin)plugin);
                    System.out.println("[Jobs] Successfully linked with Spout.");
                }
            }

            public void onPluginDisable(PluginDisableEvent event) {
                JobsConfiguration jc = JobsConfiguration.getInstance();
                if (jc.getEconomyLink() instanceof JobsiConomy5Link && event.getPlugin().getDescription().getName().equalsIgnoreCase("iConomy") || jc.getEconomyLink() instanceof JobsBOSEconomyLink && event.getPlugin().getDescription().getName().equalsIgnoreCase("BOSEconomy") || jc.getEconomyLink() instanceof JobsEssentialsLink && event.getPlugin().getDescription().getName().equalsIgnoreCase("Essentials")) {
                    jc.setEconomyLink(null);
                    System.out.println("[Jobs] Economy system successfully unlinked.");
                }
                if (event.getPlugin().getDescription().getName().equalsIgnoreCase("Stats")) {
                    jc.setStats(null);
                    System.out.println("[Jobs] Successfully unlinked with Stats.");
                }
                if (event.getPlugin().getDescription().getName().equalsIgnoreCase("Permissions")) {
                    jc.setPermissions(null);
                    System.out.println("[Jobs] Successfully unlinked with Permissions.");
                }
            }
        }, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_BREAK, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.BLOCK_PLACE, (Listener)this.blockListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.CUSTOM_EVENT, (Listener)this.jobListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.ENTITY_DEATH, (Listener)this.killListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.CREATURE_SPAWN, (Listener)this.killListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_FISH, (Listener)this.fishListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_JOIN, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.PLAYER_QUIT, (Listener)this.playerListener, Event.Priority.Monitor, (Plugin)this);
        for (Player online : this.getServer().getOnlinePlayers()) {
            this.addPlayer(online.getName());
        }
        this.getServer().getLogger().info("[Jobs v" + this.getDescription().getVersion() + "] has been enabled succesfully.");
    }

    public void addPlayer(String playername) {
        this.players.put(playername, new JobsPlayer(this, playername, JobsConfiguration.getInstance().getJobsDAO()));
    }

    public void removePlayer(String playername) {
        this.save(playername);
        this.players.remove(playername);
    }

    public void saveAll() {
        for (String playername : this.players.keySet()) {
            this.save(playername);
        }
    }

    private void save(String playername) {
        JobsPlayer player = this.players.get(playername);
        JobsConfiguration.getInstance().getJobsDAO().save(player);
    }

    public JobsPlayer getJobsPlayer(String playername) {
        JobsPlayer player = this.players.get(playername);
        if (player != null) {
            return player;
        }
        return new JobsPlayer(this, playername, JobsConfiguration.getInstance().getJobsDAO());
    }

    public static void disablePlugin() {
        if (plugin != null) {
            plugin.setEnabled(false);
        }
    }

    public static void reloadConfigurations() {
        MessageConfig.getInstance().reload();
        JobsConfiguration.getInstance().reload();
        JobConfig.getInstance().reload();
    }
}

