/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.config;

import com.nidefawl.Stats.Stats;
import com.nijikokun.bukkit.Permissions.Permissions;
import com.zford.jobs.Jobs;
import com.zford.jobs.config.container.RestrictedArea;
import com.zford.jobs.config.container.Title;
import com.zford.jobs.dao.JobsDAO;
import com.zford.jobs.dao.JobsDAOH2;
import com.zford.jobs.dao.JobsDAOMySQL;
import com.zford.jobs.economy.JobsEconomyLink;
import com.zford.jobs.util.DisplayMethod;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.util.config.Configuration;

public class JobsConfiguration {
    private DisplayMethod dispMethod;
    private TreeMap<Integer, Title> titles;
    private int savePeriod;
    private JobsDAO dao;
    private static JobsConfiguration jobsConfig = null;
    private JobsEconomyLink economy = null;
    private Stats stats = null;
    private Permissions permissions = null;
    private boolean broadcastSkillups;
    private boolean broadcastLevelups;
    private Integer maxJobs;
    private boolean statsEnabled;
    private boolean payNearSpawner;
    private String defaultEconomy = null;
    private ArrayList<RestrictedArea> restrictedAreas;

    private JobsConfiguration() {
    }

    public void reload() {
        this.loadGeneralSettings();
        this.loadTitleSettings();
        this.loadRestrictedAreaSettings();
    }

    private void loadGeneralSettings() {
        File f = new File("plugins/Jobs/generalConfig.yml");
        if (!f.exists()) {
            System.err.println("[Jobs] - configuration file generalConfig.yml does not exist.  Disabling jobs !");
            Jobs.disablePlugin();
            return;
        }
        Configuration conf = new Configuration(f);
        conf.load();
        String storageMethod = conf.getString("storage-method", "");
        if (storageMethod.equalsIgnoreCase("mysql")) {
            String username = conf.getString("mysql-username");
            if (username == null) {
                System.err.println("[Jobs] - mysql-username property invalid or missing");
                Jobs.disablePlugin();
                return;
            }
            String password = conf.getString("mysql-password", "");
            String dbName = conf.getString("mysql-database");
            if (dbName == null) {
                System.err.println("[Jobs] - mysql-database property invalid or missing");
                Jobs.disablePlugin();
                return;
            }
            String url = conf.getString("mysql-url");
            if (url == null) {
                System.err.println("[Jobs] - mysql-url property invalid or missing");
                Jobs.disablePlugin();
                return;
            }
            String prefix = conf.getString("mysql-table-prefix", "");
            this.dao = new JobsDAOMySQL(url, dbName, username, password, prefix);
        } else if (storageMethod.equalsIgnoreCase("h2")) {
            this.dao = new JobsDAOH2();
        } else {
            System.err.println("[Jobs] - Storage method invalid or missing");
            Jobs.disablePlugin();
        }
        this.savePeriod = conf.getInt("save-period", -1);
        if (this.savePeriod <= 0) {
            System.out.println("[Jobs] - save-period property not found. Defaulting to 10!");
            this.savePeriod = 10;
        }
        this.broadcastSkillups = conf.getBoolean("broadcast-on-skill-up", false);
        this.broadcastLevelups = conf.getBoolean("broadcast-on-level-up", false);
        this.statsEnabled = conf.getBoolean("enable-stats", false);
        this.payNearSpawner = conf.getBoolean("enable-pay-near-spawner", false);
        this.maxJobs = conf.getInt("max-jobs", -1);
        if (this.maxJobs == -1) {
            System.out.println("[Jobs] - max-jobs property not found. Defaulting to unlimited!");
            this.maxJobs = null;
        }
        this.defaultEconomy = conf.getString("economy");
    }

    private void loadTitleSettings() {
        File f = new File("plugins/Jobs/titleConfig.yml");
        if (!f.exists()) {
            this.titles = null;
            System.err.println("[Jobs] - configuration file titleConfig.yml does not exist, disabling titles");
            return;
        }
        Configuration conf = new Configuration(f);
        conf.load();
        List titleKeys = conf.getKeys("Titles");
        if (titleKeys == null) {
            System.err.println("[Jobs] - No titles found. Disabling titles");
            this.titles = null;
            return;
        }
        this.titles = new TreeMap();
        for (String titleKey : titleKeys) {
            String titleName = conf.getString("Titles." + titleKey + ".Name");
            String titleShortName = conf.getString("Titles." + titleKey + ".ShortName");
            ChatColor colour = ChatColor.valueOf((String)conf.getString("Titles." + titleKey + ".ChatColour", "").toUpperCase());
            int levelReq = conf.getInt("Titles." + titleKey + ".levelReq", -1);
            if (titleName == null) {
                System.err.println("[Jobs] - Title " + titleKey + " has an invalid Name property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            if (titleShortName == null) {
                System.err.println("[Jobs] - Title " + titleKey + " has an invalid ShortName property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            if (colour == null) {
                System.err.println("[Jobs] - Title " + titleKey + " has an invalid ChatColour property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            if (levelReq == -1) {
                System.err.println("[Jobs] - Title " + titleKey + " has an invalid levelReq property. Disabling jobs !");
                Jobs.disablePlugin();
                return;
            }
            this.titles.put(levelReq, new Title(titleName, titleShortName, colour, levelReq));
        }
    }

    private void loadRestrictedAreaSettings() {
        this.restrictedAreas = new ArrayList();
        File f = new File("plugins/Jobs/restrictedAreas.yml");
        if (f.exists()) {
            Configuration conf = new Configuration(f);
            conf.load();
            List areaKeys = conf.getKeys("restrictedareas");
            List worlds = Bukkit.getServer().getWorlds();
            if (areaKeys == null) {
                return;
            }
            for (String areaKey : areaKeys) {
                String worldName = conf.getString("restrictedareas." + areaKey + ".world");
                double multiplier = conf.getDouble("restrictedareas." + areaKey + ".multiplier", 0.0);
                World pointWorld = null;
                for (World world : worlds) {
                    if (!world.getName().equals(worldName)) continue;
                    pointWorld = world;
                    break;
                }
                Location point1 = new Location(pointWorld, conf.getDouble("restrictedareas." + areaKey + ".point1.x", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point1.y", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point1.z", 0.0));
                Location point2 = new Location(pointWorld, conf.getDouble("restrictedareas." + areaKey + ".point2.x", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point2.y", 0.0), conf.getDouble("restrictedareas." + areaKey + ".point2.z", 0.0));
                this.restrictedAreas.add(new RestrictedArea(point1, point2, multiplier));
            }
        } else {
            System.err.println("[Jobs] - configuration file restrictedAreas.yml does not exist");
        }
    }

    public static JobsConfiguration getInstance() {
        if (jobsConfig == null) {
            jobsConfig = new JobsConfiguration();
        }
        return jobsConfig;
    }

    public DisplayMethod getDisplayMethod() {
        return this.dispMethod;
    }

    public int getSavePeriod() {
        return this.savePeriod;
    }

    public String getDefaultEconomy() {
        return this.defaultEconomy;
    }

    public JobsDAO getJobsDAO() {
        return this.dao;
    }

    public JobsEconomyLink getEconomyLink() {
        return this.economy;
    }

    public void unhookAll() {
        this.economy = null;
        this.stats = null;
        this.permissions = null;
    }

    public void setEconomyLink(JobsEconomyLink economy) {
        this.economy = economy;
    }

    public Stats getStats() {
        return this.stats;
    }

    public void setStats(Stats stats) {
        this.stats = stats;
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Permissions permissions) {
        this.permissions = permissions;
    }

    public boolean isBroadcastingSkillups() {
        return this.broadcastSkillups;
    }

    public boolean isBroadcastingLevelups() {
        return this.broadcastLevelups;
    }

    public Title getTitleForLevel(int level) {
        Title title = null;
        if (this.titles != null) {
            for (Title temp : this.titles.values()) {
                if (title == null) {
                    if (temp.getLevelReq() > level) continue;
                    title = temp;
                    continue;
                }
                if (temp.getLevelReq() > level || temp.getLevelReq() <= title.getLevelReq()) continue;
                title = temp;
            }
        }
        return title;
    }

    public Integer getMaxJobs() {
        return this.maxJobs;
    }

    public boolean isStatsEnabled() {
        return this.statsEnabled;
    }

    public boolean payNearSpawner() {
        return this.payNearSpawner;
    }

    public List<RestrictedArea> getRestrictedAreas() {
        return this.restrictedAreas;
    }
}

