/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.config.container;

import com.zford.jobs.config.container.JobsLivingEntityInfo;
import com.zford.jobs.config.container.JobsMaterialInfo;
import com.zford.jobs.util.DisplayMethod;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.mbertoli.jfep.Parser;

public class Job {
    private HashMap<String, JobsMaterialInfo> jobBreakInfo;
    private HashMap<String, JobsMaterialInfo> jobCraftInfo;
    private HashMap<String, JobsMaterialInfo> jobPlaceInfo;
    private HashMap<String, JobsLivingEntityInfo> jobKillInfo;
    private HashMap<String, JobsMaterialInfo> jobFishInfo;
    private String jobName;
    private String jobShortName;
    private ChatColor jobColour;
    private Parser maxExpEquation;
    private Parser incomeEquation;
    private Parser expEquation;
    private DisplayMethod displayMethod;
    private Integer maxLevel;
    private Integer maxSlots;

    private Job() {
    }

    public Job(HashMap<String, JobsMaterialInfo> jobBreakInfo, HashMap<String, JobsMaterialInfo> jobPlaceInfo, HashMap<String, JobsLivingEntityInfo> jobKillInfo, HashMap<String, JobsMaterialInfo> jobFishInfo, HashMap<String, JobsMaterialInfo> jobCreateInfo, String jobName, String jobShortName, ChatColor jobColour, Parser maxExpEquation, Parser incomeEquation, Parser expEquation, DisplayMethod displayMethod, Integer maxLevel, Integer maxSlots) {
        this.jobBreakInfo = jobBreakInfo;
        this.jobPlaceInfo = jobPlaceInfo;
        this.jobCraftInfo = jobCreateInfo;
        this.jobKillInfo = jobKillInfo;
        this.jobFishInfo = jobFishInfo;
        this.jobName = jobName;
        this.jobShortName = jobShortName;
        this.jobColour = jobColour;
        this.maxExpEquation = maxExpEquation;
        this.incomeEquation = incomeEquation;
        this.expEquation = expEquation;
        this.displayMethod = displayMethod;
        this.maxLevel = maxLevel;
        this.maxSlots = maxSlots;
    }

    public Double getKillIncome(String mob, HashMap<String, Double> param) {
        if (this.jobKillInfo.containsKey(mob)) {
            return this.jobKillInfo.get(mob).getMoneyFromKill(this.incomeEquation, mob, param);
        }
        return null;
    }

    public Double getKillExp(String mob, HashMap<String, Double> param) {
        if (this.jobKillInfo.containsKey(mob)) {
            return this.jobKillInfo.get(mob).getXPFromKill(this.expEquation, mob, param);
        }
        return null;
    }

    public Double getPlaceIncome(Block block, HashMap<String, Double> param) {
        return this.getBlockActionIncome(block, param, this.jobPlaceInfo);
    }

    public Double getPlaceExp(Block block, HashMap<String, Double> param) {
        return this.getBlockActionExp(block, param, this.jobPlaceInfo);
    }

    public Double getBreakIncome(Block block, HashMap<String, Double> param) {
        return this.getBlockActionIncome(block, param, this.jobBreakInfo);
    }

    public Double getBreakExp(Block block, HashMap<String, Double> param) {
        return this.getBlockActionExp(block, param, this.jobBreakInfo);
    }

    public Double getCraftIncome(ItemStack items, HashMap<String, Double> param) {
        return this.getItemActionIncome(items, param, this.jobCraftInfo);
    }

    public Double getCraftExp(ItemStack items, HashMap<String, Double> param) {
        return this.getItemActionExp(items, param, this.jobCraftInfo);
    }

    public Double getFishIncome(Item item, HashMap<String, Double> param) {
        String materialKey = item.getItemStack().getType().toString();
        if (this.jobFishInfo.containsKey(materialKey)) {
            return this.jobFishInfo.get(materialKey).getMoneyFromMaterial(this.incomeEquation, param);
        }
        if (this.jobFishInfo.containsKey(materialKey + ":" + item.getItemStack().getData())) {
            return this.jobFishInfo.get(materialKey + ":" + item.getItemStack().getData()).getMoneyFromMaterial(this.incomeEquation, param);
        }
        return null;
    }

    public Double getFishExp(Item item, HashMap<String, Double> param) {
        String materialKey = item.getItemStack().getType().toString();
        if (this.jobFishInfo.containsKey(materialKey)) {
            return this.jobFishInfo.get(materialKey).getXPFromMaterial(this.expEquation, param);
        }
        if (this.jobFishInfo.containsKey(materialKey + ":" + item.getItemStack().getData())) {
            return this.jobFishInfo.get(materialKey + ":" + item.getItemStack().getData()).getXPFromMaterial(this.expEquation, param);
        }
        return null;
    }

    private Double getBlockActionIncome(Block block, HashMap<String, Double> param, HashMap<String, JobsMaterialInfo> info) {
        String blockKey = block.getType().toString();
        if (block.getType().equals((Object)Material.GLOWING_REDSTONE_ORE)) {
            blockKey = Material.REDSTONE_ORE.toString();
        }
        if (info.containsKey(blockKey)) {
            return info.get(blockKey).getMoneyFromMaterial(this.incomeEquation, param);
        }
        if (info.containsKey(blockKey + ":" + block.getData())) {
            return info.get(blockKey + ":" + block.getData()).getMoneyFromMaterial(this.incomeEquation, param);
        }
        return null;
    }

    private Double getBlockActionExp(Block block, HashMap<String, Double> param, HashMap<String, JobsMaterialInfo> info) {
        String blockKey = block.getType().toString();
        if (block.getType().equals((Object)Material.GLOWING_REDSTONE_ORE)) {
            blockKey = Material.REDSTONE_ORE.toString();
        }
        if (info.containsKey(blockKey)) {
            return info.get(blockKey).getXPFromMaterial(this.expEquation, param);
        }
        if (info.containsKey(blockKey + ":" + block.getData())) {
            return info.get(blockKey + ":" + block.getData()).getXPFromMaterial(this.expEquation, param);
        }
        return null;
    }

    private Double getItemActionIncome(ItemStack item, HashMap<String, Double> param, HashMap<String, JobsMaterialInfo> info) {
        String blockKey = item.getType().toString();
        if (blockKey == null) {
            return null;
        }
        if (item.getType().equals((Object)Material.GLOWING_REDSTONE_ORE)) {
            blockKey = Material.REDSTONE_ORE.toString();
        }
        if (info.containsKey(blockKey)) {
            return (double)item.getAmount() * info.get(blockKey).getMoneyFromMaterial(this.incomeEquation, param);
        }
        if (item.getData() != null && info.containsKey(blockKey + ":" + item.getData().getData())) {
            return (double)item.getAmount() * info.get(blockKey + ":" + item.getData()).getMoneyFromMaterial(this.incomeEquation, param);
        }
        return null;
    }

    private Double getItemActionExp(ItemStack item, HashMap<String, Double> param, HashMap<String, JobsMaterialInfo> info) {
        String blockKey = item.getType().toString();
        if (blockKey == null) {
            return null;
        }
        if (item.getType().equals((Object)Material.GLOWING_REDSTONE_ORE)) {
            blockKey = Material.REDSTONE_ORE.toString();
        }
        if (info.containsKey(blockKey)) {
            return (double)item.getAmount() * info.get(blockKey).getXPFromMaterial(this.expEquation, param);
        }
        if (item.getData() != null && info.containsKey(blockKey + ":" + item.getData().getData())) {
            return (double)item.getAmount() * info.get(blockKey + ":" + item.getData()).getXPFromMaterial(this.expEquation, param);
        }
        return null;
    }

    public String getName() {
        return this.jobName;
    }

    public String getShortName() {
        return this.jobShortName;
    }

    public ChatColor getChatColour() {
        return this.jobColour;
    }

    public Parser getMaxExpEquation() {
        return this.maxExpEquation;
    }

    public Parser getIncomeEquation() {
        return this.incomeEquation;
    }

    public Parser getExpEquation() {
        return this.expEquation;
    }

    public double getMaxExp(HashMap<String, Double> param) {
        for (Map.Entry<String, Double> temp : param.entrySet()) {
            this.maxExpEquation.setVariable(temp.getKey(), temp.getValue());
        }
        return this.maxExpEquation.getValue();
    }

    public DisplayMethod getDisplayMethod() {
        return this.displayMethod;
    }

    public Integer getMaxLevel() {
        return this.maxLevel;
    }

    public Integer getMaxSlots() {
        return this.maxSlots;
    }

    public HashMap<String, JobsMaterialInfo> getBreakInfo() {
        return this.jobBreakInfo;
    }

    public HashMap<String, JobsMaterialInfo> getPlaceInfo() {
        return this.jobPlaceInfo;
    }

    public HashMap<String, JobsLivingEntityInfo> getKillInfo() {
        return this.jobKillInfo;
    }

    public HashMap<String, JobsMaterialInfo> getFishInfo() {
        return this.jobFishInfo;
    }

    public HashMap<String, JobsMaterialInfo> getCraftInfo() {
        return this.jobCraftInfo;
    }
}

