/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.config.container;

import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.container.Job;
import com.zford.jobs.config.container.JobsPlayer;
import com.zford.jobs.config.container.Title;
import java.util.HashMap;

public class JobProgression {
    private Job job;
    private Title title;
    private double experience;
    private int maxExperience;
    private int level;

    public JobProgression(Job job, double experience, int level, JobsPlayer info) {
        this.job = job;
        this.experience = experience;
        this.level = level;
        HashMap<String, Double> param = new HashMap<String, Double>();
        param.put("joblevel", Double.valueOf(level));
        param.put("numjobs", Double.valueOf(info.getJobs().size()));
        this.maxExperience = (int)job.getMaxExp(param);
        this.title = JobsConfiguration.getInstance().getTitleForLevel(level);
    }

    public void addExp(double exp) {
        this.experience += exp;
    }

    public boolean canLevelUp() {
        return this.experience >= (double)this.maxExperience;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public double getExperience() {
        return this.experience;
    }

    public void setExperience(double experience) {
        this.experience = experience;
    }

    public int getMaxExperience() {
        return this.maxExperience;
    }

    public void setMaxExperience(int maxExperience) {
        this.maxExperience = maxExperience;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setTitle(Title title) {
        this.title = title;
    }

    public Title getTitle() {
        return this.title;
    }
}

