/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.config.container;

import com.zford.jobs.config.JobsConfiguration;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class RestrictedArea {
    private Location location1;
    private Location location2;
    private double multiplier;

    public RestrictedArea(Location location1, Location location2, double multiplier) {
        this.location1 = location1;
        this.location2 = location2;
        this.multiplier = multiplier;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public boolean inRestrictedArea(Player player) {
        return this.isBetween(player.getLocation().getX(), this.location1.getX(), this.location2.getX()) && this.isBetween(player.getLocation().getY(), this.location1.getY(), this.location2.getY()) && this.isBetween(player.getLocation().getZ(), this.location1.getZ(), this.location2.getZ()) && this.location1.getWorld().equals(player.getLocation().getWorld()) && this.location2.getWorld().equals(player.getLocation().getWorld());
    }

    private boolean isBetween(double number, double bound1, double bound2) {
        if (bound1 < bound2 && number > bound1 && number < bound2) {
            return true;
        }
        return bound1 > bound2 && number < bound1 && number > bound2;
    }

    public static double getMultiplier(Player player) {
        for (RestrictedArea area : JobsConfiguration.getInstance().getRestrictedAreas()) {
            if (!area.inRestrictedArea(player)) continue;
            return area.getMultiplier();
        }
        return 1.0;
    }
}

