/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.dao;

import com.zford.jobs.dao.JobsConnection;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedList;

public class JobsConnectionPool {
    private LinkedList<JobsConnection> pooledConnections = new LinkedList();
    private String url;
    private String username;
    private String password;

    public JobsConnectionPool(String driver, String url, String username, String password) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Class.forName(driver).newInstance();
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public synchronized JobsConnection getConnection() throws SQLException {
        Object conn;
        while (!this.pooledConnections.isEmpty()) {
            conn = this.pooledConnections.remove();
            if (((JobsConnection)conn).isClosed()) continue;
            return conn;
        }
        conn = DriverManager.getConnection(this.url, this.username, this.password);
        return new JobsConnection((Connection)conn, this);
    }

    public synchronized void returnToPool(JobsConnection conn) {
        this.pooledConnections.add(conn);
    }

    public synchronized void closeConnections() {
        while (!this.pooledConnections.isEmpty()) {
            JobsConnection conn = this.pooledConnections.remove();
            try {
                conn.closeConnection();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

