/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.economy;

import com.earth2me.essentials.Essentials;
import com.earth2me.essentials.api.Economy;
import com.earth2me.essentials.api.NoLoanPermittedException;
import com.earth2me.essentials.api.UserDoesNotExistException;
import com.nidefawl.Stats.Stats;
import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.container.JobsPlayer;
import com.zford.jobs.economy.JobsEconomyLink;

public class JobsEssentialsLink
implements JobsEconomyLink {
    public JobsEssentialsLink(Essentials essentials) {
    }

    @Override
    public void pay(JobsPlayer player, double amount) {
        try {
            Economy.add((String)player.getName(), (double)amount);
        }
        catch (UserDoesNotExistException e) {
            e.printStackTrace();
        }
        catch (NoLoanPermittedException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateStats(JobsPlayer player) {
        if (JobsConfiguration.getInstance().getStats() != null && JobsConfiguration.getInstance().getStats().isEnabled()) {
            double balance;
            Stats stats = JobsConfiguration.getInstance().getStats();
            try {
                balance = Economy.getMoney((String)player.getName());
            }
            catch (UserDoesNotExistException e) {
                e.printStackTrace();
                return;
            }
            if (balance > (double)stats.get(player.getName(), "job", "money")) {
                stats.setStat(player.getName(), "job", "money", (int)balance);
                stats.saveAll();
            }
        }
    }
}

