/*
 * Decompiled with CFR 0.152.
 */
package com.zford.jobs.listener;

import com.zford.jobs.Jobs;
import com.zford.jobs.config.JobsConfiguration;
import com.zford.jobs.config.container.Job;
import com.zford.jobs.config.container.JobsPlayer;
import com.zford.jobs.config.container.RestrictedArea;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityListener;

public class JobsKillPaymentListener
extends EntityListener {
    private Jobs plugin;
    private Set<LivingEntity> mobSpawnerCreatures;

    public JobsKillPaymentListener(Jobs plugin) {
        this.plugin = plugin;
        this.mobSpawnerCreatures = Collections.newSetFromMap(new WeakHashMap());
    }

    public void onEntityDeath(EntityDeathEvent event) {
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        LivingEntity lVictim = (LivingEntity)event.getEntity();
        if (this.mobSpawnerCreatures.remove(lVictim)) {
            return;
        }
        if (!this.plugin.isEnabled()) {
            return;
        }
        if (event.getEntity().getLastDamageCause() instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent e = (EntityDamageByEntityEvent)event.getEntity().getLastDamageCause();
            Player pDamager = null;
            if (e.getDamager() instanceof Player) {
                pDamager = (Player)e.getDamager();
            } else if (e.getDamager() instanceof Projectile && ((Projectile)e.getDamager()).getShooter() instanceof Player) {
                pDamager = (Player)((Projectile)e.getDamager()).getShooter();
            } else if (e.getDamager() instanceof Wolf && ((Wolf)e.getDamager()).isTamed() && ((Wolf)e.getDamager()).getOwner() instanceof Player) {
                pDamager = (Player)((Wolf)e.getDamager()).getOwner();
            }
            if (pDamager != null) {
                JobsPlayer jVictim;
                double multiplier = RestrictedArea.getMultiplier(pDamager);
                JobsPlayer jDamager = this.plugin.getJobsPlayer(pDamager.getName());
                jDamager.killed(lVictim.getClass().toString().replace("class ", "").trim(), multiplier);
                if (lVictim instanceof Player && (jVictim = this.plugin.getJobsPlayer(((Player)lVictim).getName())) != null && jVictim.getJobs() != null) {
                    for (Job temp : jVictim.getJobs()) {
                        jDamager.killed((lVictim.getClass().toString().replace("class ", "") + ":" + temp.getName()).trim(), multiplier);
                    }
                }
            }
        }
    }

    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        if (!event.getSpawnReason().equals((Object)CreatureSpawnEvent.SpawnReason.SPAWNER)) {
            return;
        }
        if (JobsConfiguration.getInstance().payNearSpawner()) {
            return;
        }
        LivingEntity creature = (LivingEntity)event.getEntity();
        this.mobSpawnerCreatures.add(creature);
    }
}

