/*
 * Decompiled with CFR 0.152.
 */
package com.parachute.common;

import com.parachute.common.AADTick;
import com.parachute.common.CommonProxyParachute;
import com.parachute.common.EntityParachute;
import com.parachute.common.ItemAutoActivateDevice;
import com.parachute.common.ItemHopAndPop;
import com.parachute.common.ItemParachute;
import com.parachute.common.ItemRipCord;
import com.parachute.common.KeyPressTick;
import com.parachute.common.PacketPipeline;
import com.parachute.common.ParachutePacket;
import com.parachute.common.ParachutePlayerTracker;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;

@Mod(modid="parachutemod", name="Parachute Mod", version="1.7.2")
public class Parachute {
    static ItemArmor.ArmorMaterial NYLON = EnumHelper.addArmorMaterial((String)"nylon", (int)15, (int[])new int[]{2, 5, 4, 1}, (int)12);
    static Item.ToolMaterial RIPSTOP = EnumHelper.addToolMaterial((String)"ripstop", (int)0, (int)59, (float)2.0f, (float)0.0f, (int)15);
    public static final PacketPipeline packetPipeline = new PacketPipeline();
    public static final String modid = "parachutemod";
    public static final String mcversion = "1.7.2";
    public static final String channel = "parachutemod";
    public static final String name = "Parachute Mod";
    public static final String parachuteName = "Parachute";
    public static final String ripcordName = "Ripcord";
    public static final String aadName = "AutoActivationDevice";
    public static final String hopnpopName = "HopAndPop";
    private String type = "Parachute";
    private boolean singleUse;
    private int heightLimit;
    private int chuteColor;
    private boolean thermals;
    private static double AADAltitude;
    private boolean smallCanopy;
    private static boolean AADActive;
    private static double fallThreshold;
    private final int entityID = EntityRegistry.findGlobalUniqueEntityId();
    private static final int armorType = 1;
    public static final int armorSlot = 2;
    @SidedProxy(clientSide="com.parachute.client.ClientProxyParachute", serverSide="com.parachute.common.CommonProxyParachute")
    public static CommonProxyParachute proxy;
    public static ItemParachute parachuteItem;
    public static ItemHopAndPop hopnpopItem;
    public static ItemRipCord ripcordItem;
    public static ItemAutoActivateDevice aadItem;
    @Mod.Instance
    public static Parachute instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String generalComments = "Parachute Mod Config\nMichael Sheppard (crackedEgg) For Minecraft Version 1.7.2\n";
        String usageComment = "singleUse - set to true for hop n pop single use (false)";
        String heightComment = "heightLimit  - 0 (zero) disables altitude limiting (256)";
        String thermalComment = "allowThermals - true|false enable/disable thermals (true)";
        String aadAltitudeComment = "AADAltitude - altitude (in meters) at which auto deploy occurs (10)";
        String fallThresholdComment = "fallThreshold - player must have fallen this far to activate AAD (5.0)";
        String aaDActiveComment = "AADActive - whether the AAD is active or not. default is inactive. (false)";
        String typeComment = "smallCanopy - set to true to use the smaller 3 panel canopy, false for the\nlarger 4 panel canopy (true)";
        String colorComment = "Color index numbers:\nblack        -  0\nblue         -  1\nbrown        -  2\ncyan         -  3\ngray         -  4\ngreen        -  5\nlight blue   -  6\nlime         -  7\nmagneta      -  8\norange       -  9\npink         - 10\npurple       - 11\nred          - 12\nsilver       - 13\nwhite        - 14\nyellow       - 15\nblue/white   - 16\nred/white    - 17\nyellow/green - 18";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.singleUse = config.get("general", "singleUse", false, usageComment).getBoolean(false);
        this.heightLimit = config.get("general", "heightLimit", 256, heightComment).getInt();
        this.thermals = config.get("general", "allowThermals", true, thermalComment).getBoolean(true);
        fallThreshold = config.get("general", "fallThreshold", 5.0, fallThresholdComment).getDouble(5.0);
        AADAltitude = config.get("general", "AADAltitude", 15.0, aadAltitudeComment).getDouble(15.0);
        AADActive = config.get("general", "AADActive", false, aaDActiveComment).getBoolean(false);
        this.smallCanopy = config.get("general", "smallCanopy", true, typeComment).getBoolean(true);
        this.chuteColor = config.get("general", "chuteColor", 18, colorComment).getInt();
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        fallThreshold = fallThreshold < 2.0 ? 2.0 : fallThreshold;
        int chuteID = proxy.addArmor(parachuteName.toLowerCase());
        EntityRegistry.registerModEntity(EntityParachute.class, (String)parachuteName, (int)this.entityID, (Object)this, (int)64, (int)10, (boolean)true);
        parachuteItem = (ItemParachute)new ItemParachute(NYLON, chuteID, 1).func_77655_b(parachuteName);
        parachuteItem.func_111206_d("parachutemod:Parachute");
        GameRegistry.registerItem((Item)parachuteItem, (String)parachuteName);
        ripcordItem = (ItemRipCord)new ItemRipCord().func_77655_b(ripcordName);
        ripcordItem.func_111206_d("parachutemod:Ripcord");
        GameRegistry.registerItem((Item)ripcordItem, (String)ripcordName);
        aadItem = (ItemAutoActivateDevice)new ItemAutoActivateDevice().func_77655_b(aadName);
        aadItem.func_111206_d("parachutemod:AutoActivationDevice");
        GameRegistry.registerItem((Item)aadItem, (String)aadName);
        hopnpopItem = (ItemHopAndPop)new ItemHopAndPop(RIPSTOP).func_77655_b(hopnpopName);
        hopnpopItem.func_111206_d("parachutemod:HopAndPop");
        GameRegistry.registerItem((Item)hopnpopItem, (String)hopnpopName);
        proxy.registerRenderer();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)parachuteItem, 1), (Object[])new Object[]{"###", "X X", " L ", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F, Character.valueOf('L'), Items.field_151116_aA});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)hopnpopItem, 1), (Object[])new Object[]{"###", "X X", " X ", Character.valueOf('#'), Blocks.field_150325_L, Character.valueOf('X'), Items.field_151007_F});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ripcordItem, 1), (Object[])new Object[]{"#  ", " # ", "  *", Character.valueOf('#'), Items.field_151007_F, Character.valueOf('*'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)aadItem, 1), (Object[])new Object[]{" * ", " % ", " # ", Character.valueOf('*'), Items.field_151132_bS, Character.valueOf('%'), Items.field_151137_ax, Character.valueOf('#'), ripcordItem});
        Parachute.NYLON.customCraftingMaterial = Items.field_151007_F;
        Parachute.RIPSTOP.customCraftingMaterial = Items.field_151007_F;
        FMLCommonHandler.instance().bus().register((Object)new AADTick());
        FMLCommonHandler.instance().bus().register((Object)new KeyPressTick());
        FMLCommonHandler.instance().bus().register((Object)new ParachutePlayerTracker());
        packetPipeline.initialise();
        packetPipeline.registerPacket(ParachutePacket.class);
        instance = this;
    }

    @Mod.EventHandler
    public void Init(FMLPostInitializationEvent event) {
        packetPipeline.postInitialise();
    }

    public String getVersion() {
        return mcversion;
    }

    public double getMaxAltitude() {
        return this.heightLimit;
    }

    public boolean getAllowThermals() {
        return this.thermals;
    }

    public int getChuteColor() {
        return this.chuteColor >= 0 && this.chuteColor <= 18 ? this.chuteColor : 18;
    }

    public static double getAADAltitude() {
        return AADAltitude;
    }

    public static boolean getAADActive() {
        return AADActive;
    }

    public static double getFallThreshold() {
        return fallThreshold;
    }

    public void setAADActive(boolean active) {
        AADActive = active;
    }

    public boolean isSmallCanopy() {
        return this.smallCanopy;
    }

    public void setType(String type) {
        this.type = type;
        if (this.type.equals(hopnpopName)) {
            this.smallCanopy = true;
        }
    }

    public String getType() {
        return this.type;
    }

    public int getHopAndPopDamageAmount() {
        if (this.singleUse) {
            return hopnpopItem.func_77612_l() + 1;
        }
        return 1;
    }

    public static boolean playerIsWearingParachute(EntityPlayer player) {
        Item item;
        ItemStack stack;
        ItemStack itemStack = stack = player == null ? null : player.func_82169_q(2);
        return stack != null && (item = stack.func_77973_b()) != null && item instanceof ItemParachute;
    }

    public static boolean isFalling(EntityPlayer entity) {
        return entity.field_70143_R > 0.0f && !entity.field_70122_E && !entity.func_70617_f_();
    }
}

