/*
 * Decompiled with CFR 0.152.
 */
package com.walkingdead.common;

import com.walkingdead.common.CommonProxyWalkingDead;
import com.walkingdead.common.EntityWalkingDead;
import com.walkingdead.common.WorldTickHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.LinkedList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="walkingdeadmod", name="WalkingDead Mod", version="1.7.2")
public class WalkingDead {
    @Mod.Instance
    public static WalkingDead instance;
    public static final String version = "1.7.2";
    public static final String modid = "walkingdeadmod";
    public static final String name = "WalkingDead Mod";
    private int walkerSpawnProb;
    private int walkerSpawns;
    private boolean spawnCreepers;
    private boolean spawnZombies;
    private boolean spawnSkeletons;
    private boolean spawnEnderman;
    private boolean spawnSpiders;
    private boolean spawnSlime;
    private boolean randomSkins;
    private boolean doorBusting;
    @SidedProxy(clientSide="com.walkingdead.client.ClientProxyWalkingDead", serverSide="com.walkingdead.common.CommonProxyWalkingDead")
    public static CommonProxyWalkingDead proxy;

    public String getVersion() {
        return version;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String generalComments = "WalkingDead Mod Config\nMichael Sheppard (crackedEgg)\n For Minecraft Version 1.7.2\n";
        String spawnProbComment = "walkerSpawnProb adjust to probability of walkers spawning,\nalthough the custom spawning most likely overrides this. the higher the\nthe number the more likely walkers will spawn.";
        String walkerComment = "walkerSpawns adjusts the number of walkers spawned, play\nwith it to see what you like. The higher the number the more\nwalkers will spawn.";
        String creeperComment = "creeperSpawns, set to false to disable creeper spawning, set to true\nif you want to spawn creepers";
        String skeletonComment = "skeletonSpawns, set to false to disable skeleton spawning, set to true\nif you want to spawn skeletons";
        String zombieComment = "zombieSpawns, set to false to disable zombie spawning, set to true\nif you want to spawn zombies. Note that spawning zombies and other monsters\nwill cause the number of walkers spawned to be reduced.";
        String endermanComment = "endermanSpawns, set to false to disable enderman spawning, set to true\nif you want to spawn enderman";
        String spiderComment = "spiderSpawns, set to false to disable spider spawning, set to true\nif you want to spawn spiders";
        String slimeComment = "slimeSpawns, set to false to disable slime spawning, set to true\nif you want to spawn slimes";
        String doorBustingComment = "doorBusting, set to true to have walkers try to break down doors,\notherwise set to false. It's quieter.";
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        this.walkerSpawnProb = config.get("general", "walkerSpawnProb", 10, spawnProbComment).getInt();
        this.walkerSpawns = config.get("general", "walkerSpawns", 60, walkerComment).getInt();
        this.spawnCreepers = config.get("general", "spawnCreepers", false, creeperComment).getBoolean(false);
        this.spawnSkeletons = config.get("general", "spawnSkeletons", false, skeletonComment).getBoolean(false);
        this.spawnZombies = config.get("general", "spawnZombies", false, zombieComment).getBoolean(false);
        this.spawnEnderman = config.get("general", "spawnEnderman", false, endermanComment).getBoolean(false);
        this.spawnSpiders = config.get("general", "spawnSpiders", true, spiderComment).getBoolean(false);
        this.spawnSlime = config.get("general", "spawnSlime", false, slimeComment).getBoolean(false);
        this.doorBusting = config.get("general", "doorBusting", false, doorBustingComment).getBoolean(false);
        config.addCustomCategoryComment("general", generalComments);
        config.save();
        int id = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(EntityWalkingDead.class, (String)"WalkingDead", (int)id, (int)44975, (int)7969861);
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent evt) {
        BiomeGenBase[] biomes = this.getBiomeList();
        EntityRegistry.addSpawn(EntityWalkingDead.class, (int)this.walkerSpawnProb, (int)2, (int)10, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
        DungeonHooks.addDungeonMob((String)"WalkingDead", (int)200);
        ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(new ItemStack(Items.field_151040_l), 1, 1, 4));
        if (!this.spawnCreepers) {
            EntityRegistry.removeSpawn(EntityCreeper.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
        }
        if (!this.spawnSkeletons) {
            EntityRegistry.removeSpawn(EntitySkeleton.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            DungeonHooks.removeDungeonMob((String)"Skeleton");
        }
        if (!this.spawnZombies) {
            EntityRegistry.removeSpawn(EntityZombie.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            DungeonHooks.removeDungeonMob((String)"Zombie");
        }
        if (!this.spawnEnderman) {
            EntityRegistry.removeSpawn(EntityEnderman.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
        }
        if (!this.spawnSpiders) {
            EntityRegistry.removeSpawn(EntitySpider.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
            DungeonHooks.removeDungeonMob((String)"Spider");
        }
        if (!this.spawnSlime) {
            EntityRegistry.removeSpawn(EntitySlime.class, (EnumCreatureType)EnumCreatureType.monster, (BiomeGenBase[])biomes);
        }
        FMLCommonHandler.instance().bus().register((Object)new WorldTickHandler());
    }

    public BiomeGenBase[] getBiomeList() {
        BiomeDictionary.Type[] t;
        LinkedList<BiomeGenBase> linkedlist = new LinkedList<BiomeGenBase>();
        for (BiomeDictionary.Type type : t = new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.DESERT, BiomeDictionary.Type.FROZEN, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MUSHROOM}) {
            BiomeGenBase[] biomes;
            for (BiomeGenBase bgb : biomes = BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                if (linkedlist.contains(bgb)) continue;
                linkedlist.add(bgb);
            }
        }
        return linkedlist.toArray(new BiomeGenBase[0]);
    }

    public int getWalkerSpawns() {
        return this.walkerSpawns;
    }

    public boolean getRandomSkins() {
        return this.randomSkins;
    }

    public boolean getDoorBusting() {
        return this.doorBusting;
    }
}

