/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.client;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.client.ClientHandler;
import net.dries007.holoInventory.client.KeyManager;
import net.dries007.holoInventory.packet.EntityRequestPacket;
import net.dries007.holoInventory.packet.PacketPipeline;
import net.dries007.holoInventory.util.Coord;
import net.dries007.holoInventory.util.Helper;
import net.dries007.holoInventory.util.NamedData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class Renderer {
    private static final DecimalFormat DF = new DecimalFormat("#.#");
    private static final int TEXTCOLOR = -1426063361;
    public static final HashMap<Integer, NamedData<ItemStack[]>> tileMap = new HashMap();
    public static final HashMap<Integer, NamedData<ItemStack[]>> entityMap = new HashMap();
    public static final HashMap<Integer, NamedData<MerchantRecipeList>> merchantMap = new HashMap();
    public static final HashMap<Integer, Long> requestMap = new HashMap();
    private EntityItem customitem;
    private Coord coord;
    public boolean enabled;
    public static final Renderer INSTANCE = new Renderer();
    private float timeD;
    private float blockScale;
    private float maxWith;
    private float maxHeight;
    private int maxColumns;
    private int maxRows;
    private boolean renderText;

    private Renderer() {
        this.customitem = new EntityItem((World)Minecraft.func_71410_x().field_71441_e);
        this.enabled = true;
        this.customitem.field_70290_d = 0.0f;
    }

    @SubscribeEvent
    public void renderEvent(RenderWorldLastEvent event) {
        if (!this.enabled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (HoloInventory.getConfig().keyMode == 2 && !KeyManager.key.func_151470_d()) {
            return;
        }
        if (HoloInventory.getConfig().keyMode == 3 && KeyManager.key.func_151470_d()) {
            return;
        }
        if (mc.field_71446_o == null || RenderManager.field_78727_a == null || RenderManager.field_78727_a.func_78716_a() == null || mc.field_71474_y.field_74320_O != 0 || mc.field_71476_x == null) {
            return;
        }
        this.coord = new Coord(mc.field_71441_e.field_73011_w.field_76574_g, mc.field_71476_x);
        switch (mc.field_71476_x.field_72313_a) {
            case BLOCK: {
                TileEntity te = mc.field_71441_e.func_147438_o((int)this.coord.x, (int)this.coord.y, (int)this.coord.z);
                if (Helper.weWant(te)) {
                    String clazz = te.getClass().getCanonicalName();
                    if (HoloInventory.getConfig().bannedTiles.contains(clazz)) {
                        return;
                    }
                    NamedData<ItemStack[]> data = tileMap.get(this.coord.hashCode());
                    if (data != null && (data.clazz == null || data.clazz.equals(clazz))) {
                        this.coord.x += 0.5;
                        this.coord.y += 0.5;
                        this.coord.z += 0.5;
                        this.renderHologram(data);
                        return;
                    }
                }
                tileMap.remove(this.coord.hashCode());
                break;
            }
            case ENTITY: {
                Entity entity;
                if (!HoloInventory.getConfig().enableEntities || !Helper.weWant(entity = mc.field_71476_x.field_72308_g)) break;
                if (HoloInventory.getConfig().bannedEntities.contains(entity.getClass().getCanonicalName())) {
                    return;
                }
                int id = entity.func_145782_y();
                if (!requestMap.containsKey(id)) {
                    PacketPipeline.PIPELINE.sendToServer(new EntityRequestPacket(mc.field_71441_e.field_73011_w.field_76574_g, id));
                    requestMap.put(id, mc.field_71441_e.func_82737_E());
                } else if (mc.field_71441_e.func_82737_E() > requestMap.get(id) + (long)(20 * HoloInventory.getConfig().syncFreq)) {
                    requestMap.remove(id);
                }
                if (entity instanceof IInventory && entityMap.containsKey(id)) {
                    this.renderHologram(entityMap.get(id));
                }
                if (!(entity instanceof IMerchant) || !merchantMap.containsKey(id)) break;
                this.renderMerchant(merchantMap.get(id));
            }
        }
    }

    private void renderMerchant(NamedData<MerchantRecipeList> namedData) {
        this.coord.y += 2.0;
        if (((MerchantRecipeList)namedData.data).size() == 0) {
            return;
        }
        double distance = this.distance();
        if (distance < 1.0) {
            return;
        }
        GL11.glPushMatrix();
        this.moveAndRotate(-0.25);
        this.timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        this.maxColumns = 3;
        this.maxRows = ((MerchantRecipeList)namedData.data).size();
        this.blockScale = this.getBlockScaleModifier(this.maxColumns) + (float)((double)0.1f * distance);
        this.maxWith = (float)this.maxColumns * this.blockScale * 0.7f * 0.4f;
        this.maxHeight = (float)this.maxRows * this.blockScale * 0.7f * 0.4f;
        this.renderText = true;
        if (HoloInventory.getConfig().colorEnable) {
            this.renderBG();
        }
        if (HoloInventory.getConfig().renderName) {
            this.renderName(namedData.name);
        }
        for (int row = 0; row < ((MerchantRecipeList)namedData.data).size(); ++row) {
            MerchantRecipe recipe = (MerchantRecipe)((MerchantRecipeList)namedData.data).get(row);
            this.renderItem(recipe.func_77394_a(), 0, row, recipe.func_77394_a().field_77994_a);
            if (recipe.func_77398_c()) {
                this.renderItem(recipe.func_77396_b(), 1, row, recipe.func_77396_b().field_77994_a);
            }
            this.renderItem(recipe.func_77397_d(), 2, row, recipe.func_77397_d().field_77994_a);
        }
        GL11.glPopMatrix();
    }

    private void renderHologram(NamedData<ItemStack[]> namedData) {
        List<Object> list;
        if (namedData.data == null || namedData.name == null || ((ItemStack[])namedData.data).length == 0) {
            return;
        }
        double distance = this.distance();
        if (distance < 1.5) {
            return;
        }
        if (HoloInventory.getConfig().enableStacking) {
            list = new ArrayList();
            for (ItemStack itemStack : Arrays.asList((Object[])namedData.data)) {
                boolean f = false;
                for (ItemStack itemStack2 : list) {
                    if (itemStack2 == null || !itemStack.func_77969_a(itemStack2) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)itemStack2)) continue;
                    itemStack2.field_77994_a += itemStack.field_77994_a;
                    f = true;
                    break;
                }
                if (f) continue;
                list.add(itemStack.func_77946_l());
            }
        } else {
            list = Arrays.asList((Object[])namedData.data);
        }
        int wantedSize = list.size();
        switch (HoloInventory.getConfig().mode) {
            case 2: {
                wantedSize = 1;
                break;
            }
            case 3: {
                wantedSize = 3;
                break;
            }
            case 4: {
                wantedSize = 5;
                break;
            }
            case 5: {
                wantedSize = 7;
                break;
            }
            case 6: {
                wantedSize = 9;
            }
        }
        if (HoloInventory.getConfig().mode != 0) {
            Collections.sort(list, new Comparator<ItemStack>(){

                @Override
                public int compare(ItemStack o1, ItemStack o2) {
                    return o2.field_77994_a - o1.field_77994_a;
                }
            });
            if (list.size() > wantedSize) {
                list = list.subList(0, wantedSize);
            }
        }
        if (HoloInventory.getConfig().cycle != 0) {
            int n = (int)(Minecraft.func_71410_x().field_71441_e.func_82737_E() / (long)HoloInventory.getConfig().cycle % (long)list.size());
            list = Arrays.asList((ItemStack)list.get(n));
        }
        this.doRenderHologram(namedData.name, list, distance);
    }

    private void doRenderHologram(String name, List<ItemStack> itemStacks, double distance) {
        GL11.glPushMatrix();
        this.moveAndRotate(-1.0);
        this.timeD = (float)(360.0 * (double)(System.currentTimeMillis() & 0x3FFFL) / 16383.0);
        this.maxColumns = this.getMaxColumns(itemStacks.size());
        this.maxRows = itemStacks.size() % this.maxColumns == 0 ? itemStacks.size() / this.maxColumns - 1 : itemStacks.size() / this.maxColumns;
        this.blockScale = this.getBlockScaleModifier(this.maxColumns) + (float)((double)0.05f * distance);
        this.maxWith = (float)this.maxColumns * this.blockScale * 0.7f * 0.4f;
        this.maxHeight = (float)this.maxRows * this.blockScale * 0.7f * 0.4f;
        this.renderText = HoloInventory.getConfig().renderText;
        if (HoloInventory.getConfig().colorEnable) {
            this.renderBG();
        }
        if (HoloInventory.getConfig().renderName) {
            this.renderName(name);
        }
        int column = 0;
        int row = 0;
        for (ItemStack item : itemStacks) {
            int stackSize = item.field_77994_a;
            if (!HoloInventory.getConfig().renderMultiple) {
                item = item.func_77946_l();
                item.field_77994_a = 1;
            }
            this.renderItem(item, column, row, stackSize);
            if (++column < this.maxColumns) continue;
            column = 0;
            ++row;
        }
        GL11.glPopMatrix();
    }

    private void moveAndRotate(double depth) {
        GL11.glTranslated((double)(this.coord.x - RenderManager.field_78725_b), (double)(this.coord.y - RenderManager.field_78726_c), (double)(this.coord.z - RenderManager.field_78723_d));
        GL11.glRotatef((float)(-RenderManager.field_78727_a.field_78735_i), (float)0.0f, (float)0.5f, (float)0.0f);
        GL11.glRotatef((float)RenderManager.field_78727_a.field_78732_j, (float)0.5f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)0.0, (double)depth);
    }

    private float getBlockScaleModifier(int columns) {
        if (columns > 9) {
            return 0.2f - (float)columns * 0.005f;
        }
        return 0.2f + (float)(9 - columns) * 0.05f;
    }

    private int getMaxColumns(int size) {
        if (size < 9) {
            return size;
        }
        if (size <= 27) {
            return 9;
        }
        if (size <= 54) {
            return 11;
        }
        if (size <= 90) {
            return 14;
        }
        if (size <= 109) {
            return 18;
        }
        return 21;
    }

    private String doStackSizeCrap(int stackSize) {
        String string;
        String string2 = string = stackSize < 1000 ? stackSize + "" : DF.format((double)stackSize / 1000.0) + "K";
        if (string.contains(",")) {
            GL11.glTranslatef((float)3.0f, (float)0.0f, (float)0.0f);
        }
        switch (string.length()) {
            case 0: {
                return string;
            }
            case 1: {
                GL11.glTranslatef((float)3.0f, (float)0.0f, (float)0.0f);
                return string;
            }
        }
        GL11.glTranslatef((float)6.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(6.0f * (float)(1 - string.length())), (float)0.0f, (float)0.0f);
        return string;
    }

    private void renderItem(ItemStack itemStack, int column, int row, int stackSize) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(this.maxWith - ((float)column + 0.2f) * this.blockScale * 0.6f), (float)(this.maxHeight - ((float)row + 0.05f) * this.blockScale * 0.6f), (float)0.0f);
        GL11.glScalef((float)this.blockScale, (float)this.blockScale, (float)this.blockScale);
        if (Minecraft.func_71410_x().field_71474_y.field_74347_j) {
            GL11.glRotatef((float)this.timeD, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)RenderManager.field_78727_a.field_78735_i, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        this.customitem.func_92058_a(itemStack);
        ClientHandler.RENDER_ITEM.func_76986_a(this.customitem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        if (itemStack.hasEffect(0)) {
            GL11.glDisable((int)2896);
        }
        GL11.glPopMatrix();
        if (this.renderText && (itemStack.func_77976_d() != 1 || itemStack.field_77994_a != 1)) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            GL11.glTranslatef((float)(this.maxWith - ((float)column + 0.2f) * this.blockScale * 0.6f), (float)(this.maxHeight - ((float)row + 0.05f) * this.blockScale * 0.6f), (float)0.0f);
            GL11.glScalef((float)this.blockScale, (float)this.blockScale, (float)this.blockScale);
            GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
            RenderManager.field_78727_a.func_78716_a().func_85187_a(this.doStackSizeCrap(stackSize), 0, 0, -1426063361, true);
            GL11.glDisable((int)32826);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }

    private void renderBG() {
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        Tessellator tess = Tessellator.field_78398_a;
        Tessellator.renderingWorldRenderer = false;
        tess.func_78371_b(7);
        tess.func_78370_a(HoloInventory.getConfig().colorR, HoloInventory.getConfig().colorG, HoloInventory.getConfig().colorB, HoloInventory.getConfig().colorAlpha);
        double d = this.blockScale / 3.0f;
        tess.func_78377_a((double)this.maxWith + d, -d - (double)this.maxHeight, 0.0);
        tess.func_78377_a((double)(-this.maxWith) - d, -d - (double)this.maxHeight, 0.0);
        tess.func_78377_a((double)(-this.maxWith) - d, d + (double)this.maxHeight, 0.0);
        tess.func_78377_a((double)this.maxWith + d, d + (double)this.maxHeight, 0.0);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    private void renderName(String name) {
        name = StatCollector.func_74838_a((String)name);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glTranslated((double)0.0, (double)((double)this.maxHeight + (double)this.blockScale / 1.25), (double)0.0);
        GL11.glScaled((double)this.blockScale, (double)this.blockScale, (double)this.blockScale);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        GL11.glScalef((float)0.03f, (float)0.03f, (float)0.03f);
        GL11.glTranslated((double)(3.0f * (float)name.length()), (double)0.0, (double)0.0);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)-1.0f, (float)1.0f, (float)0.0f);
        RenderManager.field_78727_a.func_78716_a().func_85187_a(name, 0, 0, -1426063361, true);
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private double distance() {
        return Math.sqrt((this.coord.x - RenderManager.field_78725_b) * (this.coord.x - RenderManager.field_78725_b) + (this.coord.y - RenderManager.field_78726_c) * (this.coord.y - RenderManager.field_78726_c) + (this.coord.z - RenderManager.field_78723_d) * (this.coord.z - RenderManager.field_78723_d));
    }
}

