/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.server;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dries007.holoInventory.HoloInventory;
import net.dries007.holoInventory.packet.PacketPipeline;
import net.dries007.holoInventory.packet.RemoveInventoryPacket;
import net.dries007.holoInventory.util.Coord;
import net.dries007.holoInventory.util.FakeInventory;
import net.dries007.holoInventory.util.Helper;
import net.dries007.holoInventory.util.InventoryData;
import net.minecraft.block.BlockJukebox;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ServerEventHandler {
    public List<String> banUsers = new ArrayList<String>();
    public HashMap<Integer, InventoryData> blockMap = new HashMap();

    @SubscribeEvent
    public void event(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (this.banUsers.contains(event.entityPlayer.getDisplayName())) {
            this.banUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            TileEntity te = event.entity.field_70170_p.func_147438_o(event.x, event.y, event.z);
            if (Helper.weWant(te)) {
                HoloInventory.getConfig().bannedTiles.add(te.getClass().getCanonicalName());
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(te.getClass().getCanonicalName() + " will no longer display a hologram."));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
            HoloInventory.getConfig().overrideBannedThings();
        }
    }

    @SubscribeEvent
    public void event(EntityInteractEvent event) {
        if (this.banUsers.contains(event.entityPlayer.getDisplayName())) {
            this.banUsers.remove(event.entityPlayer.getDisplayName());
            event.setCanceled(true);
            if (Helper.weWant(event.target)) {
                HoloInventory.getConfig().bannedEntities.add(event.target.getClass().getCanonicalName());
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(event.target.getClass().getCanonicalName() + " will no longer display a hologram."));
            } else {
                event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText("That is no inventory. Try again."));
            }
            HoloInventory.getConfig().overrideBannedThings();
        }
    }

    @SubscribeEvent
    public void event(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != Side.SERVER) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        WorldServer world = player.func_71121_q();
        if (world == null) {
            return;
        }
        MovingObjectPosition mo = Helper.getPlayerLookingSpot((EntityPlayer)player);
        if (mo != null) {
            switch (mo.field_72313_a) {
                case BLOCK: {
                    Coord coord = new Coord(world.field_73011_w.field_76574_g, mo);
                    TileEntity te = world.func_147438_o((int)coord.x, (int)coord.y, (int)coord.z);
                    if (!Helper.weWant(te)) break;
                    this.checkForChangedType(coord.hashCode(), te);
                    if (HoloInventory.getConfig().bannedTiles.contains(te.getClass().getCanonicalName())) {
                        this.cleanup(coord, player);
                        break;
                    }
                    if (te instanceof IInventory) {
                        this.doStuff(coord.hashCode(), player, (IInventory)te);
                        break;
                    }
                    if (te instanceof TileEntityEnderChest) {
                        this.doStuff(coord.hashCode(), player, (IInventory)player.func_71005_bN());
                        break;
                    }
                    if (te instanceof BlockJukebox.TileEntityJukebox) {
                        BlockJukebox.TileEntityJukebox realTe = (BlockJukebox.TileEntityJukebox)te;
                        this.doStuff(coord.hashCode(), player, "jukebox", realTe.func_145856_a());
                        break;
                    }
                    this.cleanup(coord, player);
                    break;
                }
                case ENTITY: {
                    if (!Helper.weWant(mo.field_72308_g)) break;
                    this.doStuff(mo.field_72308_g.func_145782_y(), player, (IInventory)mo.field_72308_g);
                }
            }
        }
    }

    private void checkForChangedType(int id, TileEntity te) {
        if (this.blockMap.containsKey(id)) {
            InventoryData data = this.blockMap.get(id);
            if (!te.getClass().getCanonicalName().equals(data.getType())) {
                this.blockMap.remove(id);
            }
        }
    }

    private void cleanup(Coord coord, EntityPlayerMP player) {
        if (this.blockMap.containsKey(coord.hashCode())) {
            InventoryData inventoryData = this.blockMap.get(coord.hashCode());
            inventoryData.playerSet.remove(player);
            if (inventoryData.playerSet.isEmpty()) {
                this.blockMap.remove(coord.hashCode());
            }
            NBTTagCompound root = new NBTTagCompound();
            root.func_74774_a("type", (byte)0);
            root.func_74768_a("id", coord.hashCode());
            PacketPipeline.PIPELINE.sendTo(new RemoveInventoryPacket(root), player);
        }
    }

    private void doStuff(int id, EntityPlayerMP player, String name, ItemStack ... itemStacks) {
        this.doStuff(id, player, new FakeInventory(name, itemStacks));
    }

    private void doStuff(int id, EntityPlayerMP player, IInventory inventory) {
        InventoryData inventoryData = this.blockMap.get(id);
        if (inventoryData == null) {
            inventoryData = new InventoryData(inventory, id);
        } else {
            inventoryData.update(inventory);
        }
        inventoryData.sendIfOld(player);
        this.blockMap.put(id, inventoryData);
    }

    public void clear() {
        this.blockMap.clear();
    }
}

