/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter.config;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import mickkay.scenter.ScenterMod;
import mickkay.scenter.Target;
import mickkay.scenter.TargetPart;
import mickkay.scenter.config.BlockElement;
import mickkay.scenter.config.Entry;
import mickkay.scenter.config.TargetEntry;
import mickkay.scenter.config.TargetsConfig;
import mickkay.scenter.config.TargetsConfigFile;
import mickkay.scenter.config.defaults.Defaults;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ScenterModConfig {
    private static final String CFG_PROP_VERSION = "version";
    private static final String CFG_CATEGORY_GENERAL = "general";
    private static final String CFG_CATEGORY_BLOCKS = "blocks";
    private final Logger logger = Logger.getLogger(ScenterMod.class.getName());
    private final Defaults defaults = new Defaults();
    private final List<Target> targets = new ArrayList<Target>();
    private final File configFile;
    private final Configuration config;
    private final TargetsConfigFile targetsConfigFile;
    private final TargetsConfig targetsConfig;

    public ScenterModConfig(File aConfigFile) throws IOException {
        this.configFile = aConfigFile;
        this.config = new Configuration(aConfigFile);
        this.config.load();
        this.targetsConfigFile = new TargetsConfigFile(this.getTargetsConfigFile(this.configFile));
        this.targetsConfig = this.targetsConfigFile.getConfig();
        this.upgradeConfigsToCurrentVersion();
        for (Entry entry : this.targetsConfig.getEntries()) {
            if (!(entry instanceof TargetEntry)) continue;
            TargetEntry targetEntry = (TargetEntry)entry;
            Target target = new Target();
            if (targetEntry.getColor() != null) {
                Color color = Color.decode("#" + targetEntry.getColor());
                target.setColor(color);
            }
            for (BlockElement blockElem : targetEntry.getBlocks()) {
                String blockName = blockElem.getName();
                Integer dmg = blockElem.getSubtype();
                Object obj = Block.field_149771_c.func_82594_a(blockName);
                if (obj != null && obj instanceof Block) {
                    Block block = (Block)obj;
                    ItemStack stack = new ItemStack(block, 1, dmg == null ? 0 : dmg);
                    String idStr = blockName + (dmg == null ? "" : "/" + dmg);
                    this.logger.info(String.format("Scenter: Adding block %s.", idStr));
                    target.getParts().add(new TargetPart(block, dmg, stack));
                    continue;
                }
                this.logger.warning(String.format("Scenter: Error - block with name '%s' not found!", blockName));
            }
            if (!target.hasParts()) continue;
            this.targets.add(target);
        }
    }

    private void upgradeConfigsToCurrentVersion() throws IOException {
        if (this.isEmpty(this.config)) {
            this.makeStandardConfig(this.config);
            this.config.save();
        } else {
            this.setConfigVersion("1.7.2-3.0.0");
            this.config.save();
        }
        if (!this.targetsConfigFile.exists()) {
            this.makeStandardTargetsConfig(this.targetsConfig);
            this.targetsConfigFile.save();
        }
    }

    private void setConfigVersion(String aNewVersion) {
        Property val = this.getConfigVersionProperty();
        val.set(aNewVersion);
    }

    private boolean isCurrentVersion(Configuration config) {
        if (!this.hasConfigVersion()) {
            return false;
        }
        String configVersion = this.getConfigVersion();
        return configVersion != null && configVersion.equals("1.7.2-3.0.0");
    }

    private boolean hasConfigVersion() {
        return this.config.hasKey(CFG_CATEGORY_GENERAL, CFG_PROP_VERSION);
    }

    private String getConfigVersion() {
        Property val = this.getConfigVersionProperty();
        return val.getString();
    }

    private Property getConfigVersionProperty() {
        return this.config.get(CFG_CATEGORY_GENERAL, CFG_PROP_VERSION, "", "Do NOT manually change this value");
    }

    private void makeBackup(File fromFile) throws IOException {
        String backupName;
        File backupFile;
        if (!fromFile.exists()) {
            return;
        }
        int num = 0;
        do {
            backupName = fromFile.getName() + ".bak" + ++num;
        } while ((backupFile = new File(fromFile.getParentFile(), backupName)).exists());
        this.copyFile(fromFile, backupFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File fromFile, File toFile) throws IOException {
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(fromFile);
            fout = new FileOutputStream(toFile);
            byte[] b = new byte[1024];
            int noOfBytes = 0;
            while ((noOfBytes = fin.read(b)) != -1) {
                fout.write(b, 0, noOfBytes);
            }
        }
        finally {
            if (fout != null) {
                fout.close();
            }
            if (fin != null) {
                fin.close();
            }
        }
    }

    private boolean isEmpty(TargetsConfigFile targetsConfigFile) {
        return targetsConfigFile.getConfig().isEmpty();
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    private File getTargetsConfigFile(File configFile) {
        String defaultConfigName = configFile.getName();
        String name = defaultConfigName.substring(0, defaultConfigName.indexOf(46));
        String targetsConfigName = name + "3.targets.cfg";
        return new File(configFile.getParentFile(), targetsConfigName);
    }

    private void makeStandardTargetsConfig(TargetsConfig targetsConfig) {
        this.addStandardHeaderComments(targetsConfig);
        for (Defaults.BlockDefault blockDef : this.defaults.getBlockDefaults()) {
            this.addTargetFor(targetsConfig, blockDef);
        }
    }

    private void addTargetFor(TargetsConfig cfg, Defaults.BlockDefault blockDef) {
        if (blockDef.block.length == 1) {
            cfg.addTarget(this.getName(blockDef.block[0]), blockDef.color);
        } else {
            TargetEntry target = cfg.addTarget(this.getName(blockDef.block[0]), blockDef.color);
            for (int i = 1; i < blockDef.block.length; ++i) {
                target.addBlockElement(this.getName(blockDef.block[i]));
            }
        }
    }

    private String getName(Block block) {
        String name = Block.field_149771_c.func_148750_c((Object)block);
        if (name.startsWith("minecraft:")) {
            return name.substring("minecraft:".length());
        }
        return name;
    }

    private void addStandardHeaderComments(TargetsConfig cfg) {
        cfg.addComment("## Scenter Targets Definitions");
        cfg.addComment("# During game play you can toggle between all defined targets by pressing 'O'.");
        cfg.addComment("# With this file you can define these targets.");
        cfg.addComment("#");
        cfg.addComment("# Each line adds one target to Scenter.");
        cfg.addComment("# A target definition consists of one ore more blocks and an optional color (for tinting the particle trail).");
        cfg.addComment("#");
        cfg.addComment("# The line format is:");
        cfg.addComment("# <block-list> [<color (hexadecimal)>]");
        cfg.addComment("#   where <block-list> is <block>[, <block>] ... ");
        cfg.addComment("#   and where <block> is <block-name>[/<subtype>]");
        cfg.addComment("#");
        cfg.addComment("# Example 1:");
        cfg.addComment("#  obsidian 000000");
        cfg.addComment("#  adds a target for obsidian, with a black (000000) particle trail color");
        cfg.addComment("# Example 2:");
        cfg.addComment("#  lava, flowing_lava FF0000 ");
        cfg.addComment("#  adds a target for lava and flowing lava, with a red (FF0000) particle trail color");
        cfg.addComment("# Example 3:");
        cfg.addComment("#  wool/14, wool/4, wool/6 FFFFFF ");
        cfg.addComment("#  adds a target for red (/14), yellow (/4), and pink (/6) wool, with a white (FFFFFF) particle trail color");
        cfg.addComment("");
        cfg.addComment(" Use '#' for comments");
        cfg.addComment("");
    }

    private boolean isEmpty(Configuration config) {
        return config.getCategoryNames().isEmpty();
    }

    private void makeStandardConfig(Configuration config) {
        this.setConfigVersion("1.7.2-3.0.0");
    }
}

