/*
 * Decompiled with CFR 0.152.
 */
package grim3212.mc.frames;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import grim3212.mc.core.packet.AbstractPacket;
import grim3212.mc.core.packet.PacketPipeline;
import grim3212.mc.frames.EnumFrame;
import grim3212.mc.frames.Frames;
import grim3212.mc.frames.PacketDye;
import grim3212.mc.frames.PacketFrame;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityFrame
extends Entity
implements IEntityAdditionalSpawnData {
    public int direction = 0;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public int red = 256;
    public int green = 256;
    public int blue = 256;
    public int material = 0;
    public boolean isBurnt = false;
    public float resistance = 0.0f;
    public EnumFrame frames;
    public final AxisAlignedBB setupboundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public final AxisAlignedBB fireboundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final int[] colorValues = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0x868686, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xFFFFFF};

    public EntityFrame(World world) {
        super(world);
        this.field_70129_M = 0.0f;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityFrame(World world, int x, int y, int z, int direction, int material) {
        this(world);
        this.xPosition = x;
        this.yPosition = y;
        this.zPosition = z;
        this.material = material;
        ArrayList<EnumFrame> arraylist = new ArrayList<EnumFrame>();
        EnumFrame[] aenumframes = EnumFrame.values();
        int i1 = aenumframes.length;
        for (int j1 = 0; j1 < i1; ++j1) {
            EnumFrame enumframes;
            this.frames = enumframes = aenumframes[j1];
            this.setDirection(direction);
            if (!this.onValidSurface()) continue;
            arraylist.add(enumframes);
        }
        if (arraylist.size() > 0) {
            this.frames = (EnumFrame)((Object)arraylist.get(0));
        }
        this.setDirection(direction);
        this.setResistance(this.material);
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
        if (entityplayer.func_82247_a(this.xPosition, this.yPosition, this.zPosition, this.direction, itemstack) && itemstack != null) {
            if (Frames.dyeFrames && itemstack.func_77973_b() == Items.field_151100_aR) {
                if (this.dyeFrame(itemstack.func_77960_j())) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        --itemstack.field_77994_a;
                    }
                    return true;
                }
            } else if (itemstack.func_77973_b() == Frames.frameItem && itemstack.func_77960_j() == this.material) {
                return this.updateFrame();
            }
        }
        return false;
    }

    public boolean updateFrame(String title) {
        for (EnumFrame enumframes : EnumFrame.values()) {
            if (!enumframes.title.equals(title)) continue;
            this.frames = enumframes;
            break;
        }
        if (this.frames == null) {
            this.frames = EnumFrame.frame_01;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.playFrameSound();
            PacketPipeline.sendToServer((AbstractPacket)new PacketFrame(this.func_145782_y(), this.frames.title));
        }
        return true;
    }

    public boolean updateFrame() {
        int lCounter = 0;
        int lOldFrame = 0;
        int lNewFrame = 0;
        String lOldTitle = this.frames.title;
        ArrayList<EnumFrame> arraylist = new ArrayList<EnumFrame>();
        EnumFrame[] aenumframes = EnumFrame.values();
        int i1 = aenumframes.length;
        for (int j1 = 0; j1 < i1; ++j1) {
            EnumFrame enumframes;
            this.frames = enumframes = aenumframes[j1];
            this.setDirection(this.direction);
            if (!this.onValidSurface()) continue;
            arraylist.add(enumframes);
            if (enumframes.title.equals(lOldTitle)) {
                lOldFrame = lCounter;
            }
            ++lCounter;
        }
        lNewFrame = lOldFrame + 1;
        if (lNewFrame >= arraylist.size()) {
            lNewFrame = 0;
        }
        if (arraylist.size() > 0) {
            this.frames = (EnumFrame)((Object)arraylist.get(lNewFrame));
        }
        this.setDirection(this.direction);
        if (!this.field_70170_p.field_72995_K) {
            this.playFrameSound();
            PacketPipeline.sendToServer((AbstractPacket)new PacketFrame(this.func_145782_y(), this.frames.title));
        }
        return true;
    }

    public boolean dyeFrame(int color, boolean burn) {
        int newred = (colorValues[color] & 0xFF0000) >> 16;
        int newgreen = (colorValues[color] & 0xFF00) >> 8;
        int newblue = colorValues[color] & 0xFF;
        if (newred == this.red && newgreen == this.green && newblue == this.blue) {
            return false;
        }
        this.red = newred;
        this.green = newgreen;
        this.blue = newblue;
        this.isBurnt = burn;
        if (!this.field_70170_p.field_72995_K) {
            if (burn) {
                this.playBurnSound();
            } else {
                this.playDyeSound();
            }
            PacketPipeline.sendToServer((AbstractPacket)new PacketDye(this.func_145782_y(), color, burn));
        }
        return true;
    }

    public boolean dyeFrame(int color) {
        return this.dyeFrame(color, false);
    }

    protected void func_70088_a() {
    }

    public void setResistance(int material) {
        switch (material) {
            case 0: {
                this.resistance = 9.0f;
                break;
            }
            case 1: {
                this.resistance = 18.0f;
            }
        }
    }

    public void setDirection(int direction) {
        this.direction = direction;
        this.field_70126_B = this.field_70177_z = (float)(direction * 90);
        float sizeX = this.frames.sizeX;
        float sizeY = this.frames.sizeY;
        float sizeZ = this.frames.sizeX;
        float width = 0.5f;
        if (direction != 0 && direction != 2) {
            sizeX = width;
        } else {
            sizeZ = width;
        }
        sizeX /= 32.0f;
        sizeY /= 32.0f;
        sizeZ /= 32.0f;
        width /= 32.0f;
        float xPos = (float)this.xPosition + 0.5f;
        float yPos = (float)this.yPosition + 0.5f;
        float zPos = (float)this.zPosition + 0.5f;
        yPos += this.sizeOffset(this.frames.sizeY);
        if (direction == 0) {
            zPos -= width + 0.5f;
            xPos -= this.sizeOffset(this.frames.sizeX);
        }
        if (direction == 1) {
            xPos -= width + 0.5f;
            zPos += this.sizeOffset(this.frames.sizeX);
        }
        if (direction == 2) {
            zPos += width + 0.5f;
            xPos += this.sizeOffset(this.frames.sizeX);
        }
        if (direction == 3) {
            xPos += width + 0.5f;
            zPos -= this.sizeOffset(this.frames.sizeX);
        }
        this.func_70107_b(xPos, yPos, zPos);
        this.field_70121_D.func_72324_b((double)(xPos - sizeX), (double)(yPos - sizeY), (double)(zPos - sizeZ), (double)(xPos + sizeX), (double)(yPos + sizeY), (double)(zPos + sizeZ));
        if (direction == 0 || direction == 2) {
            sizeX -= 0.1f;
            sizeY -= 0.1f;
        } else {
            sizeY -= 0.1f;
            sizeZ -= 0.1f;
        }
        this.setupboundingBox.func_72324_b((double)(xPos - sizeX), (double)(yPos - sizeY), (double)(zPos - sizeZ), (double)(xPos + sizeX), (double)(yPos + sizeY), (double)(zPos + sizeZ));
        if (direction == 0 || direction == 2) {
            sizeX += 0.1f;
            sizeY += 0.1f;
            sizeZ = 1.0f;
        } else {
            sizeX = 1.0f;
            sizeY += 0.1f;
            sizeZ += 0.1f;
        }
        this.fireboundingBox.func_72324_b((double)(xPos - sizeX), (double)(yPos - sizeY), (double)(zPos - sizeZ), (double)(xPos + sizeX), (double)(yPos + sizeY), (double)(zPos + sizeZ));
    }

    private float sizeOffset(int size) {
        if (size == 32) {
            return 0.5f;
        }
        return size != 64 ? 0.0f : 0.5f;
    }

    public void func_70071_h_() {
        if (this.material == 0 && Frames.burnFrames && this.field_70170_p.func_72830_b(this.fireboundingBox.func_72331_e(0.001, 0.001, 0.001), Material.field_151581_o) && !this.isBurnt) {
            this.dyeFrame(8, true);
        }
    }

    public boolean onValidSurface() {
        if (this.field_70170_p.func_72945_a((Entity)this, this.setupboundingBox).size() > 0) {
            return false;
        }
        int sizeX = this.frames.sizeX / 16;
        int sizeY = this.frames.sizeY / 16;
        int x = this.xPosition;
        int y = this.yPosition;
        int z = this.zPosition;
        boolean onWall = true;
        Material mainSupportingBlock = this.field_70170_p.func_147439_a(x, y, z).func_149688_o();
        if (!mainSupportingBlock.func_76220_a()) {
            onWall = false;
        }
        if (this.direction == 0) {
            x = MathHelper.func_76128_c((double)(this.field_70165_t - (double)((float)this.frames.sizeX / 32.0f)));
        }
        if (this.direction == 1) {
            z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)((float)this.frames.sizeX / 32.0f)));
        }
        if (this.direction == 2) {
            x = MathHelper.func_76128_c((double)(this.field_70165_t - (double)((float)this.frames.sizeX / 32.0f)));
        }
        if (this.direction == 3) {
            z = MathHelper.func_76128_c((double)(this.field_70161_v - (double)((float)this.frames.sizeX / 32.0f)));
        }
        y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)((float)this.frames.sizeY / 32.0f)));
        if (onWall) {
            for (int xOffset = 0; xOffset < sizeX; ++xOffset) {
                for (int yOffset = 0; yOffset < sizeY; ++yOffset) {
                    Material supportingBlock = this.direction == 0 || this.direction == 2 ? this.field_70170_p.func_147439_a(x + xOffset, y + yOffset, z).func_149688_o() : this.field_70170_p.func_147439_a(x, y + yOffset, z + xOffset).func_149688_o();
                    if (supportingBlock.func_76220_a()) continue;
                    return false;
                }
            }
        }
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        for (int l1 = 0; l1 < list.size(); ++l1) {
            if (!(list.get(l1) instanceof EntityFrame)) continue;
            EntityFrame lNeighbourFrame = (EntityFrame)((Object)list.get(l1));
            if (lNeighbourFrame.direction != this.direction) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70067_L() {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null) {
            if (this.material == 0 && (itemstack.func_77973_b() == Frames.frameItem && itemstack.func_77960_j() == this.material || itemstack.func_77973_b() == Items.field_151053_p || itemstack.func_77973_b() == Items.field_151049_t || itemstack.func_77973_b() == Items.field_151036_c || itemstack.func_77973_b() == Items.field_151006_E || itemstack.func_77973_b() == Items.field_151056_x || itemstack.func_77973_b() == Items.field_151100_aR)) {
                return true;
            }
            if (this.material == 1 && (itemstack.func_77973_b() == Frames.frameItem && itemstack.func_77960_j() == this.material || itemstack.func_77973_b() == Items.field_151039_o || itemstack.func_77973_b() == Items.field_151050_s || itemstack.func_77973_b() == Items.field_151035_b || itemstack.func_77973_b() == Items.field_151005_D || itemstack.func_77973_b() == Items.field_151046_w || itemstack.func_77973_b() == Items.field_151100_aR)) {
                return true;
            }
        }
        return false;
    }

    public AxisAlignedBB func_70046_E() {
        if (this.frames.isCollidable) {
            return this.field_70121_D;
        }
        return null;
    }

    public boolean func_70097_a(DamageSource damagesource, float damage) {
        if (!this.field_70128_L) {
            if (damagesource.func_76346_g() instanceof EntityPlayer) {
                ItemStack itemstack;
                EntityPlayer entityplayer = (EntityPlayer)damagesource.func_76346_g();
                if (!entityplayer.func_82247_a(this.xPosition, this.yPosition, this.zPosition, this.direction, itemstack = entityplayer.field_71071_by.func_70448_g())) {
                    return false;
                }
                this.func_70106_y();
                this.func_70018_K();
                this.playFrameSound();
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return true;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Frames.frameItem, 1, this.material)));
                }
                return true;
            }
            if (damage > this.resistance) {
                this.func_70106_y();
                this.func_70018_K();
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Frames.frameItem, 1, this.material)));
                }
                return true;
            }
        }
        return false;
    }

    public void playFrameSound() {
        switch (this.material) {
            case 0: {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "step.wood", 1.0f, 0.8f);
                break;
            }
            case 1: {
                this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "step.stone", 1.0f, 1.2f);
            }
        }
    }

    public void playDyeSound() {
        this.playFrameSound();
    }

    public void playBurnSound() {
        this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, "fire.fire", 1.0f, 1.0f);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74774_a("Dir", (byte)this.direction);
        nbttagcompound.func_74778_a("Motive", this.frames.title);
        nbttagcompound.func_74768_a("TileX", this.xPosition);
        nbttagcompound.func_74768_a("TileY", this.yPosition);
        nbttagcompound.func_74768_a("TileZ", this.zPosition);
        nbttagcompound.func_74768_a("Red", this.red);
        nbttagcompound.func_74768_a("Green", this.green);
        nbttagcompound.func_74768_a("Blue", this.blue);
        nbttagcompound.func_74768_a("Material", this.material);
        nbttagcompound.func_74757_a("Burnt", this.isBurnt);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.direction = nbttagcompound.func_74771_c("Dir");
        this.xPosition = nbttagcompound.func_74762_e("TileX");
        this.yPosition = nbttagcompound.func_74762_e("TileY");
        this.zPosition = nbttagcompound.func_74762_e("TileZ");
        this.red = nbttagcompound.func_74762_e("Red");
        this.green = nbttagcompound.func_74762_e("Green");
        this.blue = nbttagcompound.func_74762_e("Blue");
        this.material = nbttagcompound.func_74762_e("Material");
        String id = nbttagcompound.func_74779_i("Motive");
        this.isBurnt = nbttagcompound.func_74767_n("Burnt");
        for (EnumFrame enumframes : EnumFrame.values()) {
            if (!enumframes.title.equals(id)) continue;
            this.frames = enumframes;
            break;
        }
        if (this.frames == null) {
            this.frames = EnumFrame.frame_01;
        }
        this.setDirection(this.direction);
        this.setResistance(this.material);
    }

    public void func_70091_d(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && x * x + y * y + z * z > 0.0) {
            this.func_70106_y();
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Frames.frameItem, 1, this.material)));
        }
    }

    public void func_70024_g(double x, double y, double z) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && x * x + y * y + z * z > 0.0) {
            this.func_70106_y();
            this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Frames.frameItem, 1, this.material)));
        }
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeInt(this.direction);
        data.writeInt(this.xPosition);
        data.writeInt(this.yPosition);
        data.writeInt(this.zPosition);
        data.writeInt(this.material);
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)this.frames.title);
        data.writeInt(this.red);
        data.writeInt(this.green);
        data.writeInt(this.blue);
        data.writeBoolean(this.isBurnt);
    }

    public void readSpawnData(ByteBuf data) {
        this.direction = data.readInt();
        this.xPosition = data.readInt();
        this.yPosition = data.readInt();
        this.zPosition = data.readInt();
        this.material = data.readInt();
        String id = ByteBufUtils.readUTF8String((ByteBuf)data);
        for (EnumFrame enumframes : EnumFrame.values()) {
            if (!enumframes.title.equals(id)) continue;
            this.frames = enumframes;
            break;
        }
        if (this.frames == null) {
            this.frames = EnumFrame.frame_01;
        }
        this.setDirection(this.direction);
        this.setResistance(this.material);
        this.red = data.readInt();
        this.green = data.readInt();
        this.blue = data.readInt();
        this.isBurnt = data.readBoolean();
    }
}

