/*
 * Decompiled with CFR 0.152.
 */
package bacteriamod;

import bacteriamod.BacteriaCommonProxy;
import bacteriamod.BacteriaWorldGenerator;
import bacteriamod.BlockBacteriaJammer;
import bacteriamod.BlockBacteriaMust;
import bacteriamod.BlockBacteriaNormal;
import bacteriamod.BlockBacteriaReplace;
import bacteriamod.ItemBacteria;
import bacteriamod.ItemBacteriaJammer;
import bacteriamod.TileEntityBacteria;
import bacteriamod.TileEntityReplacer;
import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IPickupNotifier;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraftforge.common.Configuration;

@Mod(modid="TeNNoX_Bacteria", name="Bacteria", version="2.0.5")
@NetworkMod(clientSideRequired=true, serverSideRequired=true)
public class Bacteria
implements ICraftingHandler,
IPickupNotifier {
    static boolean achievements = false;
    @SidedProxy(clientSide="bacteriamod.BacteriaClientProxy", serverSide="bacteriamod.BacteriaCommonProxy")
    public static BacteriaCommonProxy proxy;
    public static Logger logger;
    public static BacteriaWorldGenerator worldGen;
    public static boolean randomize;
    public static boolean savefood;
    public static int bacteriaID;
    public static int replacerID;
    public static int isolationID;
    public static int bacteriaItemID;
    public static int jammerItemID;
    public static int jammerID;
    public static int mustID;
    public static int speed;
    public static int mustAchievementID;
    public static int bacteriaAchievementID;
    public static int bacteriumAchievementID;
    public static int jamAchievementID;
    public static Item bacteriaItem;
    public static Item jammerItem;
    public static Item bacteriaPotion;
    public static Block bacteria;
    public static Block replacer;
    public static Block marker;
    public static Block jammer;
    public static Block must;
    public static Achievement mustAchievement;
    public static Achievement bacteriaAchievement;
    public static Achievement bacteriumAchievement;
    public static Achievement jamAchievement;
    public static ArrayList<Integer> jamcolonies;
    public static boolean jam_all;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        bacteriaID = config.getBlock("bacteria", 2213).getInt();
        mustID = config.getBlock("must", 2214).getInt();
        jammerID = config.getBlock("jammer", 2215).getInt();
        replacerID = config.getBlock("replacer", 2216).getInt();
        bacteriaItemID = config.getItem("bacteria item", 8412).getInt();
        jammerItemID = config.getItem("jammer item", 8413).getInt();
        achievements = config.get("General", "Enable achievements", true).getBoolean(true);
        if (achievements) {
            mustAchievementID = config.get("Achievements", "achievement1", 8901).getInt();
            bacteriaAchievementID = config.get("Achievements", "achievement2", 8902).getInt();
            bacteriumAchievementID = config.get("Achievements", "achievement3", 8903).getInt();
            jamAchievementID = config.get("Achievements", "achievement4", 8904).getInt();
        }
        isolationID = config.get("General", "isolation blockID", 45).getInt();
        speed = config.get("General", "bacteria speed", 50).getInt();
        randomize = config.get("General", "randomize bacteria spread", true).getBoolean(true);
        savefood = config.get("General", "save food to NBT", true).getBoolean(true);
        config.save();
    }

    @Mod.Init
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderInformation();
        bacteriaItem = new ItemBacteria(bacteriaItemID).func_77655_b("bacteriaItem");
        jammerItem = new ItemBacteriaJammer(jammerItemID).func_77655_b("jammerItem");
        bacteriaPotion = new ItemPotion(9443).func_77655_b("bacteriaPotion");
        bacteria = new BlockBacteriaNormal(bacteriaID, Material.field_76246_e).func_71864_b("bacteria").func_71848_c(0.07f);
        replacer = new BlockBacteriaReplace(replacerID, Material.field_76246_e).func_71864_b("replacer").func_71848_c(0.07f);
        jammer = new BlockBacteriaJammer(jammerID, Material.field_76246_e).func_71864_b("jammer").func_71848_c(0.5f);
        must = new BlockBacteriaMust(mustID, Material.field_76252_l).func_71907_b(true).func_71848_c(0.6f).func_71884_a(Block.field_71965_g).func_71864_b("must");
        GameRegistry.registerBlock((Block)bacteria, (String)"bacteria");
        LanguageRegistry.addName((Object)bacteria, (String)"Bacterium Colony");
        GameRegistry.registerBlock((Block)replacer, (String)"replacer");
        LanguageRegistry.addName((Object)replacer, (String)"Replacer Colony");
        GameRegistry.registerBlock((Block)jammer, (String)"jammer");
        LanguageRegistry.addName((Object)jammer, (String)"Bacteria Jammer Block");
        GameRegistry.registerBlock((Block)must, (String)"must");
        LanguageRegistry.addName((Object)must, (String)"Must");
        LanguageRegistry.addName((Object)bacteriaItem, (String)"Bunch of Bacteria");
        LanguageRegistry.addName((Object)jammerItem, (String)"Bacteria Jammer");
        LanguageRegistry.addName((Object)bacteriaPotion, (String)"Bacteria Potion");
        GameRegistry.addRecipe((ItemStack)new ItemStack(jammer, 1), (Object[])new Object[]{"+#+", "#*#", "+-+", Character.valueOf('#'), bacteria, Character.valueOf('*'), Item.field_77703_o, Character.valueOf('-'), Block.field_72035_aQ, Character.valueOf('+'), Block.field_71978_w});
        GameRegistry.addRecipe((ItemStack)new ItemStack(jammerItem, 1), (Object[])new Object[]{" # ", "#*#", " - ", Character.valueOf('#'), bacteria, Character.valueOf('*'), Item.field_77703_o, Character.valueOf('-'), Block.field_72035_aQ});
        GameRegistry.addRecipe((ItemStack)new ItemStack(bacteria, 1), (Object[])new Object[]{" # ", "#*#", " # ", Character.valueOf('#'), bacteriaItem, Character.valueOf('*'), Block.field_72035_aQ});
        GameRegistry.addRecipe((ItemStack)new ItemStack(replacer, 1), (Object[])new Object[]{" # ", "#*#", " # ", Character.valueOf('#'), bacteriaItem, Character.valueOf('*'), Item.field_77705_m});
        GameRegistry.addRecipe((ItemStack)new ItemStack(must, 1), (Object[])new Object[]{"+*+", " # ", Character.valueOf('+'), Item.field_77684_U, Character.valueOf('#'), Item.field_77786_ax, Character.valueOf('*'), Block.field_71945_L});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Block.field_71945_L, 2), (Object[])new Object[]{"+*+", "*+*", "+#+", Character.valueOf('+'), Block.field_72101_ab, Character.valueOf('#'), Item.field_77786_ax, Character.valueOf('*'), Block.field_72097_ad});
        GameRegistry.addRecipe((ItemStack)new ItemStack(Block.field_71945_L, 2), (Object[])new Object[]{"+*+", "*+*", "+#+", Character.valueOf('+'), Block.field_72101_ab, Character.valueOf('#'), Item.field_77786_ax, Character.valueOf('*'), Block.field_72097_ad});
        if (achievements) {
            mustAchievement = new Achievement(mustAchievementID, "must", 5, -2, must, AchievementList.field_76017_h).func_75985_c();
            bacteriaAchievement = new Achievement(bacteriaAchievementID, "bacteria", 5, -3, bacteriaItem, mustAchievement).func_75985_c();
            bacteriumAchievement = new Achievement(bacteriumAchievementID, "bacterium", 5, -4, bacteria, bacteriaAchievement).func_75987_b().func_75985_c();
            jamAchievement = new Achievement(jamAchievementID, "jammer", 5, -5, jammerItem, bacteriumAchievement).func_75987_b().func_75985_c();
            this.addAchievementLocalizations("must", "Must!", "Craft some Must!");
            this.addAchievementLocalizations("bacteria", "Bacteria!", "Breed some Bacteria!");
            this.addAchievementLocalizations("bacterium", "Bacteria Mod!", "Craft your first Bacterium Colony!");
            this.addAchievementLocalizations("jammer", "JAMMER!", "Jam a Bacterium Colony with the jammer item!");
        }
        GameRegistry.registerCraftingHandler((ICraftingHandler)this);
        GameRegistry.registerPickupHandler((IPickupNotifier)this);
        GameRegistry.registerTileEntity(TileEntityBacteria.class, (String)"bacteria_tileentity");
        GameRegistry.registerTileEntity(TileEntityReplacer.class, (String)"replacer_tileentity");
        GameRegistry.registerWorldGenerator((IWorldGenerator)worldGen);
    }

    private void addAchievementLocalizations(String ach, String name, String desc) {
        LanguageRegistry.instance().addStringLocalization("achievement." + ach, "en_US", name);
        LanguageRegistry.instance().addStringLocalization("achievement." + ach + ".desc", "en_US", desc);
    }

    public void notifyPickup(EntityItem item, EntityPlayer player) {
        if (achievements && item.func_92059_d().field_77993_c == bacteriaItemID + 256) {
            player.func_71064_a((StatBase)bacteriaAchievement, 1);
        }
    }

    public void onCrafting(EntityPlayer player, ItemStack item, IInventory craftMatrix) {
        if (achievements) {
            if (item.field_77993_c == Bacteria.must.field_71990_ca) {
                player.func_71064_a((StatBase)mustAchievement, 1);
            }
            if (item.field_77993_c == Bacteria.bacteria.field_71990_ca) {
                player.func_71064_a((StatBase)bacteriumAchievement, 1);
            }
        }
    }

    public void onSmelting(EntityPlayer player, ItemStack item) {
    }

    static {
        worldGen = new BacteriaWorldGenerator();
        jamcolonies = new ArrayList();
    }
}

