/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.client;

import bau5.mods.craftingsuite.client.ModelCraftingTable;
import bau5.mods.craftingsuite.client.ModelModificationTable;
import bau5.mods.craftingsuite.common.BlockCrafting;
import bau5.mods.craftingsuite.common.BlockModificationTable;
import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.helpers.ModificationNBTHelper;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModdedTable;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModificationTable;
import bau5.mods.craftingsuite.common.tileentity.TileEntityProjectBench;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelSnowMan;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class CraftingBlockRenderer
extends TileEntitySpecialRenderer
implements IItemRenderer,
ISimpleBlockRenderingHandler {
    private RenderBlocks renderBlocks;
    private RenderItem renderItems;
    private Random random;
    private ModelModificationTable modelModificationTable;
    private ModelCraftingTable modelCraftingTable;
    public static boolean renderInDisplay = false;
    public static boolean cmas = false;
    private ResourceLocation sm = new ResourceLocation("textures/entity/snowman.png");

    public CraftingBlockRenderer() {
        this.modelModificationTable = new ModelModificationTable();
        this.modelCraftingTable = new ModelCraftingTable();
        this.renderBlocks = new RenderBlocks();
        this.renderItems = new RenderItem(){

            public byte getMiniItemCountForItemStack(ItemStack stack) {
                return 1;
            }

            public byte getMiniBlockCountForItemStack(ItemStack stack) {
                return 1;
            }

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.renderItems.func_76976_a(RenderManager.field_78727_a);
        cmas = CraftingSuite.cmas;
        this.random = new Random();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (item.func_77960_j()) {
            case 0: {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.modelModificationTable.modelTexture);
                this.modelPreRender(type);
                this.modelModificationTable.renderAll();
                break;
            }
            case 1: {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.modelCraftingTable.modelTexture);
                this.modelPreRender(type);
                this.modelCraftingTable.renderDefaultParts();
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(FMLClientHandler.instance().getClient().func_110434_K().func_130087_a(item.func_94608_d()));
                this.renderModdedCraftingTableInInventory(item);
                break;
            }
            case 2: {
                switch (type) {
                    case EQUIPPED_FIRST_PERSON: {
                        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                        break;
                    }
                    case EQUIPPED: {
                        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                        break;
                    }
                    case INVENTORY: {
                        if (!renderInDisplay) break;
                        GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
                        float rotational = (float)Minecraft.func_71386_F() / 3000.0f * 300.0f;
                        GL11.glRotatef((float)(rotational / 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                        break;
                    }
                }
                this.renderProjectBenchInInventory(item, 2, 1.0f);
            }
        }
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void modelPreRender(IItemRenderer.ItemRenderType type) {
        switch (type) {
            case INVENTORY: {
                GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case EQUIPPED: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.4f, (float)-2.0f, (float)-0.4f);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)-2.0f, (float)-0.5f);
                break;
            }
            case ENTITY: {
                GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)-1.2f, (float)0.0f);
                break;
            }
        }
    }

    public void func_76894_a(TileEntity tile, double d0, double d1, double d2, float f) {
        if (this.renderBlocks.field_78669_a == null) {
            this.renderBlocks.field_78669_a = tile.field_70331_k;
        }
        if (tile instanceof TileEntityModificationTable) {
            this.renderModificationTable((TileEntityModificationTable)tile, d0, d1, d2, f);
        }
        if (tile instanceof TileEntityModdedTable) {
            this.renderModdedTable((TileEntityModdedTable)tile, d0, d1, d2, f);
        }
        if (tile instanceof TileEntityProjectBench) {
            this.renderProjectBench((TileEntityProjectBench)tile, d0, d1, d2, f);
        }
    }

    public void renderProjectBench(TileEntityProjectBench tile, double x0, double y0, double z0, float f) {
        ItemStack stack;
        Block blck = Block.field_71973_m[tile.field_70331_k.func_72798_a(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)];
        if (blck == null) {
            return;
        }
        this.renderBlocks.func_78612_b(blck, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        boolean renderResult = tile.getModifications().visual() == 1;
        boolean renderTools = tile.getModifications().upgrades() == 3;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x0), (float)((float)y0), (float)((float)z0));
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (renderResult && (stack = tile.inventoryHandler.result) != null) {
            this.renderTileEntityResult(tile, stack);
        }
        if (renderTools && tile.func_70302_i_() >= 30 && Minecraft.func_71375_t()) {
            GL11.glPushMatrix();
            byte rotation = tile.getDirectionFacing();
            if (rotation == 5) {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1.0f);
            } else if (rotation == 3) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)-1.0f);
            } else if (rotation == 4) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.8f, (float)1.015f, (float)0.14f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            for (int i = 0; i < 3; ++i) {
                GL11.glPushMatrix();
                ItemStack copy = tile.tools[i];
                if (tile.selectedToolIndex == i) {
                    GL11.glTranslatef((float)-0.5f, (float)0.3f, (float)0.0f);
                } else {
                    switch (i) {
                        case 0: {
                            GL11.glRotatef((float)-40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            break;
                        }
                        case 1: {
                            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
                            GL11.glRotatef((float)35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            break;
                        }
                        case 2: {
                            GL11.glTranslatef((float)-1.0f, (float)0.4f, (float)0.0f);
                            GL11.glRotatef((float)30.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                    }
                }
                if (copy != null) {
                    copy = copy.func_77946_l();
                    EntityItem ei = new EntityItem(tile.field_70331_k, (double)tile.field_70329_l, (double)(tile.field_70330_m + 1), (double)tile.field_70327_n);
                    ei.field_70290_d = 0.0f;
                    ei.func_92058_a(copy);
                    Random rand = new Random();
                    GL11.glTranslatef((float)tile.randomShift, (float)tile.randomShift, (float)0.0f);
                    this.renderItems.func_77014_a(ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                }
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        if (cmas) {
            byte rotation = tile.getDirectionFacing();
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.5f, (float)-1.25f, (float)-0.5f);
            GL11.glScalef((float)0.01f, (float)0.01f, (float)0.01f);
            switch (rotation) {
                case 2: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)25.0f, (float)0.0f, (float)25.0f);
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 3: {
                    GL11.glTranslatef((float)25.0f, (float)0.0f, (float)25.0f);
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)25.0f, (float)0.0f, (float)25.0f);
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 5: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)25.0f, (float)0.0f, (float)25.0f);
                    GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            this.renderBlocks.field_94177_n.field_71446_o.func_110577_a(this.sm);
            ModelSnowMan sm = new ModelSnowMan();
            sm.func_78088_a((Entity)new EntitySnowman(tile.field_70331_k), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
            this.renderBlocks.field_94177_n.field_71446_o.func_110577_a(this.renderBlocks.field_94177_n.func_110434_K().func_130087_a(new ItemStack(Block.field_71981_t).func_94608_d()));
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void renderTileEntityResult(TileEntity tile, ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        copy.field_77994_a = 1;
        EntityItem ei = new EntityItem(tile.field_70331_k, (double)tile.field_70329_l, (double)(tile.field_70330_m + 1), (double)tile.field_70327_n);
        ei.field_70290_d = 0.0f;
        ei.func_92058_a(copy);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        int l = tile.field_70331_k.func_72802_i(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, 0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float rotational = (float)Minecraft.func_71386_F() / 3000.0f * 300.0f;
        if (stack.field_77993_c < Block.field_71973_m.length && Block.field_71973_m[stack.field_77993_c] != null && Block.field_71973_m[stack.field_77993_c].field_71990_ca != 0) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)1.2f, (float)0.5f);
            GL11.glRotatef((float)(rotational / 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderItems.func_77014_a(ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        } else {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)1.12f, (float)0.5f);
            GL11.glScalef((float)0.65f, (float)0.65f, (float)0.65f);
            GL11.glRotatef((float)(rotational / 5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderItems.func_77014_a(ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void renderModificationTable(TileEntityModificationTable tile, double x, double y, double z, float f) {
        this.func_110628_a(this.modelModificationTable.modelTexture);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (tile.model != null) {
            tile.model.renderAll();
            tile.model.rotateSpinner(tile.rotation);
        }
        this.renderResultModificationTable(tile);
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderResultModificationTable(TileEntityModificationTable tile) {
        ItemStack theStack = null;
        EntityItem ei = new EntityItem(tile.field_70331_k, (double)tile.field_70329_l, (double)(tile.field_70330_m + 1), (double)tile.field_70327_n);
        ei.field_70290_d = 0.0f;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-2.14f, (float)-0.5f);
        int l = tile.field_70331_k.func_72802_i(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)170.0f, (float)170.0f);
        float rotational = (float)Minecraft.func_71386_F() / 3000.0f * 300.0f;
        GL11.glTranslatef((float)0.5f, (float)1.6f, (float)0.5f);
        if (tile.isCrafting() && tile.craftingResult != null) {
            theStack = tile.craftingResult.func_77946_l();
            theStack.field_77994_a = 1;
            ei.func_92058_a(theStack);
            GL11.glRotatef((float)(Math.abs(tile.rotation) * 10.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)(0.002f * (float)(-(tile.finishTime / 10 - tile.timeCrafting / 10))), (float)0.0f);
        } else if (tile.func_70301_a(5) == null && tile.craftingResult != null || tile.craftingResult != null && !ItemStack.func_77970_a((ItemStack)tile.craftingResult, (ItemStack)tile.func_70301_a(5))) {
            GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
            theStack = tile.craftingResult.func_77946_l();
            theStack.field_77994_a = 1;
            ei.func_92058_a(theStack);
        } else {
            if (tile.func_70301_a(5) == null) {
                GL11.glPopMatrix();
                return;
            }
            theStack = tile.func_70301_a(5).func_77946_l();
            theStack.field_77994_a = 1;
            ei.func_92058_a(theStack);
        }
        this.renderItems.func_77014_a(ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    public void renderModdedTable(TileEntityModdedTable tile, double d0, double d1, double d2, float f) {
        if (tile.getModifications().type() == 1) {
            this.renderCraftingTable(tile, d0, d1, d2, f);
        }
    }

    private void renderCraftingTable(TileEntityModdedTable tile, double x, double y, double z, float f) {
        Block blck = Block.field_71973_m[tile.field_70331_k.func_72798_a(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n)];
        if (blck == null) {
            return;
        }
        this.renderBlocks.func_78612_b(blck, tile.field_70329_l, tile.field_70330_m, tile.field_70327_n);
        this.func_110628_a(this.modelCraftingTable.modelTexture);
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.modelCraftingTable.renderDefaultParts();
        if (tile.getModifications().visual() == 1 && tile.getInventoryHandler().result != null) {
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-1.5f, (float)-0.5f);
            this.renderTileEntityResult(tile, tile.getInventoryHandler().result);
        }
        GL11.glDisable((int)32826);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    private void renderModdedCraftingTableInInventory(ItemStack theStack) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (tessellator.field_78415_z) {
            tessellator.func_78381_a();
        }
        if (theStack.field_77990_d == null) {
            return;
        }
        byte[] bytes = ModificationNBTHelper.getUpgradeByteArray(theStack.field_77990_d);
        if (bytes == null || bytes.length != 5) {
            return;
        }
        ItemStack plankUsed = ItemStack.func_77949_a((NBTTagCompound)ModificationNBTHelper.getPlanksUsed(theStack.field_77990_d));
        Block block = Block.field_71973_m[theStack.field_77993_c];
        if (plankUsed == null) {
            return;
        }
        Icon plankIcon = Block.field_71973_m[plankUsed.field_77993_c].func_71858_a(0, plankUsed.func_77960_j());
        GL11.glPushMatrix();
        if (this.renderBlocks.field_78668_c) {
            int j = block.func_71889_f_(0);
            float f11 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f21 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f31 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f11 * 1.0f), (float)(f21 * 1.0f), (float)(f31 * 1.0f), (float)1.0f);
        }
        block.func_71919_f();
        this.renderBlocks.func_78595_a();
        this.renderBlocks.func_83018_a(block);
        GL11.glTranslatef((float)-0.5f, (float)0.6f, (float)-0.5f);
        this.renderBlocks.func_82774_a(plankIcon);
        this.renderBlocks.field_83027_i = 0.125;
        this.renderBlocks.field_83024_j = 0.75;
        this.renderBlocks.field_83026_h = 0.7;
        this.renderBlocks.field_83022_l = 0.78;
        this.renderBlocks.field_83025_k = 0.22;
        if (!tessellator.field_78415_z) {
            tessellator.func_78382_b();
        }
        this.renderBlocks.func_78605_f(block, 0.08, 0.0, 0.0, null);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        this.renderBlocks.func_78573_e(block, 0.22, 0.0, 0.0, null);
        tessellator.func_78381_a();
        this.renderBlocks.field_83027_i = 0.0;
        this.renderBlocks.field_83024_j = 1.0;
        this.renderBlocks.field_83026_h = 1.0;
        this.renderBlocks.field_83022_l = 1.0;
        this.renderBlocks.field_83025_k = 0.0;
        this.renderBlocks.field_83027_i = 0.125;
        this.renderBlocks.field_83024_j = 0.75;
        this.renderBlocks.field_83022_l = 0.7;
        this.renderBlocks.field_83026_h = 0.78;
        this.renderBlocks.field_83021_g = 0.22;
        tessellator.func_78382_b();
        this.renderBlocks.func_78622_d(block, 0.0, 0.0, 0.08, null);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        this.renderBlocks.func_78611_c(block, 0.0, 0.0, 0.22, null);
        tessellator.func_78381_a();
        this.renderBlocks.field_83027_i = 0.0;
        this.renderBlocks.field_83024_j = 1.0;
        this.renderBlocks.field_83022_l = 1.0;
        this.renderBlocks.field_83026_h = 1.0;
        this.renderBlocks.field_83021_g = 0.0;
        this.renderBlocks.field_83021_g = 0.2;
        this.renderBlocks.field_83026_h = 0.8;
        this.renderBlocks.field_83025_k = 0.2;
        this.renderBlocks.field_83022_l = 0.8;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderBlocks.func_78613_a(block, 0.0, 0.125, 0.0, null);
        tessellator.func_78381_a();
        this.renderBlocks.field_83021_g = 0.0;
        this.renderBlocks.field_83026_h = 1.0;
        this.renderBlocks.field_83025_k = 0.0;
        this.renderBlocks.field_83022_l = 1.0;
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, -1.0f, -1.0f);
        this.renderBlocks.func_78613_a(block, 0.0, -0.09, 0.0, null);
        tessellator.func_78381_a();
        this.renderBlocks.func_78595_a();
        GL11.glPopMatrix();
    }

    public void renderProjectBenchInInventory(ItemStack theStack, int i, float f) {
        boolean overlay;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (tessellator.field_78415_z) {
            tessellator.func_78381_a();
        }
        if (theStack.field_77990_d == null) {
            return;
        }
        byte[] bytes = ModificationNBTHelper.getUpgradeByteArray(theStack.field_77990_d);
        if (bytes == null || bytes.length != 5) {
            return;
        }
        ItemStack plankUsed = ItemStack.func_77949_a((NBTTagCompound)ModificationNBTHelper.getPlanksUsed(theStack.field_77990_d));
        Block theBlock = Block.field_71973_m[theStack.field_77993_c];
        Icon[] icons = null;
        boolean bl = overlay = bytes[3] - 1 != -1;
        if (theBlock instanceof BlockCrafting) {
            icons = ((BlockCrafting)theBlock).icons;
        }
        theBlock.func_71919_f();
        this.renderBlocks.func_83018_a(theBlock);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (this.renderBlocks.field_78668_c) {
            int j = theBlock.func_71889_f_(0);
            float f11 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f21 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f31 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f11 * 1.0f), (float)(f21 * 1.0f), (float)(f31 * 1.0f), (float)1.0f);
        }
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.renderBlocks.func_78613_a(theBlock, 0.0, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 0, i));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        Icon icOverlay = null;
        Icon icPlanks = null;
        if (overlay) {
            icOverlay = Block.field_72101_ab.func_71858_a(0, bytes[3] - 1);
        }
        if (plankUsed != null) {
            icPlanks = Block.field_71973_m[plankUsed.field_77993_c].func_71858_a(0, plankUsed.func_77960_j());
        }
        if (icOverlay == null) {
            icOverlay = Block.field_72101_ab.func_71858_a(0, 0);
        }
        if (icPlanks == null) {
            icPlanks = Block.field_71988_x.func_71858_a(0, 0);
        }
        this.renderBlocks.func_78617_b(theBlock, 0.0, 0.0, 0.0, overlay ? icOverlay : icPlanks);
        this.renderBlocks.func_82774_a(icons[4]);
        this.renderBlocks.func_78617_b(theBlock, 0.0, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 1, i));
        this.renderBlocks.func_78595_a();
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderBlocks.func_78611_c(theBlock, 0.0, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 2, i));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.renderBlocks.func_82774_a(icPlanks);
        this.renderBlocks.func_78611_c(theBlock, 0.0, 0.0, 0.01, this.renderBlocks.func_94165_a(theBlock, 2, i));
        tessellator.func_78381_a();
        this.renderBlocks.func_78595_a();
        if (overlay && icons != null) {
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            GL11.glPushMatrix();
            this.renderBlocks.func_78611_c(theBlock, -1.0E-6, 0.0, 0.0, icons[3]);
            this.renderBlocks.func_78622_d(theBlock, -1.0E-6, 0.0, 0.0, icons[3]);
            this.renderBlocks.func_78573_e(theBlock, 1.0E-6, 0.0, 0.0, icons[3]);
            this.renderBlocks.func_78605_f(theBlock, 1.0E-6, 0.0, 0.0, icons[3]);
            this.renderBlocks.func_78595_a();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            tessellator.func_78382_b();
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            GL11.glPushMatrix();
            this.renderBlocks.field_83024_j = 0.24997111;
            this.renderBlocks.field_83026_h = 0.755;
            this.renderBlocks.func_78611_c(theBlock, 0.121, 0.7502999, 0.001, icOverlay);
            this.renderBlocks.func_78622_d(theBlock, 0.121, 0.7502999, -0.001, icOverlay);
            this.renderBlocks.field_83026_h = 1.0;
            this.renderBlocks.field_83022_l = 0.755;
            this.renderBlocks.func_78573_e(theBlock, 0.001, 0.75, 0.121, icOverlay);
            this.renderBlocks.func_78605_f(theBlock, -0.001, 0.75, 0.121, icOverlay);
            this.renderBlocks.field_83024_j = 1.0;
            this.renderBlocks.field_83022_l = 1.0;
            this.renderBlocks.func_78595_a();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
        }
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderBlocks.func_78622_d(theBlock, 0.0, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 3, i));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.renderBlocks.func_82774_a(icPlanks);
        this.renderBlocks.func_78622_d(theBlock, 0.0, 0.0, -0.01, this.renderBlocks.func_94165_a(theBlock, 3, i));
        tessellator.func_78381_a();
        this.renderBlocks.func_78595_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderBlocks.func_78573_e(theBlock, 0.0, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 4, i));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.renderBlocks.func_82774_a(icPlanks);
        this.renderBlocks.func_78573_e(theBlock, 0.01, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 4, i));
        tessellator.func_78381_a();
        this.renderBlocks.func_78595_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderBlocks.func_78605_f(theBlock, 0.0, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 5, i));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.renderBlocks.func_82774_a(icPlanks);
        this.renderBlocks.func_78605_f(theBlock, -0.01, 0.0, 0.0, this.renderBlocks.func_94165_a(theBlock, 4, i));
        tessellator.func_78381_a();
        this.renderBlocks.func_78595_a();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (world == null || renderer.field_78669_a == null) {
            return false;
        }
        if (block instanceof BlockModificationTable) {
            return false;
        }
        if (world.func_72796_p(x, y, z) == null) {
            return false;
        }
        int meta = world.func_72805_g(x, y, z);
        switch (world.func_72805_g(x, y, z)) {
            case 1: {
                return this.renderModdedCraftingTableInWorld(world, x, y, z, block, renderer);
            }
            case 2: {
                return this.renderProjectBenchInWorld(world, x, y, z, block, renderer);
            }
        }
        return false;
    }

    private boolean renderModdedCraftingTableInWorld(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks renderer) {
        Block planksBlock;
        Tessellator tessellator = Tessellator.field_78398_a;
        int l = block.func_71874_e(world, x, y, z);
        ItemStack planks = ((TileEntityModdedTable)world.func_72796_p(x, y, z)).getModifications().getPlanks();
        if (planks == null) {
            planks = new ItemStack(Block.field_71988_x.field_71990_ca, 1, 0);
        }
        if ((planksBlock = Block.field_71973_m[planks.field_77993_c]) == null) {
            planksBlock = Block.field_71988_x;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        this.renderBlocks.field_83027_i = 0.125;
        this.renderBlocks.field_83024_j = 0.75;
        this.renderBlocks.field_83026_h = 0.7;
        this.renderBlocks.field_83022_l = 0.78;
        this.renderBlocks.field_83025_k = 0.22;
        Icon plankIcon = planksBlock.func_71858_a(0, planks.func_77960_j());
        tessellator.func_78380_c(this.renderBlocks.field_83026_h < 1.0 ? l : block.func_71874_e(world, x, y, z));
        tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
        this.renderBlocks.func_78605_f(block, (double)x + (double)0.08f, (double)y, (double)z, plankIcon);
        this.renderBlocks.func_78573_e(block, (double)x + (double)0.22f, (double)y, (double)z, plankIcon);
        this.renderBlocks.field_83027_i = 0.0;
        this.renderBlocks.field_83024_j = 1.0;
        this.renderBlocks.field_83026_h = 1.0;
        this.renderBlocks.field_83022_l = 1.0;
        this.renderBlocks.field_83025_k = 0.0;
        this.renderBlocks.field_83027_i = 0.125;
        this.renderBlocks.field_83024_j = 0.75;
        this.renderBlocks.field_83022_l = 0.7;
        this.renderBlocks.field_83026_h = 0.78;
        this.renderBlocks.field_83021_g = 0.22;
        this.renderBlocks.func_78622_d(block, (double)x, (double)y, (double)z + (double)0.08f, plankIcon);
        this.renderBlocks.func_78611_c(block, (double)x, (double)y, (double)z + (double)0.22f, plankIcon);
        this.renderBlocks.field_83027_i = 0.0;
        this.renderBlocks.field_83024_j = 1.0;
        this.renderBlocks.field_83022_l = 1.0;
        this.renderBlocks.field_83026_h = 1.0;
        this.renderBlocks.field_83021_g = 0.0;
        this.renderBlocks.field_83021_g = 0.2;
        this.renderBlocks.field_83026_h = 0.8;
        this.renderBlocks.field_83025_k = 0.2;
        this.renderBlocks.field_83022_l = 0.8;
        this.renderBlocks.func_78617_b(block, (double)x, (double)y - 0.25, (double)z, plankIcon);
        this.renderBlocks.field_83021_g = 0.0;
        this.renderBlocks.field_83026_h = 1.0;
        this.renderBlocks.field_83025_k = 0.0;
        this.renderBlocks.field_83022_l = 1.0;
        this.renderBlocks.func_78617_b(block, (double)x, (double)y - (double)3.0E-4f, (double)z, plankIcon);
        return false;
    }

    private boolean renderProjectBenchInWorld(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks renderer) {
        Block planksBlock;
        ItemStack planks;
        renderer.func_78570_q(block, x, y, z);
        Tessellator tessellator = Tessellator.field_78398_a;
        int l = block.func_71874_e(world, x, y, z);
        float f3 = 0.5f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 0.6f;
        float f7 = f4;
        float f8 = f4;
        float f9 = f4;
        float f10 = f3;
        float f11 = f5;
        float f12 = f6;
        float f13 = f3;
        float f14 = f5;
        float f15 = f6;
        float f16 = f3;
        float f17 = f5;
        float f18 = f6;
        TileEntityProjectBench tpb = (TileEntityProjectBench)world.func_72796_p(x, y, z);
        boolean overlay = tpb.getModifications().color() > 0;
        Icon[] icons = null;
        if (block instanceof BlockCrafting) {
            icons = ((BlockCrafting)block).icons;
        }
        if ((planks = ((TileEntityProjectBench)world.func_72796_p(x, y, z)).getModifications().getPlanks()) == null) {
            planks = new ItemStack(Block.field_71988_x.field_71990_ca, 1, 0);
        }
        if ((planksBlock = Block.field_71973_m[planks.field_77993_c]) == null) {
            planksBlock = Block.field_71988_x;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.1f);
        Icon plankIcon = planksBlock.func_71858_a(0, planks.func_77960_j());
        tessellator.func_78380_c(this.renderBlocks.field_83026_h < 1.0 ? l : block.func_71874_e(world, x + 1, y, z));
        tessellator.func_78386_a(f12, f15, f18);
        this.renderBlocks.func_78605_f(block, (double)x - 9.0E-4, (double)y, (double)z, plankIcon);
        if (overlay) {
            this.renderBlocks.func_78605_f(block, (double)x - 1.0E-4, (double)y, (double)z, icons[3]);
        }
        tessellator.func_78380_c(this.renderBlocks.field_83021_g > 0.0 ? l : block.func_71874_e(world, x - 1, y, z));
        tessellator.func_78386_a(f12, f15, f18);
        this.renderBlocks.func_78573_e(block, (double)x + 9.0E-4, (double)y, (double)z, plankIcon);
        if (overlay) {
            this.renderBlocks.func_78573_e(block, (double)x + 1.0E-4, (double)y, (double)z, icons[3]);
        }
        tessellator.func_78380_c(this.renderBlocks.field_83022_l < 1.0 ? l : block.func_71874_e(world, x, y, z + 1));
        tessellator.func_78386_a(f11, f14, f17);
        this.renderBlocks.func_78622_d(block, (double)x, (double)y, (double)z - 9.0E-4, plankIcon);
        if (overlay) {
            this.renderBlocks.func_78622_d(block, (double)x, (double)y, (double)z - 1.0E-4, icons[3]);
        }
        tessellator.func_78380_c(this.renderBlocks.field_83025_k > 0.0 ? l : block.func_71874_e(world, x, y, z - 1));
        tessellator.func_78386_a(f11, f14, f17);
        this.renderBlocks.func_78611_c(block, (double)x, (double)y, (double)z + 9.0E-4, plankIcon);
        if (overlay) {
            this.renderBlocks.func_78611_c(block, (double)x, (double)y, (double)z + 1.0E-4, icons[3]);
        }
        if (icons != null && overlay) {
            Icon wool = Block.field_72101_ab.func_71858_a(0, tpb.getModifications().color() - 1);
            tessellator.func_78380_c(this.renderBlocks.field_83024_j < 1.0 ? l : block.func_71874_e(world, x, y + 1, z));
            tessellator.func_78386_a(f7, f8, f9);
            this.renderBlocks.func_78617_b(block, (double)x, (double)y - 0.001, (double)z, wool);
            this.renderBlocks.field_83024_j = 0.2491;
            this.renderBlocks.field_83026_h = 0.7509;
            tessellator.func_78380_c(this.renderBlocks.field_83022_l < 1.0 ? l : block.func_71874_e(world, x, y, z + 1));
            tessellator.func_78386_a(f11, f14, f17);
            this.renderBlocks.func_78622_d(block, (double)x + 0.1247, (double)y + 0.7505, (double)z - 5.0E-4, wool);
            tessellator.func_78380_c(this.renderBlocks.field_83025_k > 0.0 ? l : block.func_71874_e(world, x, y, z - 1));
            tessellator.func_78386_a(f11, f14, f17);
            this.renderBlocks.func_78611_c(block, (double)x + 0.1247, (double)y + 0.7505, (double)z + 5.0E-4, wool);
            this.renderBlocks.field_83026_h = 1.0;
            this.renderBlocks.field_83022_l = 0.7509;
            tessellator.func_78380_c(this.renderBlocks.field_83026_h < 1.0 ? l : block.func_71874_e(world, x + 1, y, z));
            tessellator.func_78386_a(f12, f15, f18);
            this.renderBlocks.func_78605_f(block, (double)x - 5.0E-4, (double)y + 0.7505, (double)z + 0.1247, wool);
            tessellator.func_78380_c(this.renderBlocks.field_83021_g > 0.0 ? l : block.func_71874_e(world, x - 1, y, z));
            tessellator.func_78386_a(f12, f15, f18);
            this.renderBlocks.func_78573_e(block, (double)x + 5.0E-4, (double)y + 0.7505, (double)z + 0.1247, wool);
            this.renderBlocks.field_83024_j = 1.0;
            this.renderBlocks.field_83022_l = 1.0;
        } else {
            tessellator.func_78380_c(this.renderBlocks.field_83024_j < 1.0 ? l : block.func_71874_e(world, x, y + 1, z));
            tessellator.func_78386_a(f7, f8, f9);
            this.renderBlocks.func_78617_b(block, (double)x, (double)y - 0.001, (double)z, plankIcon);
        }
        return false;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return CraftingSuite.proxy.getRenderID();
    }
}

