/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.codechicken;

import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.helpers.ItemHelper;
import bau5.mods.craftingsuite.common.inventory.ContainerBase;
import bau5.mods.craftingsuite.common.inventory.EnumInventoryModifier;
import bau5.mods.craftingsuite.common.inventory.SlotPlan;
import bau5.mods.craftingsuite.common.tileentity.TileEntityProjectBench;
import codechicken.core.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.DefaultOverlayHandler;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class DefaultOverlayHandler
extends codechicken.nei.recipe.DefaultOverlayHandler
implements IOverlayHandler {
    int offsetx;
    int offsety;

    public DefaultOverlayHandler(int x, int y) {
        this.offsetx = x;
        this.offsety = y;
    }

    public DefaultOverlayHandler() {
        this(5, 11);
    }

    public void overlayRecipe(GuiContainer gui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        ItemStack stackResult;
        boolean flag;
        PositionedStack result = recipe.getResultStack(recipeIndex);
        boolean usedPlan = false;
        boolean bl = flag = ((ContainerBase)gui.field_74193_d).getInventoryModifier() == EnumInventoryModifier.PLAN;
        if (result != null && flag && (stackResult = result.item) != null) {
            Slot slotWithPlan = null;
            Slot planSlot = null;
            for (Slot slot : (ArrayList)gui.field_74193_d.field_75151_b) {
                ItemStack resultFromPlan;
                ItemStack stackInSlot;
                if (slot.func_75216_d() && slot.func_75211_c().field_77993_c == CraftingSuite.planItem.field_77779_bT && slot.func_75211_c().func_77960_j() == 1 && (stackInSlot = slot.func_75211_c()).func_77942_o() && ItemStack.func_77989_b((ItemStack)(resultFromPlan = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)stackInSlot.field_77990_d.func_74781_a("Result")))), (ItemStack)stackResult)) {
                    slotWithPlan = slot;
                }
                if (slot instanceof SlotPlan) {
                    planSlot = slot;
                }
                if (planSlot == null || slotWithPlan == null) continue;
                break;
            }
            if (slotWithPlan != null && planSlot != null && planSlot != slotWithPlan) {
                if (planSlot.func_75216_d()) {
                    FastTransferManager.clickSlot((GuiContainer)gui, (int)planSlot.field_75222_d, (int)0, (int)1);
                }
                FastTransferManager.clickSlot((GuiContainer)gui, (int)slotWithPlan.field_75222_d, (int)0, (int)1);
                usedPlan = true;
            }
        }
        List ingredients = recipe.getIngredientStacks(recipeIndex);
        List<DefaultOverlayHandler.DistributedIngred> ingredStacks = this.getPermutationIngredients(ingredients);
        if (!this.clearIngredients(gui, ingredients)) {
            return;
        }
        this.findInventoryQuantities(gui, ingredStacks);
        List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients = this.assignIngredients(ingredients, ingredStacks);
        if (assignedIngredients == null) {
            return;
        }
        this.assignIngredSlots(gui, ingredients, assignedIngredients);
        int quantity = this.calculateRecipeQuantity(assignedIngredients);
        if (usedPlan && quantity != 0) {
            for (DefaultOverlayHandler.IngredientDistribution distrib : assignedIngredients) {
                ItemStack pstack = distrib.permutation;
                for (Slot slot : gui.field_74193_d.field_75151_b) {
                    ItemStack slotStack;
                    if (!slot.func_75216_d() || !(slot.field_75224_c instanceof InventoryPlayer) && !(slot.field_75224_c instanceof TileEntityProjectBench) || !ItemHelper.checkItemMatch(pstack, slotStack = slot.func_75211_c())) continue;
                    FastTransferManager.clickSlot((GuiContainer)gui, (int)slot.field_75222_d, (int)0, (int)1);
                }
            }
        } else if (quantity != 0) {
            this.moveIngredients(gui, assignedIngredients, quantity);
        }
    }

    private boolean clearIngredients(GuiContainer gui, List<PositionedStack> ingreds) {
        for (PositionedStack pstack : ingreds) {
            for (Slot slot : gui.field_74193_d.field_75151_b) {
                if (slot.field_75223_e != pstack.relx + this.offsetx || slot.field_75221_f != pstack.rely + this.offsety || !slot.func_75216_d()) continue;
                FastTransferManager.clickSlot((GuiContainer)gui, (int)slot.field_75222_d, (int)0, (int)1);
                if (!slot.func_75216_d()) continue;
                return false;
            }
        }
        return true;
    }

    private void moveIngredients(GuiContainer gui, List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients, int quantity) {
        block0: for (DefaultOverlayHandler.IngredientDistribution distrib : assignedIngredients) {
            ItemStack pstack = distrib.permutation;
            int transferCap = quantity * pstack.field_77994_a;
            int transferred = 0;
            int destSlotIndex = 0;
            Slot dest = distrib.slots[0];
            int slotTransferred = 0;
            int slotTransferCap = pstack.func_77976_d();
            for (Slot slot : gui.field_74193_d.field_75151_b) {
                ItemStack stack;
                if (!slot.func_75216_d() || !(slot.field_75224_c instanceof InventoryPlayer) && !(slot.field_75224_c instanceof TileEntityProjectBench) || !InventoryUtils.canStack((ItemStack)(stack = slot.func_75211_c()), (ItemStack)pstack) || slot.field_75222_d <= 8) continue;
                FastTransferManager.clickSlot((GuiContainer)gui, (int)slot.field_75222_d);
                int amount = Math.min(transferCap - transferred, stack.field_77994_a);
                for (int c = 0; c < amount; ++c) {
                    FastTransferManager.clickSlot((GuiContainer)gui, (int)dest.field_75222_d, (int)1);
                    ++transferred;
                    if (++slotTransferred < slotTransferCap) continue;
                    if (++destSlotIndex == distrib.slots.length) {
                        dest = null;
                        break;
                    }
                    dest = distrib.slots[destSlotIndex];
                    slotTransferred = 0;
                }
                FastTransferManager.clickSlot((GuiContainer)gui, (int)slot.field_75222_d);
                if (transferred < transferCap && dest != null) continue;
                continue block0;
            }
        }
    }

    private int calculateRecipeQuantity(List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients) {
        int quantity = Integer.MAX_VALUE;
        for (DefaultOverlayHandler.IngredientDistribution distrib : assignedIngredients) {
            DefaultOverlayHandler.DistributedIngred istack = distrib.distrib;
            if (istack.numSlots == 0) {
                return 0;
            }
            int allSlots = istack.invAmount;
            if (allSlots / istack.numSlots > istack.stack.func_77976_d()) {
                allSlots = istack.numSlots * istack.stack.func_77976_d();
            }
            quantity = Math.min(quantity, allSlots / istack.distributed);
        }
        return quantity;
    }

    private Slot[][] assignIngredSlots(GuiContainer gui, List<PositionedStack> ingredients, List<DefaultOverlayHandler.IngredientDistribution> assignedIngredients) {
        Slot[][] recipeSlots = this.mapIngredSlots(gui, ingredients);
        HashMap<Slot, Integer> distribution = new HashMap<Slot, Integer>();
        for (int i = 0; i < recipeSlots.length; ++i) {
            for (Slot slot : recipeSlots[i]) {
                if (distribution.containsKey(slot)) continue;
                distribution.put(slot, -1);
            }
        }
        HashSet avaliableSlots = new HashSet(distribution.keySet());
        HashSet<Integer> remainingIngreds = new HashSet<Integer>();
        ArrayList assignedSlots = new ArrayList();
        for (int i = 0; i < ingredients.size(); ++i) {
            remainingIngreds.add(i);
            assignedSlots.add(new LinkedList());
        }
        while (avaliableSlots.size() > 0 && remainingIngreds.size() > 0) {
            Iterator iterator = remainingIngreds.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                boolean assigned = false;
                DefaultOverlayHandler.DistributedIngred istack = assignedIngredients.get((int)i).distrib;
                for (Slot slot : recipeSlots[i]) {
                    if (!avaliableSlots.contains(slot)) continue;
                    avaliableSlots.remove(slot);
                    if (slot.func_75216_d()) continue;
                    ++istack.numSlots;
                    ((LinkedList)assignedSlots.get(i)).add(slot);
                    assigned = true;
                    break;
                }
                if (assigned && istack.numSlots * istack.stack.func_77976_d() < istack.invAmount) continue;
                iterator.remove();
            }
        }
        for (int i = 0; i < ingredients.size(); ++i) {
            assignedIngredients.get((int)i).slots = ((LinkedList)assignedSlots.get(i)).toArray(new Slot[0]);
        }
        return recipeSlots;
    }

    private List<DefaultOverlayHandler.IngredientDistribution> assignIngredients(List<PositionedStack> ingredients, List<DefaultOverlayHandler.DistributedIngred> ingredStacks) {
        ArrayList<DefaultOverlayHandler.IngredientDistribution> assignedIngredients = new ArrayList<DefaultOverlayHandler.IngredientDistribution>();
        for (PositionedStack posstack : ingredients) {
            DefaultOverlayHandler.DistributedIngred biggestIngred = null;
            ItemStack permutation = null;
            int biggestSize = 0;
            block1: for (ItemStack pstack : posstack.items) {
                for (int j = 0; j < ingredStacks.size(); ++j) {
                    int relsize;
                    DefaultOverlayHandler.DistributedIngred istack = ingredStacks.get(j);
                    if (!InventoryUtils.canStack((ItemStack)pstack, (ItemStack)istack.stack) || istack.invAmount - istack.distributed < pstack.field_77994_a || (relsize = (istack.invAmount - istack.invAmount / istack.recipeAmount * istack.distributed) / pstack.field_77994_a) <= biggestSize) continue;
                    biggestSize = relsize;
                    biggestIngred = istack;
                    permutation = pstack;
                    continue block1;
                }
            }
            if (biggestIngred == null) {
                return null;
            }
            biggestIngred.distributed += permutation.field_77994_a;
            assignedIngredients.add(new DefaultOverlayHandler.IngredientDistribution(biggestIngred, permutation));
        }
        return assignedIngredients;
    }

    private void findInventoryQuantities(GuiContainer gui, List<DefaultOverlayHandler.DistributedIngred> ingredStacks) {
        for (Slot slot : gui.field_74193_d.field_75151_b) {
            ItemStack pstack;
            DefaultOverlayHandler.DistributedIngred istack;
            if (!slot.func_75216_d() || !(slot.field_75224_c instanceof InventoryPlayer) && !(slot.field_75224_c instanceof TileEntityProjectBench) || (istack = this.findIngred(ingredStacks, pstack = slot.func_75211_c())) == null) continue;
            istack.invAmount += pstack.field_77994_a;
        }
    }

    private List<DefaultOverlayHandler.DistributedIngred> getPermutationIngredients(List<PositionedStack> ingredients) {
        ArrayList<DefaultOverlayHandler.DistributedIngred> ingredStacks = new ArrayList<DefaultOverlayHandler.DistributedIngred>();
        for (PositionedStack posstack : ingredients) {
            for (ItemStack pstack : posstack.items) {
                DefaultOverlayHandler.DistributedIngred istack = this.findIngred(ingredStacks, pstack);
                if (istack == null) {
                    istack = new DefaultOverlayHandler.DistributedIngred(pstack);
                    ingredStacks.add(istack);
                }
                istack.recipeAmount += pstack.field_77994_a;
            }
        }
        return ingredStacks;
    }

    public Slot[][] mapIngredSlots(GuiContainer gui, List<PositionedStack> ingredients) {
        Slot[][] recipeSlotList = new Slot[ingredients.size()][];
        for (int i = 0; i < ingredients.size(); ++i) {
            LinkedList<Slot> recipeSlots = new LinkedList<Slot>();
            PositionedStack pstack = ingredients.get(i);
            for (Slot slot : gui.field_74193_d.field_75151_b) {
                if (slot.field_75223_e != pstack.relx + this.offsetx || slot.field_75221_f != pstack.rely + this.offsety) continue;
                recipeSlots.add(slot);
                break;
            }
            recipeSlotList[i] = recipeSlots.toArray(new Slot[0]);
        }
        return recipeSlotList;
    }

    public void clickSlot(GuiContainer window, int slotIndex, int button, int modifier) {
        super.clickSlot(window, slotIndex, button, modifier);
    }

    public DefaultOverlayHandler.DistributedIngred findIngred(List<DefaultOverlayHandler.DistributedIngred> ingredStacks, ItemStack pstack) {
        for (DefaultOverlayHandler.DistributedIngred istack : ingredStacks) {
            if (!InventoryUtils.canStack((ItemStack)pstack, (ItemStack)istack.stack)) continue;
            return istack;
        }
        return null;
    }
}

