/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common;

import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.helpers.ModificationStackHelper;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import bau5.mods.craftingsuite.common.tileentity.Modifications;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModdedTable;
import bau5.mods.craftingsuite.common.tileentity.TileEntityProjectBench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockCrafting
extends BlockContainer {
    public Icon[] icons;
    public static ArrayList<CachedUpgrade> cache = new ArrayList();

    protected BlockCrafting(int id, Material material) {
        super(id, material);
        this.func_71848_c(2.0f);
        this.func_71894_b(1.5f);
        this.func_71864_b("bau5_craftingblock");
        this.func_71849_a(CreativeTabs.field_78031_c);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        ItemStack vanillaStack = super.getPickBlock(target, world, x, y, z);
        vanillaStack = ModificationStackHelper.makeStackFromInfo(vanillaStack, world.func_72796_p(x, y, z));
        return vanillaStack;
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntity tile = world.func_72796_p(x, y, z);
        ArrayList list = super.getBlockDropped(world, x, y, z, metadata, fortune);
        for (ItemStack stack : list) {
            if (stack.field_77993_c != this.field_71990_ca) continue;
            if (tile != null) {
                stack = ModificationStackHelper.makeStackFromInfo(stack, tile);
                continue;
            }
            if (cache.size() <= 0) continue;
            int index = -1;
            for (int i = 0; i < cache.size(); ++i) {
                CachedUpgrade item = cache.get(i);
                if (item.x != x || item.y != y || item.z != z) continue;
                stack = ModificationStackHelper.makeStackFromInfo(stack, item.modList);
                index = i;
                break;
            }
            if (index == -1) continue;
            cache.remove(index);
        }
        return list;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te == null) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 1: {
                if (!player.func_70093_af() && !world.field_72995_K) {
                    player.openGui((Object)CraftingSuite.instance, 1, world, x, y, z);
                }
                return true;
            }
            case 2: {
                if (!player.func_70093_af() && !world.field_72995_K) {
                    player.openGui((Object)CraftingSuite.instance, 2, world, x, y, z);
                }
                return true;
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata) {
            case 1: {
                return new TileEntityModdedTable();
            }
            case 2: {
                return new TileEntityProjectBench();
            }
        }
        return null;
    }

    public TileEntity func_72274_a(World var1) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister registrar) {
        this.icons = new Icon[6];
        this.icons[0] = registrar.func_94245_a("craftingsuite:parts/rim");
        this.icons[1] = registrar.func_94245_a("craftingsuite:pbblock1");
        this.icons[2] = registrar.func_94245_a("craftingsuite:pbblock2");
        this.icons[3] = registrar.func_94245_a("craftingsuite:parts/overlay_sides");
        this.icons[4] = registrar.func_94245_a("craftingsuite:parts/top");
    }

    public Icon func_71858_a(int side, int meta) {
        switch (meta) {
            case 2: {
                switch (side) {
                    case 0: {
                        return this.icons[2];
                    }
                    case 1: {
                        return this.icons[4];
                    }
                }
                return this.icons[0];
            }
        }
        return Block.field_71988_x.func_71858_a(0, 0);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List list) {
        list.add(ModificationStackHelper.makeModdedTableType(2, 5, 14, 1));
        list.add(ModificationStackHelper.makeModdedTableType(2, 4, 13, 0));
        list.add(ModificationStackHelper.makeModdedTableType(2, 3, 0, 2));
        list.add(ModificationStackHelper.makeModdedTableType(2, -1, 12, 0));
        list.add(ModificationStackHelper.makeModdedTableType(1, -1, 0, 2));
        list.add(ModificationStackHelper.makeModdedTableType(1, 4, 0, 0));
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71857_b() {
        return CraftingSuite.proxy.getRenderID();
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        Random rand = new Random();
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityProjectBench) {
            cache.add(new CachedUpgrade((TileEntityProjectBench)te, x, y, z));
        }
        IInventory inv = te instanceof IInventory ? (IInventory)te : ((TileEntityModdedTable)te).getInventoryHandler();
        int size = inv.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem ei = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.field_77993_c, item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                ei.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            ei.field_70159_w = rand.nextGaussian() * (double)factor;
            ei.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            ei.field_70179_y = rand.nextGaussian() * (double)factor;
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)ei);
            }
            item.field_77994_a = 0;
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase el, ItemStack stack) {
        TileEntity te;
        super.func_71860_a(world, x, y, z, el, stack);
        byte dir = 0;
        int plyrFacing = MathHelper.func_76128_c((double)((double)(el.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (plyrFacing == 0) {
            dir = 2;
        }
        if (plyrFacing == 1) {
            dir = 5;
        }
        if (plyrFacing == 2) {
            dir = 3;
        }
        if (plyrFacing == 3) {
            dir = 4;
        }
        if ((te = world.func_72796_p(x, y, z)) != null && te instanceof IModifiedTileEntityProvider) {
            ((IModifiedTileEntityProvider)te).setDirectionFacing(dir);
            world.func_72845_h(x, y, z);
        }
    }

    public class CachedUpgrade {
        public final int x;
        public final int y;
        public final int z;
        public final Modifications modList;

        public CachedUpgrade(TileEntityProjectBench tile, int x1, int y1, int z1) {
            this.modList = tile.getModifications();
            this.x = x1;
            this.y = y1;
            this.z = z1;
        }
    }
}

