/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.handlers;

import bau5.mods.craftingsuite.common.handlers.IModifierHandler;
import bau5.mods.craftingsuite.common.helpers.ItemHelper;
import bau5.mods.craftingsuite.common.inventory.ContainerBase;
import bau5.mods.craftingsuite.common.inventory.LocalInventoryCrafting;
import bau5.mods.craftingsuite.common.inventory.SlotPlan;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PlanHandler
implements IModifierHandler {
    private SlotPlan planSlot;
    public ContainerBase container;

    public PlanHandler(ContainerBase cont, SlotPlan slot) {
        this.container = cont;
        this.planSlot = slot;
    }

    @Override
    public ItemStack handleSlotClick(int slot, int clickType, int clickMeta, EntityPlayer player) {
        ItemStack planResult;
        if (clickMeta == 6) {
            clickMeta = 0;
        }
        if (slot == 0 && this.planSlot.func_75216_d() && this.planSlot.func_75211_c().field_77990_d != null && ItemStack.func_77989_b((ItemStack)(planResult = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)this.planSlot.func_75211_c().field_77990_d.func_74781_a("Result")))), (ItemStack)this.container.getTileEntity().getInventoryHandler().result)) {
            LocalInventoryCrafting fromPlan = new LocalInventoryCrafting();
            LocalInventoryCrafting copy = this.container.getTileEntity().getInventoryHandler().getCraftingMatrix().copyInventory();
            NBTTagList list = this.planSlot.func_75211_c().field_77990_d.func_74761_m("Components");
            if (list != null) {
                for (int i = 0; i < fromPlan.func_70302_i_(); ++i) {
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)list.func_74743_b(i)));
                    fromPlan.func_70299_a(i, stack);
                }
            }
            InventoryBasic basic = new InventoryBasic("asdf", true, 18);
            for (int i = 0; i < basic.func_70302_i_(); ++i) {
                ItemStack stack = this.container.getTileEntity().getInventoryHandler().func_70301_a(i + 9);
                if (stack != null) {
                    stack = stack.func_77946_l();
                }
                basic.func_70299_a(i, stack);
            }
            boolean flag = false;
            for (int matrixIndex = 0; matrixIndex < 9; ++matrixIndex) {
                flag = false;
                ItemStack component = fromPlan.func_70301_a(matrixIndex);
                if (component == null) continue;
                for (int supplyIndex = 0; supplyIndex < 18; ++supplyIndex) {
                    ItemStack supplyStack = basic.func_70301_a(supplyIndex);
                    if (supplyStack == null || !OreDictionary.itemMatches((ItemStack)component, (ItemStack)supplyStack, (boolean)false) && (component.func_77960_j() != Short.MAX_VALUE || !ItemHelper.checkOreDictMatch(component, supplyStack))) continue;
                    --supplyStack.field_77994_a;
                    if (supplyStack.field_77994_a == 0) {
                        basic.func_70299_a(supplyIndex, null);
                    }
                    flag = true;
                    break;
                }
                if (flag) continue;
                return null;
            }
            this.container.getTileEntity().getInventoryHandler().setCraftingMatrix(fromPlan);
            ItemStack handledStack = this.container.slotClick_plain(slot, clickType, clickMeta, player);
            this.container.getTileEntity().getInventoryHandler().setCraftingMatrix(copy);
            for (int i = 0; i < copy.func_70302_i_(); ++i) {
                this.container.getTileEntity().getInventoryHandler().func_70299_a(i, copy.func_70301_a(i));
            }
            return handledStack;
        }
        ItemStack handledStack = this.container.slotClick_plain(slot, clickType, clickMeta, player);
        if (slot > -1 && slot <= this.container.field_75151_b.size() && (this.container.getTileEntity().getInventoryHandler().affectsCrafting(slot) || this.container.func_75139_a((int)slot).field_75222_d == this.planSlot.field_75222_d)) {
            this.container.getTileEntity().getInventoryHandler().markForUpdate();
        }
        return handledStack;
    }

    @Override
    public ItemStack handleTransferClick(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack stack;
        Slot slot = this.container.func_75139_a(par2);
        if (slot.func_75216_d() && slot.field_75222_d != this.planSlot.field_75222_d && this.planSlot.func_75214_a(stack = slot.func_75211_c())) {
            ItemStack planStack = stack.func_77946_l();
            if (!this.container.invokeMerge(planStack, this.planSlot.field_75222_d, this.planSlot.field_75222_d + 1, false)) {
                return null;
            }
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)planStack)) {
                slot.func_75215_d(null);
            }
            this.container.getTileEntity().getInventoryHandler().markForUpdate();
            return stack;
        }
        return this.container.transferStackInSlot_plain(par1EntityPlayer, par2);
    }

    @Override
    public boolean handleCraftingPiece(ItemStack neededStack, boolean metaSens) {
        return false;
    }

    public void writePlanToStack() {
        IModifiedTileEntityProvider tile = this.container.modifiedTile;
        if (tile.getInventoryHandler().getResult() != null) {
            int i;
            NBTTagCompound stackTag = new NBTTagCompound("tag");
            NBTTagList list = new NBTTagList();
            LocalInventoryCrafting matrix = tile.getInventoryHandler().getCraftingMatrix();
            boolean oreRecFlag = false;
            ItemStack result = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)matrix, ((TileEntity)tile).field_70331_k);
            IRecipe recipe = this.findMatchingRecipe(matrix, ((TileEntity)tile).field_70331_k);
            ArrayList<Integer> exclusions = new ArrayList<Integer>();
            if (recipe != null && result != null && recipe instanceof ShapedOreRecipe || recipe instanceof ShapelessOreRecipe) {
                oreRecFlag = true;
                for (i = 0; i < matrix.func_70302_i_(); ++i) {
                    int id = OreDictionary.getOreID((ItemStack)matrix.func_70301_a(i));
                    if (id == -1) continue;
                    LocalInventoryCrafting copy = matrix.copyInventory();
                    ItemStack oreCopy = ((ItemStack)OreDictionary.getOres((Integer)id).get(0)).func_77946_l();
                    oreCopy.func_77964_b(Short.MAX_VALUE);
                    copy.func_70299_a(i, oreCopy);
                    if (ItemStack.func_77989_b((ItemStack)result, (ItemStack)CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)copy, ((TileEntity)tile).field_70331_k))) continue;
                    exclusions.add(id);
                }
            }
            for (i = 0; i < matrix.func_70302_i_(); ++i) {
                NBTTagCompound tag = new NBTTagCompound();
                ItemStack stack = matrix.func_70301_a(i);
                if (stack != null) {
                    int id;
                    stack = stack.func_77946_l();
                    if (oreRecFlag && (id = OreDictionary.getOreID((ItemStack)stack)) != -1 && !exclusions.contains(id)) {
                        stack = ((ItemStack)OreDictionary.getOres((Integer)id).get(0)).func_77946_l();
                        stack.func_77964_b(Short.MAX_VALUE);
                    }
                    stack.field_77994_a = 1;
                    tag = stack.func_77955_b(tag);
                }
                list.func_74742_a((NBTBase)tag);
            }
            stackTag.func_74782_a("Components", (NBTBase)list);
            stackTag.func_74782_a("Result", (NBTBase)tile.getInventoryHandler().getResult().func_77955_b(new NBTTagCompound()));
            this.planSlot.func_75211_c().func_77982_d(stackTag);
            this.planSlot.func_75211_c().func_77964_b(1);
        }
    }

    @Override
    public boolean handlesSlotClicks() {
        return true;
    }

    @Override
    public boolean handlesTransfers() {
        return true;
    }

    @Override
    public boolean handlesCrafting() {
        return false;
    }

    public boolean validPlanInSlot() {
        ItemStack plan = this.planSlot.func_75211_c();
        return plan != null && plan.field_77990_d != null && plan.field_77990_d.func_74764_b("Components");
    }

    public boolean blankPlanInSlot() {
        ItemStack plan = this.planSlot.func_75211_c();
        return plan != null && plan.field_77990_d == null && plan.field_77994_a == 1;
    }

    public ItemStack[] getPlanStacks() {
        if (!this.planSlot.func_75216_d()) {
            return null;
        }
        ItemStack[] stacks = new ItemStack[9];
        NBTTagList list = this.planSlot.func_75211_c().field_77990_d.func_74761_m("Components");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack;
            stacks[i] = stack = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)list.func_74743_b(i)));
        }
        return stacks;
    }

    public IRecipe findMatchingRecipe(InventoryCrafting par1InventoryCrafting, World par2World) {
        int j;
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        int i = 0;
        ItemStack itemstack = null;
        ItemStack itemstack1 = null;
        for (j = 0; j < par1InventoryCrafting.func_70302_i_(); ++j) {
            ItemStack itemstack2 = par1InventoryCrafting.func_70301_a(j);
            if (itemstack2 == null) continue;
            if (i == 0) {
                itemstack = itemstack2;
            }
            if (i == 1) {
                itemstack1 = itemstack2;
            }
            ++i;
        }
        if (i == 2 && itemstack.field_77993_c == itemstack1.field_77993_c && itemstack.field_77994_a == 1 && itemstack1.field_77994_a == 1 && Item.field_77698_e[itemstack.field_77993_c].isRepairable()) {
            Item item = Item.field_77698_e[itemstack.field_77993_c];
            int k = item.func_77612_l() - itemstack.func_77952_i();
            int l = item.func_77612_l() - itemstack1.func_77952_i();
            int i1 = k + l + item.func_77612_l() * 5 / 100;
            int j1 = item.func_77612_l() - i1;
            if (j1 < 0) {
                j1 = 0;
            }
            return null;
        }
        for (j = 0; j < recipes.size(); ++j) {
            IRecipe irecipe = (IRecipe)recipes.get(j);
            if (!irecipe.func_77569_a(par1InventoryCrafting, par2World)) continue;
            return irecipe;
        }
        return null;
    }

    @Override
    public void shiftClickedCraftingSlot() {
    }

    @Override
    public boolean handlesThisTransfer(int numSlot, ItemStack stack) {
        if (numSlot == this.planSlot.field_75222_d) {
            return true;
        }
        return this.planSlot.func_75214_a(stack) && !this.planSlot.func_75216_d();
    }
}

