/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.helpers;

import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.helpers.ModificationNBTHelper;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import bau5.mods.craftingsuite.common.tileentity.Modifications;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class ModificationStackHelper {
    public static ItemStack makeBasicMkICrafter() {
        ItemStack theStack = new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 1);
        NBTTagCompound baseTag = ModificationNBTHelper.makeBaseTag();
        byte[] bytes = ModificationNBTHelper.getUpgradeByteArray(baseTag);
        bytes[0] = 1;
        bytes[4] = 1;
        theStack = ModificationStackHelper.makeStackFromInfo(theStack, bytes, new ItemStack(Block.field_71988_x.field_71990_ca, 1, 0));
        return theStack;
    }

    public static ItemStack makeBasicProjectBench() {
        ItemStack stack = new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 2);
        byte[] bytes = ModificationNBTHelper.newBytes();
        bytes[0] = 2;
        bytes[1] = 5;
        bytes[3] = 14;
        bytes[4] = 1;
        stack = ModificationStackHelper.makeStackFromInfo(stack, bytes, new ItemStack(Block.field_71988_x.field_71990_ca, 1, 1));
        return stack;
    }

    public static ItemStack makeModdedTableType(int type, int upgrade, int color, int woodDamage) {
        ItemStack stack = new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, type);
        byte[] bytes = ModificationNBTHelper.newBytes();
        bytes[0] = (byte)type;
        bytes[1] = (byte)upgrade;
        if (type == 2) {
            bytes[3] = (byte)(color + 1);
        }
        bytes[4] = 1;
        stack = ModificationStackHelper.makeStackFromInfo(stack, bytes, new ItemStack(Block.field_71988_x.field_71990_ca, 1, woodDamage));
        return stack;
    }

    public static ItemStack makeStackFromInfo(ItemStack vanillaStack, TileEntity tile) {
        byte[] bytes = null;
        Object stack = null;
        if (tile instanceof IModifiedTileEntityProvider) {
            bytes = ModificationNBTHelper.newBytes();
            Modifications mod = ((IModifiedTileEntityProvider)tile).getModifications();
            return ModificationStackHelper.makeStackFromInfo(vanillaStack, mod);
        }
        bytes = ModificationNBTHelper.newBytes();
        vanillaStack = ModificationStackHelper.makeStackFromInfo(vanillaStack, bytes, stack);
        return vanillaStack;
    }

    public static ItemStack makeStackFromInfo(ItemStack stack, Object ... data) {
        NBTTagCompound newTag = null;
        byte[] upgrades = null;
        ItemStack planks = null;
        if (data[0] instanceof Modifications) {
            upgrades = ModificationNBTHelper.newBytes();
            Modifications mod = (Modifications)data[0];
            upgrades[0] = (byte)mod.type();
            upgrades[1] = (byte)mod.upgrades();
            upgrades[3] = (byte)mod.color();
            upgrades[4] = (byte)mod.visual();
            newTag = ModificationNBTHelper.makeBaseTag();
            planks = mod.getPlanks();
            ModificationNBTHelper.setTagUpgradeBytes(newTag, upgrades);
            ModificationNBTHelper.setTagPlanksUsed(newTag, planks);
        } else if (data[0] instanceof byte[]) {
            upgrades = (byte[])data[0];
            if (data[1] instanceof ItemStack) {
                planks = (ItemStack)data[1];
            }
            if (planks == null) {
                planks = new ItemStack(Block.field_71988_x.field_71990_ca, 1, 0);
            }
            newTag = ModificationNBTHelper.makeBaseTag();
            ModificationNBTHelper.setTagUpgradeBytes(newTag, upgrades);
            ModificationNBTHelper.setTagPlanksUsed(newTag, planks);
        } else if (data[0] instanceof NBTTagCompound) {
            newTag = (NBTTagCompound)data[0];
            NBTTagCompound baseTag = new NBTTagCompound("tag");
            baseTag.func_74782_a("Modifiers", (NBTBase)newTag);
            newTag = (NBTTagCompound)baseTag.func_74737_b();
        }
        stack.field_77990_d = newTag;
        return stack;
    }

    public static ItemStack makeItemStack(ItemStack result, ItemStack[] input) {
        ItemStack stack = new ItemStack(result.field_77993_c, result.field_77994_a, result.func_77960_j());
        NBTTagCompound baseTag = ModificationNBTHelper.makeBaseTag();
        byte[] bytes = ModificationNBTHelper.getUpgradeByteArray(baseTag);
        for (ItemStack stackUsed : input) {
            if (stackUsed.field_77993_c == CraftingSuite.modItems.field_77779_bT) {
                if (stackUsed.func_77960_j() == 1) {
                    bytes[0] = 1;
                }
                if (stackUsed.func_77960_j() != 2) continue;
                bytes[0] = 2;
                continue;
            }
            if (OreDictionary.getOreID((ItemStack)stackUsed) == 1) {
                ItemStack temp = stackUsed.func_77946_l();
                temp.field_77994_a = 1;
                ModificationNBTHelper.setTagPlanksUsed(baseTag, temp);
                continue;
            }
            if (stackUsed.field_77993_c == Block.field_111031_cC.field_71990_ca) {
                bytes[3] = (byte)stackUsed.func_77960_j();
                continue;
            }
            if (stackUsed.field_77993_c != Block.field_72041_aW.field_71990_ca) continue;
            bytes[4] = 1;
        }
        stack.field_77990_d = baseTag;
        return stack;
    }

    public static ArrayList<ItemStack> getPartsForBench(ItemStack result) {
        ArrayList<ItemStack> parts = new ArrayList<ItemStack>();
        if (result.field_77993_c != CraftingSuite.craftingTableBlock.field_71990_ca || result.field_77990_d == null) {
            return parts;
        }
        byte[] bytes = ModificationNBTHelper.getUpgradeByteArray(result.field_77990_d);
        if (bytes[0] != -1) {
            ItemStack planks = ItemStack.func_77949_a((NBTTagCompound)ModificationNBTHelper.getPlanksUsed(result.field_77990_d));
            if (bytes[1] != -1) {
                parts.add(ModificationStackHelper.makeModdedTableType(bytes[0], -1, bytes[3], planks.func_77960_j()));
                parts.add(new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, (int)bytes[1]));
                return parts;
            }
            if (bytes[0] == 1) {
                parts.add(new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 1));
                planks.field_77994_a = 2;
                parts.add(planks);
            } else if (bytes[0] == 2) {
                parts.add(new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 2));
                planks.field_77994_a = 4;
                parts.add(planks);
            }
            if (bytes[3] != -1) {
                parts.add(new ItemStack(Block.field_111031_cC.field_71990_ca, 1, (int)bytes[3]));
            }
            if (bytes[4] != -1) {
                parts.add(new ItemStack(Block.field_72041_aW));
            }
        }
        return parts;
    }

    public static Modifications convertToModInfo(ItemStack stack2) {
        Modifications mods = new Modifications();
        return mods.convert(stack2);
    }
}

