/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.inventory;

import bau5.mods.craftingsuite.common.handlers.DeepSlotHandler;
import bau5.mods.craftingsuite.common.handlers.DefaultHandler;
import bau5.mods.craftingsuite.common.handlers.PlanHandler;
import bau5.mods.craftingsuite.common.handlers.ToolsHandler;
import bau5.mods.craftingsuite.common.inventory.ContainerBase;
import bau5.mods.craftingsuite.common.inventory.EnumInventoryModifier;
import bau5.mods.craftingsuite.common.inventory.SlotDeep;
import bau5.mods.craftingsuite.common.inventory.SlotPlan;
import bau5.mods.craftingsuite.common.inventory.SlotTool;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModdedTable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ContainerModdedCraftingTable
extends ContainerBase {
    private TileEntityModdedTable tileEntity;

    public ContainerModdedCraftingTable(TileEntityModdedTable te, EntityPlayer player) {
        super(te);
        this.tileEntity = te;
        this.handleInventoryModifiers();
        this.buildContainerFromTile(player);
        this.tileEntity.getInventoryHandler().findRecipe(true);
    }

    private void buildContainerFromTile(EntityPlayer player) {
        if (this.tileEntity.getModifications().type() == 1) {
            this.buildBasicCraftingInventory(player.field_71071_by, this.tileEntity.getInventoryHandler(), this.tileEntity.getInventoryHandler().resultMatrix());
        }
    }

    @Override
    public ItemStack func_75144_a(int slot, int clickType, int clickMeta, EntityPlayer player) {
        if (slot == 0 && clickMeta == 6) {
            clickMeta = 0;
        }
        ItemStack stack = super.func_75144_a(slot, clickType, clickMeta, player);
        if (slot == 0) {
            this.tileEntity.getInventoryHandler().findRecipe(false);
        }
        return stack;
    }

    @Override
    protected int[] getXYZ() {
        return new int[]{this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n};
    }

    @Override
    public EnumInventoryModifier getInventoryModifier() {
        return this.tileEntity.getInventoryModifier();
    }

    @Override
    public int getSizeInventoryOfTile() {
        return this.tileEntity.getModifiedInventorySize();
    }

    @Override
    protected void handleInventoryModifiers() {
        switch (this.getInventoryModifier()) {
            case NONE: {
                this.handler = new DefaultHandler();
                break;
            }
            case TOOLS: {
                SlotTool[] toolSlots = new SlotTool[3];
                for (int i = 0; i < 3; ++i) {
                    toolSlots[i] = new SlotTool(this.tileEntity.getInventoryHandler(), this.tileEntity.getToolModifierInvIndex() + i, -17, 17 + (16 * i + i * 2));
                    this.func_75146_a(toolSlots[i]);
                }
                this.handler = new ToolsHandler(this, toolSlots);
                break;
            }
            case DEEP: {
                SlotDeep slot = new SlotDeep(this.tileEntity.getInventoryHandler(), 9, -17, 34);
                this.func_75146_a(slot);
                this.handler = new DeepSlotHandler(this, slot);
                break;
            }
            case PLAN: {
                SlotPlan planSlot = new SlotPlan(this.tileEntity.getInventoryHandler(), 9, 10, 34);
                this.func_75146_a(planSlot);
                this.handler = new PlanHandler(this, planSlot);
            }
        }
    }

    @Override
    public IModifiedTileEntityProvider getTileEntity() {
        return this.tileEntity;
    }
}

