/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.recipe;

import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.recipe.IModRecipe;
import bau5.mods.craftingsuite.common.recipe.ModificationRecipeBasic;
import bau5.mods.craftingsuite.common.recipe.ModificationRecipeUpgrade;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModificationTable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class ModificationCrafter {
    private static final ModificationCrafter instance = new ModificationCrafter();
    private ArrayList<IModRecipe> recipeList = new ArrayList();

    private ModificationCrafter() {
        this.initRecipes();
    }

    public IModRecipe findRecipe(TileEntityModificationTable table, ItemStack[] input) {
        if ((input = this.filterNulls(input)) == null || input.length == 0) {
            return null;
        }
        IModRecipe recipe = null;
        for (IModRecipe rec : this.recipeList) {
            ItemStack[] usedInput = rec.doesRecipeMatch(input);
            table.inputForResult = usedInput;
            if (usedInput == null) continue;
            recipe = rec;
            break;
        }
        return recipe;
    }

    public ItemStack[] filterNulls(ItemStack[] input) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : input) {
            if (stack == null) continue;
            stacks.add(stack);
        }
        ItemStack[] array = new ItemStack[stacks.size()];
        int i = 0;
        for (ItemStack stack : stacks) {
            array[i++] = stack;
        }
        return array;
    }

    public void initRecipes() {
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 1), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 1), new ItemStack(Block.field_71988_x.field_71990_ca, 2, Short.MAX_VALUE)}));
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 1), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 1), new ItemStack(Block.field_71988_x.field_71990_ca, 2, Short.MAX_VALUE), new ItemStack(Block.field_72041_aW.field_71990_ca, 1, 0)}));
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 1), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 1), new ItemStack(Block.field_71988_x.field_71990_ca, 2, Short.MAX_VALUE), new ItemStack(Block.field_111031_cC.field_71990_ca, 1, Short.MAX_VALUE)}));
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 1), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 1), new ItemStack(Block.field_71988_x.field_71990_ca, 2, Short.MAX_VALUE), new ItemStack(Block.field_72041_aW.field_71990_ca, 1, 0), new ItemStack(Block.field_111031_cC.field_71990_ca, 1, Short.MAX_VALUE)}));
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 2), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 2), new ItemStack(Block.field_71988_x.field_71990_ca, 4, Short.MAX_VALUE)}));
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 2), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 2), new ItemStack(Block.field_71988_x.field_71990_ca, 4, Short.MAX_VALUE), new ItemStack(Block.field_72041_aW.field_71990_ca, 1, 0)}));
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 2), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 2), new ItemStack(Block.field_71988_x.field_71990_ca, 4, Short.MAX_VALUE), new ItemStack(Block.field_111031_cC.field_71990_ca, 1, Short.MAX_VALUE)}));
        this.addRecipe(new ModificationRecipeBasic(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 2), new ItemStack[]{new ItemStack(CraftingSuite.modItems, 1, 2), new ItemStack(Block.field_71988_x.field_71990_ca, 4, Short.MAX_VALUE), new ItemStack(Block.field_111031_cC.field_71990_ca, 1, Short.MAX_VALUE), new ItemStack(Block.field_72041_aW.field_71990_ca, 1, 0)}));
        this.addRecipe(new ModificationRecipeUpgrade(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 2), new ItemStack[]{new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 3), new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 4), new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 5), new ItemStack(Block.field_111031_cC.field_71990_ca, 1, Short.MAX_VALUE), new ItemStack(Block.field_72041_aW.field_71990_ca, 1, 0)}));
        this.addRecipe(new ModificationRecipeUpgrade(new ItemStack(CraftingSuite.craftingTableBlock.field_71990_ca, 1, 1), new ItemStack[]{new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 3), new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 4), new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 5), new ItemStack(Block.field_72041_aW.field_71990_ca, 1, 0)}));
    }

    public void addRecipe(IModRecipe rec) {
        this.recipeList.add(rec);
    }

    public ArrayList getRecipeList() {
        return this.recipeList;
    }

    public static ModificationCrafter instance() {
        return instance;
    }
}

