/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.tileentity;

import bau5.mods.craftingsuite.client.ParticleRenderer;
import bau5.mods.craftingsuite.common.CSLogger;
import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.helpers.ItemHelper;
import bau5.mods.craftingsuite.common.inventory.EnumInventoryModifier;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import bau5.mods.craftingsuite.common.tileentity.Modifications;
import bau5.mods.craftingsuite.common.tileentity.TileEntityBase;
import bau5.mods.craftingsuite.common.tileentity.TileNetHandler;
import bau5.mods.craftingsuite.common.tileentity.parthandlers.ContainerHandler;
import bau5.mods.craftingsuite.common.tileentity.parthandlers.InventoryHandler;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileEntityProjectBench
extends TileEntityBase
implements IModifiedTileEntityProvider,
IInventory,
ISidedInventory {
    public TileNetHandler netHandler;
    public InventoryHandler inventoryHandler;
    public ContainerHandler containerHandler;
    public Random random = new Random();
    public boolean cmas = CraftingSuite.cmas;
    public ItemStack[] inv = null;
    public ItemStack result;
    public ItemStack[] tools = new ItemStack[3];
    protected ItemStack planksUsed = null;
    public int selectedToolIndex = -1;
    public int toolIndexInCrafting = -1;
    private ItemStack lastResult = null;
    public IInventory craftingResult = new InventoryCraftResult();
    public LocalInventoryCrafting craftingMatrix = new LocalInventoryCrafting(this);
    public boolean containerInit = false;
    public boolean containerWorking = false;
    private boolean shouldUpdateOutput;
    private int update = 0;
    private long ticker = 0L;
    private byte directionFacing = 0;
    public float randomShift = 0.0f;
    private HashMap<EnumInventoryModifier, int[]> inventoryMap = new HashMap();
    private LocalInventoryCrafting lastCraftMatrix = new LocalInventoryCrafting();
    public boolean updateMeta = false;

    public TileEntityProjectBench() {
        this.netHandler = new TileNetHandler(this);
        this.containerHandler = new ContainerHandler();
        this.inventoryHandler = new InventoryHandler(this);
    }

    @Override
    public void initializeFromNBT(NBTTagCompound nbtTagCompound) {
        Modifications mods;
        if (nbtTagCompound.func_74764_b("Modifiers") || nbtTagCompound.func_74740_e().equals("Modifiers")) {
            NBTTagCompound tag = (NBTTagCompound)nbtTagCompound.func_74781_a("Modifiers");
            byte[] bytes = tag.func_74770_j("UpgradeArray");
            mods = new Modifications(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("PlanksUsed")), bytes);
        } else {
            byte[] bytes = nbtTagCompound.func_74770_j("UpgradeArray");
            mods = new Modifications(ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound.func_74775_l("Planks")), bytes);
        }
        this.initializeFromMods(mods);
    }

    @Override
    public void initializeFromMods(Modifications mods) {
        this.planksUsed = mods.getPlanks().func_77946_l();
        this.modifications = mods;
    }

    private void setResult(ItemStack recipe) {
        this.result = recipe;
        this.craftingResult.func_70299_a(0, this.result);
    }

    @Override
    public void handleModifiers() {
        this.inv = new ItemStack[this.getModifiedInventorySize()];
        this.inventoryHandler.initInventory();
        this.inventoryHandler.inv = this.inv;
        if (this.getInventoryModifier() == EnumInventoryModifier.PLAN) {
            this.inventoryHandler.planIndex = 27;
        }
        this.buildInventoryMap();
    }

    @Override
    public EnumInventoryModifier getInventoryModifier() {
        switch (this.modifications.upgrades()) {
            case 3: {
                return EnumInventoryModifier.TOOLS;
            }
            case 4: {
                return EnumInventoryModifier.DEEP;
            }
            case 5: {
                return EnumInventoryModifier.PLAN;
            }
        }
        return EnumInventoryModifier.NONE;
    }

    private void buildInventoryMap() {
        this.inventoryMap = new HashMap();
        int[] indicies = new int[]{0, 27};
        this.inventoryMap.put(EnumInventoryModifier.NONE, indicies);
        switch (this.getInventoryModifier()) {
            case TOOLS: {
                indicies = new int[]{27, 30};
                this.inventoryMap.put(EnumInventoryModifier.TOOLS, indicies);
                break;
            }
            case DEEP: {
                indicies[1] = 27;
                indicies[0] = 27;
                this.inventoryMap.put(EnumInventoryModifier.DEEP, indicies);
                break;
            }
            case PLAN: {
                indicies[0] = 27;
                indicies[1] = 27;
                this.inventoryMap.put(EnumInventoryModifier.PLAN, indicies);
                break;
            }
        }
    }

    @Override
    public int getToolModifierInvIndex() {
        if (this.getInventoryModifier() == EnumInventoryModifier.TOOLS) {
            if (this.inventoryMap == null || !this.inventoryMap.containsKey((Object)EnumInventoryModifier.TOOLS)) {
                this.buildInventoryMap();
                return 27;
            }
            return this.inventoryMap.get((Object)EnumInventoryModifier.TOOLS)[0];
        }
        return -1;
    }

    @Override
    public ItemStack getSelectedTool() {
        if (this.getInventoryModifier() != EnumInventoryModifier.TOOLS) {
            return null;
        }
        return this.inv[this.inventoryHandler.selectedToolIndex + this.getToolModifierInvIndex()];
    }

    @Override
    public int getSelectedToolIndex() {
        return this.inventoryHandler.selectedToolIndex;
    }

    @Override
    public int getModifiedInventorySize() {
        return this.getBaseInventorySize() + this.getInventoryModifier().getNumSlots();
    }

    @Override
    public int getBaseInventorySize() {
        return 27;
    }

    public ItemStack getPlanksUsed() {
        return this.modifications.getPlanks();
    }

    public LocalInventoryCrafting getCopyOfMatrix(LocalInventoryCrafting matrix) {
        LocalInventoryCrafting temp = new LocalInventoryCrafting(this);
        for (int i = 0; i < temp.func_70302_i_(); ++i) {
            temp.func_70299_a(i, matrix.func_70301_a(i) != null ? matrix.func_70301_a(i).func_77946_l() : null);
        }
        return temp;
    }

    public void func_70296_d() {
        this.inventoryHandler.func_70296_d();
        super.func_70296_d();
    }

    public void func_70316_g() {
        ++this.ticker;
        if ((this.shouldUpdateOutput || this.inventoryHandler.shouldUpdate) && !this.containerInit && !this.containerWorking) {
            this.inventoryHandler.findRecipe(false);
            this.shouldUpdateOutput = false;
            this.inventoryHandler.shouldUpdate = false;
        }
        if (this.sendRenderPacket && !this.field_70331_k.field_72995_K) {
            this.netHandler.postRenderPacket(0);
            this.sendRenderPacket = false;
        }
        this.netHandler.tick();
        if (this.update <= 5 && this.update != -1) {
            ++this.update;
        }
        if (this.update >= 5 && this.field_70331_k.field_72995_K) {
            FMLClientHandler.instance().getClient().field_71438_f.func_72711_b(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.update = -1;
        }
        if (this.cmas && this.field_70331_k.field_72995_K && this.ticker % 3L > 0L) {
            ParticleRenderer.doParticle(0, this.field_70331_k, (double)this.field_70329_l + this.random.nextDouble(), this.field_70330_m + 2, (double)this.field_70327_n + this.random.nextDouble());
        }
        if (this.ticker > 20000L) {
            this.ticker = 0L;
        }
        super.func_70316_g();
    }

    private void makeNewMatrix() {
        for (int i = 0; i < 9; ++i) {
            this.lastCraftMatrix.func_70299_a(i, this.inv[i]);
        }
    }

    private boolean checkDifferences() {
        for (int i = 0; i < 9; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.lastCraftMatrix.func_70301_a(i), (ItemStack)this.inv[i])) continue;
            return true;
        }
        return false;
    }

    public void markForUpdate() {
        this.shouldUpdateOutput = true;
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        super.onDataPacket(net, pkt);
        this.netHandler.onDataPacket(pkt);
        this.inventoryHandler.inv = this.inv;
        if (pkt.field_73331_e.func_74764_b("id") && this.field_70331_k != null && this.inv != null) {
            this.inventoryHandler.findRecipe(true);
        }
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                } else {
                    this.func_70296_d();
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        int[] i;
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a >= this.func_70297_j_() && this.getInventoryModifier() == EnumInventoryModifier.DEEP && (i = this.inventoryHandler.inventoryMap.get("Deep"))[0] != slot && stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (slot >= 27 && this.getInventoryModifier() == EnumInventoryModifier.TOOLS && !this.field_70331_k.field_72995_K) {
            this.sendRenderPacket = true;
            if (slot == 27) {
                this.tools[0] = this.inv[slot];
            }
            if (slot == 28) {
                this.tools[1] = this.inv[slot];
            }
            if (slot == 29) {
                this.tools[2] = this.inv[slot];
            }
            this.inventoryHandler.tools = this.tools;
        }
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        try {
            this.initializeFromNBT(tagCompound);
            this.handleModifiers();
            if (this.inv != null) {
                NBTTagList tagList = tagCompound.func_74761_m("Inventory");
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
                    byte slot = tag.func_74771_c("Slot");
                    if (slot < 0 || slot >= this.inv.length) continue;
                    if (!tag.func_74764_b("Large")) {
                        if (slot >= 0 && slot < this.inv.length) {
                            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
                        }
                    } else if (slot >= 0 && slot < this.inv.length) {
                        this.inv[slot] = ItemHelper.loadLargeItemStack(tag);
                    }
                    if (slot < 27) continue;
                    if (slot == 27) {
                        this.tools[0] = this.inv[slot];
                    }
                    if (slot == 28) {
                        this.tools[1] = this.inv[slot];
                    }
                    if (slot == 29) {
                        this.tools[2] = this.inv[slot];
                    }
                    if (this.inventoryHandler == null) continue;
                    this.inventoryHandler.tools = this.tools;
                }
            }
            if (this.getInventoryModifier() == EnumInventoryModifier.TOOLS) {
                this.setSelectedToolIndex(tagCompound.func_74771_c("selectedToolIndex"));
            }
            this.directionFacing = tagCompound.func_74771_c("direction");
        }
        catch (Exception ex) {
            String coords = "" + this.field_70329_l + " " + this.field_70330_m + " " + this.field_70327_n;
            CSLogger.logError("Failed loading a crafting table at " + coords, ex);
        }
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        if (this.inv != null) {
            for (int i = 0; i < this.inv.length; ++i) {
                ItemStack stack = this.inv[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                if (stack.field_77994_a > 64) {
                    tag.func_74774_a("Large", (byte)1);
                    ItemHelper.writeLargeStackToTag(stack, tag);
                } else {
                    stack.func_77955_b(tag);
                }
                itemList.func_74742_a((NBTBase)tag);
            }
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74774_a("direction", this.directionFacing);
        tagCompound.func_74782_a("Planks", (NBTBase)this.planksUsed.func_77955_b(new NBTTagCompound()));
        tagCompound.func_74773_a("UpgradeArray", this.modifications.buildUpgradeArray());
        if (this.getInventoryModifier() == EnumInventoryModifier.TOOLS) {
            tagCompound.func_74774_a("selectedToolIndex", (byte)this.selectedToolIndex);
        }
    }

    public String func_70303_b() {
        return "Project Bench";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && player.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
        if (!this.field_70331_k.field_72995_K) {
            this.netHandler.postRenderPacket(1);
        }
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        int[] slots = null;
        switch (side) {
            case 0: {
                slots = new int[9];
                for (int i = 0; i < slots.length; ++i) {
                    slots[i] = i;
                }
                return slots;
            }
        }
        slots = new int[18];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i + 9;
        }
        return slots;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return true;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    @Override
    public byte getDirectionFacing() {
        return this.directionFacing;
    }

    @Override
    public void setDirectionFacing(byte byt) {
        this.directionFacing = byt;
    }

    @Override
    public ItemStack getRenderedResult() {
        return this.inventoryHandler.result;
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inv;
    }

    @Override
    public void setRenderedResult(ItemStack stack) {
        this.result = stack;
    }

    @Override
    public void setTools(ItemStack[] stacks) {
        int i = 0;
        for (ItemStack stack : stacks) {
            this.tools[i++] = stack == null ? stack : stack.func_77946_l();
        }
        if (this.inventoryHandler != null) {
            this.inventoryHandler.tools = this.tools;
        }
    }

    @Override
    public void setSelectedToolIndex(int i) {
        this.inventoryHandler.selectedToolIndex = this.selectedToolIndex = i;
        this.sendRenderPacket = true;
    }

    @Override
    public void setRandomShift(float f) {
        this.randomShift = f;
    }

    @Override
    public ContainerHandler getContainerHandler() {
        return this.containerHandler;
    }

    @Override
    public InventoryHandler getInventoryHandler() {
        return this.inventoryHandler;
    }

    @Override
    public int getPlanIndexInInventory() {
        return this.inventoryHandler.planIndex;
    }

    public void setPlanksUsed(ItemStack planks) {
        this.planksUsed = planks.func_77946_l();
    }

    @Override
    public Modifications getModifications() {
        return this.modifications;
    }

    public class LocalInventoryCrafting
    extends InventoryCrafting {
        private TileEntity theTile;

        public LocalInventoryCrafting() {
            super(new Container(){

                public boolean func_75145_c(EntityPlayer var1) {
                    return false;
                }
            }, 3, 3);
        }

        public LocalInventoryCrafting(TileEntity tileEntity) {
            this();
            this.theTile = tileEntity;
        }
    }
}

