/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.tileentity;

import bau5.mods.craftingsuite.common.inventory.EnumInventoryModifier;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import cpw.mods.fml.common.network.PacketDispatcher;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileNetHandler {
    private IModifiedTileEntityProvider tile;
    private Packet nextRenderPacket;
    private Packet nextDescriptionPacket;

    public TileNetHandler(IModifiedTileEntityProvider te) {
        this.tile = te;
    }

    public void onDataPacket(Packet132TileEntityData packet) {
        if (packet.field_73331_e.func_74764_b("displayedResult")) {
            NBTTagCompound tag = packet.field_73331_e.func_74775_l("displayedResult");
            if (tag.func_74764_b("displayedResult")) {
                tag = packet.field_73331_e.func_74775_l("displayedResult");
            }
            this.tile.getInventoryHandler().result = ItemStack.func_77949_a((NBTTagCompound)tag);
            if (this.tile.getInventoryModifier() == EnumInventoryModifier.TOOLS) {
                ItemStack[] tools = new ItemStack[3];
                for (int i = 0; i < 3; ++i) {
                    tools[i] = ItemStack.func_77949_a((NBTTagCompound)packet.field_73331_e.func_74775_l("tool" + i));
                }
                this.tile.setTools(tools);
                this.tile.setSelectedToolIndex(packet.field_73331_e.func_74771_c("selectedToolIndex"));
            }
            return;
        }
        if (packet.field_73331_e.func_74764_b("randomShift")) {
            this.tile.setRandomShift(packet.field_73331_e.func_74760_g("randomShift"));
            return;
        }
        TileEntity te = (TileEntity)this.tile;
        te.func_70307_a(packet.field_73331_e);
    }

    public Packet getDescriptionPacket() {
        return null;
    }

    public Packet getInformationPacket(int type) {
        return null;
    }

    public void tick() {
        if (this.nextRenderPacket != null) {
            TileEntity te = (TileEntity)this.tile;
            PacketDispatcher.sendPacketToAllAround((double)te.field_70329_l, (double)te.field_70330_m, (double)te.field_70327_n, (double)64.0, (int)te.field_70331_k.field_73011_w.field_76574_g, (Packet)this.nextRenderPacket);
            this.nextRenderPacket = null;
        }
    }

    public Packet getRenderPacket(int type) {
        NBTTagCompound tag = new NBTTagCompound();
        TileEntity te = (TileEntity)this.tile;
        if (type == 0) {
            ItemStack result = this.tile.getRenderedResult();
            tag.func_74782_a("displayedResult", (NBTBase)(result != null ? result.func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
            if (this.tile.getInventoryModifier() == EnumInventoryModifier.TOOLS) {
                NBTTagCompound tag2 = new NBTTagCompound();
                for (int i = 0; i < 3; ++i) {
                    tag2 = new NBTTagCompound();
                    tag.func_74782_a("tool" + i, (NBTBase)(this.tile.getInventory()[i + this.tile.getToolModifierInvIndex()] != null ? this.tile.getInventory()[i + this.tile.getToolModifierInvIndex()].func_77955_b(tag2) : tag2));
                }
                tag.func_74774_a("selectedToolIndex", (byte)this.tile.getSelectedToolIndex());
            }
        }
        if (type == 1) {
            tag.func_74776_a("randomShift", new Random().nextFloat() / 100.0f);
        }
        return new Packet132TileEntityData(te.field_70329_l, te.field_70330_m, te.field_70327_n, 1, tag);
    }

    public void postRenderPacket(int type) {
        this.nextRenderPacket = this.getRenderPacket(type);
    }
}

