/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.codechicken;

import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.helpers.ModificationNBTHelper;
import bau5.mods.craftingsuite.common.helpers.ModificationStackHelper;
import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class ModificationCraftingHandler
extends TemplateRecipeHandler {
    private List<BenchCachedRecipe> recipeList = new ArrayList<BenchCachedRecipe>();
    private ResourceLocation tableResource = new ResourceLocation("craftingsuite", "textures/gui/neimodgui.png");

    public void loadCraftingRecipes(ItemStack result) {
        if (result.field_77993_c == CraftingSuite.craftingTableBlock.field_71990_ca) {
            ItemStack copy = result.func_77946_l();
            copy.field_77994_a = 1;
            ArrayList<ItemStack> inputs = ModificationStackHelper.getPartsForBench(result);
            this.arecipes.add(new BenchCachedRecipe(copy, inputs));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Random rand = new Random();
        if (ingredient.field_77993_c == CraftingSuite.craftingTableBlock.field_71990_ca) {
            if (ingredient.func_77942_o() && ModificationNBTHelper.getUpgradeByteArray(ingredient.field_77990_d)[1] == -1) {
                int i;
                ArrayList<ItemStack> ins = new ArrayList<ItemStack>();
                ArrayList<ItemStack> outs = new ArrayList<ItemStack>();
                for (i = 3; i < 6; ++i) {
                    ItemStack copy = ingredient.func_77946_l();
                    copy.field_77994_a = 1;
                    ins.add(copy);
                    ins.add(new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, i));
                    ItemStack ingred = ingredient.func_77946_l();
                    byte[] upgrades = ModificationNBTHelper.getUpgradeByteArray(ingred.field_77990_d);
                    ingred.field_77994_a = 1;
                    upgrades[1] = (byte)i;
                    if (upgrades[3] == -1) {
                        int col = rand.nextInt(15);
                        upgrades[3] = (byte)col;
                        ins.add(new ItemStack(Block.field_111031_cC.field_71990_ca, 1, col));
                    }
                    if (upgrades[4] == -1) {
                        upgrades[4] = 1;
                        ins.add(new ItemStack(Block.field_72041_aW));
                    }
                    outs.add(ingred);
                    this.arecipes.add(new BenchCachedRecipe(ingred, ins));
                    outs.clear();
                    ins.clear();
                }
                i = 0;
                for (ItemStack out : outs) {
                    this.arecipes.add(new BenchCachedRecipe(out, outs.subList(i * 2, i * 2 + 1)));
                }
                i = 0;
            }
        } else if (ingredient.field_77993_c == CraftingSuite.modificationTableBlock.field_71990_ca) {
            ArrayList<ItemStack> types = new ArrayList<ItemStack>();
            types.add(ModificationStackHelper.makeModdedTableType(2, -1, 12, 0));
            types.add(ModificationStackHelper.makeModdedTableType(2, 5, 14, 1));
            types.add(ModificationStackHelper.makeModdedTableType(2, 4, 13, 0));
            types.add(ModificationStackHelper.makeModdedTableType(2, 3, 0, 2));
            types.add(ModificationStackHelper.makeModdedTableType(1, -1, 0, 2));
            types.add(ModificationStackHelper.makeModdedTableType(1, 4, 0, 0));
            for (int i = 0; i < types.size(); ++i) {
                ArrayList<ItemStack> parts = ModificationStackHelper.getPartsForBench((ItemStack)types.get(i));
                this.arecipes.add(new BenchCachedRecipe((ItemStack)types.get(i), parts));
            }
        } else if (ingredient.field_77993_c == CraftingSuite.modItems.field_77779_bT) {
            if (ingredient.func_77960_j() > 2) {
                ArrayList<ItemStack> types = new ArrayList<ItemStack>();
                if (ingredient.func_77960_j() == 4) {
                    types.add(ModificationStackHelper.makeModdedTableType(1, ingredient.func_77960_j(), 0, 0));
                }
                types.add(ModificationStackHelper.makeModdedTableType(2, ingredient.func_77960_j(), 13, 0));
                for (int i = 0; i < types.size(); ++i) {
                    ArrayList<ItemStack> parts = ModificationStackHelper.getPartsForBench((ItemStack)types.get(i));
                    this.arecipes.add(new BenchCachedRecipe((ItemStack)types.get(i), parts));
                }
            } else if (ingredient.func_77960_j() > 0) {
                int dam;
                ArrayList<ItemStack> types = new ArrayList<ItemStack>();
                types.add(ModificationStackHelper.makeModdedTableType(dam, -1, (dam = ingredient.func_77960_j()) == 2 ? rand.nextInt(15) : -1, rand.nextInt(4)));
                for (int i = 0; i < types.size(); ++i) {
                    ArrayList<ItemStack> parts = ModificationStackHelper.getPartsForBench((ItemStack)types.get(i));
                    this.arecipes.add(new BenchCachedRecipe((ItemStack)types.get(i), parts));
                }
            }
        } else if (ingredient.field_77993_c == Block.field_72041_aW.field_71990_ca) {
            for (int i = 1; i < 3; ++i) {
                ItemStack out = ModificationStackHelper.makeModdedTableType(i, -1, i == 2 ? rand.nextInt(14) : -1, rand.nextInt(4));
                this.arecipes.add(new BenchCachedRecipe(out, ModificationStackHelper.getPartsForBench(out)));
            }
        } else if (ingredient.field_77993_c == Block.field_111031_cC.field_71990_ca) {
            ItemStack out = ModificationStackHelper.makeModdedTableType(2, -1, ingredient.func_77960_j(), rand.nextInt(4));
            this.arecipes.add(new BenchCachedRecipe(out, ModificationStackHelper.getPartsForBench(out)));
        } else {
            int id2;
            int id1 = OreDictionary.getOreID((ItemStack)ingredient);
            if (id1 == (id2 = OreDictionary.getOreID((String)"plankWood")) && id1 != -1) {
                for (int i = 1; i < 3; ++i) {
                    ItemStack out = ModificationStackHelper.makeModdedTableType(i, -1, i == 2 ? rand.nextInt(14) : -1, 0);
                    ModificationNBTHelper.setTagPlanksUsed(out.field_77990_d, ingredient);
                    this.arecipes.add(new BenchCachedRecipe(out, ModificationStackHelper.getPartsForBench(out)));
                }
            }
        }
        super.loadUsageRecipes(ingredient);
    }

    public List<PositionedStack> getOtherStacks(int recipe) {
        if (recipe < this.recipeList.size()) {
            return this.recipeList.get(recipe).getOthers();
        }
        return new ArrayList<PositionedStack>();
    }

    public PositionedStack getResultStack(int recipe) {
        return super.getResultStack(recipe);
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return super.getIngredientStacks(recipe);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return "Modification Table";
    }

    public String getGuiTexture() {
        return "craftingsuite/textures/gui/neimodgui.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)this.tableResource);
        GuiDraw.drawTexturedModalRect((int)-5, (int)0, (int)0, (int)0, (int)176, (int)130);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((ResourceLocation)this.tableResource);
        this.drawExtras(recipe);
    }

    public class BenchCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private PositionedStack presult;
        private List<PositionedStack> others;

        public BenchCachedRecipe(ItemStack res, Object ... objects) {
            super((TemplateRecipeHandler)ModificationCraftingHandler.this);
            this.others = new ArrayList<PositionedStack>();
            this.setResult(res);
            if (objects[0] instanceof List) {
                this.setOthers((List)objects[0]);
            } else {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add((ItemStack)objects[0]);
                this.setOthers(stacks);
            }
        }

        public void setResult(ItemStack result) {
            this.presult = new PositionedStack((Object)result, 137, 108, false);
        }

        public void setOthers(List<ItemStack> stacks) {
            int shift = 0;
            boolean flag = false;
            for (ItemStack stack : stacks) {
                if (stack.field_77993_c == CraftingSuite.craftingTableBlock.field_71990_ca) {
                    this.others.add(new PositionedStack((Object)stack, 6, 20, false));
                    flag = true;
                    continue;
                }
                if (stack.field_77993_c == CraftingSuite.modItems.field_77779_bT) {
                    this.others.add(new PositionedStack((Object)stack, 6, 20 + (flag ? 36 : 0), false));
                    continue;
                }
                if (stack.field_77993_c == Block.field_71988_x.field_71990_ca || OreDictionary.getOreID((ItemStack)stack) == 1) {
                    this.others.add(new PositionedStack((Object)stack, 6, 56, false));
                    continue;
                }
                if (stack.field_77993_c == Block.field_111031_cC.field_71990_ca) {
                    this.others.add(new PositionedStack((Object)stack, 6, 92, false));
                    ++shift;
                    continue;
                }
                if (stack.field_77993_c != Block.field_72041_aW.field_71990_ca) continue;
                this.others.add(new PositionedStack((Object)stack, 6 + shift * 22, 92, false));
            }
            ModificationCraftingHandler.this.recipeList.add(this);
        }

        public PositionedStack getResult() {
            return this.presult;
        }

        public List<PositionedStack> getOthers() {
            return this.others;
        }
    }
}

