/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common;

import bau5.mods.craftingsuite.common.BlockCrafting;
import bau5.mods.craftingsuite.common.BlockModificationTable;
import bau5.mods.craftingsuite.common.CommonProxy;
import bau5.mods.craftingsuite.common.ItemBlockCrafting;
import bau5.mods.craftingsuite.common.ItemBlockModificationTable;
import bau5.mods.craftingsuite.common.ItemModifications;
import bau5.mods.craftingsuite.common.ItemPlan;
import bau5.mods.craftingsuite.common.PBPacketHandler;
import bau5.mods.craftingsuite.common.Reference;
import bau5.mods.craftingsuite.common.VersionChecker;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModdedTable;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModificationTable;
import bau5.mods.craftingsuite.common.tileentity.TileEntityProjectBench;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.Calendar;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

@Mod(modid="CraftingSuite", name="Crafting Suite", version="0.2.1.3")
@NetworkMod(clientSideRequired=true, serverSideRequired=false, channels={"bau5_CS"}, packetHandler=PBPacketHandler.class)
public class CraftingSuite {
    @Mod.Instance(value="CraftingSuite")
    public static CraftingSuite instance;
    @SidedProxy(clientSide="bau5.mods.craftingsuite.client.ClientProxy", serverSide="bau5.mods.craftingsuite.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block modificationTableBlock;
    public static Block craftingTableBlock;
    public static Item craftingFrame;
    public static Item modItems;
    public static Item planItem;
    public static boolean VERBOSE;
    public static boolean VERSION_CHECK;
    public static boolean EE_ENABLED;
    public static boolean cmas;
    private int[] blockIDs;
    private int[] itemIDs;
    private int entityID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent ev) {
        Configuration config = new Configuration(ev.getSuggestedConfigurationFile());
        this.itemIDs = new int[2];
        this.blockIDs = new int[2];
        try {
            config.load();
            this.blockIDs[0] = config.getBlock("Modification Block", 700).getInt(700);
            this.blockIDs[1] = config.getBlock("Crafting Block", 701).getInt(701);
            this.itemIDs[0] = config.getItem("Modifications", 18976).getInt(18976) - 256;
            this.itemIDs[1] = config.getItem("Plan", 18977).getInt(18977) - 256;
            VERBOSE = config.get("general", "Verbose Logging", false).getBoolean(false);
            VERSION_CHECK = config.get("general", "Version Check", true).getBoolean(true);
            EE_ENABLED = config.get("general", "Easter Eggs Enabled", true).getBoolean(true);
        }
        catch (Exception ex) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)ex, (String)"Crafting Suite: Failed loading configuration file.", (Object[])new Object[0]);
        }
        finally {
            config.save();
        }
        if (VERSION_CHECK) {
            VersionChecker.go();
        }
        this.dc();
        this.initParts();
    }

    private void initParts() {
        modificationTableBlock = new BlockModificationTable(this.blockIDs[0], Material.field_76245_d);
        craftingTableBlock = new BlockCrafting(this.blockIDs[1], Material.field_76245_d);
        GameRegistry.registerBlock((Block)modificationTableBlock, ItemBlockModificationTable.class, (String)"modtableblock");
        GameRegistry.registerBlock((Block)craftingTableBlock, ItemBlockCrafting.class, (String)"craftingtableblock");
        GameRegistry.registerTileEntity(TileEntityModificationTable.class, (String)"bau5csMT");
        GameRegistry.registerTileEntity(TileEntityModdedTable.class, (String)"bau5csMCT");
        GameRegistry.registerTileEntity(TileEntityProjectBench.class, (String)"bau5csPB");
        modItems = new ItemModifications(this.itemIDs[0]);
        planItem = new ItemPlan(this.itemIDs[1]);
        this.entityID = EntityRegistry.findGlobalUniqueEntityId();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        proxy.registerRenderingInformation();
    }

    @Mod.EventHandler
    public void mainInit(FMLInitializationEvent ev) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent ev) {
        this.registerRecipes();
        this.loadLanguages();
    }

    private void loadLanguages() {
        for (String lang : Reference.LANGUAGES) {
            LanguageRegistry.instance().loadLocalization(new ResourceLocation("/bau5/mods/craftingsuite/langs/" + lang + ".xml").func_110623_a(), lang, true);
        }
    }

    private void dc() {
        boolean m;
        int d = Calendar.getInstance().get(5);
        boolean bl = m = Calendar.getInstance().get(2) == 11;
        if (EE_ENABLED && m && d > 20) {
            cmas = true;
        }
    }

    public void registerRecipes() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modItems, 1, 0), new Object[]{" S ", "SCS", " S ", Character.valueOf('C'), new ItemStack(Block.field_72060_ay.field_71990_ca, 1, Short.MAX_VALUE), Character.valueOf('S'), new ItemStack(Item.field_77669_D.field_77779_bT, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modItems, 1, 1), new Object[]{"ICI", Character.valueOf('C'), new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 0), Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(modItems, 2, 2), new Object[]{new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 1), new ItemStack((Block)Block.field_72077_au, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(modItems, 2, 2), new Object[]{new ItemStack(CraftingSuite.modItems.field_77779_bT, 1, 0), new ItemStack(Item.field_77703_o, 1, 0), new ItemStack((Block)Block.field_72077_au, 1, Short.MAX_VALUE)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(CraftingSuite.modificationTableBlock.field_71990_ca, 1, 0), new Object[]{" C ", "PRP", "SSS", Character.valueOf('C'), new ItemStack(Block.field_72060_ay.field_71990_ca, 1, 0), Character.valueOf('P'), new ItemStack(Block.field_71988_x, 1, Short.MAX_VALUE), Character.valueOf('R'), new ItemStack(Item.field_77767_aC, 1, 0), Character.valueOf('S'), new ItemStack(Block.field_71981_t.field_71990_ca, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modItems, 2, 3), new Object[]{" I ", "IBI", "III", Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1, 0), Character.valueOf('B'), new ItemStack(Item.field_77788_aw, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modItems, 2, 4), new Object[]{"P P", "PIP", " P ", Character.valueOf('P'), Block.field_71988_x, Character.valueOf('I'), new ItemStack(Item.field_77703_o, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(modItems, 2, 5), new Object[]{"SIS", "IPI", "SIS", Character.valueOf('S'), Block.field_71981_t, Character.valueOf('I'), Item.field_77703_o, Character.valueOf('P'), planItem}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(planItem, 8, 0), new Object[]{" PS", "PNP", "SP ", Character.valueOf('P'), Item.field_77759_aK, Character.valueOf('S'), Item.field_77669_D, Character.valueOf('N'), Item.field_77733_bq}));
    }
}

