/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common;

import bau5.mods.craftingsuite.common.CSLogger;
import bau5.mods.craftingsuite.common.Reference;
import bau5.mods.craftingsuite.common.VersionCheckTicker;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import net.minecraft.client.resources.I18n;

public class VersionChecker
implements Runnable {
    private static VersionChecker instance = new VersionChecker();
    private static final String versionURL = "https://raw.github.com/bau5/CraftingSuite/master/version.xml";
    private static final String changesURL = "https://raw.github.com/bau5/CraftingSuite/master/changes.xml";
    public static Properties versionProperties = new Properties();
    public static Properties changesProperties = new Properties();
    public static final byte NOT_DONE = 0;
    public static final byte UP_TO_DATE = 1;
    public static final byte OUT_OF_DATE = 2;
    public static final byte FAILED = 3;
    private static byte result = 0;
    public static String remoteVersion = null;
    public static String remoteVersionImportance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkVersion() {
        InputStream remoteVersionStream = null;
        result = 0;
        try {
            URL versionurl = new URL(versionURL);
            remoteVersionStream = versionurl.openStream();
            versionProperties.loadFromXML(remoteVersionStream);
            String versionFromRemote = versionProperties.getProperty(Loader.instance().getMCVersionString());
            if (versionFromRemote != null) {
                String[] versionSplit = versionFromRemote.split("\\|");
                if (versionSplit[0] != null) {
                    remoteVersion = versionSplit[0];
                }
                if (versionSplit[1] != null) {
                    remoteVersionImportance = versionSplit[1];
                }
                if (remoteVersion != null) {
                    Reference.LATEST_VERSION = remoteVersion;
                    result = remoteVersion.equalsIgnoreCase("0.2.1.3") ? (byte)1 : (byte)2;
                }
            } else {
                result = (byte)3;
            }
        }
        catch (Exception ex) {
            CSLogger.log(I18n.func_135053_a((String)"cs.versioncheck.fail"), ex);
        }
        finally {
            if (result == 0) {
                result = (byte)3;
            }
            try {
                if (remoteVersionStream != null) {
                    remoteVersionStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLatestChanges() {
        InputStream remoteChangesStream = null;
        try {
            URL remoteChangesURL = new URL(changesURL);
            remoteChangesStream = remoteChangesURL.openStream();
            changesProperties.loadFromXML(remoteChangesStream);
            String changesFromRemote = changesProperties.getProperty(Reference.LATEST_VERSION);
            if (changesFromRemote != null) {
                CSLogger.log("Latest Changes: " + changesFromRemote);
                Reference.LATEST_CHANGES = changesFromRemote;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (remoteChangesStream != null) {
                    remoteChangesStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void run() {
        int tries = 0;
        CSLogger.log("Starting Version check.");
        try {
            while (tries < 3 && result != 2 && result != 1) {
                VersionChecker.checkVersion();
                ++tries;
                if (result == 2) {
                    Reference.UP_TO_DATE = false;
                    VersionChecker.checkLatestChanges();
                    TickRegistry.registerTickHandler((ITickHandler)new VersionCheckTicker(), (Side)Side.CLIENT);
                }
                if (result != 1) continue;
                CSLogger.log("Up to date.");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void go() {
        new Thread(instance).start();
    }
}

