/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.helpers;

import cpw.mods.fml.common.FMLLog;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ModificationNBTHelper {
    public static final String tagListName = "ModificationInfo";
    public static final String upgradeArrayName = "UpgradeArray";
    public static final String planksName = "PlanksUsed";
    public static final String modifierTag = "Modifiers";
    public static final int ARRAY_LENGTH = 5;

    public static NBTTagCompound makeBaseTag() {
        NBTTagCompound baseTag = new NBTTagCompound("tag");
        return baseTag;
    }

    public static void setTagUpgradeBytes(NBTTagCompound baseTag, byte[] bytes) {
        baseTag.func_74773_a(upgradeArrayName, bytes);
    }

    public static void setTagPlanksUsed(NBTTagCompound newTag, ItemStack planks) {
        newTag.func_74766_a(planksName, planks.func_77955_b(new NBTTagCompound()));
    }

    public static NBTTagCompound getModifierTag(NBTTagCompound baseTag) {
        if (baseTag == null) {
            baseTag = ModificationNBTHelper.makeBaseTag();
        }
        if (baseTag.func_74740_e().equals(modifierTag)) {
            return baseTag;
        }
        if (baseTag.func_74764_b(modifierTag)) {
            NBTTagCompound returnTag = baseTag.func_74775_l(modifierTag);
            return returnTag;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74773_a(upgradeArrayName, ModificationNBTHelper.newBytes());
        baseTag.func_74782_a(modifierTag, (NBTBase)tag);
        return tag.func_74775_l(modifierTag);
    }

    public static byte[] getUpgradeByteArray(NBTTagCompound tag) {
        byte[] array = null;
        try {
            if (tag.func_74764_b(modifierTag)) {
                array = tag.func_74775_l(modifierTag).func_74770_j(upgradeArrayName);
            } else if (tag.func_74764_b(upgradeArrayName)) {
                array = tag.func_74770_j(upgradeArrayName);
            }
        }
        catch (Exception ex) {
            FMLLog.log((Level)Level.SEVERE, (Throwable)ex, (String)"%s", (Object[])new Object[]{"Crafting Suite encountered an error. A broken stack was encountered, resetting stack."});
            ModificationNBTHelper.getModifierTag(tag).func_74773_a(upgradeArrayName, array);
        }
        if (array == null) {
            array = ModificationNBTHelper.placeHolderBytes();
        }
        return array;
    }

    public static byte[] ensureSize(byte[] array) {
        if (array.length != 5) {
            byte[] bytes = new byte[5];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = i < array.length ? array[i] : -1;
            }
            return bytes;
        }
        return array;
    }

    public static boolean ensureIntegrity(Object ... data) {
        NBTTagCompound tag;
        if (data == null) {
            return false;
        }
        byte[] bytes = null;
        return data.length > 0 && (data[0] instanceof NBTTagCompound ? ((tag = (NBTTagCompound)data[0]).func_74740_e().equals(modifierTag) ? (bytes = ModificationNBTHelper.getUpgradeByteArray(tag)).length > 0 && bytes[0] > -1 : (tag.func_74764_b(modifierTag) ? (bytes = ModificationNBTHelper.getUpgradeByteArray(tag = tag.func_74775_l(modifierTag))).length > 0 && bytes[0] > -1 : tag.func_74764_b(planksName) && (bytes = ModificationNBTHelper.getUpgradeByteArray(tag)).length > 0 && bytes[0] > -1)) : data[0] instanceof byte[] && (bytes = (byte[])data[0]).length > 0 && bytes[0] > -1);
    }

    public static byte[] newBytes() {
        byte[] bytes = new byte[5];
        int i = 0;
        for (byte b : bytes) {
            bytes[i++] = 0;
        }
        return bytes;
    }

    public static byte[] placeHolderBytes() {
        byte[] bytes = new byte[5];
        bytes[0] = 2;
        bytes[1] = 3;
        bytes[3] = 14;
        bytes[4] = 1;
        return bytes;
    }

    public static NBTTagCompound convertOldNBT(NBTTagCompound oldTag) {
        NBTTagCompound tag = oldTag.func_74775_l(modifierTag);
        return oldTag;
    }

    public static NBTTagCompound getPlanksUsed_Base(NBTTagCompound stackTagCompound) {
        if (stackTagCompound == null) {
            return new ItemStack(Block.field_71988_x.field_71990_ca, 1, 0).func_77955_b(new NBTTagCompound());
        }
        return ModificationNBTHelper.getPlanksUsed(stackTagCompound.func_74775_l(modifierTag));
    }

    public static NBTTagCompound getPlanksUsed(NBTTagCompound stackTagCompound) {
        if (stackTagCompound == null) {
            return new ItemStack(Block.field_71988_x.field_71990_ca, 1, 0).func_77955_b(new NBTTagCompound());
        }
        if (stackTagCompound.func_74764_b(modifierTag)) {
            return stackTagCompound.func_74775_l(modifierTag).func_74775_l(planksName);
        }
        return stackTagCompound.func_74775_l(planksName);
    }
}

