/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.inventory;

import bau5.mods.craftingsuite.common.handlers.DeepSlotHandler;
import bau5.mods.craftingsuite.common.handlers.DefaultHandler;
import bau5.mods.craftingsuite.common.handlers.PlanHandler;
import bau5.mods.craftingsuite.common.handlers.ToolsHandler;
import bau5.mods.craftingsuite.common.inventory.ContainerBase;
import bau5.mods.craftingsuite.common.inventory.EnumInventoryModifier;
import bau5.mods.craftingsuite.common.inventory.SlotDeep;
import bau5.mods.craftingsuite.common.inventory.SlotPBCrafting;
import bau5.mods.craftingsuite.common.inventory.SlotPlan;
import bau5.mods.craftingsuite.common.inventory.SlotTool;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import bau5.mods.craftingsuite.common.tileentity.TileEntityProjectBench;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerProjectBench
extends ContainerBase {
    public TileEntityProjectBench tileEntity;
    private SlotPBCrafting craftingSlot;
    private int index = 0;

    public ContainerProjectBench(InventoryPlayer invPlayer, TileEntityProjectBench tpb) {
        super(tpb);
        this.tileEntity = tpb;
        this.tileEntity.getContainerHandler().containerInit = true;
        this.layoutContainer(invPlayer, this.tileEntity);
        this.handleInventoryModifiers();
        this.craftingSlot.handler = this.handler;
        this.tileEntity.getContainerHandler().containerInit = false;
        this.tileEntity.getInventoryHandler().findRecipe(false);
    }

    private void layoutContainer(InventoryPlayer invPlayer, TileEntityProjectBench tile) {
        int i;
        int col;
        int row;
        this.craftingSlot = new SlotPBCrafting(invPlayer.field_70458_d, this.tileEntity, this.handler, this.tileEntity.inventoryHandler.resultMatrix(), 0, 124, 35);
        this.func_75146_a((Slot)this.craftingSlot);
        this.craftingSlotIndex = this.craftingSlot.field_75222_d;
        Slot slot = null;
        boolean xShift = false;
        if (this.handler instanceof DeepSlotHandler) {
            xShift = true;
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                slot = new Slot((IInventory)this.tileEntity, this.index++, 30 + col * 18, 17 + row * 18);
                this.func_75146_a(slot);
            }
        }
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 9; ++col) {
                if (row == 1) {
                    slot = new Slot((IInventory)this.tileEntity, 18 + col, 8 + col * 18, row * 2 - 1 + 77 + row * 18);
                    this.func_75146_a(slot);
                    continue;
                }
                slot = new Slot((IInventory)this.tileEntity, 9 + col, 8 + col * 18, 77 + row * 18);
                this.func_75146_a(slot);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j + i * 9 + 9, 8 + j * 18, 82 + i * 18 + 39));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i, 8 + i * 18, 179));
        }
    }

    @Override
    public ItemStack func_75144_a(int slot, int clickType, int clickMeta, EntityPlayer player) {
        ItemStack lastCraftResult = this.tileEntity.getInventoryHandler().resultMatrix().func_70301_a(0);
        lastCraftResult = lastCraftResult != null ? lastCraftResult.func_77946_l() : null;
        ItemStack stack = super.func_75144_a(slot, clickType, clickMeta, player);
        if (slot == 0 && !ItemStack.func_77989_b((ItemStack)lastCraftResult, (ItemStack)this.tileEntity.getInventoryHandler().resultMatrix().func_70301_a(0))) {
            this.tileEntity.getInventoryHandler().findRecipe(false);
        }
        return stack;
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.tileEntity.func_70300_a(player);
    }

    @Override
    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        this.tileEntity.containerInit = true;
        this.tileEntity.containerHandler.containerInit = true;
        super.func_75131_a(par1ArrayOfItemStack);
        this.tileEntity.containerInit = false;
        this.tileEntity.containerHandler.containerInit = false;
        this.tileEntity.func_70296_d();
    }

    @Override
    public void func_75141_a(int slot, ItemStack itemStack) {
        this.tileEntity.containerHandler.containerInit = true;
        super.func_75141_a(slot, itemStack);
        this.tileEntity.containerHandler.containerInit = false;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int numSlot) {
        ItemStack stack = null;
        Slot slot = (Slot)this.field_75151_b.get(numSlot);
        if (this.handler != null && this.handler.handlesThisTransfer(numSlot, slot.func_75211_c())) {
            ItemStack stack2 = this.handler.handleTransferClick(player, numSlot);
            return stack2;
        }
        if (slot != null && slot.func_75216_d()) {
            boolean flag = false;
            ItemStack stack2 = slot.func_75211_c();
            stack = stack2.func_77946_l();
            if (!flag && (this.tileEntity.getInventoryModifier() == EnumInventoryModifier.TOOLS && stack.func_77984_f() && numSlot != 0 ? (numSlot < 64 ? !this.func_75135_a(stack2, 64, 67, false) && !this.func_75135_a(stack2, 10, 28, false) : numSlot >= 64 && numSlot <= 66 && !this.func_75135_a(stack2, 28, 63, false)) : (numSlot == 0 ? !this.func_75135_a(stack2, 10, 55, false) : (numSlot > 0 && numSlot <= 9 ? !this.func_75135_a(stack2, 10, 28, false) && !this.func_75135_a(stack2, 28, 63, false) : (numSlot >= 10 && numSlot <= 27 ? !this.func_75135_a(stack2, 28, 63, false) : numSlot >= 28 && numSlot < 64 && !this.func_75135_a(stack2, 10, 28, false)))))) {
                return null;
            }
            if (stack2.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (stack2.field_77994_a == stack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stack2);
        }
        return stack;
    }

    @Override
    public EnumInventoryModifier getInventoryModifier() {
        return this.tileEntity.getInventoryModifier();
    }

    @Override
    public void handleInventoryModifiers() {
        switch (this.getInventoryModifier()) {
            case NONE: {
                this.handler = new DefaultHandler();
                break;
            }
            case TOOLS: {
                SlotTool[] toolSlots = new SlotTool[3];
                for (int i = 0; i < 3; ++i) {
                    toolSlots[i] = new SlotTool(this.tileEntity, this.tileEntity.getToolModifierInvIndex() + i, -17, 17 + (16 * i + i * 2));
                    this.func_75146_a(toolSlots[i]);
                }
                this.handler = new ToolsHandler(this, toolSlots);
                break;
            }
            case PLAN: {
                SlotPlan planSlot = new SlotPlan(this.tileEntity, 27, 8, 34);
                this.func_75146_a(planSlot);
                this.handler = new PlanHandler(this, planSlot);
                break;
            }
            case DEEP: {
                SlotDeep slot = new SlotDeep(this.tileEntity, 27, -17, 34);
                this.func_75146_a(slot);
                this.handler = new DeepSlotHandler(this, slot);
            }
        }
    }

    @Override
    public int getSizeInventoryOfTile() {
        return this.tileEntity.func_70302_i_();
    }

    @Override
    protected int[] getXYZ() {
        return new int[]{this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n};
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        this.tileEntity.func_70305_f();
    }

    @Override
    public IModifiedTileEntityProvider getTileEntity() {
        return this.tileEntity;
    }
}

