/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.recipe;

import bau5.mods.craftingsuite.common.CraftingSuite;
import bau5.mods.craftingsuite.common.helpers.ItemHelper;
import bau5.mods.craftingsuite.common.helpers.ModificationNBTHelper;
import bau5.mods.craftingsuite.common.recipe.IModRecipe;
import bau5.mods.craftingsuite.common.tileentity.TileEntityModificationTable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModificationRecipeUpgrade
implements IModRecipe {
    private ItemStack baseResult;
    private ItemStack[] possibleInputs;

    public ModificationRecipeUpgrade(ItemStack basicResult, ItemStack[] inputs) {
        this.baseResult = basicResult;
        this.possibleInputs = inputs;
    }

    @Override
    public ItemStack getOutput() {
        return this.baseResult;
    }

    @Override
    public ItemStack getExactOutput(ItemStack[] input) {
        ItemStack[] used = this.doesRecipeMatch(input);
        byte[] bytes = (byte[])ModificationNBTHelper.getUpgradeByteArray(input[0].field_77990_d).clone();
        if (bytes == null || used == null) {
            return input[0];
        }
        for (ItemStack stack : used) {
            if (stack.field_77993_c == Block.field_111031_cC.field_71990_ca) {
                bytes[3] = (byte)stack.func_77960_j();
                continue;
            }
            if (stack.field_77993_c == Block.field_72041_aW.field_71990_ca) {
                bytes[4] = 1;
            }
            if (stack.field_77993_c != CraftingSuite.modItems.field_77779_bT || stack.func_77960_j() < 3) continue;
            bytes[1] = (byte)stack.func_77960_j();
        }
        ItemStack newStack = input[0].func_77946_l();
        newStack.field_77994_a = 1;
        ModificationNBTHelper.setTagUpgradeBytes(newStack.field_77990_d, bytes);
        return newStack;
    }

    @Override
    public ItemStack[] doesRecipeMatch(ItemStack[] provided) {
        if (provided == null) {
            return null;
        }
        ItemStack base = null;
        for (ItemStack stack : provided) {
            if (stack.field_77993_c != this.baseResult.field_77993_c || stack.func_77960_j() != this.baseResult.func_77960_j()) continue;
            base = stack.func_77946_l();
            base.field_77994_a = 1;
            break;
        }
        if (base == null) {
            return null;
        }
        for (int i = 0; i < provided.length; ++i) {
            int j = 0;
            while (j < provided.length && i < provided.length) {
                if (i != j && provided[i].field_77993_c == CraftingSuite.modItems.field_77779_bT && provided[j].field_77993_c == provided[i].field_77993_c) {
                    return null;
                }
                ++i;
            }
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(base);
        if (this.baseResult.field_77993_c == provided[0].field_77993_c && this.baseResult.func_77960_j() == provided[0].func_77960_j()) {
            byte[] fromStack = ModificationNBTHelper.getUpgradeByteArray(provided[0].field_77990_d);
            byte[] bytes = new byte[fromStack.length];
            System.arraycopy(fromStack, 0, bytes, 0, bytes.length);
            for (ItemStack possible : this.possibleInputs) {
                for (int i = 0; i < provided.length; ++i) {
                    if (!ItemHelper.checkItemMatch(possible, provided[i])) continue;
                    ItemStack newPiece = null;
                    if (provided[i].field_77993_c == Block.field_111031_cC.field_71990_ca) {
                        newPiece = provided[i].func_77946_l();
                        newPiece.field_77994_a = 1;
                        list.add(newPiece);
                        continue;
                    }
                    if (provided[i].field_77993_c == Block.field_72041_aW.field_71990_ca) {
                        if (bytes[4] != -1) continue;
                        newPiece = provided[i].func_77946_l();
                        newPiece.field_77994_a = 1;
                        list.add(newPiece);
                        continue;
                    }
                    if (provided[i].field_77993_c != CraftingSuite.modItems.field_77779_bT || provided[i].func_77960_j() < 3 || bytes[1] != -1) continue;
                    bytes[1] = (byte)provided[i].func_77960_j();
                    newPiece = provided[i].func_77946_l();
                    newPiece.field_77994_a = 1;
                    list.add(newPiece);
                }
            }
        }
        if (list.size() == 1) {
            return null;
        }
        ItemStack[] stacks = new ItemStack[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stacks[i] = (ItemStack)list.get(i);
        }
        return stacks;
    }

    @Override
    public boolean consumeItems(TileEntityModificationTable tile) {
        boolean flag = true;
        tile.func_70298_a(0, 1);
        block0: for (ItemStack component : this.possibleInputs) {
            for (int i = 0; i < tile.func_70302_i_(); ++i) {
                int idi = OreDictionary.getOreID((ItemStack)tile.func_70301_a(i));
                int idc = OreDictionary.getOreID((ItemStack)component);
                if (OreDictionary.itemMatches((ItemStack)component, (ItemStack)tile.func_70301_a(i), (boolean)false) || idi != -1 && idi == idc) {
                    tile.func_70298_a(i, component.field_77994_a);
                    continue block0;
                }
                flag = false;
            }
        }
        return flag;
    }
}

