/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.tileentity;

import bau5.mods.craftingsuite.common.CSLogger;
import bau5.mods.craftingsuite.common.inventory.EnumInventoryModifier;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import bau5.mods.craftingsuite.common.tileentity.Modifications;
import bau5.mods.craftingsuite.common.tileentity.TileEntityBase;
import bau5.mods.craftingsuite.common.tileentity.TileNetHandler;
import bau5.mods.craftingsuite.common.tileentity.parthandlers.ContainerHandler;
import bau5.mods.craftingsuite.common.tileentity.parthandlers.InventoryHandler;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;

public class TileEntityModdedTable
extends TileEntityBase
implements IModifiedTileEntityProvider {
    private final InventoryHandler inventoryHandler = new InventoryHandler(this);
    private final ContainerHandler containerHandler = new ContainerHandler(this);
    private final TileNetHandler netHandler = new TileNetHandler(this);
    private boolean initialized = false;
    public boolean sendRenderPacket = false;
    private byte directionFacing = 0;
    private int update = 0;
    public float randomShift = 0.0f;
    private ItemStack planksUsed = null;

    public void func_70316_g() {
        if (this.inventoryHandler != null && this.containerHandler != null) {
            if (this.inventoryHandler.shouldUpdate && !this.containerHandler().isContainerInit() && !this.containerHandler().isContainerWorking()) {
                this.inventoryHandler.findRecipe(false);
                this.inventoryHandler.shouldUpdate = false;
            }
            if (this.sendRenderPacket && !this.field_70331_k.field_72995_K) {
                this.netHandler.postRenderPacket(0);
                this.sendRenderPacket = false;
            }
        }
        if (this.update <= 5 && this.update != -1) {
            ++this.update;
        }
        if (this.update >= 5 && this.field_70331_k.field_72995_K) {
            FMLClientHandler.instance().getClient().field_71438_f.func_72711_b(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.update = -1;
        }
        super.func_70316_g();
    }

    public Packet func_70319_e() {
        if (this.inventoryHandler.inv == null && !this.modifications.isInitialized()) {
            this.init();
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        Packet132TileEntityData packet = new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
        return packet;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        super.onDataPacket(net, pkt);
        this.initializeFromNBT(pkt.field_73331_e);
        this.handleModifiers();
        this.netHandler.onDataPacket(pkt);
        if (!this.inventoryHandler.checkValidity()) {
            return;
        }
        if (this.field_70331_k != null) {
            this.inventoryHandler.findRecipe(true);
        }
    }

    public void func_70296_d() {
        this.inventoryHandler.onTileInventoryChanged();
        super.func_70296_d();
    }

    public ContainerHandler containerHandler() {
        return this.containerHandler;
    }

    public void init() {
        if (!this.initialized) {
            this.inventoryHandler.initInventory();
            this.initialized = true;
        }
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        try {
            this.directionFacing = tagCompound.func_74771_c("direction");
            this.field_70325_p = tagCompound.func_74762_e("blockMetadata");
            this.initializeFromNBT(tagCompound);
            this.handleModifiers();
            this.init();
            this.inventoryHandler.readInventoryFromNBT(tagCompound);
        }
        catch (Exception ex) {
            CSLogger.logError("Failed loading a crafting table.");
        }
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        this.inventoryHandler.writeInventoryToNBT(tagCompound);
        tagCompound.func_74774_a("direction", this.getDirectionFacing());
        tagCompound.func_74773_a("UpgradeArray", this.modifications.buildUpgradeArray());
        if (this.modifications.getPlanks() != null) {
            tagCompound.func_74782_a("Planks", (NBTBase)this.planksUsed.func_77955_b(new NBTTagCompound()));
        }
        if (this.getInventoryModifier() == EnumInventoryModifier.TOOLS) {
            tagCompound.func_74774_a("selectedToolIndex", (byte)this.inventoryHandler.selectedToolIndex);
        }
    }

    @Override
    public int getModifiedInventorySize() {
        return this.getBaseInventorySize() + this.getInventoryModifier().getNumSlots();
    }

    @Override
    public EnumInventoryModifier getInventoryModifier() {
        switch (this.modifications.upgrades()) {
            case 3: {
                return EnumInventoryModifier.TOOLS;
            }
            case 4: {
                return EnumInventoryModifier.DEEP;
            }
        }
        return EnumInventoryModifier.NONE;
    }

    @Override
    public int getBaseInventorySize() {
        return 9;
    }

    @Override
    public void initializeFromNBT(NBTTagCompound nbtTagCompound) {
        Modifications mods;
        if (nbtTagCompound.func_74764_b("Modifiers") || nbtTagCompound.func_74740_e().equals("Modifiers")) {
            NBTTagCompound tag = (NBTTagCompound)nbtTagCompound.func_74781_a("Modifiers");
            byte[] bytes = tag.func_74770_j("UpgradeArray");
            mods = new Modifications(ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("PlanksUsed")), bytes);
        } else {
            byte[] bytes = nbtTagCompound.func_74770_j("UpgradeArray");
            mods = new Modifications(ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound.func_74775_l("Planks")), bytes);
        }
        this.initializeFromMods(mods);
        this.initialized = true;
    }

    @Override
    public void initializeFromMods(Modifications mods) {
        this.planksUsed = mods.getPlanks().func_77946_l();
        this.modifications = mods;
    }

    @Override
    public void handleModifiers() {
        this.inventoryHandler.inv = new ItemStack[this.getModifiedInventorySize()];
    }

    @Override
    public int getToolModifierInvIndex() {
        return this.getInventoryModifier() == EnumInventoryModifier.TOOLS ? 9 : -1;
    }

    @Override
    public byte getDirectionFacing() {
        return this.directionFacing;
    }

    @Override
    public void setDirectionFacing(byte byt) {
        this.directionFacing = byt;
    }

    public ItemStack getPlanksUsed() {
        return this.modifications.getPlanks();
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventoryHandler.inv;
    }

    @Override
    public ItemStack getRenderedResult() {
        return this.inventoryHandler.result;
    }

    @Override
    public int getSelectedToolIndex() {
        return this.inventoryHandler.selectedToolIndex;
    }

    @Override
    public void setRenderedResult(ItemStack stack) {
        this.inventoryHandler.result = stack;
    }

    @Override
    public void setTools(ItemStack[] stacks) {
        int i = 0;
        for (ItemStack stack : stacks) {
            this.inventoryHandler.tools[i++] = stack == null ? stack : stack.func_77946_l();
        }
    }

    @Override
    public void setSelectedToolIndex(int i) {
        this.inventoryHandler.selectedToolIndex = i;
    }

    @Override
    public void setRandomShift(float f) {
        this.randomShift = f;
    }

    @Override
    public ItemStack getSelectedTool() {
        if (this.getInventoryModifier() != EnumInventoryModifier.TOOLS) {
            return null;
        }
        if (this.inventoryHandler.selectedToolIndex + this.getToolModifierInvIndex() < this.inventoryHandler.inv.length) {
            return this.inventoryHandler.inv[this.inventoryHandler.selectedToolIndex + this.getToolModifierInvIndex()];
        }
        return new ItemStack(Block.field_71981_t);
    }

    @Override
    public ContainerHandler getContainerHandler() {
        return this.containerHandler;
    }

    @Override
    public InventoryHandler getInventoryHandler() {
        return this.inventoryHandler;
    }

    @Override
    public int getPlanIndexInInventory() {
        return this.inventoryHandler.planIndex;
    }

    @Override
    public Modifications getModifications() {
        return this.modifications;
    }
}

