/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.tileentity;

import bau5.mods.craftingsuite.client.ModelModificationTable;
import bau5.mods.craftingsuite.common.CSLogger;
import bau5.mods.craftingsuite.common.recipe.IModRecipe;
import bau5.mods.craftingsuite.common.recipe.ModificationCrafter;
import cpw.mods.fml.common.network.PacketDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;

public class TileEntityModificationTable
extends TileEntity
implements IInventory {
    public ModelModificationTable model;
    public ItemStack[] inv = new ItemStack[6];
    public ItemStack result = null;
    public ItemStack craftingResult = null;
    public ItemStack[] inputForResult = null;
    public int finishTime;
    public int timeCrafting;
    public boolean crafting;
    public float rotation = 0.0f;
    private int increment;

    public void func_70296_d() {
        super.func_70296_d();
        this.updateResult(false);
    }

    public void craftRecipe() {
        if (!this.field_70331_k.field_72995_K) {
            this.updateResult(false);
        }
        if (this.result != null) {
            this.craftingResult = this.result.func_77946_l();
            ItemStack[] stacks = new ItemStack[this.inv.length - 1];
            for (int i = 0; i < stacks.length; ++i) {
                stacks[i] = this.inv[i];
            }
            IModRecipe rec = ModificationCrafter.instance().findRecipe(this, stacks);
            ItemStack output = rec.getExactOutput(ModificationCrafter.instance().filterNulls(stacks));
            if (ItemStack.func_77989_b((ItemStack)this.result, (ItemStack)output) && ItemStack.func_77970_a((ItemStack)this.result, (ItemStack)output)) {
                rec.consumeItems(this);
                this.initiateCrafting();
            } else {
                this.result = null;
                this.updateResult(false);
            }
        }
    }

    private void initiateCrafting() {
        if (this.isCrafting()) {
            return;
        }
        this.finishTime = 2000;
        this.timeCrafting = 0;
        this.increment = 10;
        if (!this.field_70331_k.field_72995_K) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)64.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
    }

    private void finishCrafting() {
        if (this.inv[5] == null) {
            if (this.craftingResult == null) {
                this.craftingResult = ModificationCrafter.instance().findRecipe(this, this.inputForResult).getExactOutput(this.inputForResult);
            }
            this.inv[5] = this.craftingResult.func_77946_l();
        } else if (this.craftingResult != null && ItemStack.func_77989_b((ItemStack)this.inv[5], (ItemStack)this.craftingResult) && ItemStack.func_77970_a((ItemStack)this.inv[5], (ItemStack)this.craftingResult)) {
            ++this.inv[5].field_77994_a;
        }
        this.finishTime = 0;
        this.timeCrafting = 0;
        this.increment = 0;
        this.rotation = 0.0f;
        this.craftingResult = null;
        this.updateResult(false);
        if (!this.field_70331_k.field_72995_K) {
            PacketDispatcher.sendPacketToAllAround((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, (double)64.0, (int)this.field_70331_k.field_73011_w.field_76574_g, (Packet)this.func_70319_e());
        }
    }

    public ItemStack updateResult(boolean fromPacket) {
        if (this.isCrafting()) {
            return null;
        }
        ItemStack[] stacks = new ItemStack[this.inv.length - 1];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = this.inv[i];
        }
        IModRecipe recipe = ModificationCrafter.instance().findRecipe(this, stacks);
        this.result = recipe != null ? recipe.getExactOutput(ModificationCrafter.instance().filterNulls(stacks)) : null;
        return this.result;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.model == null && this.field_70331_k != null && this.field_70331_k.field_72995_K) {
            this.model = new ModelModificationTable();
        }
        this.timeCrafting += this.increment;
        if (!this.isCrafting() && this.timeCrafting > 0) {
            this.finishCrafting();
        }
        if (this.isCrafting()) {
            this.rotation = this.timeCrafting <= this.finishTime / 2 ? (this.rotation += 0.1f) : (this.rotation -= 0.1f);
        }
    }

    public boolean isCrafting() {
        return this.finishTime > this.timeCrafting;
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        super.onDataPacket(net, pkt);
        this.func_70307_a(pkt.field_73331_e);
        this.updateResult(true);
        CSLogger.log("Updating result from packet");
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                } else {
                    this.func_70296_d();
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return "Modification Table";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) == this && entityplayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        NBTTagList tagList = tagCompound.func_74761_m("Inventory");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inv.length) continue;
            this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.craftingResult = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("craftingresult"));
        this.timeCrafting = tagCompound.func_74762_e("timeCrafting");
        this.finishTime = tagCompound.func_74762_e("finishTime");
        this.rotation = tagCompound.func_74760_g("rotation");
        this.increment = tagCompound.func_74762_e("increment");
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inv.length; ++i) {
            ItemStack stack = this.inv[i];
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
        tagCompound.func_74768_a("finishTime", this.finishTime);
        tagCompound.func_74768_a("timecrafting", this.timeCrafting);
        tagCompound.func_74776_a("rotation", this.rotation);
        tagCompound.func_74768_a("increment", this.increment);
        tagCompound.func_74782_a("craftingresult", (NBTBase)(this.craftingResult != null ? this.craftingResult.func_77955_b(new NBTTagCompound()) : new NBTTagCompound()));
    }
}

