/*
 * Decompiled with CFR 0.152.
 */
package bau5.mods.craftingsuite.common.tileentity.parthandlers;

import bau5.mods.craftingsuite.common.CSLogger;
import bau5.mods.craftingsuite.common.helpers.ItemHelper;
import bau5.mods.craftingsuite.common.inventory.EnumInventoryModifier;
import bau5.mods.craftingsuite.common.inventory.LocalInventoryCrafting;
import bau5.mods.craftingsuite.common.tileentity.IModifiedTileEntityProvider;
import bau5.mods.craftingsuite.common.tileentity.TileEntityBase;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryHandler
implements IInventory {
    public ItemStack[] inv = null;
    public ItemStack[] tools = new ItemStack[3];
    public int selectedToolIndex = -1;
    public int toolIndexInCrafting = -1;
    public int planIndex;
    private TileEntityBase tileEntity;
    private IInventory craftResult = new InventoryCraftResult();
    private LocalInventoryCrafting craftingMatrix = new LocalInventoryCrafting();
    private LocalInventoryCrafting lastCraftMatrix = new LocalInventoryCrafting();
    private int[] craftingInventoryRange = new int[2];
    public HashMap<String, int[]> inventoryMap = new HashMap();
    public ItemStack result = null;
    public ItemStack lastResult = null;
    public boolean shouldUpdate = false;

    public InventoryHandler(TileEntityBase tile) {
        this.tileEntity = tile;
    }

    public void initInventory() {
        this.inv = new ItemStack[this.tileEntity.getModifiedInventorySize()];
        int typ = this.tileEntity.getModifications().type();
        switch (typ) {
            case 1: {
                this.inventoryMap.put("Crafting", new int[]{0, 8});
                break;
            }
            case 2: {
                this.inventoryMap.put("Crafting", new int[]{0, 8});
                this.inventoryMap.put("Supply", new int[]{9, 26});
            }
        }
        int[] indicies = new int[2];
        switch (this.tileEntity.getInventoryModifier()) {
            case DEEP: {
                indicies = typ == 1 ? new int[]{9, 9} : new int[]{27, 27};
                this.inventoryMap.put("Deep", indicies);
                break;
            }
            case TOOLS: {
                this.inventoryMap.put("Tools", new int[]{27, 29});
                break;
            }
            case PLAN: {
                this.inventoryMap.put("Plan", new int[]{27, 27});
                break;
            }
        }
    }

    public ItemStack findRecipe(boolean fromPacket) {
        if (this.tileEntity.field_70331_k == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        this.lastResult = this.result != null ? this.result.func_77946_l() : null;
        boolean toolIn = false;
        this.toolIndexInCrafting = -1;
        ItemStack stack = null;
        if (this.func_70301_a(4) == null && this.selectedToolIndex != -1 && !toolIn && stack == null) {
            this.craftingMatrix.func_70299_a(4, this.tileEntity.getSelectedTool());
            toolIn = true;
            this.toolIndexInCrafting = 4;
        }
        for (int i = 0; i < this.craftingMatrix.func_70302_i_(); ++i) {
            stack = this.func_70301_a(i);
            if (i == 4 && toolIn && this.toolIndexInCrafting == 4) continue;
            if (!toolIn && this.selectedToolIndex != -1 && stack == null) {
                this.craftingMatrix.func_70299_a(i, this.tileEntity.getSelectedTool());
                toolIn = true;
                this.toolIndexInCrafting = i;
                continue;
            }
            this.craftingMatrix.func_70299_a(i, stack);
        }
        ItemStack recipe = CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftingMatrix, this.tileEntity.field_70331_k);
        if (recipe == null && this.tileEntity.getInventoryModifier() == EnumInventoryModifier.PLAN) {
            ItemStack planStack = this.inv[this.planIndex];
            if (planStack != null && planStack.func_77942_o()) {
                this.setResult(ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)planStack.field_77990_d.func_74781_a("Result"))));
            } else {
                this.setResult(recipe);
            }
        } else {
            this.setResult(recipe);
        }
        if (!(ItemStack.func_77989_b((ItemStack)this.lastResult, (ItemStack)this.result) || fromPacket || this.tileEntity.field_70331_k.field_72995_K)) {
            this.tileEntity.sendRenderPacket = true;
        }
        long end = System.currentTimeMillis();
        CSLogger.log("Recipe found on " + (this.tileEntity.field_70331_k.field_72995_K ? "client " : "server ") + "in " + (end - start) + " milliseconds.");
        return recipe;
    }

    private void setResult(ItemStack recipe) {
        this.result = recipe;
        this.craftResult.func_70299_a(0, recipe);
    }

    public ItemStack getResult() {
        return this.result;
    }

    public void onTileInventoryChanged() {
        if (!this.tileEntity.getContainerHandler().isContainerInit() && !this.tileEntity.getContainerHandler().isContainerWorking() && this.checkDifferences()) {
            this.markForUpdate();
            this.makeNewMatrix();
        }
    }

    private void makeNewMatrix() {
        for (int i = 0; i < 9; ++i) {
            this.lastCraftMatrix.func_70299_a(i, this.inv[i + this.craftingInventoryRange[0]]);
        }
    }

    public void markForUpdate() {
        this.shouldUpdate = true;
    }

    private boolean checkDifferences() {
        for (int i = 0; i < 9; ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.lastCraftMatrix.func_70301_a(i), (ItemStack)this.inv[i])) continue;
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_70302_i_() {
        return this.inv.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inv[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amount);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                } else {
                    this.func_70296_d();
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        this.func_70296_d();
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv[slot] = stack;
        if (stack != null && stack.field_77994_a >= this.func_70297_j_() && this.tileEntity.getInventoryModifier() == EnumInventoryModifier.DEEP) {
            int[] i = this.inventoryMap.get("Deep");
            if (i == null) {
                return;
            }
            if (i[0] != slot && stack != null && stack.field_77994_a > this.func_70297_j_()) {
                stack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_70303_b() {
        return "Modded Crafting Table";
    }

    public boolean func_94042_c() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.tileEntity.field_70331_k.func_72796_p(this.tileEntity.field_70329_l, this.tileEntity.field_70330_m, this.tileEntity.field_70327_n) == this.tileEntity && entityplayer.func_70092_e((double)this.tileEntity.field_70329_l + 0.5, (double)this.tileEntity.field_70330_m + 0.5, (double)this.tileEntity.field_70327_n + 0.5) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public LocalInventoryCrafting getCraftingMatrix() {
        return this.craftingMatrix;
    }

    public void setCraftingMatrix(LocalInventoryCrafting crafting) {
        this.craftingMatrix = crafting;
    }

    public void readInventoryFromNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = tagCompound.func_74761_m("Inventory");
        if (this.inv != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = (NBTTagCompound)tagList.func_74743_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (!tag.func_74764_b("Large")) {
                    if (slot < 0 || slot >= this.inv.length) continue;
                    this.inv[slot] = ItemStack.func_77949_a((NBTTagCompound)tag);
                    continue;
                }
                if (slot < 0 || slot >= this.inv.length) continue;
                this.inv[slot] = ItemHelper.loadLargeItemStack(tag);
            }
        }
    }

    public void writeInventoryToNBT(NBTTagCompound tagCompound) {
        NBTTagList itemList = new NBTTagList();
        if (this.inv != null) {
            for (int i = 0; i < this.inv.length; ++i) {
                ItemStack stack = this.inv[i];
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                if (stack.field_77994_a > 64) {
                    tag.func_74774_a("Large", (byte)1);
                    ItemHelper.writeLargeStackToTag(stack, tag);
                } else {
                    stack.func_77955_b(tag);
                }
                itemList.func_74742_a((NBTBase)tag);
            }
        }
        tagCompound.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public IInventory resultMatrix() {
        return this.craftResult;
    }

    public void func_70296_d() {
        this.onTileInventoryChanged();
    }

    public IModifiedTileEntityProvider getTileProvider() {
        return this.tileEntity;
    }

    public boolean checkValidity() {
        return this.inv != null && this.inv.length > 0;
    }

    public boolean affectsCrafting(int slot) {
        if (slot == -1) {
            return false;
        }
        for (String str : this.inventoryMap.keySet()) {
            int[] indicies;
            if (!(str.equals("Crafting") ? slot <= (indicies = this.inventoryMap.get(str))[1] && slot >= indicies[0] : (str.equals("Plan") ? slot <= (indicies = this.inventoryMap.get(str))[1] && slot >= indicies[0] : str.equals("Tools") && slot <= (indicies = this.inventoryMap.get(str))[1] && slot >= indicies[0]))) continue;
            return true;
        }
        return false;
    }
}

