/*
 * Decompiled with CFR 0.152.
 */
import elliandetector.EllianDetector;
import elliandetector.EllianHelpMessages;
import elliandetector.Material;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.lwjgl.input.Keyboard;

public class EllianGuiMaterialScreen
extends EllianGUIScreenInterface {
    static final int LIST_SIZE = 9;
    static final int MAX_STRING_WIDTH = 160;
    static final int MIN_STRING_WIDTH = 64;
    private EllianGuiSimpleButton addButton;
    private EllianGuiSimpleButton backButton;
    private EllianGuiSimpleButton cancelButton;
    private ConcurrentHashMap deleteObject;
    private EllianDetector detector = null;
    private EllianGuiMaterial[] guiMaterials;
    private List<Material> mats;
    private int maxStringWidth;
    private EllianGUIScreenInterface parent;
    private EllianGuiSimpleButton removeButton;
    private boolean removeMode;
    private int scroll;
    private EllianGuiScrollbar scrollbar;

    public EllianGuiMaterialScreen(EllianGUIScreenInterface xe1, EllianDetector detector) {
        this.detector = detector;
        this.mats = detector.getMaterials();
        this.guiMaterials = new EllianGuiMaterial[9];
        this.scrollbar = new EllianGuiScrollbar(0, 0, 0, 12, 90);
        this.parent = xe1;
        int _i = 0;
        while (_i < 9) {
            this.guiMaterials[_i] = new EllianGuiMaterial(detector, _i, this);
            ++_i;
        }
        this.deleteObject = new ConcurrentHashMap();
    }

    protected void a(bax ct) {
        if (ct == this.backButton) {
            this.mine.a((bco)this.parent);
        }
        if (ct == this.removeButton) {
            this.setRemoveMode(true);
        }
        if (ct == this.cancelButton) {
            this.setRemoveMode(false);
        }
        if (!this.removeMode && ct == this.addButton) {
            this.mine.a((bco)new EllianGuiMaterialEditorScreen(this.detector, this, null));
        }
        if (ct instanceof EllianGUIHelpButton) {
            this.mine.a((bco)new EllianGuiHelpScreen(this, ((EllianGUIHelpButton)ct).getHelpMessage()));
        }
    }

    public void a(int mouseX, int mouseY, float floa) {
        this.addButton.l = true;
        this.addButton.m = true;
        int kk = Math.min(160, this.maxStringWidth) + 16;
        int ll = this.height - 90 >> 1;
        int i1 = this.height + 90 >> 1;
        int j1 = this.width - kk - 45 - 10 >> 1;
        int k1 = this.width + kk + 45 + 10 >> 1;
        EllianGuiMaterialScreen.a((int)(j1 - 2), (int)(ll - 2), (int)(k1 + 2), (int)(i1 + 2), (int)-1610612736);
        String string = String.format("Ellian's Material Detector Materials", new Object[0]);
        int l1 = EllianGUIFontRenderer.ELLIANGUIFONTRENDERER.a(string);
        int i2 = this.width - l1 >> 1;
        int j2 = this.width + l1 >> 1;
        EllianGuiMaterialScreen.a((int)(i2 - 2), (int)(ll - 22), (int)(j2 + 2), (int)(ll - 8), (int)-1610612736);
        this.a(EllianGUIFontRenderer.ELLIANGUIFONTRENDERER, string, this.width / 2, ll - 19, -1);
        super.a(mouseX, mouseY, floa);
    }

    void addMaterial(Material material) {
        if (!this.mats.contains(material)) {
            this.mats.add(material);
            this.detector.saveMaterials(this.mats);
            this.updateMaterials();
            this.scrollbar.setValue(this.scrollbar.getMaximum());
        }
    }

    public void b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    boolean getRemoveMode() {
        return this.removeMode;
    }

    public void r_() {
        this.initialise();
        this.buttons.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        EllianGuiMaterial[] aguimaterial = this.guiMaterials;
        int l = this.guiMaterials.length;
        int _j = 0;
        while (_j < l) {
            EllianGuiMaterial guimaterial = aguimaterial[_j];
            this.buttons.add(guimaterial);
            ++_j;
        }
        this.buttons.add(this.scrollbar);
        this.updateMaterials();
        int _i = this.width / 2;
        int _k = this.height + 90 >> 1;
        this.backButton = new EllianGuiSimpleButton(0, _i - 65, _k + 7, 40, 14, this.parent != null ? "Back" : "Close");
        this.buttons.add(this.backButton);
        this.addButton = new EllianGuiSimpleButton(0, _i - 20, _k + 7, 40, 14, "Add");
        this.buttons.add(this.addButton);
        this.removeButton = new EllianGuiSimpleButton(0, _i + 25, _k + 7, 40, 14, "Remove");
        this.buttons.add(this.removeButton);
        this.cancelButton = new EllianGuiSimpleButton(0, _i - 20, _k + 7, 40, 14, "Cancel");
        this.buttons.add(this.cancelButton);
        this.buttons.add(new EllianGUIHelpButton(0, _i + 91, _k - 111, 12, 12, "?", EllianHelpMessages.Messages.MATERIALS));
        this.setRemoveMode(this.removeMode);
    }

    void removeMaterial(Material material) {
        if (this.mats.remove(material)) {
            this.detector.saveMaterials(this.mats);
            this.updateMaterials();
        }
        this.setRemoveMode(false);
    }

    private void setMaterials() {
        int _i = 0;
        while (_i < 9) {
            int _j = _i + this.scroll;
            this.guiMaterials[_i].setMaterial(_j + 1, _j >= this.mats.size() ? null : this.mats.get(_j));
            ++_i;
        }
    }

    void setRemoveMode(boolean flag) {
        this.backButton.m = !flag;
        this.backButton.l = this.backButton.m;
        this.addButton.m = !flag;
        this.addButton.l = this.addButton.m;
        this.removeButton.m = !flag;
        this.removeButton.l = this.removeButton.m;
        this.cancelButton.l = this.cancelButton.m = flag;
        if (this.removeMode != flag) {
            this.removeMode = flag;
        }
    }

    private void updateGui() {
        int _i = Math.min(160, this.maxStringWidth) + 16;
        int _j = this.height - 90 - 4 >> 1;
        int _k = this.width - _i - 45 - 12 >> 1;
        int _l = this.width + _i + 45 + 12 >> 1;
        int i1 = 0;
        while (i1 < 9) {
            this.guiMaterials[i1].bounds(_k + 2, _j + 2 + 10 * i1, _i + 45, 9);
            ++i1;
        }
        this.scrollbar.h = _l - 12;
        this.scrollbar.i = _j + 2;
    }

    void updateMaterial(Material material) {
        if (this.mats.contains(material)) {
            this.detector.saveMaterials(this.mats);
            this.updateMaterials();
        }
    }

    private void updateMaterials() {
        this.maxStringWidth = 128;
        int i = 0;
        int j = this.mats.size();
        while (i < j) {
            Material material = this.mats.get(i);
            this.maxStringWidth = Math.max(this.maxStringWidth, EllianGUIFontRenderer.ELLIANGUIFONTRENDERER.a(String.valueOf(i + 1) + ") " + material.getName()));
            ++i;
        }
        this.scrollbar.setMinimum(0.0f);
        this.scrollbar.setMaximum(this.mats.size());
        this.scrollbar.setVisibleAmount(Math.min(9, this.mats.size()));
        this.scroll = (int)this.scrollbar.getValue();
        this.updateGui();
        this.setMaterials();
    }
}

