/*
 * Decompiled with CFR 0.152.
 */
package elliandetector;

import elliandetector.EllianDetector;
import elliandetector.EllianDetectorConfiguration;

public class Material {
    private int blockId;
    private int subType;
    private float blue;
    private boolean enable;
    private float green;
    private String name;
    private float red;

    public Material(Material material) {
        this.set(material);
    }

    public static int formatBlockId(String id) {
        int blockId = 0;
        blockId = id.contains(":") ? Integer.parseInt(id.substring(0, id.indexOf(":"))) : Integer.parseInt(id);
        return blockId;
    }

    public static int formatSubBlockId(String id) {
        int subId = 0;
        if (id.contains(":")) {
            subId = Integer.parseInt(id.substring(id.indexOf(":") + 1, id.length()));
        }
        return subId;
    }

    public Material(String name, boolean flag, int blockId, int subType, float f, float f1, float f2) {
        this.name = name;
        this.blockId = blockId;
        this.subType = subType;
        this.enable = flag;
        this.red = f;
        this.green = f1;
        this.blue = f2;
    }

    public Material(String name, boolean flag, int blockId, int subType) {
        this.name = name;
        this.blockId = blockId;
        this.subType = subType;
        this.enable = flag;
        int color = EllianDetector.getBlockColor(String.valueOf(blockId) + ":" + subType);
        this.red = (float)(color >> 16 & 0xFF) / 255.0f;
        this.green = (float)(color >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(color >> 0 & 0xFF) / 255.0f;
    }

    public Material(String name, boolean flag, String id) {
        this.name = name;
        this.blockId = Material.formatBlockId(id);
        this.subType = Material.formatSubBlockId(id);
        this.enable = flag;
        int color = EllianDetectorConfiguration.COLOR_TRANSPARENT;
        if (EllianDetector.blockColors.containsKey(this.blockId + ":" + this.subType)) {
            color = EllianDetector.blockColors.get(this.blockId + ":" + this.subType);
        } else if (EllianDetector.blockColors.containsKey("" + this.blockId)) {
            color = EllianDetector.blockColors.get("" + this.blockId);
        }
        this.red = (float)(color >> 16 & 0xFF) / 255.0f;
        this.green = (float)(color >> 8 & 0xFF) / 255.0f;
        this.blue = (float)(color >> 0 & 0xFF) / 255.0f;
    }

    public int getBlockId() {
        return this.blockId;
    }

    public float getBlue() {
        return this.blue;
    }

    public int getColor() {
        int rr = (int)(this.getRed() * 255.0f) & 0xFF;
        int gg = (int)(this.getGreen() * 255.0f) & 0xFF;
        int bb = (int)(this.getBlue() * 255.0f) & 0xFF;
        return rr << 16 | gg << 8 | bb;
    }

    public int getDisplayColor() {
        int rr = (int)(this.getRed() * 255.0f) & 0xFF;
        int gg = (int)(this.getGreen() * 255.0f) & 0xFF;
        int bb = (int)(this.getBlue() * 255.0f) & 0xFF;
        return 0xFF000000 | rr << 16 | gg << 8 | bb;
    }

    public float getGreen() {
        return this.green;
    }

    public String getName() {
        return this.name;
    }

    public float getRed() {
        return this.red;
    }

    public int getSubType() {
        return this.subType;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void set(Material material) {
        this.name = material.name;
        this.enable = material.enable;
        this.red = material.red;
        this.green = material.green;
        this.blue = material.blue;
        this.blockId = material.blockId;
        this.subType = material.subType;
    }

    public void setBlockId(int blockId) {
        this.blockId = blockId;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setSubType(int subType) {
        this.subType = subType;
    }

    public String toString() {
        String out = String.valueOf(this.getName()) + "=" + this.getBlockId();
        if (this.getSubType() != 0) {
            out = String.valueOf(this.getName()) + "=" + this.getBlockId() + ":" + this.getSubType();
        }
        return out;
    }

    public String getId() {
        String id = "" + this.blockId;
        if (this.getSubType() != 0) {
            id = String.valueOf(id) + ":" + this.subType;
        }
        return id;
    }
}

