/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drops;

import java.util.Random;
import mod.lucky.Lucky;
import mod.lucky.LuckyFunction;
import mod.lucky.drops.EntityLuckyFallingBlock;
import mod.lucky.drops.LuckyDrop;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;

public class SpawnOther {
    public LuckyFunction luckyFunction = new LuckyFunction();

    public void spawnOther(World world, EntityPlayer player, LuckyDrop luckyDrop) {
        int posX = luckyDrop.getPosX();
        int posY = luckyDrop.getPosY();
        int posZ = luckyDrop.getPosZ();
        if (luckyDrop.getType().equals("block")) {
            this.setBlockWithMeta(world, posX, posY, posZ, Block.func_149684_b((String)luckyDrop.getId()), luckyDrop.getDamage());
            try {
                if (luckyDrop.getNBTTag() != null) {
                    TileEntityChest tileEntity = null;
                    if (Block.func_149684_b((String)luckyDrop.getId()) == Blocks.field_150486_ae) {
                        tileEntity = new TileEntityChest();
                        tileEntity.func_145839_a(luckyDrop.getNBTTag());
                    } else {
                        tileEntity = new TileEntity();
                        tileEntity.func_145839_a(luckyDrop.getNBTTag());
                    }
                    world.func_147455_a(posX, posY, posZ, (TileEntity)tileEntity);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (luckyDrop.getType().equals("particle")) {
            world.func_72926_e(Integer.valueOf(luckyDrop.getId()).intValue(), posX, posY, posZ, luckyDrop.getDamage());
        }
        if (luckyDrop.getType().equals("fallingblock")) {
            this.removeColumn(world, posX, posY, posZ, 7);
            EntityLuckyFallingBlock fallingBlock = new EntityLuckyFallingBlock(world, (double)posX + 0.5, (double)posY + 0.5 + 6.0, (double)posZ + 0.5, Block.func_149684_b((String)luckyDrop.getId()), luckyDrop.getDamage());
            this.spawnEntity(world, (Entity)fallingBlock);
        }
        if (luckyDrop.getType().equals("structure")) {
            String[] text;
            if (luckyDrop.getId().equals("anviltrap")) {
                this.makeCage(world, player, posX, posY, posZ, 3);
                text = new String[]{"", "Look Up", "", "", ""};
                this.makeCageSign(world, player, posX, posY, posZ, text);
                this.removeColumn(world, posX, posY, posZ, 64);
                this.setBlock(world, posX, posY + 64, posZ, Blocks.field_150467_bQ);
                this.setBlock(world, posX, posY + 63, posZ, Blocks.field_150467_bQ);
            }
            if (luckyDrop.getId().equals("lavatrap")) {
                this.makeCage(world, player, posX, posY, posZ, 4);
                text = new String[]{"", "Look Up", "", "", ""};
                this.makeCageSign(world, player, posX, posY, posZ, text);
                this.setBlock(world, posX, posY + 3, posZ, (Block)Blocks.field_150356_k);
            }
            if (luckyDrop.getId().equals("watertrap")) {
                this.makeWaterCage(world, player, posX, posY, posZ, 3);
                this.setBlock(world, posX, posY + 1, posZ, (Block)Blocks.field_150358_i);
            }
            if (luckyDrop.getId().equals("pittrap")) {
                this.makeRect(world, player, posX - 1, posY - 60, posZ - 1, 3, 60, 3, Blocks.field_150350_a);
                this.makeRect(world, player, posX - 1, posY - 59, posZ - 1, 3, 1, 3, (Block)Blocks.field_150356_k);
                this.makeRect(world, player, posX - 1, posY - 58, posZ - 1, 3, 1, 3, Blocks.field_150321_G);
            }
            if (luckyDrop.getId().equals("fort")) {
                this.makeFort(world, player, posX, posY, posZ);
            }
            if (luckyDrop.getId().equals("temple")) {
                this.makeTemple(world, player, posX, posY, posZ);
            }
            if (luckyDrop.getId().equals("bedrock")) {
                this.setBlock(world, luckyDrop.getPosX(), luckyDrop.getPosY(), luckyDrop.getPosZ(), Blocks.field_150357_h);
                text = new String[]{"", "Well, there's", "your problem.", "", ""};
                this.makeSign(world, posX, posY + 1, posZ, Blocks.field_150472_an, LuckyFunction.getPlayerDirection(player, 16) + 8, text);
            }
            if (luckyDrop.getId().equals("explosion")) {
                world.func_72876_a(null, (double)posX, (double)posY, (double)posZ, (float)(luckyDrop.getDamage() * 2), true);
            }
            if (luckyDrop.getId().equals("chest")) {
                Random rand = new Random();
                int playerDirection = LuckyFunction.getPlayerDirection(player, 4);
                this.setBlock(world, posX, posY, posZ, (Block)Blocks.field_150486_ae);
                switch (playerDirection) {
                    case 0: {
                        this.setBlockMeta(world, posX, posY, posZ, 2);
                        break;
                    }
                    case 1: {
                        this.setBlockMeta(world, posX, posY, posZ, 5);
                        break;
                    }
                    case 2: {
                        this.setBlockMeta(world, posX, posY, posZ, 3);
                        break;
                    }
                    case 3: {
                        this.setBlockMeta(world, posX, posY, posZ, 4);
                    }
                }
                TileEntityChest tileentitychest = (TileEntityChest)world.func_147438_o(posX, posY, posZ);
                if (tileentitychest != null && tileentitychest != null) {
                    try {
                        if (luckyDrop.getNBTTag() != null) {
                            if (luckyDrop.getNBTTag().func_74764_b("type")) {
                                String chestGenType = luckyDrop.getNBTTag().func_74779_i("type");
                                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])ChestGenHooks.getItems((String)chestGenType, (Random)rand), (IInventory)tileentitychest, (int)ChestGenHooks.getCount((String)chestGenType, (Random)rand));
                            } else {
                                int max;
                                NBTTagList allItemTags = luckyDrop.getNBTTag().func_150295_c("items", 10);
                                int min = luckyDrop.getNBTTag().func_74762_e("min");
                                int amount = min < (max = luckyDrop.getNBTTag().func_74762_e("max")) ? min + rand.nextInt(max - min) : max;
                                WeightedRandomChestContent[] allItems = new WeightedRandomChestContent[allItemTags.func_74745_c()];
                                for (int a = 0; a < allItemTags.func_74745_c(); ++a) {
                                    ItemStack item;
                                    NBTTagCompound currItemTag = allItemTags.func_150305_b(a);
                                    int itemId = currItemTag.func_74762_e("id");
                                    int itemDamage = currItemTag.func_74762_e("damage");
                                    int minAmount = currItemTag.func_74762_e("minAmount");
                                    int maxAmount = currItemTag.func_74762_e("maxAmount");
                                    int weight = currItemTag.func_74762_e("weight");
                                    if (minAmount == 0) {
                                        minAmount = 1;
                                    }
                                    if (maxAmount == 0) {
                                        maxAmount = 1;
                                    }
                                    if (currItemTag.func_74764_b("item")) {
                                        NBTTagCompound itemStackTag = currItemTag.func_74775_l("item");
                                        item = ItemStack.func_77949_a((NBTTagCompound)itemStackTag);
                                    } else {
                                        item = new ItemStack(this.getItem(itemId), 1, itemDamage);
                                    }
                                    allItems[a] = new WeightedRandomChestContent(item, minAmount, maxAmount, weight);
                                }
                                WeightedRandomChestContent.func_76293_a((Random)rand, (WeightedRandomChestContent[])allItems, (IInventory)tileentitychest, (int)amount);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public int getEdgeDistance(int firstPos, int newPos) {
        int distance = newPos - firstPos;
        if (distance < 0) {
            distance *= -1;
        }
        return distance;
    }

    public boolean isEdgeSingleSide(int firstPos, int newPos, int edgeDistance) {
        int distance = newPos - firstPos;
        if (distance < 0) {
            distance *= -1;
        }
        return distance == edgeDistance;
    }

    public boolean isEdge(int firstPosX, int firstPosZ, int newPosX, int newPosZ, int edgeDistance) {
        if (this.getEdgeDistance(firstPosX, newPosX) == edgeDistance && this.getEdgeDistance(firstPosZ, newPosZ) <= edgeDistance) {
            return true;
        }
        return this.getEdgeDistance(firstPosZ, newPosZ) == edgeDistance && this.getEdgeDistance(firstPosX, newPosX) <= edgeDistance;
    }

    public boolean isCenterEdge(int firstPosX, int firstPosZ, int newPosX, int newPosZ, int edgeDistance) {
        if (this.getEdgeDistance(firstPosX, newPosX) == edgeDistance && this.getEdgeDistance(firstPosZ, newPosZ) == 0) {
            return true;
        }
        return this.getEdgeDistance(firstPosZ, newPosZ) == edgeDistance && this.getEdgeDistance(firstPosX, newPosX) == 0;
    }

    public boolean isCorner(int firstPosX, int firstPosZ, int newPosX, int newPosZ, int cornerDistance) {
        return this.getEdgeDistance(firstPosX, newPosX) == cornerDistance && this.getEdgeDistance(firstPosZ, newPosZ) == cornerDistance;
    }

    public void makeRect(World world, EntityPlayer player, int posX, int posY, int posZ, int length, int height, int width, Block block) {
        for (int y = posY; y < posY + height; ++y) {
            for (int x = posX; x < posX + length; ++x) {
                for (int z = posZ; z < posZ + width; ++z) {
                    this.setBlock(world, x, y, z, block);
                }
            }
        }
    }

    public void makeCage(World world, EntityPlayer player, int posX, int posY, int posZ, int height) {
        for (int y = posY - 1; y < posY + height; ++y) {
            for (int x = posX - 1; x < posX + 2; ++x) {
                for (int z = posZ - 1; z < posZ + 2; ++z) {
                    if (y == posY - 1) {
                        this.setBlock(world, x, y, z, Blocks.field_150417_aV);
                        continue;
                    }
                    if (this.isEdge(posX, posZ, x, z, 1)) {
                        this.setBlock(world, x, y, z, Blocks.field_150411_aY);
                        continue;
                    }
                    this.setBlock(world, x, y, z, Blocks.field_150350_a);
                }
            }
        }
    }

    public void makeWaterCage(World world, EntityPlayer player, int posX, int posY, int posZ, int height) {
        for (int y = posY - 1; y < posY + height; ++y) {
            for (int x = posX - 1; x < posX + 2; ++x) {
                for (int z = posZ - 1; z < posZ + 2; ++z) {
                    if (y == posY - 1) {
                        this.setBlock(world, x, y, z, Blocks.field_150417_aV);
                        continue;
                    }
                    if (this.isEdge(posX, posZ, x, z, 1) || y == posY + height - 1) {
                        if (y == posY + 1) {
                            this.setBlock(world, x, y, z, Blocks.field_150359_w);
                            continue;
                        }
                        this.setBlock(world, x, y, z, Blocks.field_150343_Z);
                        continue;
                    }
                    this.setBlock(world, x, y, z, Blocks.field_150350_a);
                }
            }
        }
    }

    public void makeFort(World world, EntityPlayer player, int posX, int posY, int posZ) {
        for (int y = posY - 1; y < posY + 3; ++y) {
            for (int x = posX - 2; x < posX + 3; ++x) {
                for (int z = posZ - 2; z < posZ + 3; ++z) {
                    if (y == posY - 1) {
                        this.setBlock(world, x, y, z, Blocks.field_150322_A);
                    }
                    if (y == posY) {
                        if (this.isEdge(posX, posZ, x, z, 2)) {
                            this.setBlockWithMeta(world, x, y, z, Blocks.field_150322_A, 2);
                        } else if (this.isCorner(posX, posZ, x, z, 1)) {
                            this.setBlock(world, x, y, z, Lucky.lucky_block);
                        } else {
                            this.setBlock(world, x, y, z, Blocks.field_150350_a);
                        }
                    }
                    if (y == posY + 1) {
                        if (this.isEdge(posX, posZ, x, z, 2)) {
                            this.setBlockWithMeta(world, x, y, z, Blocks.field_150322_A, 2);
                        } else {
                            this.setBlock(world, x, y, z, Blocks.field_150350_a);
                        }
                    }
                    if (y != posY + 2) continue;
                    if (this.isCorner(posX, posZ, x, z, 2)) {
                        this.setBlock(world, x, y, z, Blocks.field_150340_R);
                        continue;
                    }
                    this.setBlock(world, x, y, z, Blocks.field_150350_a);
                }
            }
        }
    }

    public void makeTemple(World world, EntityPlayer player, int posX, int posY, int posZ) {
        for (int y = posY - 1; y < posY + 5; ++y) {
            for (int x = posX - 3; x < posX + 4; ++x) {
                for (int z = posZ - 3; z < posZ + 4; ++z) {
                    if (y == posY - 1) {
                        this.setBlock(world, x, y, z, Blocks.field_150322_A);
                    }
                    if (y == posY) {
                        if (this.isEdge(posX, posZ, x, z, 3)) {
                            this.setBlockWithMeta(world, x, y, z, Blocks.field_150322_A, 2);
                        } else if (this.isCorner(posX, posZ, x, z, 2)) {
                            this.setBlock(world, x, y, z, Lucky.lucky_block);
                        } else {
                            this.setBlock(world, x, y, z, Blocks.field_150350_a);
                        }
                    }
                    if (y == posY + 1) {
                        if (this.isEdge(posX, posZ, x, z, 2) || this.isCorner(posX, posZ, x, z, 3)) {
                            this.setBlockWithMeta(world, x, y, z, Blocks.field_150322_A, 2);
                        } else {
                            this.setBlock(world, x, y, z, Blocks.field_150350_a);
                        }
                    }
                    if (y == posY + 2) {
                        if (this.isEdge(posX, posZ, x, z, 1) || this.isCorner(posX, posZ, x, z, 3)) {
                            this.setBlockWithMeta(world, x, y, z, Blocks.field_150322_A, 2);
                        } else {
                            this.setBlock(world, x, y, z, Blocks.field_150350_a);
                        }
                    }
                    if (y != posY + 3) continue;
                    if (this.isEdge(posX, posZ, x, z, 0) || this.isCorner(posX, posZ, x, z, 3)) {
                        this.setBlock(world, x, y, z, Blocks.field_150340_R);
                        continue;
                    }
                    this.setBlock(world, x, y, z, Blocks.field_150350_a);
                }
            }
        }
        int playerDirection = LuckyFunction.getPlayerDirection(player, 4);
        switch (playerDirection) {
            case 0: {
                this.setBlockWithMeta(world, posX, posY + 1, posZ - 1, Blocks.field_150478_aa, 3);
                break;
            }
            case 1: {
                this.setBlockWithMeta(world, posX + 1, posY + 1, posZ, Blocks.field_150478_aa, 2);
                break;
            }
            case 2: {
                this.setBlockWithMeta(world, posX, posY + 1, posZ + 1, Blocks.field_150478_aa, 4);
                break;
            }
            case 3: {
                this.setBlockWithMeta(world, posX - 1, posY + 1, posZ, Blocks.field_150478_aa, 1);
            }
        }
    }

    public void makeCageSign(World world, EntityPlayer player, int posX, int posY, int posZ, String[] text) {
        int playerDirection = LuckyFunction.getPlayerDirection(player, 4);
        switch (playerDirection) {
            case 0: {
                this.setBlock(world, posX, posY - 1, posZ + 2, Blocks.field_150417_aV);
                this.makeSign(world, posX, posY, posZ + 2, Blocks.field_150472_an, 8, text);
                this.setBlock(world, posX, posY + 1, posZ + 2, Blocks.field_150350_a);
                break;
            }
            case 1: {
                this.setBlock(world, posX - 2, posY - 1, posZ, Blocks.field_150417_aV);
                this.makeSign(world, posX - 2, posY, posZ, Blocks.field_150472_an, 12, text);
                this.setBlock(world, posX - 2, posY + 1, posZ, Blocks.field_150350_a);
                break;
            }
            case 2: {
                this.setBlock(world, posX, posY - 1, posZ - 2, Blocks.field_150417_aV);
                this.makeSign(world, posX, posY, posZ - 2, Blocks.field_150472_an, 0, text);
                this.setBlock(world, posX, posY + 1, posZ - 2, Blocks.field_150350_a);
                break;
            }
            case 3: {
                this.setBlock(world, posX + 2, posY - 1, posZ, Blocks.field_150417_aV);
                this.makeSign(world, posX + 2, posY, posZ, Blocks.field_150472_an, 4, text);
                this.setBlock(world, posX + 2, posY + 1, posZ, Blocks.field_150350_a);
            }
        }
    }

    public void makeSign(World world, int posX, int posY, int posZ, Block block, int meta, String[] text) {
        this.setBlockWithMeta(world, posX, posY, posZ, block, meta);
        TileEntitySign signEntity = new TileEntitySign();
        for (int a = 0; a < 4; ++a) {
            signEntity.field_145915_a[a] = text[a];
        }
        world.func_147455_a(posX, posY, posZ, (TileEntity)signEntity);
    }

    public void removeColumn(World world, int posX, int posY, int posZ, int height) {
        for (int y = posY; y < posY + height; ++y) {
            this.setBlock(world, posX, y, posZ, Blocks.field_150350_a);
        }
    }

    public boolean setBlock(World world, int posX, int posY, int posZ, Block block) {
        try {
            world.func_147465_d(posX, posY, posZ, block, 0, 3);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBlockWithMeta(World world, int posX, int posY, int posZ, Block block, int meta) {
        try {
            world.func_147465_d(posX, posY, posZ, block, meta, 3);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setBlockMeta(World world, int posX, int posY, int posZ, int meta) {
        try {
            world.func_72921_c(posX, posY, posZ, meta, 3);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean spawnEntity(World world, Entity entity) {
        try {
            world.func_72838_d(entity);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Item getItem(String id) {
        return (Item)Item.field_150901_e.func_82594_a(id);
    }

    public Item getItem(int id) {
        return (Item)Item.field_150901_e.func_148754_a(id);
    }
}

