/*
 * Decompiled with CFR 0.152.
 */
package plugins.Incomprehendable.SDJ.listeners;

import java.util.ArrayList;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import plugins.Incomprehendable.SDJ.SDJ;
import plugins.Incomprehendable.SDJ.listeners.OnMove;
import plugins.Incomprehendable.SDJ.utilities.ParticleEffects;

public class OnPlayerToggleFlightEvent
implements Listener {
    private final SDJ plugin;
    public static ArrayList<String> playersWhoDoubleJumped = new ArrayList();
    public static ArrayList<String> playersWhoCannotDoubleJump = new ArrayList();

    public OnPlayerToggleFlightEvent(SDJ plugin) {
        this.plugin = plugin;
    }

    public static ArrayList<String> getWhoDoubleJumped() {
        return playersWhoDoubleJumped;
    }

    public static ArrayList<String> getWhoCannotDoubleJump() {
        return playersWhoCannotDoubleJump;
    }

    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent event) {
        if (!event.isCancelled()) {
            double velocity = this.plugin.getConfig().getDouble("Doubles.velocity");
            double height = this.plugin.getConfig().getDouble("Doubles.height");
            Player ply = event.getPlayer();
            final Location loc = ply.getLocation();
            int cooldown = this.plugin.getConfig().getInt("Integers.doubleJumpCooldown");
            if (ply.hasPermission("sdj.use") && ply.getGameMode() != GameMode.CREATIVE && OnMove.getPlayersWhoCanDoubleJump().contains(ply.getName()) && !playersWhoCannotDoubleJump.contains(ply.getName())) {
                event.setCancelled(true);
                ply.setAllowFlight(false);
                ply.setFlying(false);
                ply.setVelocity(loc.getDirection().multiply(velocity).setY(height));
                playersWhoDoubleJumped.add(ply.getName());
                if (this.plugin.getConfig().getBoolean("Booleans.playSoundOnDoubleJump")) {
                    loc.getWorld().playSound(loc, Sound.ZOMBIE_INFECT, 1.0f, 2.0f);
                }
                if (this.plugin.getConfig().getBoolean("Booleans.smokeEffectOnDoubleJump")) {
                    try {
                        ParticleEffects.SMOKE.sendToPlayer(ply, loc, 1.0f, 1.0f, 1.0f, 1.0f, 5);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new BukkitRunnable(){

                        public void run() {
                            if (OnPlayerToggleFlightEvent.this.plugin.getConfig().getBoolean("Booleans.playSoundWhenYouCanDoubleJump", true)) {
                                loc.getWorld().playSound(loc, Sound.LEVEL_UP, 1.0f, 2.0f);
                            }
                        }
                    }, (long)cooldown);
                }
            }
        }
    }
}

