/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.modularpots.item.crafting;

import com.jaquadro.minecraft.modularpots.ModBlocks;
import com.jaquadro.minecraft.modularpots.ModItems;
import com.jaquadro.minecraft.modularpots.ModularPots;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class PotteryManager {
    private static final PotteryManager instance = new PotteryManager();
    private List<ItemStack> patternList = new ArrayList<ItemStack>();
    private Map<ItemStack, Integer> targetList = new HashMap<ItemStack, Integer>();

    public static PotteryManager instance() {
        return instance;
    }

    private PotteryManager() {
        for (int i = 1; i < 256; ++i) {
            if (!ModularPots.config.hasPattern(i)) continue;
            this.registerPattern(new ItemStack((Item)ModItems.potteryPattern, 1, i));
        }
        this.registerTarget(new ItemStack((Block)ModBlocks.largePot, 1, 1));
    }

    public void registerPattern(ItemStack itemStack) {
        if (itemStack != null) {
            this.patternList.add(itemStack);
        }
    }

    public void registerTarget(ItemStack itemStack) {
        if (itemStack != null) {
            this.registerTarget(itemStack, 8);
        }
    }

    public void registerTarget(ItemStack itemStack, int patternDataShift) {
        this.targetList.put(itemStack, patternDataShift);
    }

    public boolean isRegisteredPattern(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (ItemStack item : this.patternList) {
            if (item.func_77973_b() != itemStack.func_77973_b() || item.func_77960_j() != itemStack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public boolean isRegisteredTarget(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (ItemStack item : this.targetList.keySet()) {
            if (item.func_77973_b() != itemStack.func_77973_b() || item.func_77960_j() != itemStack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getStampResult(ItemStack pattern, ItemStack target) {
        if (target == null || !this.isRegisteredPattern(pattern)) {
            return null;
        }
        for (Map.Entry<ItemStack, Integer> entry : this.targetList.entrySet()) {
            ItemStack item = entry.getKey();
            if (item.func_77973_b() != target.func_77973_b() || item.func_77960_j() != target.func_77960_j()) continue;
            ItemStack result = target.func_77946_l();
            result.field_77994_a = 1;
            result.func_77964_b(target.func_77960_j() | pattern.func_77960_j() << entry.getValue());
            return result;
        }
        return null;
    }
}

