/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.core.ServerUtils;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.ClientHandler;
import codechicken.nei.NEIActions;
import codechicken.nei.NEIServerConfig;
import codechicken.nei.PlayerSave;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;

public class NEIServerUtils {
    public static boolean isRaining(World world) {
        return world.func_72912_H().func_76059_o();
    }

    public static void toggleRaining(World world, boolean notify) {
        boolean raining;
        boolean bl = raining = !world.func_72896_J();
        if (!raining) {
            ((WorldServer)world).field_73011_w.resetRainAndThunder();
        } else {
            world.func_72912_H().func_76084_b(!NEIServerUtils.isRaining(world));
        }
        if (notify) {
            ServerUtils.sendChatToAll((IChatComponent)new ChatComponentTranslation("nei.chat.rain." + (raining ? "on" : "off"), new Object[0]));
        }
    }

    public static void healPlayer(EntityPlayer player) {
        player.func_70691_i(20.0f);
        player.func_71024_bL().func_75122_a(20, 1.0f);
        player.func_70066_B();
    }

    public static long getTime(World world) {
        return world.func_72912_H().func_76073_f();
    }

    public static void setTime(long l, World world) {
        world.func_72912_H().func_76068_b(l);
    }

    public static void setSlotContents(EntityPlayer player, int slot, ItemStack item, boolean containerInv) {
        if (slot == -999) {
            player.field_71071_by.func_70437_b(item);
        } else if (containerInv) {
            player.field_71070_bA.func_75141_a(slot, item);
        } else {
            player.field_71071_by.func_70299_a(slot, item);
        }
    }

    public static ItemStack getSlotContents(EntityPlayer player, int slot, boolean containerInv) {
        if (slot == -999) {
            return player.field_71071_by.func_70445_o();
        }
        if (containerInv) {
            return player.field_71070_bA.func_75139_a(slot).func_75211_c();
        }
        return player.field_71071_by.func_70301_a(slot);
    }

    public static void deleteAllItems(EntityPlayerMP player) {
        for (Slot slot : player.field_71070_bA.field_75151_b) {
            slot.func_75215_d(null);
        }
        player.func_71110_a(player.field_71070_bA, player.field_71070_bA.func_75138_a());
    }

    public static void setHourForward(World world, int hour, boolean notify) {
        long day = NEIServerUtils.getTime(world) / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        NEIServerUtils.setTime(newTime, world);
        if (notify) {
            ServerUtils.sendChatToAll((IChatComponent)new ChatComponentTranslation("nei.chat.time", new Object[]{NEIServerUtils.getTime(world) / 24000L, hour}));
        }
    }

    public static void advanceDisabledTimes(World world) {
        int hour;
        int dim = CommonUtils.getDimension((World)world);
        int newhour = hour = (int)(NEIServerUtils.getTime(world) % 24000L) / 1000;
        while (NEIServerConfig.isActionDisabled(dim, NEIActions.timeZones[newhour / 6])) {
            newhour = (newhour / 6 + 1) % 4 * 6;
        }
        if (newhour != hour) {
            NEIServerUtils.setHourForward(world, newhour, false);
        }
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        return InventoryUtils.insertItem((IInventory)player.field_71071_by, (ItemStack)itemstack, (boolean)true) == 0;
    }

    public static void sendNotice(ICommandSender sender, IChatComponent msg, String permission) {
        ChatComponentTranslation notice = new ChatComponentTranslation("chat.type.admin", new Object[]{sender.func_70005_c_(), msg.func_150259_f()});
        notice.func_150256_b().func_150238_a(EnumChatFormatting.GRAY).func_150217_b(Boolean.valueOf(true));
        if (NEIServerConfig.canPlayerPerformAction("CONSOLE", permission)) {
            MinecraftServer.func_71276_C().func_145747_a((IChatComponent)notice);
        }
        for (EntityPlayer p : ServerUtils.getPlayers()) {
            if (p == sender) {
                p.func_146105_b(msg);
                continue;
            }
            if (!NEIServerConfig.canPlayerPerformAction(p.func_70005_c_(), permission)) continue;
            p.func_146105_b((IChatComponent)notice);
        }
    }

    public static boolean areStacksSameType(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return stack1 == stack2;
        }
        return InventoryUtils.canStack((ItemStack)stack1, (ItemStack)stack2);
    }

    public static boolean areStacksSameTypeCrafting(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        return stack1.func_77973_b() == stack2.func_77973_b() && (stack1.func_77960_j() == stack2.func_77960_j() || stack1.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == Short.MAX_VALUE || stack1.func_77973_b().func_77645_m());
    }

    public static int compareStacks(ItemStack stack1, ItemStack stack2) {
        if (stack1 == stack2) {
            return 0;
        }
        if (stack1 == null || stack2 == null) {
            return stack1 == null ? -1 : 1;
        }
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return Item.func_150891_b((Item)stack1.func_77973_b()) - Item.func_150891_b((Item)stack2.func_77973_b());
        }
        if (stack1.field_77994_a != stack2.field_77994_a) {
            return stack1.field_77994_a - stack2.field_77994_a;
        }
        return stack1.func_77960_j() - stack2.func_77960_j();
    }

    public static boolean areStacksIdentical(ItemStack stack1, ItemStack stack2) {
        return NEIServerUtils.compareStacks(stack1, stack2) == 0;
    }

    public static IChatComponent setColour(IChatComponent msg, EnumChatFormatting colour) {
        msg.func_150256_b().func_150238_a(colour);
        return msg;
    }

    public static void givePlayerItem(EntityPlayerMP player, ItemStack stack, boolean infinite, boolean doGive) {
        if (stack.func_77973_b() == null) {
            player.func_146105_b(NEIServerUtils.setColour((IChatComponent)new ChatComponentTranslation("nei.chat.give.noitem", new Object[0]), EnumChatFormatting.WHITE));
            return;
        }
        int given = stack.field_77994_a;
        if (doGive) {
            if (infinite) {
                player.field_71071_by.func_70441_a(stack);
            } else {
                given -= InventoryUtils.insertItem((IInventory)player.field_71071_by, (ItemStack)stack, (boolean)false);
            }
        }
        NEIServerUtils.sendNotice((ICommandSender)player, (IChatComponent)new ChatComponentTranslation("commands.give.success", new Object[]{stack.func_151000_E(), infinite ? "\u221e" : Integer.toString(given), player.func_70005_c_()}), "notify-item");
        player.field_71070_bA.func_75142_b();
    }

    public static ItemStack copyStack(ItemStack itemstack, int i) {
        if (itemstack == null) {
            return null;
        }
        itemstack.field_77994_a += i;
        return itemstack.func_77979_a(i);
    }

    public static ItemStack copyStack(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        return NEIServerUtils.copyStack(itemstack, itemstack.field_77994_a);
    }

    public static void toggleMagnetMode(EntityPlayerMP player) {
        PlayerSave playerSave;
        playerSave.enableAction("magnet", !(playerSave = NEIServerConfig.forPlayer(player.func_70005_c_())).isActionEnabled("magnet"));
    }

    public static int getCreativeMode(EntityPlayerMP player) {
        if (NEIServerConfig.forPlayer(player.func_70005_c_()).isActionEnabled("creative+")) {
            return 2;
        }
        if (player.field_71134_c.func_73083_d()) {
            return 1;
        }
        if (player.field_71134_c.func_73081_b().func_82752_c()) {
            return 3;
        }
        return 0;
    }

    public static WorldSettings.GameType getGameType(int mode) {
        switch (mode) {
            case 0: {
                return WorldSettings.GameType.SURVIVAL;
            }
            case 1: 
            case 2: {
                return WorldSettings.GameType.CREATIVE;
            }
            case 3: {
                return WorldSettings.GameType.ADVENTURE;
            }
        }
        return null;
    }

    public static void setGamemode(EntityPlayerMP player, int mode) {
        if (mode < 0 || mode >= NEIActions.gameModes.length || NEIActions.nameActionMap.containsKey(NEIActions.gameModes[mode]) && !NEIServerConfig.canPlayerPerformAction(player.func_70005_c_(), NEIActions.gameModes[mode])) {
            return;
        }
        player.field_71134_c.func_73076_a(NEIServerUtils.getGameType(mode));
        NEIServerConfig.forPlayer(player.func_70005_c_()).enableAction("creative+", mode == 2);
        new PacketCustom((Object)"NEI", 14).writeByte(mode).sendToPlayer((EntityPlayer)player);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("nei.chat.gamemode." + mode, new Object[0]));
    }

    public static void cycleCreativeInv(EntityPlayerMP player, int steps) {
        int row;
        int row2;
        InventoryPlayer inventory = player.field_71071_by;
        ItemStack[][] slots = new ItemStack[10][9];
        PlayerSave playerSave = NEIServerConfig.forPlayer(player.func_70005_c_());
        System.arraycopy(inventory.field_70462_a, 0, slots[9], 0, 9);
        for (row2 = 0; row2 < 3; ++row2) {
            System.arraycopy(inventory.field_70462_a, (row2 + 1) * 9, slots[row2 + 6], 0, 9);
        }
        for (row2 = 0; row2 < 6; ++row2) {
            System.arraycopy(playerSave.creativeInv, row2 * 9, slots[row2], 0, 9);
        }
        ItemStack[][] newslots = new ItemStack[10][];
        for (row = 0; row < 10; ++row) {
            newslots[(row + steps + 10) % 10] = slots[row];
        }
        System.arraycopy(newslots[9], 0, inventory.field_70462_a, 0, 9);
        for (row = 0; row < 3; ++row) {
            System.arraycopy(newslots[row + 6], 0, inventory.field_70462_a, (row + 1) * 9, 9);
        }
        for (row = 0; row < 6; ++row) {
            System.arraycopy(newslots[row], 0, playerSave.creativeInv, row * 9, 9);
        }
        playerSave.setDirty();
    }

    public static List<int[]> getEnchantments(ItemStack itemstack) {
        NBTTagList nbttaglist;
        ArrayList<int[]> arraylist = new ArrayList<int[]>();
        if (itemstack != null && (nbttaglist = itemstack.func_77986_q()) != null) {
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound tag = nbttaglist.func_150305_b(i);
                arraylist.add(new int[]{tag.func_74765_d("id"), tag.func_74765_d("lvl")});
            }
        }
        return arraylist;
    }

    public static boolean stackHasEnchantment(ItemStack itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantmentLevel(ItemStack itemstack, int e) {
        List<int[]> allenchantments = NEIServerUtils.getEnchantments(itemstack);
        for (int[] ai : allenchantments) {
            if (ai[0] != e) continue;
            return ai[1];
        }
        return -1;
    }

    public static boolean doesEnchantmentConflict(List<int[]> enchantments, Enchantment e) {
        for (int[] ai : enchantments) {
            if (e.func_77326_a(Enchantment.field_77331_b[ai[0]])) continue;
            return true;
        }
        return false;
    }

    public static RuntimeException throwCME(String msg) {
        if (CommonUtils.isClient()) {
            return ClientHandler.throwCME(msg);
        }
        throw new RuntimeException(msg);
    }

    public static ItemStack[] extractRecipeItems(Object obj) {
        if (obj instanceof ItemStack) {
            return new ItemStack[]{(ItemStack)obj};
        }
        if (obj instanceof ItemStack[]) {
            return (ItemStack[])obj;
        }
        if (obj instanceof List) {
            return ((List)obj).toArray(new ItemStack[0]);
        }
        throw new ClassCastException("not an ItemStack, ItemStack[] or List<ItemStack?");
    }

    public static List<Integer> getRange(final int start, final int end) {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int index) {
                return start + index;
            }

            @Override
            public int size() {
                return end - start;
            }
        };
    }

    public static StringBuilder fixTrailingCommaList(StringBuilder sb) {
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb;
    }
}

