/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.nei.FastTransferManager;
import codechicken.nei.ItemList;
import codechicken.nei.LangProxy;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIActions;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.ItemInfo;
import com.google.common.collect.Iterables;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import org.lwjgl.input.Keyboard;

public class NEIClientUtils
extends NEIServerUtils {
    public static LangProxy lang = new LangProxy("nei");

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static String translate(String key, Object ... params) {
        return lang.format(key, params);
    }

    public static void printChatMessage(IChatComponent msg) {
        if (NEIClientUtils.mc().field_71456_v != null) {
            NEIClientUtils.mc().field_71456_v.func_146158_b().func_146227_a(msg);
        }
    }

    public static void deleteHeldItem() {
        NEIClientUtils.deleteSlotStack(-999);
    }

    public static void dropHeldItem() {
        NEIClientUtils.mc().field_71442_b.func_78753_a(((GuiContainer)NEIClientUtils.mc().field_71462_r).field_147002_h.field_75152_c, -999, 0, 0, (EntityPlayer)NEIClientUtils.mc().field_71439_g);
    }

    public static void deleteSlotStack(int slotNumber) {
        NEIClientUtils.setSlotContents(slotNumber, null, true);
    }

    public static void decreaseSlotStack(int slotNumber) {
        ItemStack stack;
        ItemStack itemStack = stack = slotNumber == -999 ? NEIClientUtils.getHeldItem() : NEIClientUtils.mc().field_71439_g.field_71070_bA.func_75139_a(slotNumber).func_75211_c();
        if (stack == null) {
            return;
        }
        if (stack.field_77994_a == 1) {
            NEIClientUtils.deleteSlotStack(slotNumber);
        } else {
            stack = stack.func_77946_l();
            --stack.field_77994_a;
            NEIClientUtils.setSlotContents(slotNumber, stack, true);
        }
    }

    public static void deleteEverything() {
        NEICPH.sendDeleteAllItems();
    }

    public static void deleteItemsOfType(ItemStack type) {
        Container c = NEIClientUtils.getGuiContainer().field_147002_h;
        for (int i = 0; i < c.field_75151_b.size(); ++i) {
            ItemStack stack;
            Slot slot = c.func_75139_a(i);
            if (slot == null || (stack = slot.func_75211_c()) == null || stack.func_77973_b() != type.func_77973_b() || stack.func_77960_j() != type.func_77960_j()) continue;
            NEIClientUtils.setSlotContents(i, null, true);
            slot.func_75215_d(null);
        }
    }

    public static ItemStack getHeldItem() {
        return NEIClientUtils.mc().field_71439_g.field_71071_by.func_70445_o();
    }

    public static void setSlotContents(int slot, ItemStack item, boolean containerInv) {
        NEICPH.sendSetSlot(slot, item, containerInv);
        if (slot == -999) {
            NEIClientUtils.mc().field_71439_g.field_71071_by.func_70437_b(item);
        }
    }

    public static void cheatItem(ItemStack typeStack, int button, int mode) {
        if (!NEIClientConfig.canPerformAction("item") || typeStack.func_77942_o() && !NEIClientConfig.canPerformAction("itemnbt")) {
            return;
        }
        if (mode == -1 && button == 0 && NEIClientUtils.shiftKey()) {
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                ItemStack stack;
                if (!handler.canHandleItem(typeStack) || (stack = handler.getInfiniteItem(typeStack)) == null) continue;
                NEIClientUtils.giveStack(stack, stack.field_77994_a, true);
                return;
            }
            NEIClientUtils.cheatItem(typeStack, button, 0);
        } else if (button == 1) {
            NEIClientUtils.giveStack(typeStack, 1);
        } else if (mode == 1 && typeStack.field_77994_a < typeStack.func_77976_d()) {
            NEIClientUtils.giveStack(typeStack, typeStack.func_77976_d() - typeStack.field_77994_a);
        } else {
            int amount = NEIClientConfig.getItemQuantity();
            if (amount == 0) {
                amount = typeStack.func_77976_d();
            }
            NEIClientUtils.giveStack(typeStack, amount);
        }
    }

    public static void giveStack(ItemStack itemstack) {
        NEIClientUtils.giveStack(itemstack, itemstack.field_77994_a);
    }

    public static void giveStack(ItemStack itemstack, int i) {
        NEIClientUtils.giveStack(itemstack, i, false);
    }

    public static void giveStack(ItemStack itemstack, int i, boolean infinite) {
        ItemStack itemstack1 = NEIClientUtils.copyStack(itemstack, i);
        if (NEIClientConfig.hasSMPCounterPart()) {
            ItemStack typestack = NEIClientUtils.copyStack(itemstack1, 1);
            if (!infinite && !NEIClientUtils.canItemFitInInventory((EntityPlayer)NEIClientUtils.mc().field_71439_g, itemstack1) && NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
                GuiContainer gui = NEIClientUtils.getGuiContainer();
                LinkedList<Iterable<Integer>> handlerSlots = new LinkedList<Iterable<Integer>>();
                for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                    handlerSlots.add(handler.getItemSpawnSlots(gui, typestack));
                }
                int increment = typestack.func_77976_d();
                int given = 0;
                Iterator i$ = Iterables.concat(handlerSlots).iterator();
                while (i$.hasNext()) {
                    int slotNo = (Integer)i$.next();
                    Slot slot = gui.field_147002_h.func_75139_a(slotNo);
                    if (!slot.func_75214_a(typestack) || !InventoryUtils.canStack((ItemStack)slot.func_75211_c(), (ItemStack)typestack)) continue;
                    int qty = Math.min(itemstack1.field_77994_a - given, increment);
                    int current = slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0;
                    qty = Math.min(qty, slot.func_75219_a() - current);
                    ItemStack newStack = NEIClientUtils.copyStack(typestack, qty + current);
                    slot.func_75215_d(newStack);
                    NEIClientUtils.setSlotContents(slotNo, newStack, true);
                    if ((given += qty) < itemstack1.field_77994_a) continue;
                    break;
                }
                if (given > 0) {
                    NEICPH.sendGiveItem(NEIClientUtils.copyStack(typestack, given), false, false);
                }
            } else {
                NEICPH.sendGiveItem(itemstack1, infinite, true);
            }
        } else {
            int qty;
            for (int given = 0; given < itemstack1.field_77994_a; given += qty) {
                qty = Math.min(itemstack1.field_77994_a - given, itemstack1.func_77976_d());
                NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.item"), NEIClientUtils.mc().field_71439_g.func_70005_c_(), itemstack1.func_77973_b().func_77658_a(), qty, itemstack1.func_77960_j());
            }
        }
    }

    public static void updateUnlimitedItems() {
        ItemStack itemstack = NEIClientUtils.getHeldItem();
        if (itemstack != null && itemstack.field_77994_a > 64) {
            itemstack.field_77994_a = 1;
        }
        ItemStack[] aitemstack = NEIClientUtils.mc().field_71439_g.field_71071_by.field_70462_a;
        for (int slot = 0; slot < aitemstack.length; ++slot) {
            ItemStack itemstack1 = aitemstack[slot];
            if (itemstack1 == null) continue;
            if (itemstack1.field_77994_a < 0 || itemstack1.field_77994_a > 64) {
                itemstack1.field_77994_a = 111;
            }
            if (itemstack1.func_77960_j() <= -32000 || itemstack1.func_77960_j() >= -30000) continue;
            itemstack1.func_77964_b(-32000);
        }
    }

    public static boolean itemListContains(ItemStack test) {
        for (ItemStack stack : ItemList.itemMap.get((Object)test.func_77973_b())) {
            if (!NEIClientUtils.areStacksIdentical(stack, test)) continue;
            return true;
        }
        return false;
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        return InventoryUtils.getInsertibleQuantity((InventoryRange)new InventoryRange((IInventory)player.field_71071_by, 0, 36), (ItemStack)itemstack) > 0;
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean controlKey() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int getGamemode() {
        if (NEIClientConfig.invCreativeMode()) {
            return 2;
        }
        if (NEIClientUtils.mc().field_71442_b.func_78758_h()) {
            return 1;
        }
        if (NEIClientUtils.mc().field_71442_b.field_78779_k.func_82752_c()) {
            return 3;
        }
        return 0;
    }

    public static boolean isValidGamemode(String s) {
        return s.equals("survival") || NEIClientConfig.canPerformAction(s) && Arrays.asList(NEIClientConfig.getStringArrSetting("inventory.gamemodes")).contains(s);
    }

    public static int getNextGamemode() {
        int mode;
        int nmode = mode = NEIClientUtils.getGamemode();
        while ((nmode = (nmode + 1) % NEIActions.gameModes.length) != mode && !NEIClientUtils.isValidGamemode(NEIActions.gameModes[nmode])) {
        }
        return nmode;
    }

    public static void cycleGamemode() {
        int nmode;
        int mode = NEIClientUtils.getGamemode();
        if (mode == (nmode = NEIClientUtils.getNextGamemode())) {
            return;
        }
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendGamemode(nmode);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.creative"), NEIClientUtils.getGameType(nmode), NEIClientUtils.mc().field_71439_g.func_70005_c_());
        }
    }

    public static long getTime() {
        return NEIClientUtils.mc().field_71441_e.func_72912_H().func_76073_f();
    }

    public static void setTime(long l) {
        NEIClientUtils.mc().field_71441_e.func_72912_H().func_76068_b(l);
    }

    public static void setHourForward(int hour) {
        long day = NEIClientUtils.getTime() / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetTime(hour);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.time"), newTime);
        }
    }

    public static void sendCommand(String command, Object ... args) {
        if (command.length() == 0) {
            return;
        }
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        numberformat.setGroupingUsed(false);
        MessageFormat messageformat = new MessageFormat(command);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Integer) && !(args[i] instanceof Long)) continue;
            messageformat.setFormatByArgumentIndex(i, numberformat);
        }
        NEIClientUtils.mc().field_71439_g.func_71165_d(messageformat.format(args));
    }

    public static boolean isRaining() {
        return NEIClientUtils.mc().field_71441_e.func_72912_H().func_76059_o();
    }

    public static void toggleRaining() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleRain();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.rain"), NEIClientUtils.isRaining() ? 0 : 1);
        }
    }

    public static void healPlayer() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendHeal();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.heal"), NEIClientUtils.mc().field_71439_g.func_70005_c_());
        }
    }

    public static void toggleMagnetMode() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleMagnetMode();
        }
    }

    public static ArrayList<int[]> concatIntegersToRanges(List<Integer> damages) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (damages.size() == 0) {
            return ranges;
        }
        Collections.sort(damages);
        int start = -1;
        int next = 0;
        for (Integer i : damages) {
            if (start == -1) {
                start = next = i.intValue();
                continue;
            }
            if (next + 1 != i) {
                ranges.add(new int[]{start, next});
                start = next = i.intValue();
                continue;
            }
            next = i;
        }
        ranges.add(new int[]{start, next});
        return ranges;
    }

    public static ArrayList<int[]> addIntegersToRanges(List<int[]> ranges, List<Integer> damages) {
        for (int[] range : ranges) {
            for (int integer = range[0]; integer <= range[1]; ++integer) {
                damages.add(integer);
            }
        }
        return NEIClientUtils.concatIntegersToRanges(damages);
    }

    public static boolean safeKeyDown(int keyCode) {
        try {
            return Keyboard.isKeyDown((int)keyCode);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static void setItemQuantity(int i) {
        NEIClientConfig.world.nbt.func_74768_a("quantity", i);
        NEIClientConfig.world.saveNBT();
        LayoutManager.quantity.setText(Integer.toString(i));
    }

    public static GuiContainer getGuiContainer() {
        if (NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
            return (GuiContainer)NEIClientUtils.mc().field_71462_r;
        }
        return null;
    }

    public static void overlayScreen(GuiScreen gui) {
        if (NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
            FastTransferManager.clickSlot(NEIClientUtils.getGuiContainer(), -999);
        }
        NEIClientUtils.mc().field_71462_r = null;
        NEIClientUtils.mc().func_147108_a(gui);
    }

    public static boolean altKey() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }
}

