/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config;

import codechicken.nei.config.Option;
import codechicken.nei.config.OptionButton;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public class OptionKeyBind
extends OptionButton {
    private boolean hasFocus = false;

    public OptionKeyBind(String name) {
        super("keys." + name);
    }

    @Override
    public void onMouseClicked(int mousex, int mousey, int button) {
        this.hasFocus = false;
    }

    @Override
    public void keyTyped(char c, int keycode) {
        if (this.hasFocus) {
            this.setValue(keycode);
            this.hasFocus = false;
        }
    }

    @Override
    public boolean onClick(int button) {
        if (this.renderDefault()) {
            return false;
        }
        if (button == 0) {
            this.hasFocus = true;
            return true;
        }
        if (button == 1 && this.getValue() != 0) {
            this.setValue(0);
            return true;
        }
        return false;
    }

    public boolean conflicted() {
        if (this.getValue() == 0) {
            return false;
        }
        for (Option o : this.slot.options) {
            if (!(o instanceof OptionKeyBind) || o == this || ((OptionKeyBind)o).getValue() != this.getValue()) continue;
            return true;
        }
        return false;
    }

    public void setValue(int keycode) {
        this.getTag().setIntValue(keycode);
    }

    public int getValue() {
        return this.renderTag().getIntValue();
    }

    @Override
    public String getPrefix() {
        return this.translateN(this.name, new Object[0]);
    }

    @Override
    public String getButtonText() {
        if (this.hasFocus) {
            return EnumChatFormatting.WHITE + "> " + EnumChatFormatting.YELLOW + "??? " + EnumChatFormatting.WHITE + "<";
        }
        if (this.conflicted()) {
            return EnumChatFormatting.RED + Keyboard.getKeyName((int)this.getValue());
        }
        return Keyboard.getKeyName((int)this.getValue());
    }

    @Override
    public int getTextColour(int mousex, int mousey) {
        return -1;
    }
}

