/*
 * Decompiled with CFR 0.152.
 */
package thehippomaster.BetterHorses;

import java.util.ArrayList;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thehippomaster.AnimationAPI.AnimationAPI;
import thehippomaster.AnimationAPI.IAnimatedEntity;
import thehippomaster.BetterHorses.BetterHorses;
import thehippomaster.BetterHorses.ai.AIEatGrass;
import thehippomaster.BetterHorses.ai.AIRear;
import thehippomaster.BetterHorses.ai.AIShakeHead;
import thehippomaster.BetterHorses.ai.AIShakeTail;

public class Horse
extends EntityHorse
implements IAnimatedEntity {
    public int airTick;
    public int prevAirTick;
    public float renderPitch;
    public float prevRenderPitch;
    public boolean moveBackwards;
    private int animID;
    private int animTick;

    public Horse(World world) {
        super(world);
        this.overrideTasks();
        this.prevAirTick = 0;
        this.airTick = 0;
        this.prevRenderPitch = 0.0f;
        this.renderPitch = 0.0f;
        this.field_70158_ak = true;
        this.moveBackwards = false;
    }

    public Horse(World world, NBTTagCompound tagcompound) {
        this(world);
        this.func_70037_a(tagcompound);
    }

    private void overrideTasks() {
        this.field_70714_bg.field_75782_a = new ArrayList();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.3));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRunAroundLikeCrazy((EntityHorse)this, 1.3));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.3));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIRear(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.3));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIShakeTail(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIShakeHead(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIEatGrass(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 5.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(23, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(48.0);
    }

    public void setAirborne(boolean flag) {
        this.field_70180_af.func_75692_b(23, (Object)((byte)(flag ? 1 : 0)));
    }

    public boolean inAir() {
        return this.field_70180_af.func_75683_a(23) == 1;
    }

    public void setAnimID(int id) {
        this.animID = id;
    }

    public void setAnimTick(int tick) {
        this.animTick = tick;
    }

    public int getAnimID() {
        return this.animID;
    }

    public int getAnimTick() {
        return this.animTick;
    }

    public void func_110219_q(boolean flag) {
        super.func_110219_q(flag);
        if (!this.field_70170_p.field_72995_K && flag && this.animID == 0) {
            AnimationAPI.sendAnimPacket((IAnimatedEntity)this, (int)4);
        }
    }

    public void func_110206_u(int power) {
        if (this.func_110257_ck()) {
            if (power < 0) {
                power = 0;
            }
            this.field_110277_bt = power >= 90 ? 1.0f : 0.4f + 0.4f * (float)power / 90.0f;
        }
    }

    protected void updateRenderRotations() {
        this.prevRenderPitch = this.renderPitch;
        this.prevAirTick = this.airTick;
        if (!this.inAir()) {
            this.renderPitch *= 0.2f;
            this.airTick = Math.max(0, this.airTick - 1);
        } else {
            float angle;
            double x = this.field_70165_t - this.field_70169_q;
            double z = this.field_70161_v - this.field_70166_s;
            double d = Math.sqrt(x * x + z * z) * (double)0.4f;
            for (angle = (float)Math.toDegrees(Math.atan2(this.field_70163_u - this.field_70167_r, d)) * 0.6f; angle > this.renderPitch + 180.0f; angle -= 360.0f) {
            }
            while (angle < this.renderPitch - 180.0f) {
                angle += 360.0f;
            }
            this.renderPitch += (angle - this.renderPitch) * 0.1f;
            this.airTick = Math.min(6, this.airTick + 1);
        }
        this.renderPitch = MathHelper.func_76131_a((float)this.renderPitch, (float)-90.0f, (float)90.0f);
    }

    protected void updateMoveBackwards() {
        float yaw;
        double dX = this.field_70165_t - this.field_70169_q;
        double dZ = this.field_70161_v - this.field_70166_s;
        double motion = dX * dX + dZ * dZ;
        for (yaw = -((float)Math.atan2(dX, dZ)) * 180.0f / (float)Math.PI; yaw <= this.field_70177_z - 180.0f; yaw += 360.0f) {
        }
        while (yaw > this.field_70177_z + 180.0f) {
            yaw -= 360.0f;
        }
        float tempYaw = this.field_70177_z - yaw;
        float tempSign = tempYaw / Math.abs(tempYaw);
        this.moveBackwards = motion > 1.0E-4 && Math.abs(tempYaw) > 100.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.animID != 0) {
            ++this.animTick;
        }
        this.updateRenderRotations();
        this.updateMoveBackwards();
    }

    public void func_70612_e(float strafe, float forward) {
        if (!this.field_70170_p.field_72995_K) {
            boolean airborne = !this.field_70122_E && !this.field_70171_ac;
            this.setAirborne(airborne);
        }
        super.func_70612_e(strafe, forward);
    }

    public void func_70043_V() {
        if (this.field_70153_n == null) {
            return;
        }
        float offset = (float)this.func_70042_X();
        float rad = (float)Math.PI / 180;
        float xPitch = MathHelper.func_76134_b((float)((this.renderPitch + 90.0f) * rad)) * offset;
        float yPitch = MathHelper.func_76126_a((float)((this.renderPitch + 90.0f) * rad)) * offset;
        Vec3 pitchVec = BetterHorses.getYawVector(this.field_70177_z, xPitch);
        this.field_70153_n.func_70107_b(this.field_70165_t + pitchVec.field_72450_a, this.field_70163_u + (double)yPitch + this.field_70153_n.func_70033_W(), this.field_70161_v + pitchVec.field_72449_c);
    }

    public boolean func_70085_c(EntityPlayer player) {
        boolean prevRidden = this.field_70153_n != null;
        boolean flag = super.func_70085_c(player);
        if (!this.field_70170_p.field_72995_K && !prevRidden && this.field_70153_n != null) {
            this.func_70661_as().func_75499_g();
        }
        return flag;
    }

    public EntityHorse convertToVanillaHorse() {
        EntityHorse horse = new EntityHorse(this.field_70170_p);
        NBTTagCompound data = new NBTTagCompound();
        this.func_70014_b(data);
        horse.func_70037_a(data);
        horse.func_70080_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        return horse;
    }

    public static Horse convertHorse(EntityHorse oldHorse) {
        if (oldHorse == null) {
            return null;
        }
        NBTTagCompound data = new NBTTagCompound();
        oldHorse.func_70014_b(data);
        Horse horse = new Horse(oldHorse.field_70170_p, data);
        horse.func_70080_a(oldHorse.field_70165_t, oldHorse.field_70163_u, oldHorse.field_70161_v, oldHorse.field_70177_z, oldHorse.field_70125_A);
        return horse;
    }
}

