/*
 * Decompiled with CFR 0.152.
 */
package rblocks.core;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import rblocks.core.TileRotatableBlock;
import rblocks.util.IOrientable;
import rblocks.util.Platform;

public class RotationLogic {
    public static RotationLogic instance = new RotationLogic();
    private ThreadLocal<Boolean> enableTileSet = new ThreadLocal();

    private RotationLogic() {
    }

    public boolean isSupported(Object object) {
        return this.blockIsEnabled((Block)object);
    }

    private boolean blockIsEnabled(Block object) {
        return object.func_149662_c() && object.func_149686_d() && object.func_149645_b() == 0;
    }

    public boolean useOrConvert(World worldObj, int x, int y, int z, ForgeDirection face) {
        TileEntity te;
        Block blk = worldObj.func_147439_a(x, y, z);
        if (blk == Blocks.field_150349_c || blk == Blocks.field_150391_bh) {
            worldObj.func_147465_d(x, y, z, Blocks.field_150346_d, 0, 3);
        }
        if ((te = worldObj.func_147438_o(x, y, z)) instanceof TileRotatableBlock) {
            return this.rotateBlockAround((TileRotatableBlock)te, face);
        }
        int meta = worldObj.func_72805_g(x, y, z);
        this.enableTileSet.set(true);
        if (blk.hasTileEntity(meta)) {
            this.enableTileSet.set(false);
            return false;
        }
        if (blk.isAir((IBlockAccess)worldObj, x, y, z) || !blk.func_149662_c()) {
            this.enableTileSet.set(false);
            return false;
        }
        TileRotatableBlock tr = new TileRotatableBlock();
        this.enableTileSet.set(false);
        worldObj.func_147455_a(x, y, z, (TileEntity)tr);
        return this.rotateBlockAround(tr, face);
    }

    private boolean rotateBlockAround(IOrientable rotateable, ForgeDirection axis) {
        ForgeDirection forward = rotateable.getForward();
        ForgeDirection up = rotateable.getUp();
        forward = Platform.rotateAround(forward, axis);
        up = Platform.rotateAround(up, axis);
        rotateable.setOrientation(forward, up);
        return true;
    }

    public boolean getEnableTile(Block block) {
        return this.isSupported(block) && !this.isOpen();
    }

    public boolean isOpen() {
        Boolean val = this.enableTileSet.get();
        return val == null ? false : val;
    }

    public ForgeDirection mapRotation(IOrientable ori, ForgeDirection dir) {
        ForgeDirection forward = ori.getForward();
        ForgeDirection up = ori.getUp();
        ForgeDirection west = ForgeDirection.UNKNOWN;
        if (forward == null || up == null) {
            return dir;
        }
        int west_x = forward.offsetY * up.offsetZ - forward.offsetZ * up.offsetY;
        int west_y = forward.offsetZ * up.offsetX - forward.offsetX * up.offsetZ;
        int west_z = forward.offsetX * up.offsetY - forward.offsetY * up.offsetX;
        for (ForgeDirection dx : ForgeDirection.VALID_DIRECTIONS) {
            if (dx.offsetX != west_x || dx.offsetY != west_y || dx.offsetZ != west_z) continue;
            west = dx;
        }
        if (dir.equals((Object)forward)) {
            return ForgeDirection.SOUTH;
        }
        if (dir.equals((Object)forward.getOpposite())) {
            return ForgeDirection.NORTH;
        }
        if (dir.equals((Object)up)) {
            return ForgeDirection.UP;
        }
        if (dir.equals((Object)up.getOpposite())) {
            return ForgeDirection.DOWN;
        }
        if (dir.equals((Object)west)) {
            return ForgeDirection.WEST;
        }
        if (dir.equals((Object)west.getOpposite())) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.UNKNOWN;
    }

    int mapRotation(IOrientable ori, int s) {
        return this.mapRotation(ori, ForgeDirection.getOrientation((int)s)).ordinal();
    }

    public IIcon getIcon(Block blk, IBlockAccess w, int x, int y, int z, int s) {
        if (this.isOpen()) {
            return null;
        }
        IIcon ico = null;
        this.enableTileSet.set(true);
        TileEntity te = w.func_147438_o(x, y, z);
        ico = te instanceof IOrientable ? blk.func_149673_e(w, x, y, z, this.mapRotation((IOrientable)te, s)) : blk.func_149673_e(w, x, y, z, s);
        this.enableTileSet.set(false);
        return ico;
    }
}

