/*
 * Decompiled with CFR 0.152.
 */
package rblocks.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.FloatBuffer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import rblocks.client.render.BlockRenderInfo;
import rblocks.core.TileRotatableBlock;
import rblocks.util.IOrientable;
import rblocks.util.Platform;

@SideOnly(value=Side.CLIENT)
public abstract class RotateableBlockRender {
    final int ORIENTATION_BITS = 7;
    static final int FLIP_H_BIT = 8;
    static final int FLIP_V_BIT = 16;
    private final byte[][][] OrientationMap = new byte[6][6][6];
    final FloatBuffer rotMat = BufferUtils.createFloatBuffer((int)16);

    protected RotateableBlockRender() {
        this.setOriMap();
    }

    protected abstract BlockRenderInfo getRendererInstance(Object var1);

    public int getOrientation(ForgeDirection in, ForgeDirection forward, ForgeDirection up) {
        if (in == null || in.equals((Object)ForgeDirection.UNKNOWN) || forward == null || forward.equals((Object)ForgeDirection.UNKNOWN) || up == null || up.equals((Object)ForgeDirection.UNKNOWN)) {
            return 0;
        }
        int a = in.ordinal();
        int b = forward.ordinal();
        int c = up.ordinal();
        return this.OrientationMap[a][b][c];
    }

    public void setOriMap() {
        this.OrientationMap[0][3][1] = 0;
        this.OrientationMap[1][3][1] = 0;
        this.OrientationMap[2][3][1] = 0;
        this.OrientationMap[3][3][1] = 0;
        this.OrientationMap[4][3][1] = 0;
        this.OrientationMap[5][3][1] = 0;
        this.OrientationMap[0][5][1] = 1;
        this.OrientationMap[1][5][1] = 2;
        this.OrientationMap[2][5][1] = 0;
        this.OrientationMap[3][5][1] = 0;
        this.OrientationMap[4][5][1] = 0;
        this.OrientationMap[5][5][1] = 0;
        this.OrientationMap[0][2][1] = 3;
        this.OrientationMap[1][2][1] = 3;
        this.OrientationMap[2][2][1] = 0;
        this.OrientationMap[3][2][1] = 0;
        this.OrientationMap[4][2][1] = 0;
        this.OrientationMap[5][2][1] = 0;
        this.OrientationMap[0][4][1] = 2;
        this.OrientationMap[1][4][1] = 1;
        this.OrientationMap[2][4][1] = 0;
        this.OrientationMap[3][4][1] = 0;
        this.OrientationMap[4][4][1] = 0;
        this.OrientationMap[5][4][1] = 0;
        this.OrientationMap[0][3][0] = 8;
        this.OrientationMap[1][3][0] = 8;
        this.OrientationMap[2][3][0] = 3;
        this.OrientationMap[3][3][0] = 3;
        this.OrientationMap[4][3][0] = 3;
        this.OrientationMap[5][3][0] = 3;
        this.OrientationMap[0][4][0] = 10;
        this.OrientationMap[1][4][0] = 9;
        this.OrientationMap[2][4][0] = 3;
        this.OrientationMap[3][4][0] = 3;
        this.OrientationMap[4][4][0] = 3;
        this.OrientationMap[5][4][0] = 3;
        this.OrientationMap[0][5][0] = 9;
        this.OrientationMap[1][5][0] = 10;
        this.OrientationMap[2][5][0] = 3;
        this.OrientationMap[3][5][0] = 3;
        this.OrientationMap[4][5][0] = 3;
        this.OrientationMap[5][5][0] = 3;
        this.OrientationMap[0][2][0] = 11;
        this.OrientationMap[1][2][0] = 11;
        this.OrientationMap[2][2][0] = 3;
        this.OrientationMap[3][2][0] = 3;
        this.OrientationMap[4][2][0] = 3;
        this.OrientationMap[5][2][0] = 3;
        this.OrientationMap[0][3][5] = 17;
        this.OrientationMap[1][3][5] = 9;
        this.OrientationMap[2][3][5] = 1;
        this.OrientationMap[3][3][5] = 1;
        this.OrientationMap[4][3][5] = 1;
        this.OrientationMap[5][3][5] = 17;
        this.OrientationMap[0][1][5] = 9;
        this.OrientationMap[1][1][5] = 1;
        this.OrientationMap[2][1][5] = 19;
        this.OrientationMap[3][1][5] = 3;
        this.OrientationMap[4][1][5] = 17;
        this.OrientationMap[5][1][5] = 1;
        this.OrientationMap[0][2][5] = 9;
        this.OrientationMap[1][2][5] = 9;
        this.OrientationMap[2][2][5] = 1;
        this.OrientationMap[3][2][5] = 18;
        this.OrientationMap[4][2][5] = 17;
        this.OrientationMap[5][2][5] = 1;
        this.OrientationMap[0][0][5] = 9;
        this.OrientationMap[1][0][5] = 1;
        this.OrientationMap[2][0][5] = 0;
        this.OrientationMap[3][0][5] = 16;
        this.OrientationMap[4][0][5] = 1;
        this.OrientationMap[5][0][5] = 17;
        this.OrientationMap[0][1][2] = 8;
        this.OrientationMap[1][1][2] = 0;
        this.OrientationMap[2][1][2] = 10;
        this.OrientationMap[3][1][2] = 1;
        this.OrientationMap[4][1][2] = 3;
        this.OrientationMap[5][1][2] = 11;
        this.OrientationMap[0][4][2] = 8;
        this.OrientationMap[1][4][2] = 8;
        this.OrientationMap[2][4][2] = 10;
        this.OrientationMap[3][4][2] = 1;
        this.OrientationMap[4][4][2] = 9;
        this.OrientationMap[5][4][2] = 2;
        this.OrientationMap[0][0][2] = 16;
        this.OrientationMap[1][0][2] = 0;
        this.OrientationMap[2][0][2] = 2;
        this.OrientationMap[3][0][2] = 9;
        this.OrientationMap[4][0][2] = 11;
        this.OrientationMap[5][0][2] = 0;
        this.OrientationMap[0][5][2] = 8;
        this.OrientationMap[1][5][2] = 8;
        this.OrientationMap[2][5][2] = 2;
        this.OrientationMap[3][5][2] = 9;
        this.OrientationMap[4][5][2] = 2;
        this.OrientationMap[5][5][2] = 9;
        this.OrientationMap[0][0][3] = 11;
        this.OrientationMap[1][0][3] = 3;
        this.OrientationMap[2][0][3] = 1;
        this.OrientationMap[3][0][3] = 10;
        this.OrientationMap[4][0][3] = 0;
        this.OrientationMap[5][0][3] = 8;
        this.OrientationMap[0][4][3] = 3;
        this.OrientationMap[1][4][3] = 3;
        this.OrientationMap[2][4][3] = 9;
        this.OrientationMap[3][4][3] = 2;
        this.OrientationMap[4][4][3] = 1;
        this.OrientationMap[5][4][3] = 10;
        this.OrientationMap[0][1][3] = 19;
        this.OrientationMap[1][1][3] = 3;
        this.OrientationMap[2][1][3] = 9;
        this.OrientationMap[3][1][3] = 2;
        this.OrientationMap[4][1][3] = 11;
        this.OrientationMap[5][1][3] = 0;
        this.OrientationMap[0][5][3] = 3;
        this.OrientationMap[1][5][3] = 3;
        this.OrientationMap[2][5][3] = 1;
        this.OrientationMap[3][5][3] = 10;
        this.OrientationMap[4][5][3] = 10;
        this.OrientationMap[5][5][3] = 1;
        this.OrientationMap[0][3][4] = 1;
        this.OrientationMap[1][3][4] = 2;
        this.OrientationMap[2][3][4] = 10;
        this.OrientationMap[3][3][4] = 1;
        this.OrientationMap[4][3][4] = 10;
        this.OrientationMap[5][3][4] = 1;
        this.OrientationMap[0][0][4] = 9;
        this.OrientationMap[1][0][4] = 2;
        this.OrientationMap[2][0][4] = 0;
        this.OrientationMap[3][0][4] = 8;
        this.OrientationMap[4][0][4] = 10;
        this.OrientationMap[5][0][4] = 1;
        this.OrientationMap[0][1][4] = 9;
        this.OrientationMap[1][1][4] = 2;
        this.OrientationMap[2][1][4] = 11;
        this.OrientationMap[3][1][4] = 3;
        this.OrientationMap[4][1][4] = 2;
        this.OrientationMap[5][1][4] = 9;
        this.OrientationMap[0][2][4] = 1;
        this.OrientationMap[1][2][4] = 2;
        this.OrientationMap[2][2][4] = 1;
        this.OrientationMap[3][2][4] = 10;
        this.OrientationMap[4][2][4] = 2;
        this.OrientationMap[5][2][4] = 9;
    }

    public IOrientable getOrientable(Block block, IBlockAccess w, int x, int y, int z) {
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof IOrientable) {
            return (IOrientable)te;
        }
        return null;
    }

    public void preRenderInWorld(Block block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        ForgeDirection forward = ForgeDirection.SOUTH;
        ForgeDirection up = ForgeDirection.UP;
        BlockRenderInfo info = this.getRendererInstance(block);
        IOrientable te = this.getOrientable(block, world, x, y, z);
        if (te != null) {
            forward = te.getForward();
            up = te.getUp();
            renderer.field_147865_v = info.getTexture(ForgeDirection.DOWN).setFlip(this.getOrientation(ForgeDirection.DOWN, forward, up));
            renderer.field_147867_u = info.getTexture(ForgeDirection.UP).setFlip(this.getOrientation(ForgeDirection.UP, forward, up));
            renderer.field_147875_q = info.getTexture(ForgeDirection.EAST).setFlip(this.getOrientation(ForgeDirection.EAST, forward, up));
            renderer.field_147873_r = info.getTexture(ForgeDirection.WEST).setFlip(this.getOrientation(ForgeDirection.WEST, forward, up));
            renderer.field_147869_t = info.getTexture(ForgeDirection.NORTH).setFlip(this.getOrientation(ForgeDirection.NORTH, forward, up));
            renderer.field_147871_s = info.getTexture(ForgeDirection.SOUTH).setFlip(this.getOrientation(ForgeDirection.SOUTH, forward, up));
        }
    }

    public void postRenderInWorld(RenderBlocks renderer) {
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
    }

    public boolean renderInWorld(Block block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        BlockRenderInfo info = this.getRendererInstance(block);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileRotatableBlock) {
            TileRotatableBlock tr = (TileRotatableBlock)te;
            Block blk = tr.getBlock();
            int meta = tr.getMeta();
            if (blk == null || !blk.func_149662_c()) {
                return true;
            }
            info.setTemporaryRenderIcons(blk.func_149691_a(ForgeDirection.UP.ordinal(), meta), blk.func_149691_a(ForgeDirection.DOWN.ordinal(), meta), blk.func_149691_a(ForgeDirection.SOUTH.ordinal(), meta), blk.func_149691_a(ForgeDirection.NORTH.ordinal(), meta), blk.func_149691_a(ForgeDirection.EAST.ordinal(), meta), blk.func_149691_a(ForgeDirection.WEST.ordinal(), meta));
            this.preRenderInWorld(block, world, x, y, z, renderer);
            boolean o = renderer.func_147784_q(block, x, y, z);
            this.postRenderInWorld(renderer);
            return o;
        }
        return renderer.func_147784_q(block, x, y, z);
    }

    protected void applyTESRRotation(double x, double y, double z, ForgeDirection forward, ForgeDirection up) {
        if (forward != null && up != null) {
            if (forward == ForgeDirection.UNKNOWN) {
                forward = ForgeDirection.SOUTH;
            }
            if (up == ForgeDirection.UNKNOWN) {
                up = ForgeDirection.UP;
            }
            ForgeDirection west = Platform.crossProduct(forward, up);
            this.rotMat.put(0, west.offsetX);
            this.rotMat.put(1, west.offsetY);
            this.rotMat.put(2, west.offsetZ);
            this.rotMat.put(3, 0.0f);
            this.rotMat.put(4, up.offsetX);
            this.rotMat.put(5, up.offsetY);
            this.rotMat.put(6, up.offsetZ);
            this.rotMat.put(7, 0.0f);
            this.rotMat.put(8, forward.offsetX);
            this.rotMat.put(9, forward.offsetY);
            this.rotMat.put(10, forward.offsetZ);
            this.rotMat.put(11, 0.0f);
            this.rotMat.put(12, 0.0f);
            this.rotMat.put(13, 0.0f);
            this.rotMat.put(14, 0.0f);
            this.rotMat.put(15, 1.0f);
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glMultMatrix((FloatBuffer)this.rotMat);
            GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
            GL11.glCullFace((int)1028);
        } else {
            GL11.glTranslated((double)x, (double)y, (double)z);
        }
    }

    protected void setInvRenderBounds(RenderBlocks renderer, int i, int j, int k, int l, int m, int n) {
        renderer.func_147782_a((double)i / 16.0, (double)j / 16.0, (double)k / 16.0, (double)l / 16.0, (double)m / 16.0, (double)n / 16.0);
    }

    protected void renderBlockBounds(RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, ForgeDirection x, ForgeDirection y, ForgeDirection z) {
        double aX = (minX /= 16.0) * (double)x.offsetX + (minY /= 16.0) * (double)y.offsetX + (minZ /= 16.0) * (double)z.offsetX;
        double aY = minX * (double)x.offsetY + minY * (double)y.offsetY + minZ * (double)z.offsetY;
        double aZ = minX * (double)x.offsetZ + minY * (double)y.offsetZ + minZ * (double)z.offsetZ;
        double bX = (maxX /= 16.0) * (double)x.offsetX + (maxY /= 16.0) * (double)y.offsetX + (maxZ /= 16.0) * (double)z.offsetX;
        double bY = maxX * (double)x.offsetY + maxY * (double)y.offsetY + maxZ * (double)z.offsetY;
        double bZ = maxX * (double)x.offsetZ + maxY * (double)y.offsetZ + maxZ * (double)z.offsetZ;
        if (x.offsetX + y.offsetX + z.offsetX < 0) {
            aX += 1.0;
            bX += 1.0;
        }
        if (x.offsetY + y.offsetY + z.offsetY < 0) {
            aY += 1.0;
            bY += 1.0;
        }
        if (x.offsetZ + y.offsetZ + z.offsetZ < 0) {
            aZ += 1.0;
            bZ += 1.0;
        }
        renderer.field_147859_h = Math.min(aX, bX);
        renderer.field_147855_j = Math.min(aY, bY);
        renderer.field_147851_l = Math.min(aZ, bZ);
        renderer.field_147861_i = Math.max(aX, bX);
        renderer.field_147857_k = Math.max(aY, bY);
        renderer.field_147853_m = Math.max(aZ, bZ);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderFace(Tessellator tess, double offsetX, double offsetY, double offsetZ, double ax, double ay, double az, double bx, double by, double bz, double ua, double ub, double va, double vb, IIcon ico, boolean flip) {
        if (flip) {
            tess.func_78374_a(offsetX + ax * ua + bx * va, offsetY + ay * ua + by * va, offsetZ + az * ua + bz * va, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(va * 16.0));
            tess.func_78374_a(offsetX + ax * ua + bx * vb, offsetY + ay * ua + by * vb, offsetZ + az * ua + bz * vb, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(vb * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * vb, offsetY + ay * ub + by * vb, offsetZ + az * ub + bz * vb, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(vb * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * va, offsetY + ay * ub + by * va, offsetZ + az * ub + bz * va, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(va * 16.0));
        } else {
            tess.func_78374_a(offsetX + ax * ua + bx * va, offsetY + ay * ua + by * va, offsetZ + az * ua + bz * va, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(va * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * va, offsetY + ay * ub + by * va, offsetZ + az * ub + bz * va, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(va * 16.0));
            tess.func_78374_a(offsetX + ax * ub + bx * vb, offsetY + ay * ub + by * vb, offsetZ + az * ub + bz * vb, (double)ico.func_94214_a(ub * 16.0), (double)ico.func_94207_b(vb * 16.0));
            tess.func_78374_a(offsetX + ax * ua + bx * vb, offsetY + ay * ua + by * vb, offsetZ + az * ua + bz * vb, (double)ico.func_94214_a(ua * 16.0), (double)ico.func_94207_b(vb * 16.0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void renderFace(int x, int y, int z, Block block, IIcon ico, RenderBlocks renderer, ForgeDirection orientation) {
        switch (orientation) {
            case NORTH: {
                renderer.func_147761_c(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case SOUTH: {
                renderer.func_147734_d(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case EAST: {
                renderer.func_147764_f(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case WEST: {
                renderer.func_147798_e(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case UP: {
                renderer.func_147806_b(block, (double)x, (double)y, (double)z, ico);
                break;
            }
            case DOWN: {
                renderer.func_147768_a(block, (double)x, (double)y, (double)z, ico);
                break;
            }
        }
    }

    public void selectFace(RenderBlocks renderer, ForgeDirection west, ForgeDirection up, ForgeDirection forward, int u1, int u2, int v1, int v2) {
        v1 = 16 - v1;
        v2 = 16 - v2;
        double minX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u1) + this.mapFaceUV(up.offsetX, v1);
        double minY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u1) + this.mapFaceUV(up.offsetY, v1);
        double minZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u1) + this.mapFaceUV(up.offsetZ, v1);
        double maxX = (double)(forward.offsetX > 0 ? 1 : 0) + this.mapFaceUV(west.offsetX, u2) + this.mapFaceUV(up.offsetX, v2);
        double maxY = (double)(forward.offsetY > 0 ? 1 : 0) + this.mapFaceUV(west.offsetY, u2) + this.mapFaceUV(up.offsetY, v2);
        double maxZ = (double)(forward.offsetZ > 0 ? 1 : 0) + this.mapFaceUV(west.offsetZ, u2) + this.mapFaceUV(up.offsetZ, v2);
        renderer.field_147859_h = Math.max(0.0, Math.min(minX, maxX) - 0.001);
        renderer.field_147861_i = Math.min(1.0, Math.max(minX, maxX) + 0.001);
        renderer.field_147855_j = Math.max(0.0, Math.min(minY, maxY) - 0.001);
        renderer.field_147857_k = Math.min(1.0, Math.max(minY, maxY) + 0.001);
        renderer.field_147851_l = Math.max(0.0, Math.min(minZ, maxZ) - 0.001);
        renderer.field_147853_m = Math.min(1.0, Math.max(minZ, maxZ) + 0.001);
    }

    private double mapFaceUV(int offset, int uv) {
        if (offset == 0) {
            return 0.0;
        }
        if (offset > 0) {
            return (double)uv / 16.0;
        }
        return (16.0 - (double)uv) / 16.0;
    }

    public void renderTile(Block block, TileRotatableBlock tile, Tessellator tess, double x, double y, double z, float f, RenderBlocks renderer) {
        ForgeDirection forward = ForgeDirection.SOUTH;
        ForgeDirection up = ForgeDirection.UP;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147873_r = 0;
        renderer.field_147875_q = 0;
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
        this.applyTESRRotation(x, y, z, forward, up);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tess.func_78373_b((double)(-tile.field_145851_c), (double)(-tile.field_145848_d), (double)(-tile.field_145849_e));
        tess.func_78382_b();
        renderer.func_147775_a(block);
        renderer.func_147784_q(block, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        tess.func_78381_a();
        tess.func_78373_b(0.0, 0.0, 0.0);
        RenderHelper.func_74519_b();
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147873_r = 0;
        renderer.field_147875_q = 0;
        renderer.field_147867_u = 0;
        renderer.field_147865_v = 0;
    }
}

